/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.client.main;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.rub.nds.tlsattacker.client.config.ClientCommandConfig;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ListDelegate;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TlsClient {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void main(String[] args) {
        ClientCommandConfig config = new ClientCommandConfig(new GeneralDelegate());
        JCommander commander = new JCommander((Object)config);
        try {
            commander.parse(args);
            if (config.getGeneralDelegate().isHelp()) {
                commander.usage();
                return;
            }
            ListDelegate list = (ListDelegate)config.getDelegate(ListDelegate.class);
            if (list.isSet()) {
                list.plotListing();
                return;
            }
            try {
                Config tlsConfig = config.createConfig();
                TlsClient client = new TlsClient();
                client.startTlsClient(tlsConfig);
            }
            catch (Exception E) {
                LOGGER.error("Encountered an uncaught Exception aborting. See debug for more info.", (Throwable)E);
            }
        }
        catch (ParameterException E) {
            LOGGER.error("Could not parse provided parameters. " + E.getLocalizedMessage());
            LOGGER.debug((Object)E);
            commander.usage();
        }
    }

    public void startTlsClient(Config config) {
        State state = new State(config);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(config.getWorkflowExecutorType(), state);
        try {
            workflowExecutor.executeWorkflow();
        }
        catch (WorkflowExecutionException ex) {
            LOGGER.warn("The TLS protocol flow was not executed completely, follow the debug messages for more information.");
            LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

