/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendDynamicServerCertificateAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public SendDynamicServerCertificateAction() {
    }

    public SendDynamicServerCertificateAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        CipherSuite selectedCipherSuite;
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.messages = new LinkedList();
        WorkflowConfigurationFactory workflowFactory = new WorkflowConfigurationFactory(state.getConfig());
        if (workflowFactory.shouldServerSendACertificate(selectedCipherSuite = tlsContext.getSelectedCipherSuite())) {
            this.messages.add(new CertificateMessage());
        }
        String sending = this.getReadableString(this.messages);
        if (this.hasDefaultAlias()) {
            LOGGER.info("Sending Dynamic Certificate: " + sending);
        } else {
            LOGGER.info("Sending Dynamic Certificate (" + this.connectionAlias + "): " + sending);
        }
        try {
            MessageActionResult result = this.sendMessageHelper.sendMessages(this.messages, this.records, tlsContext);
            this.messages = new ArrayList<ProtocolMessage>(result.getMessageList());
            this.records = new ArrayList<AbstractRecord>(result.getRecordList());
            this.setExecuted(true);
        }
        catch (IOException E) {
            tlsContext.setReceivedTransportHandlerException(true);
            LOGGER.debug((Object)E);
            this.setExecuted(false);
        }
    }

    public String toString() {
        StringBuilder sb = this.isExecuted() ? new StringBuilder("Send Dynamic Certificate Action:\n") : new StringBuilder("Send Dynamic Certificate: (not executed)\n");
        sb.append("\tMessages:");
        if (this.messages != null) {
            for (ProtocolMessage message : this.messages) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.messages != null && !this.messages.isEmpty()) {
            sb.append(" (");
            for (ProtocolMessage message : this.messages) {
                sb.append(message.toCompactString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(",")).append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    @Override
    public void reset() {
        LinkedList<ModifiableVariableHolder> holders = new LinkedList<ModifiableVariableHolder>();
        if (this.messages != null) {
            for (ProtocolMessage message : this.messages) {
                holders.addAll(message.getAllModifiableVariableHolders());
            }
        }
        if (this.getRecords() != null) {
            for (AbstractRecord record : this.getRecords()) {
                holders.addAll(record.getAllModifiableVariableHolders());
            }
        }
        for (ModifiableVariableHolder holder : holders) {
            List<Field> fields = holder.getAllModifiableVariableFields();
            for (Field f : fields) {
                f.setAccessible(true);
                ModifiableVariable mv = null;
                try {
                    mv = (ModifiableVariable)f.get(holder);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.warn("Could not retrieve ModifiableVariables");
                    LOGGER.debug((Object)ex);
                }
                if (mv == null) continue;
                if (mv.getModification() != null || mv.isCreateRandomModification()) {
                    mv.setOriginalValue(null);
                    continue;
                }
                try {
                    f.set(holder, null);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.warn("Could not strip ModifiableVariable without Modification");
                }
            }
        }
        this.setExecuted(null);
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.records;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendDynamicClientKeyExchangeAction other = (SendDynamicClientKeyExchangeAction)obj;
        if (!Objects.equals(this.messages, other.messages)) {
            return false;
        }
        if (!Objects.equals(this.records, other.records)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + Objects.hashCode(this.messages);
        hash = 67 * hash + Objects.hashCode(this.records);
        return hash;
    }
}

