/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportedVersionsExtensionSerializer
extends ExtensionSerializer<SupportedVersionsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupportedVersionsExtensionMessage msg;

    public SupportedVersionsExtensionSerializer(SupportedVersionsExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing SupportedVersionsExtensionMessage");
        if (this.msg.getSupportedVersionsLength() == null || this.msg.getSupportedVersions().getValue() == null) {
            this.writeSupportedVersions(this.msg);
        } else {
            this.writeSupportedVersionsLength(this.msg);
            this.writeSupportedVersions(this.msg);
        }
        return this.getAlreadySerialized();
    }

    private void writeSupportedVersionsLength(SupportedVersionsExtensionMessage msg) {
        this.appendInt((Integer)msg.getSupportedVersionsLength().getValue(), 1);
        LOGGER.debug("SupportedVersionsLength: " + msg.getSupportedVersionsLength().getValue());
    }

    private void writeSupportedVersions(SupportedVersionsExtensionMessage msg) {
        this.appendBytes((byte[])msg.getSupportedVersions().getValue());
        LOGGER.debug("SupportedVersions: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSupportedVersions().getValue())));
    }
}

