/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateMessageSerializer
extends HandshakeMessageSerializer<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateMessage msg;

    public CertificateMessageSerializer(CertificateMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing CertificateMessage");
        if (this.version.isTLS13()) {
            this.writeRequestContextLength(this.msg);
            this.writeRequestContext(this.msg);
        }
        this.writeCertificatesListLength(this.msg);
        this.wirteCertificatesListBytes(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeRequestContextLength(CertificateMessage msg) {
        this.appendInt((Integer)msg.getRequestContextLength().getValue(), 1);
        LOGGER.debug("RequestContextLength: " + msg.getRequestContextLength().getValue());
    }

    private void writeRequestContext(CertificateMessage msg) {
        this.appendBytes((byte[])msg.getRequestContext().getValue());
        LOGGER.debug("RequestContext: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getRequestContext().getValue())));
    }

    private void writeCertificatesListLength(CertificateMessage msg) {
        this.appendInt((Integer)msg.getCertificatesListLength().getValue(), 3);
        LOGGER.debug("certificatesListLength: " + msg.getCertificatesListLength().getValue());
    }

    private void wirteCertificatesListBytes(CertificateMessage msg) {
        this.appendBytes((byte[])msg.getCertificatesListBytes().getValue());
        LOGGER.debug("certificatesListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCertificatesListBytes().getValue())));
    }
}

