/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertSerializer
extends ProtocolMessageSerializer<AlertMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AlertMessage msg;

    public AlertSerializer(AlertMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serializing AlertMessage");
        this.writeLevel(this.msg);
        this.writeDescription(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeLevel(AlertMessage msg) {
        this.appendByte((Byte)msg.getLevel().getValue());
        LOGGER.debug("Level: " + msg.getLevel().getValue());
    }

    private void writeDescription(AlertMessage msg) {
        this.appendByte((Byte)msg.getDescription().getValue());
        LOGGER.debug("Description: " + msg.getDescription().getValue());
    }
}

