/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.KeyShareCalculator;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.cipher.DecryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.EncryptionCipher;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ClientEsniInnerParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ClientEsniInnerPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.KeyShareEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ClientEsniInnerSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareEntrySerializer;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.core.workflow.chooser.DefaultChooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionPreparator
extends ExtensionPreparator<EncryptedServerNameIndicationExtensionMessage> {
    private static final int IV_LENGTH = 12;
    private static final Logger LOGGER = LogManager.getLogger();
    private final Chooser chooser;
    private final EncryptedServerNameIndicationExtensionMessage msg;
    private ClientHelloMessage clientHelloMessage;
    private EsniPreparatorMode esniPreparatorMode;

    public EncryptedServerNameIndicationExtensionPreparator(Chooser chooser, EncryptedServerNameIndicationExtensionMessage message, ExtensionSerializer<EncryptedServerNameIndicationExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
        this.chooser = chooser;
        this.esniPreparatorMode = chooser.getConnectionEndType() == ConnectionEndType.CLIENT ? EsniPreparatorMode.CLIENT : EsniPreparatorMode.SERVER;
    }

    public ClientHelloMessage getClientHelloMessage() {
        return this.clientHelloMessage;
    }

    public void setClientHelloMessage(ClientHelloMessage clientHelloMessage) {
        this.clientHelloMessage = clientHelloMessage;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing EncryptedServerNameIndicationExtension");
        switch (this.esniPreparatorMode) {
            case CLIENT: {
                this.configurateEsniMessageType(this.msg);
                this.prepareClientEsniInner(this.msg);
                this.prepareClientEsniInnerBytes(this.msg);
                this.prepareCipherSuite(this.msg);
                this.prepareNamedGroup(this.msg);
                this.prepareKeyShareEntry(this.msg);
                this.prepareEsniServerPublicKey(this.msg);
                this.prepareEsniRecordBytes(this.msg);
                this.prepareRecordDigest(this.msg);
                this.prepareRecordDigestLength(this.msg);
                this.prepareClientRandom(this.msg);
                this.prepareEsniContents(this.msg);
                this.prepareEsniContentsHash(this.msg);
                this.prepareEsniClientSharedSecret(this.msg);
                this.prepareEsniMasterSecret(this.msg);
                this.prepareEsniKey(this.msg);
                this.prepareEsniIv(this.msg);
                this.prepareClientHelloKeyShare(this.msg);
                this.prepareEncryptedSni(this.msg);
                this.prepareEncryptedSniLength(this.msg);
                break;
            }
            case SERVER: {
                this.configurateEsniMessageType(this.msg);
                this.prepareServerNonce(this.msg);
                break;
            }
        }
    }

    @Override
    public void afterPrepareExtensionContent() {
        LOGGER.debug("AfterPreparing EncryptedServerNameIndicationExtension");
        if (this.esniPreparatorMode == EsniPreparatorMode.CLIENT) {
            LOGGER.debug("Afterpreparing EncryptedServerNameIndicationExtension");
            this.prepareClientRandom(this.msg);
            this.prepareEsniContents(this.msg);
            this.prepareEsniContentsHash(this.msg);
            this.prepareEsniClientSharedSecret(this.msg);
            this.prepareEsniMasterSecret(this.msg);
            this.prepareEsniKey(this.msg);
            this.prepareEsniIv(this.msg);
            this.prepareClientHelloKeyShare(this.msg);
            this.prepareEncryptedSni(this.msg);
            this.prepareEncryptedSniLength(this.msg);
        }
    }

    public void prepareAfterParse() {
        LOGGER.debug("PreparingAfterParse EncryptedServerNameIndicationExtension");
        if (this.esniPreparatorMode == EsniPreparatorMode.SERVER) {
            try {
                this.prepareClientRandom(this.msg);
                this.prepareEsniContents(this.msg);
                this.prepareEsniContentsHash(this.msg);
                this.prepareEsniServerSharedSecret(this.msg);
                this.prepareEsniMasterSecret(this.msg);
                this.prepareEsniKey(this.msg);
                this.prepareEsniIv(this.msg);
                this.prepareClientHelloKeyShare(this.msg);
                this.parseEncryptedSni(this.msg);
                this.parseClientEsniInnerBytes(this.msg);
            }
            catch (NullPointerException e) {
                throw new PreparationException("Missing parameters to prepareAfterParse EncryptedServerNameIndicationExtension", e);
            }
        }
    }

    private void configurateEsniMessageType(EncryptedServerNameIndicationExtensionMessage msg) {
        if (msg.getEsniMessageTypeConfig() == null) {
            switch (this.esniPreparatorMode) {
                case CLIENT: {
                    msg.setEsniMessageTypeConfig(EncryptedServerNameIndicationExtensionMessage.EsniMessageType.CLIENT);
                    break;
                }
                case SERVER: {
                    msg.setEsniMessageTypeConfig(EncryptedServerNameIndicationExtensionMessage.EsniMessageType.SERVER);
                    break;
                }
            }
        }
    }

    private void prepareClientEsniInner(EncryptedServerNameIndicationExtensionMessage msg) {
        ClientEsniInnerPreparator clientEsniInnerPreparator = new ClientEsniInnerPreparator(this.chooser, msg.getClientEsniInner());
        clientEsniInnerPreparator.prepare();
    }

    private void prepareClientEsniInnerBytes(EncryptedServerNameIndicationExtensionMessage msg) {
        ClientEsniInnerSerializer serializer = new ClientEsniInnerSerializer(msg.getClientEsniInner());
        byte[] clientEsniInnerBytes = serializer.serialize();
        msg.setClientEsniInnerBytes(clientEsniInnerBytes);
        LOGGER.debug("clientEsniInnerBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getClientEsniInnerBytes().getValue())));
    }

    private void parseClientEsniInnerBytes(EncryptedServerNameIndicationExtensionMessage msg) {
        ClientEsniInnerParser parser = new ClientEsniInnerParser(0, (byte[])msg.getClientEsniInnerBytes().getValue());
        ClientEsniInner clientEsniInner = parser.parse();
        msg.setClientEsniInner(clientEsniInner);
    }

    private void prepareEsniServerPublicKey(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] serverPublicKey = this.chooser.getEsniServerKeyShareEntries().get(0).getPublicKey();
        for (KeyShareStoreEntry entry : this.chooser.getEsniServerKeyShareEntries()) {
            if (!Arrays.equals(entry.getGroup().getValue(), (byte[])msg.getKeyShareEntry().getGroup().getValue())) continue;
            serverPublicKey = entry.getPublicKey();
            break;
        }
        msg.getEncryptedSniComputation().setEsniServerPublicKey(serverPublicKey);
        LOGGER.debug("esniServerPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniServerPublicKey().getValue())));
    }

    private void prepareNamedGroup(EncryptedServerNameIndicationExtensionMessage msg) {
        List<NamedGroup> implementedNamedGroups = KeyShareCalculator.getImplemented();
        List<NamedGroup> clientSupportedNamedGroups = this.chooser.getConfig().getClientSupportedEsniNamedGroups();
        LinkedList<NamedGroup> serverSupportedNamedGroups = new LinkedList<NamedGroup>();
        for (KeyShareStoreEntry entry : this.chooser.getEsniServerKeyShareEntries()) {
            serverSupportedNamedGroups.add(entry.getGroup());
        }
        NamedGroup selectedNamedGroup = implementedNamedGroups.get(0);
        boolean isFoundSharedNamedGroup = false;
        for (NamedGroup g : clientSupportedNamedGroups) {
            if (!implementedNamedGroups.contains((Object)g)) continue;
            selectedNamedGroup = g;
            if (!serverSupportedNamedGroups.contains((Object)g)) continue;
            isFoundSharedNamedGroup = true;
            break;
        }
        if (!isFoundSharedNamedGroup) {
            LOGGER.warn("Found no shared named group. Using " + (Object)((Object)selectedNamedGroup));
        }
        msg.getKeyShareEntry().setGroupConfig(selectedNamedGroup);
        LOGGER.debug("NamedGroup: " + ArrayConverter.bytesToHexString((byte[])msg.getKeyShareEntry().getGroupConfig().getValue()));
    }

    private void prepareKeyShareEntry(EncryptedServerNameIndicationExtensionMessage msg) {
        KeyShareEntry keyShareEntry = msg.getKeyShareEntry();
        keyShareEntry.setPrivateKey(this.chooser.getConfig().getDefaultEsniClientPrivateKey());
        KeyShareEntryPreparator keyShareEntryPreparator = new KeyShareEntryPreparator(this.chooser, keyShareEntry);
        keyShareEntryPreparator.prepare();
        LOGGER.debug("ClientPrivateKey: " + ArrayConverter.bytesToHexString((byte[])msg.getKeyShareEntry().getPrivateKey().toByteArray()));
        LOGGER.debug("ClientPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getKeyShareEntry().getPublicKey().getValue())));
    }

    private void prepareCipherSuite(EncryptedServerNameIndicationExtensionMessage msg) {
        List<CipherSuite> clientSupportedCiphersuites = this.chooser.getConfig().getClientSupportedEsniCiphersuites();
        List<CipherSuite> serverSupportedCiphersuites = ((DefaultChooser)this.chooser).getEsniServerCiphersuites();
        List<CipherSuite> implementedCiphersuites = CipherSuite.getEsniImplemented();
        CipherSuite selectedCiphersuite = implementedCiphersuites.get(0);
        boolean isFoundSharedCipher = false;
        for (CipherSuite c : clientSupportedCiphersuites) {
            if (!implementedCiphersuites.contains((Object)c)) continue;
            selectedCiphersuite = c;
            if (!serverSupportedCiphersuites.contains((Object)c)) continue;
            isFoundSharedCipher = true;
            break;
        }
        if (!isFoundSharedCipher) {
            LOGGER.warn("Found no shared cipher. Using " + (Object)((Object)selectedCiphersuite));
        }
        msg.setCipherSuite(selectedCiphersuite.getByteValue());
        LOGGER.debug("CipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuite().getValue())));
    }

    private void prepareEsniRecordBytes(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] recordBytes = this.chooser.getEsniRecordBytes();
        msg.getEncryptedSniComputation().setEsniRecordBytes(recordBytes);
        LOGGER.debug("esniRecordBytes: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getEncryptedSniComputation().getEsniRecordBytes()));
    }

    private void prepareRecordDigest(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] recordDigest = null;
        byte[] record = (byte[])msg.getEncryptedSniComputation().getEsniRecordBytes().getValue();
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        DigestAlgorithm algorithm = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, cipherSuite);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm.getJavaName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PreparationException("Could not prepare recordDigest", e);
        }
        recordDigest = messageDigest.digest(record);
        msg.setRecordDigest(recordDigest);
        LOGGER.debug("RecordDigest: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getRecordDigest().getValue())));
    }

    private void prepareRecordDigestLength(EncryptedServerNameIndicationExtensionMessage msg) {
        msg.setRecordDigestLength(((byte[])msg.getRecordDigest().getValue()).length);
        LOGGER.debug("RecordDigestLength: " + msg.getRecordDigestLength().getValue());
    }

    private void prepareClientRandom(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] clienRandom = this.chooser.getClientRandom();
        clienRandom = this.clientHelloMessage != null ? (byte[])this.clientHelloMessage.getRandom().getValue() : this.chooser.getClientRandom();
        msg.getEncryptedSniComputation().setClientHelloRandom(clienRandom);
        LOGGER.debug("ClientHello: " + ArrayConverter.bytesToHexString((byte[])clienRandom));
    }

    private void prepareEsniContents(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] contents = this.generateEsniContents(msg);
        msg.getEncryptedSniComputation().setEsniContents(contents);
        LOGGER.debug("EsniContents: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniContents().getValue())));
    }

    private void prepareEsniContentsHash(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] contentsHash = null;
        byte[] contents = (byte[])msg.getEncryptedSniComputation().getEsniContents().getValue();
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        DigestAlgorithm algorithm = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, cipherSuite);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm.getJavaName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PreparationException("Could not prepare esniContentsHash", e);
        }
        contentsHash = messageDigest.digest(contents);
        msg.getEncryptedSniComputation().setEsniContentsHash(contentsHash);
        LOGGER.debug("EsniContentsHash: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniContentsHash().getValue())));
    }

    private void prepareEsniClientSharedSecret(EncryptedServerNameIndicationExtensionMessage msg) {
        NamedGroup group = NamedGroup.getNamedGroup((byte[])msg.getKeyShareEntry().getGroup().getValue());
        BigInteger clientPrivatetKey = msg.getKeyShareEntry().getPrivateKey();
        byte[] serverPublicKey = (byte[])msg.getEncryptedSniComputation().getEsniServerPublicKey().getValue();
        byte[] esniSharedSecret = KeyShareCalculator.computeSharedSecret(group, clientPrivatetKey, serverPublicKey);
        msg.getEncryptedSniComputation().setEsniSharedSecret(esniSharedSecret);
        LOGGER.debug("esniSharedSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniSharedSecret().getValue())));
    }

    private void prepareEsniServerSharedSecret(EncryptedServerNameIndicationExtensionMessage msg) {
        NamedGroup group = NamedGroup.getNamedGroup((byte[])msg.getKeyShareEntry().getGroup().getValue());
        boolean isFoundSharedNamedGroup = false;
        BigInteger serverPrivateKey = this.chooser.getConfig().getEsniServerKeyPairs().get(0).getPrivateKey();
        for (KeyShareEntry keyShareEntry : this.chooser.getConfig().getEsniServerKeyPairs()) {
            if (!Arrays.equals((byte[])keyShareEntry.getGroup().getValue(), group.getValue())) continue;
            serverPrivateKey = keyShareEntry.getPrivateKey();
            isFoundSharedNamedGroup = true;
            break;
        }
        if (!isFoundSharedNamedGroup) {
            LOGGER.warn("No private key available for selected named group: " + (Object)((Object)group));
        }
        byte[] clientPublicKey = (byte[])msg.getKeyShareEntry().getPublicKey().getValue();
        byte[] esniSharedSecret = KeyShareCalculator.computeSharedSecret(group, serverPrivateKey, clientPublicKey);
        msg.getEncryptedSniComputation().setEsniSharedSecret(esniSharedSecret);
        LOGGER.debug("esniSharedSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniSharedSecret().getValue())));
    }

    private void prepareEsniMasterSecret(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] esniMasterSecret = null;
        byte[] esniSharedSecret = (byte[])msg.getEncryptedSniComputation().getEsniSharedSecret().getValue();
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(cipherSuite);
        try {
            esniMasterSecret = HKDFunction.extract(hkdfAlgortihm, null, esniSharedSecret);
        }
        catch (CryptoException e) {
            throw new PreparationException("Could not prepare esniMasterSecret", e);
        }
        msg.getEncryptedSniComputation().setEsniMasterSecret(esniMasterSecret);
        LOGGER.debug("esniMasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniMasterSecret().getValue())));
    }

    private void prepareEsniKey(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] key = null;
        byte[] esniMasterSecret = (byte[])msg.getEncryptedSniComputation().getEsniMasterSecret().getValue();
        byte[] hashIn = (byte[])msg.getEncryptedSniComputation().getEsniContentsHash().getValue();
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(cipherSuite);
        int keyLen = AlgorithmResolver.getCipher(cipherSuite).getKeySize();
        try {
            key = HKDFunction.expandLabel(hkdfAlgortihm, esniMasterSecret, "esni key", hashIn, keyLen);
        }
        catch (CryptoException e) {
            throw new PreparationException("Could not prepare esniKey", e);
        }
        msg.getEncryptedSniComputation().setEsniKey(key);
        LOGGER.debug("esniKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniKey().getValue())));
    }

    private void prepareEsniIv(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] iv = null;
        byte[] esniMasterSecret = (byte[])msg.getEncryptedSniComputation().getEsniMasterSecret().getValue();
        byte[] hashIn = (byte[])msg.getEncryptedSniComputation().getEsniContentsHash().getValue();
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(cipherSuite);
        try {
            iv = HKDFunction.expandLabel(hkdfAlgortihm, esniMasterSecret, "esni iv", hashIn, 12);
        }
        catch (CryptoException e) {
            throw new PreparationException("Could not prepare esniIv", e);
        }
        msg.getEncryptedSniComputation().setEsniIv(iv);
        LOGGER.debug("esniIv: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSniComputation().getEsniIv().getValue())));
    }

    private void prepareClientHelloKeyShare(EncryptedServerNameIndicationExtensionMessage msg) {
        int keyShareListBytesLength = 0;
        byte[] keyShareListBytesLengthField = null;
        byte[] keyShareListBytes = null;
        ByteArrayOutputStream clientHelloKeyShareStream = new ByteArrayOutputStream();
        boolean isClientHelloExensionsFound = false;
        if (this.clientHelloMessage != null) {
            List<ExtensionMessage> clientHelloExtensions = this.clientHelloMessage.getExtensions();
            for (ExtensionMessage m : clientHelloExtensions) {
                if (!(m instanceof KeyShareExtensionMessage)) continue;
                KeyShareExtensionMessage keyShareExtensionMessage = (KeyShareExtensionMessage)m;
                keyShareListBytesLength = (Integer)keyShareExtensionMessage.getKeyShareListLength().getValue();
                keyShareListBytes = (byte[])keyShareExtensionMessage.getKeyShareListBytes().getValue();
                isClientHelloExensionsFound = true;
                break;
            }
        }
        if (!isClientHelloExensionsFound) {
            ByteArrayOutputStream keyShareListStream = new ByteArrayOutputStream();
            for (KeyShareStoreEntry pair : this.chooser.getClientKeyShares()) {
                KeyShareEntry entry = new KeyShareEntry();
                KeyShareEntrySerializer serializer = new KeyShareEntrySerializer(entry);
                entry.setGroup(pair.getGroup().getValue());
                entry.setPublicKeyLength(pair.getPublicKey().length);
                entry.setPublicKey(pair.getPublicKey());
                try {
                    keyShareListStream.write(serializer.serialize());
                }
                catch (IOException e) {
                    throw new PreparationException("Failed to write esniContents", e);
                }
            }
            keyShareListBytes = keyShareListStream.toByteArray();
            keyShareListBytesLength = keyShareListBytes.length;
        }
        keyShareListBytesLengthField = ArrayConverter.intToBytes((int)keyShareListBytesLength, (int)2);
        try {
            clientHelloKeyShareStream.write(keyShareListBytesLengthField);
            clientHelloKeyShareStream.write(keyShareListBytes);
        }
        catch (IOException e) {
            throw new PreparationException("Failed to write ClientHelloKeyShare", e);
        }
        byte[] clientHelloKeyShareBytes = clientHelloKeyShareStream.toByteArray();
        msg.getEncryptedSniComputation().setClientHelloKeyShare(clientHelloKeyShareBytes);
        LOGGER.debug("clientHelloKeyShare: " + ArrayConverter.bytesToHexString((byte[])clientHelloKeyShareBytes));
    }

    private void prepareEncryptedSni(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] encryptedSni = null;
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        byte[] plainText = (byte[])msg.getClientEsniInnerBytes().getValue();
        byte[] key = (byte[])msg.getEncryptedSniComputation().getEsniKey().getValue();
        byte[] iv = (byte[])msg.getEncryptedSniComputation().getEsniIv().getValue();
        byte[] aad = (byte[])msg.getEncryptedSniComputation().getClientHelloKeyShare().getValue();
        int tagBitLength = cipherSuite.isCCM_8() ? 64 : 128;
        KeySet keySet = new KeySet();
        keySet.setClientWriteKey(key);
        EncryptionCipher encryptCipher = CipherWrapper.getEncryptionCipher(cipherSuite, ConnectionEndType.CLIENT, keySet);
        try {
            encryptedSni = encryptCipher.encrypt(iv, tagBitLength, aad, plainText);
        }
        catch (CryptoException e) {
            throw new PreparationException("Could not encrypt clientEsniInnerBytes", e);
        }
        msg.setEncryptedSni(encryptedSni);
        LOGGER.debug("EncryptedSni: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSni().getValue())));
    }

    private void parseEncryptedSni(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] clientEsniInnerBytes = null;
        CipherSuite cipherSuite = CipherSuite.getCipherSuite((byte[])msg.getCipherSuite().getValue());
        byte[] cipherText = (byte[])msg.getEncryptedSni().getValue();
        byte[] key = (byte[])msg.getEncryptedSniComputation().getEsniKey().getValue();
        byte[] iv = (byte[])msg.getEncryptedSniComputation().getEsniIv().getValue();
        byte[] aad = (byte[])msg.getEncryptedSniComputation().getClientHelloKeyShare().getValue();
        int tagBitLength = cipherSuite.isCCM_8() ? 64 : 128;
        KeySet keySet = new KeySet();
        keySet.setClientWriteKey(key);
        DecryptionCipher decryptCipher = CipherWrapper.getDecryptionCipher(cipherSuite, ConnectionEndType.SERVER, keySet);
        try {
            clientEsniInnerBytes = decryptCipher.decrypt(iv, tagBitLength, aad, cipherText);
        }
        catch (CryptoException e) {
            throw new PreparationException("Could not decrypt encryptedSni", e);
        }
        msg.setClientEsniInnerBytes(clientEsniInnerBytes);
        LOGGER.debug("ClientesniInnerBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getClientEsniInnerBytes().getValue())));
    }

    private void prepareEncryptedSniLength(EncryptedServerNameIndicationExtensionMessage msg) {
        msg.setEncryptedSniLength(((byte[])msg.getEncryptedSni().getValue()).length);
        LOGGER.debug("EncryptedSniLength: " + msg.getEncryptedSniLength().getValue());
    }

    private void prepareServerNonce(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] receivedClientNonce = this.chooser.getEsniClientNonce();
        msg.setServerNonce(receivedClientNonce);
        LOGGER.debug("ServerNonce: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getServerNonce().getValue())));
    }

    private byte[] generateEsniContents(EncryptedServerNameIndicationExtensionMessage msg) {
        ByteArrayOutputStream contentsStream = new ByteArrayOutputStream();
        try {
            contentsStream.write(msg.getRecordDigestLength().getByteArray(2));
            contentsStream.write((byte[])msg.getRecordDigest().getValue());
            contentsStream.write((byte[])msg.getKeyShareEntry().getGroup().getValue());
            contentsStream.write(msg.getKeyShareEntry().getPublicKeyLength().getByteArray(2));
            contentsStream.write((byte[])msg.getKeyShareEntry().getPublicKey().getValue());
            contentsStream.write((byte[])msg.getEncryptedSniComputation().getClientHelloRandom().getValue());
        }
        catch (IOException e) {
            throw new PreparationException("Failed to generate esniContents", e);
        }
        return contentsStream.toByteArray();
    }

    public EsniPreparatorMode getEsniPreparatorMode() {
        return this.esniPreparatorMode;
    }

    public void setEsniPreparatorMode(EsniPreparatorMode esniPreparatorMode) {
        this.esniPreparatorMode = esniPreparatorMode;
    }

    public static enum EsniPreparatorMode {
        CLIENT,
        SERVER;

    }
}

