/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HelloMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHelloPreparator
extends HelloMessagePreparator<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerHelloMessage msg;

    public ServerHelloPreparator(Chooser chooser, ServerHelloMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ServerHelloMessage");
        this.prepareProtocolVersion();
        this.prepareRandom();
        this.prepareSessionID();
        this.prepareSessionIDLength();
        this.prepareCipherSuite();
        this.prepareCompressionMethod();
        if (!this.chooser.getConfig().getHighestProtocolVersion().isSSL() || this.chooser.getConfig().getHighestProtocolVersion().isSSL() && this.chooser.getConfig().isAddExtensionsInSSL().booleanValue()) {
            this.prepareExtensions();
            this.prepareExtensionLength();
        }
    }

    private void prepareCipherSuite() {
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setSelectedCipherSuite(this.chooser.getConfig().getDefaultSelectedCipherSuite().getByteValue());
        } else {
            CipherSuite selectedSuite = null;
            for (CipherSuite suite : this.chooser.getConfig().getDefaultServerSupportedCiphersuites()) {
                if (!this.chooser.getClientSupportedCiphersuites().contains((Object)suite)) continue;
                selectedSuite = suite;
                break;
            }
            if (selectedSuite == null) {
                selectedSuite = this.chooser.getConfig().getDefaultSelectedCipherSuite();
                LOGGER.warn("No CipherSuites in common, falling back to defaultSelectedCipherSuite");
            }
            this.msg.setSelectedCipherSuite(selectedSuite.getByteValue());
        }
        LOGGER.debug("SelectedCipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getSelectedCipherSuite().getValue())));
    }

    private void prepareCompressionMethod() {
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setSelectedCompressionMethod(this.chooser.getConfig().getDefaultSelectedCompressionMethod().getValue());
        } else {
            CompressionMethod selectedCompressionMethod = null;
            for (CompressionMethod method : this.chooser.getConfig().getDefaultServerSupportedCompressionMethods()) {
                if (!this.chooser.getClientSupportedCompressions().contains((Object)method)) continue;
                selectedCompressionMethod = method;
                break;
            }
            if (selectedCompressionMethod == null) {
                selectedCompressionMethod = this.chooser.getConfig().getDefaultSelectedCompressionMethod();
                LOGGER.warn("No CompressionMethod in common, falling back to defaultSelectedCompressionMethod");
            }
            this.msg.setSelectedCompressionMethod(selectedCompressionMethod.getValue());
        }
        LOGGER.debug("SelectedCompressionMethod: " + this.msg.getSelectedCompressionMethod().getValue());
    }

    private void prepareSessionID() {
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            this.msg.setSessionId(this.chooser.getClientSessionId());
        } else {
            this.msg.setSessionId(this.chooser.getServerSessionId());
        }
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getSessionId().getValue())));
    }

    private void prepareProtocolVersion() {
        ProtocolVersion ourVersion = this.chooser.getConfig().getHighestProtocolVersion();
        if (this.chooser.getConfig().getHighestProtocolVersion().isTLS13()) {
            ourVersion = ProtocolVersion.TLS12;
        }
        ProtocolVersion clientVersion = this.chooser.getHighestClientProtocolVersion();
        int intRepresentationOurVersion = ourVersion.getValue()[0] * 256 + ourVersion.getValue()[1];
        int intRepresentationClientVersion = clientVersion.getValue()[0] * 256 + clientVersion.getValue()[1];
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            this.msg.setProtocolVersion(ourVersion.getValue());
        } else {
            if (this.chooser.getHighestClientProtocolVersion().isDTLS() && this.chooser.getConfig().getHighestProtocolVersion().isDTLS()) {
                if (intRepresentationClientVersion <= intRepresentationOurVersion) {
                    this.msg.setProtocolVersion(ourVersion.getValue());
                } else {
                    this.msg.setProtocolVersion(clientVersion.getValue());
                }
            }
            if (!this.chooser.getHighestClientProtocolVersion().isDTLS() && !this.chooser.getConfig().getHighestProtocolVersion().isDTLS()) {
                if (intRepresentationClientVersion >= intRepresentationOurVersion) {
                    this.msg.setProtocolVersion(ourVersion.getValue());
                } else {
                    this.msg.setProtocolVersion(clientVersion.getValue());
                }
            } else {
                this.msg.setProtocolVersion(this.chooser.getSelectedProtocolVersion().getValue());
            }
        }
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getProtocolVersion().getValue())));
    }
}

