/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionTicketTLSExtensionParser
extends ExtensionParser<SessionTicketTLSExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SessionTicketTLSExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(SessionTicketTLSExtensionMessage msg) {
        if ((Integer)msg.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SessionTLS ticket length shouldn't exceed 2 bytes as defined in RFC 4507. Length was " + msg.getExtensionLength().getValue());
        }
        msg.setTicket(this.parseByteArrayField((Integer)msg.getExtensionLength().getValue()));
        LOGGER.debug("The session ticket TLS parser parsed the value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getTicket()));
    }

    @Override
    protected SessionTicketTLSExtensionMessage createExtensionMessage() {
        return new SessionTicketTLSExtensionMessage();
    }
}

