/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareEntryParser;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionParser
extends ExtensionParser<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<KeyShareEntry> entryList;
    private final ExtensionType type;

    public KeyShareExtensionParser(int startposition, byte[] array, ExtensionType type) {
        super(startposition, array);
        this.type = type;
    }

    @Override
    public void parseExtensionMessageContent(KeyShareExtensionMessage msg) {
        LOGGER.debug("Parsing KeyShareExtensionMessage");
        this.parseKeyShareListLength(msg);
        LOGGER.debug("Parsing KeyShareExtensionMessage");
        if ((Integer)msg.getKeyShareListLength().getValue() + 2 == (Integer)msg.getExtensionLength().getValue()) {
            this.parseKeyShareListBytes(msg);
        } else {
            msg.setKeyShareListLength((Integer)msg.getExtensionLength().getValue());
            LOGGER.debug("KeyShareListLength: " + msg.getExtensionLength().getValue());
            this.setPointer(this.getPointer() - 2);
            this.parseKeyShareListBytes(msg);
        }
        int position = 0;
        this.entryList = new LinkedList<KeyShareEntry>();
        while (position < (Integer)msg.getKeyShareListLength().getValue()) {
            KeyShareEntryParser parser = new KeyShareEntryParser(position, (byte[])msg.getKeyShareListBytes().getValue());
            this.entryList.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing KeySharePairs");
            }
            position = parser.getPointer();
        }
        this.parseKeyShareList(msg);
    }

    @Override
    protected KeyShareExtensionMessage createExtensionMessage() {
        return new KeyShareExtensionMessage();
    }

    private void parseKeyShareListLength(KeyShareExtensionMessage msg) {
        msg.setKeyShareListLength(this.parseIntField(2));
        LOGGER.debug("KeyShareListLength: " + msg.getKeyShareListLength().getValue());
    }

    private void parseKeyShareListBytes(KeyShareExtensionMessage msg) {
        msg.setKeyShareListBytes(this.parseByteArrayField((Integer)msg.getKeyShareListLength().getValue()));
        LOGGER.debug("KeyShareListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getKeyShareListBytes().getValue())));
    }

    private void parseKeyShareList(KeyShareExtensionMessage msg) {
        msg.setKeyShareList(this.entryList);
    }
}

