/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ECDHEServerKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDheServerKeyExchangeParser
extends ECDHEServerKeyExchangeParser<PskEcDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;

    public PskEcDheServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, version, config);
        this.version = version;
    }

    @Override
    protected void parseHandshakeMessageContent(PskEcDheServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKECDHEServerKeyExchangeMessage");
        this.parsePskIdentityHintLength(msg);
        this.parsePskIdentityHint(msg);
        super.parseEcDheParams(msg);
    }

    @Override
    protected PskEcDheServerKeyExchangeMessage createHandshakeMessage() {
        return new PskEcDheServerKeyExchangeMessage();
    }

    private void parsePskIdentityHintLength(PskEcDheServerKeyExchangeMessage msg) {
        msg.setIdentityHintLength(this.parseIntField(2));
        LOGGER.debug("SerializedPSK-IdentityLength: " + msg.getIdentityHintLength().getValue());
    }

    private void parsePskIdentityHint(PskEcDheServerKeyExchangeMessage msg) {
        msg.setIdentityHint(this.parseByteArrayField((Integer)msg.getIdentityHintLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentityHint().getValue())));
    }
}

