/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UserMappingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestV2ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateUrlExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptThenMacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedMasterSecretExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HeartbeatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PaddingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TruncatedHmacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class ClientHelloMessage
extends HelloMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger compressionLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger cipherSuiteLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray cipherSuites;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray compressions;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COOKIE)
    private ModifiableByteArray cookie = null;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableByte cookieLength = null;

    public ClientHelloMessage() {
        super(HandshakeMessageType.CLIENT_HELLO);
    }

    public ClientHelloMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.CLIENT_HELLO);
        if (!tlsConfig.getHighestProtocolVersion().isSSL() || tlsConfig.getHighestProtocolVersion().isSSL() && tlsConfig.isAddExtensionsInSSL().booleanValue()) {
            if (tlsConfig.isAddHeartbeatExtension().booleanValue()) {
                this.addExtension(new HeartbeatExtensionMessage());
            }
            if (tlsConfig.isAddECPointFormatExtension().booleanValue()) {
                this.addExtension(new ECPointFormatExtensionMessage());
            }
            if (tlsConfig.isAddEllipticCurveExtension().booleanValue()) {
                this.addExtension(new EllipticCurvesExtensionMessage());
            }
            if (tlsConfig.isAddMaxFragmentLengthExtension()) {
                this.addExtension(new MaxFragmentLengthExtensionMessage());
            }
            if (tlsConfig.isAddServerNameIndicationExtension().booleanValue()) {
                ServerNameIndicationExtensionMessage extension = new ServerNameIndicationExtensionMessage();
                ServerNamePair pair = new ServerNamePair();
                pair.setServerNameConfig(tlsConfig.getDefaultClientConnection().getHostname().getBytes(Charset.forName("ASCII")));
                pair.setServerNameTypeConfig(tlsConfig.getSniType().getValue());
                extension.getServerNameList().add(pair);
                this.addExtension(extension);
            }
            if (tlsConfig.isAddEncryptedServerNameIndicationExtension().booleanValue()) {
                EncryptedServerNameIndicationExtensionMessage extensionMessage = new EncryptedServerNameIndicationExtensionMessage();
                String hostname = tlsConfig.getDefaultClientConnection().getHostname();
                ServerNamePair pair = new ServerNamePair();
                pair.setServerNameConfig(hostname.getBytes(StandardCharsets.UTF_8));
                extensionMessage.getClientEsniInner().getServerNameList().add(pair);
                this.addExtension(extensionMessage);
            }
            if (tlsConfig.isAddSignatureAndHashAlgrorithmsExtension().booleanValue()) {
                this.addExtension(new SignatureAndHashAlgorithmsExtensionMessage());
            }
            if (tlsConfig.isAddSupportedVersionsExtension().booleanValue()) {
                this.addExtension(new SupportedVersionsExtensionMessage());
            }
            if (tlsConfig.isAddKeyShareExtension().booleanValue()) {
                this.addExtension(new KeyShareExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddEarlyDataExtension().booleanValue()) {
                this.addExtension(new EarlyDataExtensionMessage());
            }
            if (tlsConfig.isAddPSKKeyExchangeModesExtension().booleanValue()) {
                this.addExtension(new PSKKeyExchangeModesExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddExtendedMasterSecretExtension().booleanValue()) {
                this.addExtension(new ExtendedMasterSecretExtensionMessage());
            }
            if (tlsConfig.isAddSessionTicketTLSExtension().booleanValue()) {
                this.addExtension(new SessionTicketTLSExtensionMessage());
            }
            if (tlsConfig.isAddSignedCertificateTimestampExtension().booleanValue()) {
                this.addExtension(new SignedCertificateTimestampExtensionMessage());
            }
            if (tlsConfig.isAddPaddingExtension().booleanValue()) {
                this.addExtension(new PaddingExtensionMessage());
            }
            if (tlsConfig.isAddRenegotiationInfoExtension().booleanValue()) {
                this.addExtension(new RenegotiationInfoExtensionMessage());
            }
            if (tlsConfig.isAddTokenBindingExtension().booleanValue()) {
                this.addExtension(new TokenBindingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestExtension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestExtensionMessage());
            }
            if (tlsConfig.isAddAlpnExtension().booleanValue()) {
                this.addExtension(new AlpnExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddSRPExtension().booleanValue()) {
                this.addExtension(new SRPExtensionMessage());
            }
            if (tlsConfig.isAddSRTPExtension().booleanValue()) {
                this.addExtension(new SrtpExtensionMessage());
            }
            if (tlsConfig.isAddTruncatedHmacExtension().booleanValue()) {
                this.addExtension(new TruncatedHmacExtensionMessage());
            }
            if (tlsConfig.isAddUserMappingExtension().booleanValue()) {
                this.addExtension(new UserMappingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateTypeExtension().booleanValue()) {
                this.addExtension(new CertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddClientAuthzExtension().booleanValue()) {
                this.addExtension(new ClientAuthzExtensionMessage());
            }
            if (tlsConfig.isAddServerAuthzExtension().booleanValue()) {
                this.addExtension(new ServerAuthzExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ClientCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddServerCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ServerCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddEncryptThenMacExtension().booleanValue()) {
                this.addExtension(new EncryptThenMacExtensionMessage());
            }
            if (tlsConfig.isAddCachedInfoExtension().booleanValue()) {
                this.addExtension(new CachedInfoExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateUrlExtension().booleanValue()) {
                this.addExtension(new ClientCertificateUrlExtensionMessage());
            }
            if (tlsConfig.isAddTrustedCaIndicationExtension().booleanValue()) {
                this.addExtension(new TrustedCaIndicationExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestV2Extension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestV2ExtensionMessage());
            }
            if (tlsConfig.isAddPWDProtectExtension().booleanValue()) {
                this.addExtension(new PWDProtectExtensionMessage());
            }
            if (tlsConfig.isAddPWDClearExtension().booleanValue()) {
                this.addExtension(new PWDClearExtensionMessage());
            }
            if (tlsConfig.isAddExtendedRandomExtension()) {
                this.addExtension(new ExtendedRandomExtensionMessage());
            }
            if (tlsConfig.isAddPreSharedKeyExtension().booleanValue()) {
                this.addExtension(new PreSharedKeyExtensionMessage(tlsConfig));
            }
        }
    }

    public ModifiableInteger getCompressionLength() {
        return this.compressionLength;
    }

    public ModifiableInteger getCipherSuiteLength() {
        return this.cipherSuiteLength;
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public ModifiableByteArray getCompressions() {
        return this.compressions;
    }

    public void setCompressionLength(ModifiableInteger compressionLength) {
        this.compressionLength = compressionLength;
    }

    public void setCipherSuiteLength(ModifiableInteger cipherSuiteLength) {
        this.cipherSuiteLength = cipherSuiteLength;
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCompressions(ModifiableByteArray compressions) {
        this.compressions = compressions;
    }

    public void setCompressionLength(int compressionLength) {
        this.compressionLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.compressionLength, (Integer)compressionLength);
    }

    public void setCipherSuiteLength(int cipherSuiteLength) {
        this.cipherSuiteLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuiteLength, (Integer)cipherSuiteLength);
    }

    public void setCipherSuites(byte[] array) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])array);
    }

    public void setCompressions(byte[] array) {
        this.compressions = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.compressions, (byte[])array);
    }

    public ModifiableByteArray getCookie() {
        return this.cookie;
    }

    public ModifiableByte getCookieLength() {
        return this.cookieLength;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cookie, (byte[])cookie);
    }

    public void setCookie(ModifiableByteArray cookie) {
        this.cookie = cookie;
    }

    public void setCookieLength(byte cookieLength) {
        this.cookieLength = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.cookieLength, (Byte)cookieLength);
    }

    public void setCookieLength(ModifiableByte cookieLength) {
        this.cookieLength = cookieLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Client Unix Time: ");
        if (this.getUnixTime() != null && this.getUnixTime().getValue() != null) {
            sb.append(new Date(ArrayConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
        } else {
            sb.append("null");
        }
        sb.append("\n  Client Random: ");
        if (this.getRandom() != null && this.getRandom().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getRandom().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Session ID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported Cipher Suites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported Compression Methods: ");
        if (this.getCompressions() != null && this.getCompressions().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getCompressions().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Extensions: ");
        if (this.getExtensions() != null) {
            for (ExtensionMessage extension : this.getExtensions()) {
                sb.append(extension.toString()).append("\n");
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new ClientHelloHandler(context);
    }
}

