/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateVerifyHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class CertificateVerifyMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray signatureHashAlgorithm;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger signatureLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.SIGNATURE)
    private ModifiableByteArray signature;

    public CertificateVerifyMessage() {
        super(HandshakeMessageType.CERTIFICATE_VERIFY);
    }

    public CertificateVerifyMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.CERTIFICATE_VERIFY);
    }

    public ModifiableByteArray getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public void setSignatureHashAlgorithm(ModifiableByteArray signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }

    public void setSignatureHashAlgorithm(byte[] signatureHashAlgorithm) {
        this.signatureHashAlgorithm = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureHashAlgorithm, (byte[])signatureHashAlgorithm);
    }

    public ModifiableInteger getSignatureLength() {
        return this.signatureLength;
    }

    public void setSignatureLength(ModifiableInteger signatureLength) {
        this.signatureLength = signatureLength;
    }

    public void setSignatureLength(int length) {
        this.signatureLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureLength, (Integer)length);
    }

    public ModifiableByteArray getSignature() {
        return this.signature;
    }

    public void setSignature(ModifiableByteArray signature) {
        this.signature = signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signature, (byte[])signature);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateVerifyMessage:");
        builder.append("\n  SignatureAndHashAlgorithm: ");
        if (this.signatureHashAlgorithm != null && this.signatureHashAlgorithm.getValue() != null) {
            builder.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.signatureHashAlgorithm.getValue())));
        } else {
            builder.append("null");
        }
        builder.append("\n  Signature Length: ");
        if (this.signatureLength != null && this.signatureLength.getValue() != null) {
            builder.append(this.signatureLength.getValue());
        } else {
            builder.append("null");
        }
        builder.append("\n  Signature: ");
        if (this.signature != null && this.signature.getValue() != null) {
            builder.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.signature.getValue())));
        } else {
            builder.append("null");
        }
        return builder.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new CertificateVerifyHandler(context);
    }
}

