/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ClientMasterKeyPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2ClientMasterKeySerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class SSL2ClientMasterKeyHandler
extends ProtocolMessageHandler<SSL2ClientMasterKeyMessage> {
    public SSL2ClientMasterKeyHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ProtocolMessageParser<SSL2ClientMasterKeyMessage> getParser(byte[] message, int pointer) {
        return null;
    }

    public SSL2ClientMasterKeyPreparator getPreparator(SSL2ClientMasterKeyMessage message) {
        return new SSL2ClientMasterKeyPreparator(this.tlsContext.getChooser(), message);
    }

    public SSL2ClientMasterKeySerializer getSerializer(SSL2ClientMasterKeyMessage message) {
        return new SSL2ClientMasterKeySerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(SSL2ClientMasterKeyMessage message) {
        byte[] premasterSecret = (byte[])message.getComputations().getPremasterSecret().getValue();
        this.tlsContext.setPreMasterSecret(premasterSecret);
        this.tlsContext.setClearKey((byte[])message.getClearKeyData().getValue());
        if (this.tlsContext.getChooser().getSSL2CipherSuite().getBlockSize() != 0) {
            this.tlsContext.setSSL2Iv((byte[])message.getKeyArgData().getValue());
        }
    }
}

