/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementF2m;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurveOverF2m
extends EllipticCurve {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FieldElementF2m a;
    private final FieldElementF2m b;

    public EllipticCurveOverF2m(BigInteger a, BigInteger b, BigInteger polynomial) {
        super(polynomial);
        this.a = new FieldElementF2m(a, this.getModulus());
        this.b = new FieldElementF2m(b, this.getModulus());
    }

    public EllipticCurveOverF2m(BigInteger a, BigInteger b, BigInteger polynomial, BigInteger x, BigInteger y, BigInteger q) {
        super(polynomial, x, y, q);
        this.a = new FieldElementF2m(a, this.getModulus());
        this.b = new FieldElementF2m(b, this.getModulus());
    }

    @Override
    public Point getPoint(BigInteger x, BigInteger y) {
        FieldElementF2m elemX = new FieldElementF2m(x, this.getModulus());
        FieldElementF2m elemY = new FieldElementF2m(y, this.getModulus());
        return new Point(elemX, elemY);
    }

    @Override
    public boolean isOnCurve(Point p) {
        if (p.isAtInfinity()) {
            return true;
        }
        if (p.getX().getClass() != FieldElementF2m.class || p.getY().getClass() != FieldElementF2m.class) {
            return false;
        }
        FieldElementF2m x = (FieldElementF2m)p.getX();
        FieldElementF2m y = (FieldElementF2m)p.getY();
        if (x.getModulus() != this.getModulus() || y.getModulus() != this.getModulus()) {
            return false;
        }
        FieldElementF2m leftPart = (FieldElementF2m)y.mult(y).add(x.mult(y));
        FieldElementF2m rightPart = (FieldElementF2m)x.mult(x.mult(x)).add(x.mult(x).mult(this.a)).add(this.b);
        return leftPart.equals(rightPart);
    }

    @Override
    protected Point inverseAffine(Point p) {
        if (!(p.getX() instanceof FieldElementF2m) || !(p.getY() instanceof FieldElementF2m)) {
            LOGGER.warn("Trying to invert non F2m point with F2m curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        FieldElementF2m x = (FieldElementF2m)p.getX();
        FieldElementF2m invY = (FieldElementF2m)p.getY().add(x);
        return new Point(x, invY);
    }

    @Override
    protected Point additionFormular(Point p, Point q) {
        if (!(p.getX() instanceof FieldElementF2m && p.getY() instanceof FieldElementF2m && q.getX() instanceof FieldElementF2m && q.getY() instanceof FieldElementF2m)) {
            LOGGER.warn("Trying to add non F2m points with F2m curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        try {
            FieldElementF2m y3;
            FieldElementF2m x3;
            FieldElementF2m x1 = (FieldElementF2m)p.getX();
            FieldElementF2m y1 = (FieldElementF2m)p.getY();
            FieldElementF2m x2 = (FieldElementF2m)q.getX();
            FieldElementF2m y2 = (FieldElementF2m)q.getY();
            if (!x1.equals(x2)) {
                FieldElementF2m lambda = (FieldElementF2m)y1.add(y2).divide(x1.add(x2));
                x3 = (FieldElementF2m)lambda.mult(lambda).add(lambda).add(x1).add(x2).add(this.a);
                y3 = (FieldElementF2m)lambda.mult(x1.add(x3)).add(x3).add(y1);
            } else {
                FieldElementF2m one = new FieldElementF2m(BigInteger.ONE, this.getModulus());
                FieldElementF2m lambda = (FieldElementF2m)x1.add(y1.divide(x1));
                x3 = (FieldElementF2m)lambda.mult(lambda).add(lambda).add(this.a);
                y3 = (FieldElementF2m)x1.mult(x1).add(lambda.add(one).mult(x3));
            }
            return new Point(x3, y3);
        }
        catch (ArithmeticException e) {
            LOGGER.warn("Encountered an arithmetic exception during addition. Returning point at 0,0");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
    }

    @Override
    public FieldElement createFieldElement(BigInteger value) {
        return new FieldElementF2m(value, this.getModulus());
    }

    @Override
    public Point createAPointOnCurve(BigInteger x) {
        throw new UnsupportedOperationException("Currently not supported");
    }
}

