/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import de.rub.nds.modifiablevariable.FileConfigurationException;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.singlebyte.ByteAddModification;
import de.rub.nds.modifiablevariable.singlebyte.ByteExplicitValueModification;
import de.rub.nds.modifiablevariable.singlebyte.ByteSubtractModification;
import de.rub.nds.modifiablevariable.singlebyte.ByteXorModification;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ByteModificationFactory {
    private static final int BYTE_EXPLICIT_VALUE_MODIFICATION = 3;
    private static final int BYTE_XOR_MODIFICATION = 2;
    private static final int BYTE_SUBTRACT_MODIFICATION = 1;
    private static final int BYTE_ADD_MODIFICATION = 0;
    private static final int MODIFICATION_COUNT = 5;
    private static List<VariableModification<Byte>> modificationsFromFile;
    public static final String FILE_NAME = "de/rub/nds/modifiablevariable/explicit/byte.vec";

    public static ByteAddModification add(String summand) {
        return ByteModificationFactory.add(new Byte(summand));
    }

    public static ByteAddModification add(Byte summand) {
        return new ByteAddModification(summand);
    }

    public static VariableModification<Byte> sub(String subtrahend) {
        return ByteModificationFactory.sub(new Byte(subtrahend));
    }

    public static VariableModification<Byte> sub(Byte subtrahend) {
        return new ByteSubtractModification(subtrahend);
    }

    public static VariableModification<Byte> xor(String xor) {
        return ByteModificationFactory.xor(new Byte(xor));
    }

    public static VariableModification<Byte> xor(Byte xor) {
        return new ByteXorModification(xor);
    }

    public static VariableModification<Byte> explicitValue(String value) {
        return ByteModificationFactory.explicitValue(new Byte(value));
    }

    public static VariableModification<Byte> explicitValue(Byte value) {
        return new ByteExplicitValueModification(value);
    }

    public static VariableModification<Byte> explicitValueFromFile(int value) {
        List<VariableModification<Byte>> modifications = ByteModificationFactory.modificationsFromFile();
        int pos = value % modifications.size();
        return modifications.get(pos);
    }

    public static synchronized List<VariableModification<Byte>> modificationsFromFile() {
        try {
            if (modificationsFromFile == null) {
                String line;
                modificationsFromFile = new LinkedList<VariableModification<Byte>>();
                ClassLoader classLoader = ByteModificationFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream(FILE_NAME);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    String value = line.trim().split(" ")[0];
                    modificationsFromFile.add(ByteModificationFactory.explicitValue(value));
                }
            }
            return modificationsFromFile;
        }
        catch (IOException ex) {
            throw new FileConfigurationException("Modifiable variable file name could not have been found.", ex);
        }
    }

    public static VariableModification<Byte> createRandomModification() {
        Random random = RandomHelper.getRandom();
        int r = random.nextInt(5);
        byte modification = (byte)random.nextInt(127);
        VariableModification vm = null;
        switch (r) {
            case 0: {
                vm = new ByteAddModification(modification);
                return vm;
            }
            case 1: {
                vm = new ByteSubtractModification(modification);
                return vm;
            }
            case 2: {
                vm = new ByteXorModification(modification);
                return vm;
            }
            case 3: {
                vm = new ByteExplicitValueModification(modification);
                return vm;
            }
            case 4: {
                vm = ByteModificationFactory.explicitValueFromFile(random.nextInt(127));
                return vm;
            }
        }
        return vm;
    }

    private ByteModificationFactory() {
    }
}

