/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"explicitValue", "modificationFilter", "postModification"})
public class BigIntegerExplicitValueModification
extends VariableModification<BigInteger> {
    private static final int MAX_EXPLICIT_LENGTH = 8;
    private BigInteger explicitValue;

    public BigIntegerExplicitValueModification() {
    }

    public BigIntegerExplicitValueModification(BigInteger bi) {
        this.explicitValue = bi;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        return this.explicitValue;
    }

    public BigInteger getExplicitValue() {
        return this.explicitValue;
    }

    public void setExplicitValue(BigInteger explicitValue) {
        this.explicitValue = explicitValue;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        Random r = new Random();
        if (r.nextBoolean()) {
            return new BigIntegerExplicitValueModification(this.explicitValue.add(new BigInteger(8, r)));
        }
        return new BigIntegerExplicitValueModification(this.explicitValue.subtract(new BigInteger(8, r)));
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.explicitValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerExplicitValueModification other = (BigIntegerExplicitValueModification)obj;
        return Objects.equals(this.explicitValue, other.explicitValue);
    }
}

