/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.Asn1EncoderForX509;
import de.rub.nds.asn1.encoder.Asn1TypeRegister;
import de.rub.nds.asn1.encoder.typeprocessors.DefaultX509TypeProcessor;
import de.rub.nds.asn1.encoder.typeprocessors.SubjectPublicKeyInfoTypeProcessor;
import de.rub.nds.asn1.model.Asn1PseudoType;
import de.rub.nds.asn1.model.KeyInfo;
import de.rub.nds.asn1.model.SignatureInfo;
import de.rub.nds.asn1.parser.Asn1Parser;
import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.asn1.parser.contentunpackers.ContentUnpacker;
import de.rub.nds.asn1.parser.contentunpackers.ContentUnpackerRegister;
import de.rub.nds.asn1.parser.contentunpackers.DefaultContentUnpacker;
import de.rub.nds.asn1.parser.contentunpackers.PrimitiveBitStringUnpacker;
import de.rub.nds.asn1.translator.ContextRegister;
import de.rub.nds.asn1.translator.ParseNativeTypesContext;
import de.rub.nds.asn1.util.AttributeParser;
import de.rub.nds.asn1tool.Asn1Tool;
import de.rub.nds.asn1tool.filesystem.TextFileReader;
import de.rub.nds.asn1tool.xmlparser.Asn1XmlContent;
import de.rub.nds.asn1tool.xmlparser.JaxbClassList;
import de.rub.nds.asn1tool.xmlparser.XmlConverter;
import de.rub.nds.asn1tool.xmlparser.XmlParser;
import de.rub.nds.x509attacker.fileystem.CertificateFileReader;
import de.rub.nds.x509attacker.fileystem.CertificateFileWriter;
import de.rub.nds.x509attacker.keyfilemanager.KeyFileManager;
import de.rub.nds.x509attacker.keyfilemanager.KeyFileManagerException;
import de.rub.nds.x509attacker.linker.Linker;
import de.rub.nds.x509attacker.xmlsignatureengine.XmlSignatureEngine;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class X509Attacker {
    public static void main(String[] args) {
        if (args.length > 0) {
            switch (args[0]) {
                case "xml2cert": {
                    if (args.length == 4) {
                        X509Attacker.xmlToCertificate(args[1], args[2], args[3]);
                        break;
                    }
                    X509Attacker.printHelp();
                    break;
                }
                case "cert2xml": {
                    if (args.length == 3) {
                        X509Attacker.certificateToXml(args[1], args[2]);
                        break;
                    }
                    X509Attacker.printHelp();
                    break;
                }
                default: {
                    X509Attacker.printHelp();
                    break;
                }
            }
        } else {
            X509Attacker.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: x509attacker xml2cert [input xml file] [key file directory] [output certificate directory]");
        System.out.println("   or: x509attacker cert2xml [input certificate file] [output xml file]");
        System.out.println();
        System.out.println("[input xml file]                the file name of the xml input file");
        System.out.println("[key file directory]            the directory where key files are stored");
        System.out.println("[output certificate directory]  the directory where output certificates are created");
        System.out.println();
        System.out.println("[input certificate file]        the input certificate file");
        System.out.println("[output xml file]               the output xml file");
    }

    public static void xmlToCertificate(String xmlFile, String keyDirectory, String certificateOutputDirectory) {
        try {
            X509Attacker.registerXmlClasses();
            X509Attacker.registerTypes();
            TextFileReader textFileReader = new TextFileReader(xmlFile);
            String xmlString = textFileReader.read();
            XmlParser xmlParser = new XmlParser(xmlString);
            Asn1XmlContent asn1XmlContent = xmlParser.getAsn1XmlContent();
            Map identifierMap = xmlParser.getIdentifierMap();
            Linker linker = new Linker(identifierMap);
            KeyFileManager keyFileManager = KeyFileManager.getReference();
            keyFileManager.init(keyDirectory);
            XmlSignatureEngine xmlSignatureEngine = new XmlSignatureEngine(linker, identifierMap);
            xmlSignatureEngine.computeSignatures();
            List certificates = asn1XmlContent.getAsn1Encodables();
            byte[][] encodedCertificates = new byte[certificates.size()][];
            for (int i = 0; i < certificates.size(); ++i) {
                encodedCertificates[i] = Asn1EncoderForX509.encodeForCertificate(linker, (Asn1Encodable)certificates.get(i));
            }
            X509Attacker.writeCertificates(certificateOutputDirectory, certificates, encodedCertificates);
            System.out.println("Done.");
        }
        catch (KeyFileManagerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void certificateToXml(String certificateFile, String xmlFile) {
        try {
            X509Attacker.registerXmlClasses();
            X509Attacker.registerTypes();
            X509Attacker.registerContexts();
            X509Attacker.registerContentUnpackers();
            CertificateFileReader certificateFileReader = new CertificateFileReader(certificateFile);
            byte[] certificateContent = certificateFileReader.readBytes();
            Asn1Parser asn1Parser = new Asn1Parser(certificateContent, false);
            List asn1Encodables = asn1Parser.parse(ParseNativeTypesContext.NAME);
            Asn1XmlContent asn1XmlContent = new Asn1XmlContent();
            asn1XmlContent.setAsn1Encodables(asn1Encodables);
            XmlConverter xmlConverter = new XmlConverter(asn1XmlContent, new File(xmlFile));
            System.out.println("Done.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public static void registerXmlClasses() {
        JaxbClassList jaxbClassList = JaxbClassList.getInstance();
        jaxbClassList.addClasses(Asn1Tool.getAsn1ToolJaxbClasses());
        jaxbClassList.addClasses(new Class[]{Asn1PseudoType.class, SignatureInfo.class, KeyInfo.class});
    }

    public static void registerTypes() {
        Asn1TypeRegister asn1TypeRegister = Asn1TypeRegister.getInstance();
        asn1TypeRegister.setDefaultTypeProcessorClass(DefaultX509TypeProcessor.class);
        asn1TypeRegister.register("SubjectPublicKeyInfo", SubjectPublicKeyInfoTypeProcessor.class);
    }

    public static void registerContexts() {
        ContextRegister contextRegister = ContextRegister.getInstance();
        contextRegister.registerContext(ParseNativeTypesContext.NAME, ParseNativeTypesContext.class);
    }

    public static void registerContentUnpackers() {
        ContentUnpackerRegister contentUnpackerRegister = ContentUnpackerRegister.getInstance();
        contentUnpackerRegister.registerContentUnpacker((ContentUnpacker)new DefaultContentUnpacker());
        contentUnpackerRegister.registerContentUnpacker((ContentUnpacker)new PrimitiveBitStringUnpacker());
    }

    public static void writeCertificates(String certificateOutputDirectory, List<Asn1Encodable> certificates, byte[][] encodedCertificates) throws IOException {
        CertificateFileWriter certificateChainFileWriter = new CertificateFileWriter(certificateOutputDirectory, "certificate_chain.pem");
        for (int i = 0; i < certificates.size(); ++i) {
            Asn1Encodable certificate = certificates.get(i);
            if (!certificate.getType().equalsIgnoreCase("Certificate")) continue;
            if (AttributeParser.parseBooleanAttributeOrDefault((Asn1Encodable)certificate, (String)"attachToCertificateList", (boolean)false)) {
                certificateChainFileWriter.writeCertificate(encodedCertificates[i]);
            }
            X509Attacker.writeSingleCertificate(certificateOutputDirectory, certificate, encodedCertificates[i]);
        }
        certificateChainFileWriter.close();
    }

    private static void writeSingleCertificate(String certificateOutputDirectory, Asn1Encodable certificate, byte[] encodedCertificate) throws IOException {
        String certificateFileName = certificate.getIdentifier() + ".pem";
        CertificateFileWriter certificateFileWriter = new CertificateFileWriter(certificateOutputDirectory, certificateFileName);
        certificateFileWriter.writeCertificate(encodedCertificate);
        certificateFileWriter.close();
    }
}

