/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.handler.sql.SolrTable;

class SolrSchema
extends AbstractSchema
implements Closeable {
    final Properties properties;
    final SolrClientCache solrClientCache;
    private volatile boolean isClosed = false;

    SolrSchema(Properties properties, SolrClientCache solrClientCache) {
        this.properties = properties;
        this.solrClientCache = solrClientCache;
    }

    public SolrClientCache getSolrClientCache() {
        return this.solrClientCache;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected Map<String, Table> getTableMap() {
        String zk = this.properties.getProperty("zk");
        CloudSolrClient cloudSolrClient = this.solrClientCache.getCloudSolrClient(zk);
        ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set collections = clusterState.getCollectionsMap().keySet();
        for (String collection : collections) {
            builder.put((Object)collection, (Object)new SolrTable(this, collection));
        }
        Aliases aliases = zkStateReader.getAliases();
        for (String alias : aliases.getCollectionAliasListMap().keySet()) {
            if (collections.contains(alias)) continue;
            builder.put((Object)alias, (Object)new SolrTable(this, alias));
        }
        return builder.build();
    }

    private Map<String, LukeResponse.FieldInfo> getFieldInfo(String collection) {
        String zk = this.properties.getProperty("zk");
        CloudSolrClient cloudSolrClient = this.solrClientCache.getCloudSolrClient(zk);
        try {
            LukeRequest lukeRequest = new LukeRequest();
            lukeRequest.setNumTerms(0);
            LukeResponse lukeResponse = (LukeResponse)lukeRequest.process((SolrClient)cloudSolrClient, collection);
            return lukeResponse.getFieldInfo();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    RelProtoDataType getRelDataType(String collection) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        Map<String, LukeResponse.FieldInfo> luceneFieldInfoMap = this.getFieldInfo(collection);
        for (Map.Entry<String, LukeResponse.FieldInfo> entry : luceneFieldInfoMap.entrySet()) {
            RelDataType type;
            LukeResponse.FieldInfo luceneFieldInfo = entry.getValue();
            String luceneFieldType = luceneFieldInfo.getType();
            if (luceneFieldType == null) continue;
            switch (luceneFieldType) {
                case "string": {
                    type = typeFactory.createJavaType(String.class);
                    break;
                }
                case "tint": 
                case "tlong": 
                case "int": 
                case "long": 
                case "pint": 
                case "plong": {
                    type = typeFactory.createJavaType(Long.class);
                    break;
                }
                case "tfloat": 
                case "tdouble": 
                case "float": 
                case "double": 
                case "pfloat": 
                case "pdouble": {
                    type = typeFactory.createJavaType(Double.class);
                    break;
                }
                default: {
                    type = typeFactory.createJavaType(String.class);
                }
            }
            fieldInfo.add(entry.getKey(), type).nullable(true);
        }
        fieldInfo.add("_query_", typeFactory.createJavaType(String.class));
        fieldInfo.add("score", typeFactory.createJavaType(Double.class));
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }
}

