/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.SegmentWalker;
import de.escape.quincunx.dxf.reader.DxfLTYPE;
import java.util.NoSuchElementException;

public class LineStyle {
    private String name;
    private boolean isConti = false;
    private float patternLength;
    private float[] pattern;
    private boolean startsWithDot;

    public LineStyle(DxfLTYPE ltype, float scale) {
        this.name = ltype.getName();
        boolean bl = this.isConti = ltype == null || ltype.isContinuous();
        if (!this.isConti) {
            this.patternLength = ltype.getPatternLength() * scale;
            this.pattern = ltype.getPattern();
            if (this.pattern != null) {
                int p = this.pattern.length - 1;
                while (p >= 0) {
                    int n = p--;
                    this.pattern[n] = this.pattern[n] * scale;
                }
            }
            this.startsWithDot = this.pattern[0] == 0.0f;
        }
    }

    public SegmentWalker lineSegments(float lineLength, boolean closed) {
        int repetitions = (int)(lineLength / this.patternLength);
        return this.isConti || lineLength == 0.0f || LineStyleManager.MAX_NUMBER_REPETITIONS > 0 && repetitions > LineStyleManager.MAX_NUMBER_REPETITIONS ? null : new Walker(lineLength, closed);
    }

    public String toString() {
        return "LineStyle(name=" + this.name + ",length=" + this.patternLength + ")";
    }

    class Walker
    implements SegmentWalker {
        private int multiply;
        private float[] intro;
        private float[] extro;
        private int step;
        private int introSteps;
        private int middleSteps;
        private int extroSteps;
        private int allSteps;
        private float stretch = 1.0f;

        Walker(float lineLength, boolean closed) {
            LineStyle.this = LineStyle.this;
            float repeat = lineLength / LineStyle.this.patternLength;
            int repetition = (int)repeat;
            if (closed) {
                if (repeat >= 1.0f) {
                    this.stretch = repeat / (float)repetition;
                    this.middleSteps = LineStyle.this.pattern.length * repetition;
                } else {
                    this.intro = new float[1];
                    this.intro[0] = lineLength;
                    this.introSteps = 1;
                }
            } else {
                float rest = lineLength - (float)repetition * LineStyle.this.patternLength;
                if (lineLength > LineStyle.this.patternLength) {
                    if (LineStyle.this.startsWithDot) {
                        float sumOfHoles = -rest + LineStyle.this.pattern[1] + LineStyle.this.pattern[LineStyle.this.pattern.length - 1];
                        if (repetition >= 2) {
                            this.intro = new float[LineStyle.this.pattern.length];
                            this.extro = new float[LineStyle.this.pattern.length + 1];
                            System.arraycopy(LineStyle.this.pattern, 0, this.intro, 0, LineStyle.this.pattern.length);
                            System.arraycopy(LineStyle.this.pattern, 0, this.extro, 0, LineStyle.this.pattern.length);
                            float f = sumOfHoles / 2.0f;
                            this.extro[((LineStyle)LineStyle.this).pattern.length - 1] = f;
                            this.intro[1] = f;
                            this.introSteps = this.intro.length;
                            this.extroSteps = this.extro.length;
                            this.middleSteps = (repetition - 2) * LineStyle.this.pattern.length;
                        } else {
                            this.intro = new float[LineStyle.this.pattern.length + 1];
                            System.arraycopy(LineStyle.this.pattern, 0, this.intro, 0, LineStyle.this.pattern.length);
                            float f = sumOfHoles / 2.0f;
                            this.intro[((LineStyle)LineStyle.this).pattern.length - 1] = f;
                            this.intro[1] = f;
                            this.introSteps = this.intro.length;
                        }
                    } else {
                        float sumOfLines = rest + LineStyle.this.pattern[0];
                        this.intro = new float[LineStyle.this.pattern.length];
                        this.extro = new float[1];
                        System.arraycopy(LineStyle.this.pattern, 0, this.intro, 0, LineStyle.this.pattern.length);
                        this.intro[0] = this.extro[0] = sumOfLines / 2.0f;
                        this.introSteps = this.intro.length;
                        this.middleSteps = (repetition - 1) * LineStyle.this.pattern.length;
                        this.extroSteps = this.extro.length;
                    }
                } else {
                    this.intro = new float[1];
                    this.intro[0] = lineLength;
                    this.introSteps = 1;
                }
            }
            this.allSteps = this.introSteps + this.middleSteps + this.extroSteps;
            this.step = 0;
        }

        public boolean hasMoreSegments() {
            return this.step < this.allSteps;
        }

        public float nextSegment() {
            int pos;
            if ((pos = this.step++) < this.introSteps) {
                return this.intro[pos];
            }
            if ((pos -= this.introSteps) < this.middleSteps) {
                return LineStyle.this.pattern[pos % LineStyle.this.pattern.length] * this.stretch;
            }
            if ((pos -= this.middleSteps) < this.extroSteps) {
                return this.extro[pos];
            }
            throw new NoSuchElementException();
        }
    }
}

