/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMDiagnosticHandler;
import org.lwjgl.llvm.LLVMDiagnosticHandlerI;
import org.lwjgl.llvm.LLVMYieldCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class LLVMCore {
    public static final int LLVMRet = 1;
    public static final int LLVMBr = 2;
    public static final int LLVMSwitch = 3;
    public static final int LLVMIndirectBr = 4;
    public static final int LLVMInvoke = 5;
    public static final int LLVMUnreachable = 7;
    public static final int LLVMFNeg = 66;
    public static final int LLVMAdd = 8;
    public static final int LLVMFAdd = 9;
    public static final int LLVMSub = 10;
    public static final int LLVMFSub = 11;
    public static final int LLVMMul = 12;
    public static final int LLVMFMul = 13;
    public static final int LLVMUDiv = 14;
    public static final int LLVMSDiv = 15;
    public static final int LLVMFDiv = 16;
    public static final int LLVMURem = 17;
    public static final int LLVMSRem = 18;
    public static final int LLVMFRem = 19;
    public static final int LLVMShl = 20;
    public static final int LLVMLShr = 21;
    public static final int LLVMAShr = 22;
    public static final int LLVMAnd = 23;
    public static final int LLVMOr = 24;
    public static final int LLVMXor = 25;
    public static final int LLVMAlloca = 26;
    public static final int LLVMLoad = 27;
    public static final int LLVMStore = 28;
    public static final int LLVMGetElementPtr = 29;
    public static final int LLVMTrunc = 30;
    public static final int LLVMZExt = 31;
    public static final int LLVMSExt = 32;
    public static final int LLVMFPToUI = 33;
    public static final int LLVMFPToSI = 34;
    public static final int LLVMUIToFP = 35;
    public static final int LLVMSIToFP = 36;
    public static final int LLVMFPTrunc = 37;
    public static final int LLVMFPExt = 38;
    public static final int LLVMPtrToInt = 39;
    public static final int LLVMIntToPtr = 40;
    public static final int LLVMBitCast = 41;
    public static final int LLVMAddrSpaceCast = 60;
    public static final int LLVMICmp = 42;
    public static final int LLVMFCmp = 43;
    public static final int LLVMPHI = 44;
    public static final int LLVMCall = 45;
    public static final int LLVMSelect = 46;
    public static final int LLVMUserOp1 = 47;
    public static final int LLVMUserOp2 = 48;
    public static final int LLVMVAArg = 49;
    public static final int LLVMExtractElement = 50;
    public static final int LLVMInsertElement = 51;
    public static final int LLVMShuffleVector = 52;
    public static final int LLVMExtractValue = 53;
    public static final int LLVMInsertValue = 54;
    public static final int LLVMFence = 55;
    public static final int LLVMAtomicCmpXchg = 56;
    public static final int LLVMAtomicRMW = 57;
    public static final int LLVMResume = 58;
    public static final int LLVMLandingPad = 59;
    public static final int LLVMCleanupRet = 61;
    public static final int LLVMCatchRet = 62;
    public static final int LLVMCatchPad = 63;
    public static final int LLVMCleanupPad = 64;
    public static final int LLVMCatchSwitch = 65;
    public static final int LLVMVoidTypeKind = 0;
    public static final int LLVMHalfTypeKind = 1;
    public static final int LLVMFloatTypeKind = 2;
    public static final int LLVMDoubleTypeKind = 3;
    public static final int LLVMX86_FP80TypeKind = 4;
    public static final int LLVMFP128TypeKind = 5;
    public static final int LLVMPPC_FP128TypeKind = 6;
    public static final int LLVMLabelTypeKind = 7;
    public static final int LLVMIntegerTypeKind = 8;
    public static final int LLVMFunctionTypeKind = 9;
    public static final int LLVMStructTypeKind = 10;
    public static final int LLVMArrayTypeKind = 11;
    public static final int LLVMPointerTypeKind = 12;
    public static final int LLVMVectorTypeKind = 13;
    public static final int LLVMMetadataTypeKind = 14;
    public static final int LLVMX86_MMXTypeKind = 15;
    public static final int LLVMTokenTypeKind = 16;
    public static final int LLVMExternalLinkage = 0;
    public static final int LLVMAvailableExternallyLinkage = 1;
    public static final int LLVMLinkOnceAnyLinkage = 2;
    public static final int LLVMLinkOnceODRLinkage = 3;
    public static final int LLVMLinkOnceODRAutoHideLinkage = 4;
    public static final int LLVMWeakAnyLinkage = 5;
    public static final int LLVMWeakODRLinkage = 6;
    public static final int LLVMAppendingLinkage = 7;
    public static final int LLVMInternalLinkage = 8;
    public static final int LLVMPrivateLinkage = 9;
    public static final int LLVMDLLImportLinkage = 10;
    public static final int LLVMDLLExportLinkage = 11;
    public static final int LLVMExternalWeakLinkage = 12;
    public static final int LLVMGhostLinkage = 13;
    public static final int LLVMCommonLinkage = 14;
    public static final int LLVMLinkerPrivateLinkage = 15;
    public static final int LLVMLinkerPrivateWeakLinkage = 16;
    public static final int LLVMDefaultVisibility = 0;
    public static final int LLVMHiddenVisibility = 1;
    public static final int LLVMProtectedVisibility = 2;
    public static final int LLVMNoUnnamedAddr = 0;
    public static final int LLVMLocalUnnamedAddr = 1;
    public static final int LLVMGlobalUnnamedAddr = 2;
    public static final int LLVMDefaultStorageClass = 0;
    public static final int LLVMDLLImportStorageClass = 1;
    public static final int LLVMDLLExportStorageClass = 2;
    public static final int LLVMCCallConv = 0;
    public static final int LLVMFastCallConv = 8;
    public static final int LLVMColdCallConv = 9;
    public static final int LLVMGHCCallConv = 10;
    public static final int LLVMHiPECallConv = 11;
    public static final int LLVMWebKitJSCallConv = 12;
    public static final int LLVMAnyRegCallConv = 13;
    public static final int LLVMPreserveMostCallConv = 14;
    public static final int LLVMPreserveAllCallConv = 15;
    public static final int LLVMSwiftCallConv = 16;
    public static final int LLVMCXXFASTTLSCallConv = 17;
    public static final int LLVMX86StdcallCallConv = 64;
    public static final int LLVMX86FastcallCallConv = 65;
    public static final int LLVMARMAPCSCallConv = 66;
    public static final int LLVMARMAAPCSCallConv = 67;
    public static final int LLVMARMAAPCSVFPCallConv = 68;
    public static final int LLVMMSP430INTRCallConv = 69;
    public static final int LLVMX86ThisCallCallConv = 70;
    public static final int LLVMPTXKernelCallConv = 71;
    public static final int LLVMPTXDeviceCallConv = 72;
    public static final int LLVMSPIRFUNCCallConv = 75;
    public static final int LLVMSPIRKERNELCallConv = 76;
    public static final int LLVMIntelOCLBICallConv = 77;
    public static final int LLVMX8664SysVCallConv = 78;
    public static final int LLVMWin64CallConv = 79;
    public static final int LLVMX86VectorCallCallConv = 80;
    public static final int LLVMHHVMCallConv = 81;
    public static final int LLVMHHVMCCallConv = 82;
    public static final int LLVMX86INTRCallConv = 83;
    public static final int LLVMAVRINTRCallConv = 84;
    public static final int LLVMAVRSIGNALCallConv = 85;
    public static final int LLVMAVRBUILTINCallConv = 86;
    public static final int LLVMAMDGPUVSCallConv = 87;
    public static final int LLVMAMDGPUGSCallConv = 88;
    public static final int LLVMAMDGPUPSCallConv = 89;
    public static final int LLVMAMDGPUCSCallConv = 90;
    public static final int LLVMAMDGPUKERNELCallConv = 91;
    public static final int LLVMX86RegCallCallConv = 92;
    public static final int LLVMAMDGPUHSCallConv = 93;
    public static final int LLVMMSP430BUILTINCallConv = 94;
    public static final int LLVMAMDGPULSCallConv = 95;
    public static final int LLVMAMDGPUESCallConv = 96;
    public static final int LLVMArgumentValueKind = 0;
    public static final int LLVMBasicBlockValueKind = 1;
    public static final int LLVMMemoryUseValueKind = 2;
    public static final int LLVMMemoryDefValueKind = 3;
    public static final int LLVMMemoryPhiValueKind = 4;
    public static final int LLVMFunctionValueKind = 5;
    public static final int LLVMGlobalAliasValueKind = 6;
    public static final int LLVMGlobalIFuncValueKind = 7;
    public static final int LLVMGlobalVariableValueKind = 8;
    public static final int LLVMBlockAddressValueKind = 9;
    public static final int LLVMConstantExprValueKind = 10;
    public static final int LLVMConstantArrayValueKind = 11;
    public static final int LLVMConstantStructValueKind = 12;
    public static final int LLVMConstantVectorValueKind = 13;
    public static final int LLVMUndefValueValueKind = 14;
    public static final int LLVMConstantAggregateZeroValueKind = 15;
    public static final int LLVMConstantDataArrayValueKind = 16;
    public static final int LLVMConstantDataVectorValueKind = 17;
    public static final int LLVMConstantIntValueKind = 18;
    public static final int LLVMConstantFPValueKind = 19;
    public static final int LLVMConstantPointerNullValueKind = 20;
    public static final int LLVMConstantTokenNoneValueKind = 21;
    public static final int LLVMMetadataAsValueValueKind = 22;
    public static final int LLVMInlineAsmValueKind = 23;
    public static final int LLVMInstructionValueKind = 24;
    public static final int LLVMIntEQ = 32;
    public static final int LLVMIntNE = 33;
    public static final int LLVMIntUGT = 34;
    public static final int LLVMIntUGE = 35;
    public static final int LLVMIntULT = 36;
    public static final int LLVMIntULE = 37;
    public static final int LLVMIntSGT = 38;
    public static final int LLVMIntSGE = 39;
    public static final int LLVMIntSLT = 40;
    public static final int LLVMIntSLE = 41;
    public static final int LLVMRealPredicateFalse = 0;
    public static final int LLVMRealOEQ = 1;
    public static final int LLVMRealOGT = 2;
    public static final int LLVMRealOGE = 3;
    public static final int LLVMRealOLT = 4;
    public static final int LLVMRealOLE = 5;
    public static final int LLVMRealONE = 6;
    public static final int LLVMRealORD = 7;
    public static final int LLVMRealUNO = 8;
    public static final int LLVMRealUEQ = 9;
    public static final int LLVMRealUGT = 10;
    public static final int LLVMRealUGE = 11;
    public static final int LLVMRealULT = 12;
    public static final int LLVMRealULE = 13;
    public static final int LLVMRealUNE = 14;
    public static final int LLVMRealPredicateTrue = 15;
    public static final int LLVMLandingPadCatch = 0;
    public static final int LLVMLandingPadFilter = 1;
    public static final int LLVMNotThreadLocal = 0;
    public static final int LLVMGeneralDynamicTLSModel = 1;
    public static final int LLVMLocalDynamicTLSModel = 2;
    public static final int LLVMInitialExecTLSModel = 3;
    public static final int LLVMLocalExecTLSModel = 4;
    public static final int LLVMAtomicOrderingNotAtomic = 0;
    public static final int LLVMAtomicOrderingUnordered = 1;
    public static final int LLVMAtomicOrderingMonotonic = 2;
    public static final int LLVMAtomicOrderingAcquire = 4;
    public static final int LLVMAtomicOrderingRelease = 5;
    public static final int LLVMAtomicOrderingAcquireRelease = 6;
    public static final int LLVMAtomicOrderingSequentiallyConsistent = 7;
    public static final int LLVMAtomicRMWBinOpXchg = 0;
    public static final int LLVMAtomicRMWBinOpAdd = 1;
    public static final int LLVMAtomicRMWBinOpSub = 2;
    public static final int LLVMAtomicRMWBinOpAnd = 3;
    public static final int LLVMAtomicRMWBinOpNand = 4;
    public static final int LLVMAtomicRMWBinOpOr = 5;
    public static final int LLVMAtomicRMWBinOpXor = 6;
    public static final int LLVMAtomicRMWBinOpMax = 7;
    public static final int LLVMAtomicRMWBinOpMin = 8;
    public static final int LLVMAtomicRMWBinOpUMax = 9;
    public static final int LLVMAtomicRMWBinOpUMin = 10;
    public static final int LLVMDSError = 0;
    public static final int LLVMDSWarning = 1;
    public static final int LLVMDSRemark = 2;
    public static final int LLVMDSNote = 3;
    public static final int LLVMInlineAsmDialectATT = 0;
    public static final int LLVMInlineAsmDialectIntel = 1;
    public static final int LLVMModuleFlagBehaviorError = 0;
    public static final int LLVMModuleFlagBehaviorWarning = 1;
    public static final int LLVMModuleFlagBehaviorRequire = 2;
    public static final int LLVMModuleFlagBehaviorOverride = 3;
    public static final int LLVMModuleFlagBehaviorAppend = 4;
    public static final int LLVMModuleFlagBehaviorAppendUnique = 5;
    public static final int LLVMAttributeReturnIndex = 0;
    public static final int LLVMAttributeFunctionIndex = -1;
    private static final SharedLibrary LLVM = Library.loadNative(LLVMCore.class, (String)"org.lwjgl.llvm", (Configuration)Configuration.LLVM_LIBRARY_NAME, (String[])new String[]{"LLVM", "LLVM-C"});

    protected LLVMCore() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return LLVM;
    }

    public static void LLVMInitializeCore(@NativeType(value="LLVMPassRegistryRef") long R) {
        long __functionAddress = Functions.InitializeCore;
        if (Checks.CHECKS) {
            Checks.check((long)R);
        }
        JNI.invokePV((long)R, (long)__functionAddress);
    }

    public static void LLVMShutdown() {
        long __functionAddress = Functions.Shutdown;
        JNI.invokeV((long)__functionAddress);
    }

    public static long nLLVMCreateMessage(long Message) {
        long __functionAddress = Functions.CreateMessage;
        return JNI.invokePP((long)Message, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMCreateMessage(@NativeType(value="char const *") ByteBuffer Message) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Message);
        }
        long __result = LLVMCore.nLLVMCreateMessage(MemoryUtil.memAddress((ByteBuffer)Message));
        return MemoryUtil.memUTF8((long)__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char *")
    public static String LLVMCreateMessage(@NativeType(value="char const *") CharSequence Message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Message, true);
            long MessageEncoded = stack.getPointerAddress();
            long __result = LLVMCore.nLLVMCreateMessage(MessageEncoded);
            String string = MemoryUtil.memUTF8((long)__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMDisposeMessage(long Message) {
        long __functionAddress = Functions.DisposeMessage;
        JNI.invokePV((long)Message, (long)__functionAddress);
    }

    public static void LLVMDisposeMessage(@NativeType(value="char *") ByteBuffer Message) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Message);
        }
        LLVMCore.nLLVMDisposeMessage(MemoryUtil.memAddress((ByteBuffer)Message));
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMContextCreate() {
        long __functionAddress = Functions.ContextCreate;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetGlobalContext() {
        long __functionAddress = Functions.GetGlobalContext;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void nLLVMContextSetDiagnosticHandler(long C, long Handler, long DiagnosticContext) {
        long __functionAddress = Functions.ContextSetDiagnosticHandler;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePPPV((long)C, (long)Handler, (long)DiagnosticContext, (long)__functionAddress);
    }

    public static void LLVMContextSetDiagnosticHandler(@NativeType(value="LLVMContextRef") long C, @Nullable @NativeType(value="void (*) (LLVMDiagnosticInfoRef, void *)") LLVMDiagnosticHandlerI Handler, @NativeType(value="void *") long DiagnosticContext) {
        LLVMCore.nLLVMContextSetDiagnosticHandler(C, MemoryUtil.memAddressSafe((Pointer)Handler), DiagnosticContext);
    }

    public static long nLLVMContextGetDiagnosticHandler(long C) {
        long __functionAddress = Functions.ContextGetDiagnosticHandler;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void (*) (LLVMDiagnosticInfoRef, void *)")
    public static LLVMDiagnosticHandler LLVMContextGetDiagnosticHandler(@NativeType(value="LLVMContextRef") long C) {
        return LLVMDiagnosticHandler.createSafe(LLVMCore.nLLVMContextGetDiagnosticHandler(C));
    }

    @NativeType(value="void *")
    public static long LLVMContextGetDiagnosticContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextGetDiagnosticContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    public static void nLLVMContextSetYieldCallback(long C, long Callback2, long OpaqueHandle) {
        long __functionAddress = Functions.ContextSetYieldCallback;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePPPV((long)C, (long)Callback2, (long)OpaqueHandle, (long)__functionAddress);
    }

    public static void LLVMContextSetYieldCallback(@NativeType(value="LLVMContextRef") long C, @Nullable @NativeType(value="void (*) (LLVMContextRef, void *)") LLVMYieldCallbackI Callback2, @NativeType(value="void *") long OpaqueHandle) {
        LLVMCore.nLLVMContextSetYieldCallback(C, MemoryUtil.memAddressSafe((Pointer)Callback2), OpaqueHandle);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMContextShouldDiscardValueNames(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextShouldDiscardValueNames;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        return JNI.invokePI((long)C, (long)__functionAddress) != 0;
    }

    public static void LLVMContextSetDiscardValueNames(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBool") boolean Discard) {
        long __functionAddress = Functions.ContextSetDiscardValueNames;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        JNI.invokePV((long)C, (int)(Discard ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMContextDispose(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextDispose;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePV((long)C, (long)__functionAddress);
    }

    public static long nLLVMGetDiagInfoDescription(long DI) {
        long __functionAddress = Functions.GetDiagInfoDescription;
        if (Checks.CHECKS) {
            Checks.check((long)DI);
        }
        return JNI.invokePP((long)DI, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMGetDiagInfoDescription(@NativeType(value="LLVMDiagnosticInfoRef") long DI) {
        long __result = LLVMCore.nLLVMGetDiagInfoDescription(DI);
        return MemoryUtil.memUTF8((long)__result);
    }

    @NativeType(value="LLVMDiagnosticSeverity")
    public static int LLVMGetDiagInfoSeverity(@NativeType(value="LLVMDiagnosticInfoRef") long DI) {
        long __functionAddress = Functions.GetDiagInfoSeverity;
        if (Checks.CHECKS) {
            Checks.check((long)DI);
        }
        return JNI.invokePI((long)DI, (long)__functionAddress);
    }

    public static int nLLVMGetMDKindIDInContext(long C, long Name, int SLen) {
        long __functionAddress = Functions.GetMDKindIDInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPI((long)C, (long)Name, (int)SLen, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindIDInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetMDKindIDInContext(C, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindIDInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetMDKindIDInContext(C, NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetMDKindID(long Name, int SLen) {
        long __functionAddress = Functions.GetMDKindID;
        return JNI.invokePI((long)Name, (int)SLen, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindID(@NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetMDKindID(MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindID(@NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetMDKindID(NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetEnumAttributeKindForName(long Name, long SLen) {
        long __functionAddress = Functions.GetEnumAttributeKindForName;
        return JNI.invokePPI((long)Name, (long)SLen, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKindForName(@NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetEnumAttributeKindForName(MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKindForName(@NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetEnumAttributeKindForName(NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetLastEnumAttributeKind() {
        long __functionAddress = Functions.GetLastEnumAttributeKind;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateEnumAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="unsigned int") int KindID, @NativeType(value="uint64_t") long Val) {
        long __functionAddress = Functions.CreateEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePJP((long)C, (int)KindID, (long)Val, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKind(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.GetEnumAttributeKind;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePI((long)A, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetEnumAttributeValue(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.GetEnumAttributeValue;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePJ((long)A, (long)__functionAddress);
    }

    public static long nLLVMCreateStringAttribute(long C, long K, int KLength, long V2, int VLength) {
        long __functionAddress = Functions.CreateStringAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPPP((long)C, (long)K, (int)KLength, (long)V2, (int)VLength, (long)__functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateStringAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer K, @NativeType(value="char const *") ByteBuffer V2) {
        return LLVMCore.nLLVMCreateStringAttribute(C, MemoryUtil.memAddress((ByteBuffer)K), K.remaining(), MemoryUtil.memAddress((ByteBuffer)V2), V2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateStringAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence K, @NativeType(value="char const *") CharSequence V2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            int VEncodedLength = stack.nUTF8(V2, false);
            long VEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateStringAttribute(C, KEncoded, KEncodedLength, VEncoded, VEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStringAttributeKind(long A, long Length) {
        long __functionAddress = Functions.GetStringAttributeKind;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePPP((long)A, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetStringAttributeKind(@NativeType(value="LLVMAttributeRef") long A) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetStringAttributeKind(A, MemoryUtil.memAddress((IntBuffer)Length));
            String string = MemoryUtil.memUTF8((long)__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStringAttributeValue(long A, long Length) {
        long __functionAddress = Functions.GetStringAttributeValue;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePPP((long)A, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetStringAttributeValue(@NativeType(value="LLVMAttributeRef") long A) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetStringAttributeValue(A, MemoryUtil.memAddress((IntBuffer)Length));
            String string = MemoryUtil.memUTF8((long)__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsEnumAttribute(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.IsEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePI((long)A, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsStringAttribute(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.IsStringAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)A);
        }
        return JNI.invokePI((long)A, (long)__functionAddress) != 0;
    }

    public static long nLLVMModuleCreateWithName(long ModuleID) {
        long __functionAddress = Functions.ModuleCreateWithName;
        return JNI.invokePP((long)ModuleID, (long)__functionAddress);
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithName(@NativeType(value="char const *") ByteBuffer ModuleID) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)ModuleID);
        }
        return LLVMCore.nLLVMModuleCreateWithName(MemoryUtil.memAddress((ByteBuffer)ModuleID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithName(@NativeType(value="char const *") CharSequence ModuleID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ModuleID, true);
            long ModuleIDEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMModuleCreateWithName(ModuleIDEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMModuleCreateWithNameInContext(long ModuleID, long C) {
        long __functionAddress = Functions.ModuleCreateWithNameInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)ModuleID, (long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithNameInContext(@NativeType(value="char const *") ByteBuffer ModuleID, @NativeType(value="LLVMContextRef") long C) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)ModuleID);
        }
        return LLVMCore.nLLVMModuleCreateWithNameInContext(MemoryUtil.memAddress((ByteBuffer)ModuleID), C);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithNameInContext(@NativeType(value="char const *") CharSequence ModuleID, @NativeType(value="LLVMContextRef") long C) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ModuleID, true);
            long ModuleIDEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMModuleCreateWithNameInContext(ModuleIDEncoded, C);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMCloneModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CloneModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static void LLVMDisposeModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.DisposeModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePV((long)M, (long)__functionAddress);
    }

    public static long nLLVMGetModuleIdentifier(long M, long Len) {
        long __functionAddress = Functions.GetModuleIdentifier;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Len, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetModuleIdentifier(M, MemoryUtil.memAddress((CustomBuffer)Len));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Len.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetModuleIdentifier(long M, long Ident, long Len) {
        long __functionAddress = Functions.SetModuleIdentifier;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePPPV((long)M, (long)Ident, (long)Len, (long)__functionAddress);
    }

    public static void LLVMSetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Ident) {
        LLVMCore.nLLVMSetModuleIdentifier(M, MemoryUtil.memAddress((ByteBuffer)Ident), Ident.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Ident) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int IdentEncodedLength = stack.nUTF8(Ident, false);
            long IdentEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleIdentifier(M, IdentEncoded, IdentEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetSourceFileName(long M, long Len) {
        long __functionAddress = Functions.GetSourceFileName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Len, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetSourceFileName(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetSourceFileName(M, MemoryUtil.memAddress((CustomBuffer)Len));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Len.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetSourceFileName(long M, long Name, long Len) {
        long __functionAddress = Functions.SetSourceFileName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        JNI.invokePPPV((long)M, (long)Name, (long)Len, (long)__functionAddress);
    }

    public static void LLVMSetSourceFileName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        LLVMCore.nLLVMSetSourceFileName(M, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetSourceFileName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetSourceFileName(M, NameEncoded, NameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDataLayoutStr(long M) {
        long __functionAddress = Functions.GetDataLayoutStr;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetDataLayoutStr(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetDataLayoutStr(M);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static long nLLVMGetDataLayout(long M) {
        long __functionAddress = Functions.GetDataLayout;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetDataLayout(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetDataLayout(M);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nLLVMSetDataLayout(long M, long DataLayoutStr) {
        long __functionAddress = Functions.SetDataLayout;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePPV((long)M, (long)DataLayoutStr, (long)__functionAddress);
    }

    public static void LLVMSetDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer DataLayoutStr) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)DataLayoutStr);
        }
        LLVMCore.nLLVMSetDataLayout(M, MemoryUtil.memAddress((ByteBuffer)DataLayoutStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence DataLayoutStr) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(DataLayoutStr, true);
            long DataLayoutStrEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetDataLayout(M, DataLayoutStrEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetTarget(long M) {
        long __functionAddress = Functions.GetTarget;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetTarget(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetTarget(M);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nLLVMSetTarget(long M, long Triple) {
        long __functionAddress = Functions.SetTarget;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePPV((long)M, (long)Triple, (long)__functionAddress);
    }

    public static void LLVMSetTarget(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Triple) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Triple);
        }
        LLVMCore.nLLVMSetTarget(M, MemoryUtil.memAddress((ByteBuffer)Triple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetTarget(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Triple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetTarget(M, TripleEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCopyModuleFlagsMetadata(long M, long Len) {
        long __functionAddress = Functions.CopyModuleFlagsMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Len, (long)__functionAddress);
    }

    @NativeType(value="LLVMModuleFlagEntry *")
    public static long LLVMCopyModuleFlagsMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="size_t *") PointerBuffer Len) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Len, (int)1);
        }
        return LLVMCore.nLLVMCopyModuleFlagsMetadata(M, MemoryUtil.memAddress((CustomBuffer)Len));
    }

    public static void LLVMDisposeModuleFlagsMetadata(@NativeType(value="LLVMModuleFlagEntry *") long Entries) {
        long __functionAddress = Functions.DisposeModuleFlagsMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        JNI.invokePV((long)Entries, (long)__functionAddress);
    }

    @NativeType(value="LLVMModuleFlagBehavior")
    public static int LLVMModuleFlagEntriesGetFlagBehavior(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ModuleFlagEntriesGetFlagBehavior;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        return JNI.invokePI((long)Entries, (int)Index, (long)__functionAddress);
    }

    public static long nLLVMModuleFlagEntriesGetKey(long Entries, int Index, long Len) {
        long __functionAddress = Functions.ModuleFlagEntriesGetKey;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        return JNI.invokePPP((long)Entries, (int)Index, (long)Len, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMModuleFlagEntriesGetKey(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMModuleFlagEntriesGetKey(Entries, Index, MemoryUtil.memAddress((CustomBuffer)Len));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Len.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMModuleFlagEntriesGetMetadata(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ModuleFlagEntriesGetMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        return JNI.invokePP((long)Entries, (int)Index, (long)__functionAddress);
    }

    public static long nLLVMGetModuleFlag(long M, long Key, long KeyLen) {
        long __functionAddress = Functions.GetModuleFlag;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPPP((long)M, (long)Key, (long)KeyLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Key) {
        return LLVMCore.nLLVMGetModuleFlag(M, MemoryUtil.memAddress((ByteBuffer)Key), Key.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Key) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KeyEncodedLength = stack.nUTF8(Key, false);
            long KeyEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetModuleFlag(M, KeyEncoded, KeyEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddModuleFlag(long M, int Behavior, long Key, long KeyLen, long Val) {
        long __functionAddress = Functions.AddModuleFlag;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
            Checks.check((long)Val);
        }
        JNI.invokePPPPV((long)M, (int)Behavior, (long)Key, (long)KeyLen, (long)Val, (long)__functionAddress);
    }

    public static void LLVMAddModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleFlagBehavior") int Behavior, @NativeType(value="char const *") ByteBuffer Key, @NativeType(value="LLVMMetadataRef") long Val) {
        LLVMCore.nLLVMAddModuleFlag(M, Behavior, MemoryUtil.memAddress((ByteBuffer)Key), Key.remaining(), Val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleFlagBehavior") int Behavior, @NativeType(value="char const *") CharSequence Key, @NativeType(value="LLVMMetadataRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KeyEncodedLength = stack.nUTF8(Key, false);
            long KeyEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddModuleFlag(M, Behavior, KeyEncoded, KeyEncodedLength, Val);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDumpModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.DumpModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePV((long)M, (long)__functionAddress);
    }

    public static int nLLVMPrintModuleToFile(long M, long Filename, long ErrorMessage) {
        long __functionAddress = Functions.PrintModuleToFile;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPPI((long)M, (long)Filename, (long)ErrorMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMPrintModuleToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Filename, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Filename);
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        return LLVMCore.nLLVMPrintModuleToFile(M, MemoryUtil.memAddress((ByteBuffer)Filename), MemoryUtil.memAddress((CustomBuffer)ErrorMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMPrintModuleToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Filename, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Filename, true);
            long FilenameEncoded = stack.getPointerAddress();
            boolean bl = LLVMCore.nLLVMPrintModuleToFile(M, FilenameEncoded, MemoryUtil.memAddress((CustomBuffer)ErrorMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMPrintModuleToString(long M) {
        long __functionAddress = Functions.PrintModuleToString;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintModuleToString(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMPrintModuleToString(M);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static long nLLVMGetModuleInlineAsm(long M, long Len) {
        long __functionAddress = Functions.GetModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Len, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetModuleInlineAsm(M, MemoryUtil.memAddress((CustomBuffer)Len));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Len.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetModuleInlineAsm2(long M, long Asm, long Len) {
        long __functionAddress = Functions.SetModuleInlineAsm2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        JNI.invokePPPV((long)M, (long)Asm, (long)Len, (long)__functionAddress);
    }

    public static void LLVMSetModuleInlineAsm2(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        LLVMCore.nLLVMSetModuleInlineAsm2(M, MemoryUtil.memAddress((ByteBuffer)Asm), Asm.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleInlineAsm2(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int AsmEncodedLength = stack.nUTF8(Asm, false);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleInlineAsm2(M, AsmEncoded, AsmEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAppendModuleInlineAsm(long M, long Asm, long Len) {
        long __functionAddress = Functions.AppendModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        JNI.invokePPPV((long)M, (long)Asm, (long)Len, (long)__functionAddress);
    }

    public static void LLVMAppendModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        LLVMCore.nLLVMAppendModuleInlineAsm(M, MemoryUtil.memAddress((ByteBuffer)Asm), Asm.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAppendModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int AsmEncodedLength = stack.nUTF8(Asm, false);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAppendModuleInlineAsm(M, AsmEncoded, AsmEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetInlineAsm(long Ty, long AsmString, long AsmStringSize, long Constraints, long ConstraintsSize, int HasSideEffects, int IsAlignStack, int Dialect) {
        long __functionAddress = Functions.GetInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPP((long)Ty, (long)AsmString, (long)AsmStringSize, (long)Constraints, (long)ConstraintsSize, (int)HasSideEffects, (int)IsAlignStack, (int)Dialect, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char *") ByteBuffer AsmString, @NativeType(value="char *") ByteBuffer Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack, @NativeType(value="LLVMInlineAsmDialect") int Dialect) {
        return LLVMCore.nLLVMGetInlineAsm(Ty, MemoryUtil.memAddress((ByteBuffer)AsmString), AsmString.remaining(), MemoryUtil.memAddress((ByteBuffer)Constraints), Constraints.remaining(), HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0, Dialect);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetModuleContext(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetModuleContext;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static long nLLVMGetTypeByName(long M, long Name) {
        long __functionAddress = Functions.GetTypeByName;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMGetTypeByName(M, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetTypeByName(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetFirstNamedMetadata(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetLastNamedMetadata(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNextNamedMetadata(@NativeType(value="LLVMNamedMDNodeRef") long NamedMDNode) {
        long __functionAddress = Functions.GetNextNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)NamedMDNode);
        }
        return JNI.invokePP((long)NamedMDNode, (long)__functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetPreviousNamedMetadata(@NativeType(value="LLVMNamedMDNodeRef") long NamedMDNode) {
        long __functionAddress = Functions.GetPreviousNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)NamedMDNode);
        }
        return JNI.invokePP((long)NamedMDNode, (long)__functionAddress);
    }

    public static long nLLVMGetNamedMetadata(long M, long Name, long NameLen) {
        long __functionAddress = Functions.GetNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPPP((long)M, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetNamedMetadata(M, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedMetadata(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetOrInsertNamedMetadata(long M, long Name, long NameLen) {
        long __functionAddress = Functions.GetOrInsertNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPPP((long)M, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetOrInsertNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetOrInsertNamedMetadata(M, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetOrInsertNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetOrInsertNamedMetadata(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedMetadataName(long NamedMD, long NameLen) {
        long __functionAddress = Functions.GetNamedMetadataName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)NamedMD);
        }
        return JNI.invokePPP((long)NamedMD, (long)NameLen, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetNamedMetadataName(@NativeType(value="LLVMNamedMDNodeRef") long NamedMD) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLen = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetNamedMetadataName(NamedMD, MemoryUtil.memAddress((CustomBuffer)NameLen));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)NameLen.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetNamedMetadataNumOperands(long M, long Name) {
        long __functionAddress = Functions.GetNamedMetadataNumOperands;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPI((long)M, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNamedMetadataNumOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMGetNamedMetadataNumOperands(M, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetNamedMetadataNumOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetNamedMetadataNumOperands(M, NameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMGetNamedMetadataOperands(long M, long Name, long Dest) {
        long __functionAddress = Functions.GetNamedMetadataOperands;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePPPV((long)M, (long)Name, (long)Dest, (long)__functionAddress);
    }

    public static void LLVMGetNamedMetadataOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
            if (Checks.DEBUG) {
                Checks.check((CustomBuffer)Dest, (int)LLVMCore.LLVMGetNamedMetadataNumOperands(M, Name));
            }
        }
        LLVMCore.nLLVMGetNamedMetadataOperands(M, MemoryUtil.memAddress((ByteBuffer)Name), MemoryUtil.memAddress((CustomBuffer)Dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMGetNamedMetadataOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Dest, (int)LLVMCore.LLVMGetNamedMetadataNumOperands(M, Name));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMGetNamedMetadataOperands(M, NameEncoded, MemoryUtil.memAddress((CustomBuffer)Dest));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddNamedMetadataOperand(long M, long Name, long Val) {
        long __functionAddress = Functions.AddNamedMetadataOperand;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)Val);
        }
        JNI.invokePPPV((long)M, (long)Name, (long)Val, (long)__functionAddress);
    }

    public static void LLVMAddNamedMetadataOperand(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMValueRef") long Val) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        LLVMCore.nLLVMAddNamedMetadataOperand(M, MemoryUtil.memAddress((ByteBuffer)Name), Val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddNamedMetadataOperand(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddNamedMetadataOperand(M, NameEncoded, Val);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDebugLocDirectory(long Val, long Length) {
        long __functionAddress = Functions.GetDebugLocDirectory;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePPP((long)Val, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetDebugLocDirectory(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetDebugLocDirectory(Val, MemoryUtil.memAddress((IntBuffer)Length));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDebugLocFilename(long Val, long Length) {
        long __functionAddress = Functions.GetDebugLocFilename;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePPP((long)Val, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetDebugLocFilename(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetDebugLocFilename(Val, MemoryUtil.memAddress((IntBuffer)Length));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetDebugLocLine(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetDebugLocLine;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetDebugLocColumn(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetDebugLocColumn;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress);
    }

    public static long nLLVMAddFunction(long M, long Name, long FunctionTy) {
        long __functionAddress = Functions.AddFunction;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)FunctionTy);
        }
        return JNI.invokePPPP((long)M, (long)Name, (long)FunctionTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMTypeRef") long FunctionTy) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAddFunction(M, MemoryUtil.memAddress((ByteBuffer)Name), FunctionTy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMTypeRef") long FunctionTy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddFunction(M, NameEncoded, FunctionTy);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedFunction(long M, long Name) {
        long __functionAddress = Functions.GetNamedFunction;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMGetNamedFunction(M, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedFunction(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstFunction(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstFunction;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastFunction(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastFunction;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetNextFunction;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetPreviousFunction;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    public static void nLLVMSetModuleInlineAsm(long M, long Asm) {
        long __functionAddress = Functions.SetModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        JNI.invokePPV((long)M, (long)Asm, (long)__functionAddress);
    }

    public static void LLVMSetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Asm);
        }
        LLVMCore.nLLVMSetModuleInlineAsm(M, MemoryUtil.memAddress((ByteBuffer)Asm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Asm, true);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleInlineAsm(M, AsmEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMTypeKind")
    public static int LLVMGetTypeKind(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetTypeKind;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePI((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTypeIsSized(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.TypeIsSized;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePI((long)Ty, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetTypeContext(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetTypeContext;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    public static void LLVMDumpType(@NativeType(value="LLVMTypeRef") long Val) {
        long __functionAddress = Functions.DumpType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        JNI.invokePV((long)Val, (long)__functionAddress);
    }

    public static long nLLVMPrintTypeToString(long Val) {
        long __functionAddress = Functions.PrintTypeToString;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintTypeToString(@NativeType(value="LLVMTypeRef") long Val) {
        long __result = LLVMCore.nLLVMPrintTypeToString(Val);
        return MemoryUtil.memUTF8((long)__result);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt1TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int1TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt8TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int8TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt16TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int16TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt32TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int32TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt64TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int64TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="unsigned int") int NumBits) {
        long __functionAddress = Functions.IntTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (int)NumBits, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt1Type() {
        long __functionAddress = Functions.Int1Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt8Type() {
        long __functionAddress = Functions.Int8Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt16Type() {
        long __functionAddress = Functions.Int16Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt32Type() {
        long __functionAddress = Functions.Int32Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt64Type() {
        long __functionAddress = Functions.Int64Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt128Type() {
        long __functionAddress = Functions.Int128Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntType(@NativeType(value="unsigned int") int NumBits) {
        long __functionAddress = Functions.IntType;
        return JNI.invokeP((int)NumBits, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetIntTypeWidth(@NativeType(value="LLVMTypeRef") long IntegerTy) {
        long __functionAddress = Functions.GetIntTypeWidth;
        if (Checks.CHECKS) {
            Checks.check((long)IntegerTy);
        }
        return JNI.invokePI((long)IntegerTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMHalfTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.HalfTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFloatTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.FloatTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMDoubleTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.DoubleTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86FP80TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.X86FP80TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFP128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.FP128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPPCFP128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.PPCFP128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMHalfType() {
        long __functionAddress = Functions.HalfType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFloatType() {
        long __functionAddress = Functions.FloatType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMDoubleType() {
        long __functionAddress = Functions.DoubleType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86FP80Type() {
        long __functionAddress = Functions.X86FP80Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFP128Type() {
        long __functionAddress = Functions.FP128Type;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPPCFP128Type() {
        long __functionAddress = Functions.PPCFP128Type;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long nLLVMFunctionType(long ReturnType, long ParamTypes, int ParamCount, int IsVarArg) {
        long __functionAddress = Functions.FunctionType;
        if (Checks.CHECKS) {
            Checks.check((long)ReturnType);
        }
        return JNI.invokePPP((long)ReturnType, (long)ParamTypes, (int)ParamCount, (int)IsVarArg, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFunctionType(@NativeType(value="LLVMTypeRef") long ReturnType, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes, @NativeType(value="LLVMBool") boolean IsVarArg) {
        return LLVMCore.nLLVMFunctionType(ReturnType, MemoryUtil.memAddress((CustomBuffer)ParamTypes), ParamTypes.remaining(), IsVarArg ? 1 : 0);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsFunctionVarArg(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.IsFunctionVarArg;
        if (Checks.CHECKS) {
            Checks.check((long)FunctionTy);
        }
        return JNI.invokePI((long)FunctionTy, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetReturnType(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.GetReturnType;
        if (Checks.CHECKS) {
            Checks.check((long)FunctionTy);
        }
        return JNI.invokePP((long)FunctionTy, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountParamTypes(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.CountParamTypes;
        if (Checks.CHECKS) {
            Checks.check((long)FunctionTy);
        }
        return JNI.invokePI((long)FunctionTy, (long)__functionAddress);
    }

    public static void nLLVMGetParamTypes(long FunctionTy, long Dest) {
        long __functionAddress = Functions.GetParamTypes;
        if (Checks.CHECKS) {
            Checks.check((long)FunctionTy);
        }
        JNI.invokePPV((long)FunctionTy, (long)Dest, (long)__functionAddress);
    }

    public static void LLVMGetParamTypes(@NativeType(value="LLVMTypeRef") long FunctionTy, @NativeType(value="LLVMTypeRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Dest, (int)LLVMCore.LLVMCountParamTypes(FunctionTy));
        }
        LLVMCore.nLLVMGetParamTypes(FunctionTy, MemoryUtil.memAddress((CustomBuffer)Dest));
    }

    public static long nLLVMStructTypeInContext(long C, long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)ElementTypes, (int)ElementCount, (int)Packed, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMStructTypeInContext(C, MemoryUtil.memAddress((CustomBuffer)ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMStructType(long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructType;
        return JNI.invokePP((long)ElementTypes, (int)ElementCount, (int)Packed, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructType(@NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMStructType(MemoryUtil.memAddress((CustomBuffer)ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMStructCreateNamed(long C, long Name) {
        long __functionAddress = Functions.StructCreateNamed;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructCreateNamed(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMStructCreateNamed(C, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructCreateNamed(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMStructCreateNamed(C, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStructName(long Ty) {
        long __functionAddress = Functions.GetStructName;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetStructName(@NativeType(value="LLVMTypeRef") long Ty) {
        long __result = LLVMCore.nLLVMGetStructName(Ty);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nLLVMStructSetBody(long StructTy, long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructSetBody;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        JNI.invokePPV((long)StructTy, (long)ElementTypes, (int)ElementCount, (int)Packed, (long)__functionAddress);
    }

    public static void LLVMStructSetBody(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        LLVMCore.nLLVMStructSetBody(StructTy, MemoryUtil.memAddress((CustomBuffer)ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountStructElementTypes(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.CountStructElementTypes;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        return JNI.invokePI((long)StructTy, (long)__functionAddress);
    }

    public static void nLLVMGetStructElementTypes(long StructTy, long Dest) {
        long __functionAddress = Functions.GetStructElementTypes;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        JNI.invokePPV((long)StructTy, (long)Dest, (long)__functionAddress);
    }

    public static void LLVMGetStructElementTypes(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMTypeRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Dest, (int)LLVMCore.LLVMCountStructElementTypes(StructTy));
        }
        LLVMCore.nLLVMGetStructElementTypes(StructTy, MemoryUtil.memAddress((CustomBuffer)Dest));
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructGetTypeAtIndex(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.StructGetTypeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        return JNI.invokePP((long)StructTy, (int)i, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsPackedStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsPackedStruct;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        return JNI.invokePI((long)StructTy, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsOpaqueStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsOpaqueStruct;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        return JNI.invokePI((long)StructTy, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsLiteralStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsLiteralStruct;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)StructTy);
        }
        return JNI.invokePI((long)StructTy, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetElementType(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetElementType;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    public static void nLLVMGetSubtypes(long Tp, long Arr) {
        long __functionAddress = Functions.GetSubtypes;
        if (Checks.CHECKS) {
            Checks.check((long)Tp);
        }
        JNI.invokePPV((long)Tp, (long)Arr, (long)__functionAddress);
    }

    public static void LLVMGetSubtypes(@NativeType(value="LLVMTypeRef") long Tp, @NativeType(value="LLVMTypeRef *") PointerBuffer Arr) {
        LLVMCore.nLLVMGetSubtypes(Tp, MemoryUtil.memAddress((CustomBuffer)Arr));
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumContainedTypes(@NativeType(value="LLVMTypeRef") long Tp) {
        long __functionAddress = Functions.GetNumContainedTypes;
        if (Checks.CHECKS) {
            Checks.check((long)Tp);
        }
        return JNI.invokePI((long)Tp, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMArrayType(@NativeType(value="LLVMTypeRef") long ElementType, @NativeType(value="unsigned int") int ElementCount) {
        long __functionAddress = Functions.ArrayType;
        if (Checks.CHECKS) {
            Checks.check((long)ElementType);
        }
        return JNI.invokePP((long)ElementType, (int)ElementCount, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetArrayLength(@NativeType(value="LLVMTypeRef") long ArrayTy) {
        long __functionAddress = Functions.GetArrayLength;
        if (Checks.CHECKS) {
            Checks.check((long)ArrayTy);
        }
        return JNI.invokePI((long)ArrayTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPointerType(@NativeType(value="LLVMTypeRef") long ElementType, @NativeType(value="unsigned int") int AddressSpace) {
        long __functionAddress = Functions.PointerType;
        if (Checks.CHECKS) {
            Checks.check((long)ElementType);
        }
        return JNI.invokePP((long)ElementType, (int)AddressSpace, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetPointerAddressSpace(@NativeType(value="LLVMTypeRef") long PointerTy) {
        long __functionAddress = Functions.GetPointerAddressSpace;
        if (Checks.CHECKS) {
            Checks.check((long)PointerTy);
        }
        return JNI.invokePI((long)PointerTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVectorType(@NativeType(value="LLVMTypeRef") long ElementType, @NativeType(value="unsigned int") int ElementCount) {
        long __functionAddress = Functions.VectorType;
        if (Checks.CHECKS) {
            Checks.check((long)ElementType);
        }
        return JNI.invokePP((long)ElementType, (int)ElementCount, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetVectorSize(@NativeType(value="LLVMTypeRef") long VectorTy) {
        long __functionAddress = Functions.GetVectorSize;
        if (Checks.CHECKS) {
            Checks.check((long)VectorTy);
        }
        return JNI.invokePI((long)VectorTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVoidTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.VoidTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMLabelTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.LabelTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86MMXTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.X86MMXTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMTokenTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.TokenTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMMetadataTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.MetadataTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVoidType() {
        long __functionAddress = Functions.VoidType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMLabelType() {
        long __functionAddress = Functions.LabelType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86MMXType() {
        long __functionAddress = Functions.X86MMXType;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMTypeOf(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.TypeOf;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueKind")
    public static int LLVMGetValueKind(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetValueKind;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress);
    }

    public static long nLLVMGetValueName2(long Val, long Length) {
        long __functionAddress = Functions.GetValueName2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePPP((long)Val, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetValueName2(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetValueName2(Val, MemoryUtil.memAddress((CustomBuffer)Length));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Length.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetValueName2(long Val, long Name, long NameLen) {
        long __functionAddress = Functions.SetValueName2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        JNI.invokePPPV((long)Val, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    public static void LLVMSetValueName2(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        LLVMCore.nLLVMSetValueName2(Val, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetValueName2(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetValueName2(Val, NameEncoded, NameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDumpValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.DumpValue;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        JNI.invokePV((long)Val, (long)__functionAddress);
    }

    public static long nLLVMPrintValueToString(long Val) {
        long __functionAddress = Functions.PrintValueToString;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintValueToString(@NativeType(value="LLVMValueRef") long Val) {
        long __result = LLVMCore.nLLVMPrintValueToString(Val);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void LLVMReplaceAllUsesWith(@NativeType(value="LLVMValueRef") long OldVal, @NativeType(value="LLVMValueRef") long NewVal) {
        long __functionAddress = Functions.ReplaceAllUsesWith;
        if (Checks.CHECKS) {
            Checks.check((long)OldVal);
            Checks.check((long)NewVal);
        }
        JNI.invokePPV((long)OldVal, (long)NewVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConstant(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsConstant;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsUndef(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsUndef;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAArgument(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAArgument;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInlineAsm(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUser(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUser;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstant(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstant;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABlockAddress(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABlockAddress;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantAggregateZero(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantAggregateZero;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantArray(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantArray;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataSequential(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataSequential;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataArray(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataArray;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataVector(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataVector;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantExpr(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantExpr;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantFP(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantFP;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantInt(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantInt;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantPointerNull(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantPointerNull;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantStruct(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantStruct;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantTokenNone(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantTokenNone;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantVector(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantVector;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalValue;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalAlias(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalIFunc(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalObject(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalObject;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFunction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFunction;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalVariable(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalVariable;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUndefValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUndefValue;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInstruction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABinaryOperator(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABinaryOperator;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACallInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACallInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIntrinsicInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIntrinsicInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgInfoIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgInfoIntrinsic;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgVariableIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgVariableIntrinsic;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgDeclareInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgDeclareInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgLabelInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgLabelInst;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemIntrinsic;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemCpyInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemCpyInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemMoveInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemMoveInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemSetInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemSetInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACmpInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFCmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFCmpInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAICmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAICmpInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAExtractElementInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAExtractElementInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGetElementPtrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGetElementPtrInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInsertElementInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInsertElementInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInsertValueInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInsertValueInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsALandingPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsALandingPadInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAPHINode(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAPHINode;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASelectInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASelectInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAShuffleVectorInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAShuffleVectorInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAStoreInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAStoreInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABranchInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABranchInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIndirectBrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIndirectBrInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInvokeInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInvokeInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAReturnInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASwitchInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASwitchInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUnreachableInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUnreachableInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAResumeInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAResumeInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACleanupReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACleanupReturnInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACatchReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACatchReturnInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFuncletPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFuncletPadInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACatchPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACatchPadInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACleanupPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACleanupPadInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUnaryInstruction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUnaryInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAAllocaInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAAllocaInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACastInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAAddrSpaceCastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAAddrSpaceCastInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABitCastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABitCastInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPExtInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPToSIInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPToSIInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPToUIInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPToUIInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPTruncInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPTruncInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIntToPtrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIntToPtrInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAPtrToIntInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAPtrToIntInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASExtInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASIToFPInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASIToFPInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsATruncInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsATruncInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUIToFPInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUIToFPInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAZExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAZExtInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAExtractValueInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAExtractValueInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsALoadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsALoadInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAVAArgInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAVAArgInst;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMDNode(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMDNode;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMDString(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMDString;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    public static long nLLVMGetValueName(long Val) {
        long __functionAddress = Functions.GetValueName;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetValueName(@NativeType(value="LLVMValueRef") long Val) {
        long __result = LLVMCore.nLLVMGetValueName(Val);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nLLVMSetValueName(long Val, long Name) {
        long __functionAddress = Functions.SetValueName;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        JNI.invokePPV((long)Val, (long)Name, (long)__functionAddress);
    }

    public static void LLVMSetValueName(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        LLVMCore.nLLVMSetValueName(Val, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetValueName(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetValueName(Val, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetFirstUse(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetFirstUse;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetNextUse(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetNextUse;
        if (Checks.CHECKS) {
            Checks.check((long)U);
        }
        return JNI.invokePP((long)U, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUser(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetUser;
        if (Checks.CHECKS) {
            Checks.check((long)U);
        }
        return JNI.invokePP((long)U, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUsedValue(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetUsedValue;
        if (Checks.CHECKS) {
            Checks.check((long)U);
        }
        return JNI.invokePP((long)U, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetOperand(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetOperand;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (int)Index, (long)__functionAddress);
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetOperandUse(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetOperandUse;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (int)Index, (long)__functionAddress);
    }

    public static void LLVMSetOperand(@NativeType(value="LLVMValueRef") long User, @NativeType(value="unsigned int") int Index, @NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.SetOperand;
        if (Checks.CHECKS) {
            Checks.check((long)User);
            Checks.check((long)Val);
        }
        JNI.invokePPV((long)User, (int)Index, (long)Val, (long)__functionAddress);
    }

    public static int LLVMGetNumOperands(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetNumOperands;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNull(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstNull;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAllOnes(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstAllOnes;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUndef(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetUndef;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsNull(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsNull;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPointerNull(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstPointerNull;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInt(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="unsigned long long") long N, @NativeType(value="LLVMBool") boolean SignExtend) {
        long __functionAddress = Functions.ConstInt;
        if (Checks.CHECKS) {
            Checks.check((long)IntTy);
        }
        return JNI.invokePJP((long)IntTy, (long)N, (int)(SignExtend ? 1 : 0), (long)__functionAddress);
    }

    public static long nLLVMConstIntOfArbitraryPrecision(long IntTy, int NumWords, long Words) {
        long __functionAddress = Functions.ConstIntOfArbitraryPrecision;
        if (Checks.CHECKS) {
            Checks.check((long)IntTy);
        }
        return JNI.invokePPP((long)IntTy, (int)NumWords, (long)Words, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfArbitraryPrecision(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="uint64_t const *") LongBuffer Words) {
        return LLVMCore.nLLVMConstIntOfArbitraryPrecision(IntTy, Words.remaining(), MemoryUtil.memAddress((LongBuffer)Words));
    }

    public static long nLLVMConstIntOfString(long IntTy, long Text, byte Radix) {
        long __functionAddress = Functions.ConstIntOfString;
        if (Checks.CHECKS) {
            Checks.check((long)IntTy);
        }
        return JNI.invokePPP((long)IntTy, (long)Text, (byte)Radix, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfString(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") ByteBuffer Text, @NativeType(value="uint8_t") byte Radix) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Text);
        }
        return LLVMCore.nLLVMConstIntOfString(IntTy, MemoryUtil.memAddress((ByteBuffer)Text), Radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfString(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") CharSequence Text, @NativeType(value="uint8_t") byte Radix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Text, true);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstIntOfString(IntTy, TextEncoded, Radix);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstIntOfStringAndSize(long IntTy, long Text, int SLen, byte Radix) {
        long __functionAddress = Functions.ConstIntOfStringAndSize;
        if (Checks.CHECKS) {
            Checks.check((long)IntTy);
        }
        return JNI.invokePPP((long)IntTy, (long)Text, (int)SLen, (byte)Radix, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfStringAndSize(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") ByteBuffer Text, @NativeType(value="uint8_t") byte Radix) {
        return LLVMCore.nLLVMConstIntOfStringAndSize(IntTy, MemoryUtil.memAddress((ByteBuffer)Text), Text.remaining(), Radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfStringAndSize(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") CharSequence Text, @NativeType(value="uint8_t") byte Radix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int TextEncodedLength = stack.nUTF8(Text, false);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstIntOfStringAndSize(IntTy, TextEncoded, TextEncodedLength, Radix);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstReal(@NativeType(value="LLVMTypeRef") long RealTy, double N) {
        long __functionAddress = Functions.ConstReal;
        if (Checks.CHECKS) {
            Checks.check((long)RealTy);
        }
        return JNI.invokePP((long)RealTy, (double)N, (long)__functionAddress);
    }

    public static long nLLVMConstRealOfString(long RealTy, long Text) {
        long __functionAddress = Functions.ConstRealOfString;
        if (Checks.CHECKS) {
            Checks.check((long)RealTy);
        }
        return JNI.invokePPP((long)RealTy, (long)Text, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfString(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") ByteBuffer Text) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Text);
        }
        return LLVMCore.nLLVMConstRealOfString(RealTy, MemoryUtil.memAddress((ByteBuffer)Text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfString(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") CharSequence Text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Text, true);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstRealOfString(RealTy, TextEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstRealOfStringAndSize(long RealTy, long Text, int SLen) {
        long __functionAddress = Functions.ConstRealOfStringAndSize;
        if (Checks.CHECKS) {
            Checks.check((long)RealTy);
        }
        return JNI.invokePPP((long)RealTy, (long)Text, (int)SLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfStringAndSize(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") ByteBuffer Text) {
        return LLVMCore.nLLVMConstRealOfStringAndSize(RealTy, MemoryUtil.memAddress((ByteBuffer)Text), Text.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfStringAndSize(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") CharSequence Text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int TextEncodedLength = stack.nUTF8(Text, false);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstRealOfStringAndSize(RealTy, TextEncoded, TextEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned long long")
    public static long LLVMConstIntGetZExtValue(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstIntGetZExtValue;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePJ((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="long long")
    public static long LLVMConstIntGetSExtValue(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstIntGetSExtValue;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePJ((long)ConstantVal, (long)__functionAddress);
    }

    public static double nLLVMConstRealGetDouble(long ConstantVal, long losesInfo) {
        long __functionAddress = Functions.ConstRealGetDouble;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPD((long)ConstantVal, (long)losesInfo, (long)__functionAddress);
    }

    public static double LLVMConstRealGetDouble(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMBool *") IntBuffer losesInfo) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)losesInfo, (int)1);
        }
        return LLVMCore.nLLVMConstRealGetDouble(ConstantVal, MemoryUtil.memAddress((IntBuffer)losesInfo));
    }

    public static long nLLVMConstStringInContext(long C, long Str, int Length, int DontNullTerminate) {
        long __functionAddress = Functions.ConstStringInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)Str, (int)Length, (int)DontNullTerminate, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        return LLVMCore.nLLVMConstStringInContext(C, MemoryUtil.memAddress((ByteBuffer)Str), Str.remaining(), DontNullTerminate ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstStringInContext(C, StrEncoded, StrEncodedLength, DontNullTerminate ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstString(long Str, int Length, int DontNullTerminate) {
        long __functionAddress = Functions.ConstString;
        return JNI.invokePP((long)Str, (int)Length, (int)DontNullTerminate, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstString(@NativeType(value="char const *") ByteBuffer Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        return LLVMCore.nLLVMConstString(MemoryUtil.memAddress((ByteBuffer)Str), Str.remaining(), DontNullTerminate ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstString(@NativeType(value="char const *") CharSequence Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstString(StrEncoded, StrEncodedLength, DontNullTerminate ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConstantString(@NativeType(value="LLVMValueRef") long c) {
        long __functionAddress = Functions.IsConstantString;
        if (Checks.CHECKS) {
            Checks.check((long)c);
        }
        return JNI.invokePI((long)c, (long)__functionAddress) != 0;
    }

    public static long nLLVMGetAsString(long c, long Length) {
        long __functionAddress = Functions.GetAsString;
        if (Checks.CHECKS) {
            Checks.check((long)c);
        }
        return JNI.invokePPP((long)c, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetAsString(@NativeType(value="LLVMValueRef") long c) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetAsString(c, MemoryUtil.memAddress((CustomBuffer)Length));
            String string = MemoryUtil.memUTF8((long)__result, (int)((int)Length.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstStructInContext(long C, long ConstantVals, int Count, int Packed) {
        long __functionAddress = Functions.ConstStructInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)ConstantVals, (int)Count, (int)Packed, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStructInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMConstStructInContext(C, MemoryUtil.memAddress((CustomBuffer)ConstantVals), ConstantVals.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMConstStruct(long ConstantVals, int Count, int Packed) {
        long __functionAddress = Functions.ConstStruct;
        return JNI.invokePP((long)ConstantVals, (int)Count, (int)Packed, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStruct(@NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMConstStruct(MemoryUtil.memAddress((CustomBuffer)ConstantVals), ConstantVals.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMConstArray(long ElementTy, long ConstantVals, int Length) {
        long __functionAddress = Functions.ConstArray;
        if (Checks.CHECKS) {
            Checks.check((long)ElementTy);
        }
        return JNI.invokePPP((long)ElementTy, (long)ConstantVals, (int)Length, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstArray(@NativeType(value="LLVMTypeRef") long ElementTy, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals) {
        return LLVMCore.nLLVMConstArray(ElementTy, MemoryUtil.memAddress((CustomBuffer)ConstantVals), ConstantVals.remaining());
    }

    public static long nLLVMConstNamedStruct(long StructTy, long ConstantVals, int Count) {
        long __functionAddress = Functions.ConstNamedStruct;
        if (Checks.CHECKS) {
            Checks.check((long)StructTy);
        }
        return JNI.invokePPP((long)StructTy, (long)ConstantVals, (int)Count, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNamedStruct(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals) {
        return LLVMCore.nLLVMConstNamedStruct(StructTy, MemoryUtil.memAddress((CustomBuffer)ConstantVals), ConstantVals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetElementAsConstant(@NativeType(value="LLVMValueRef") long C, @NativeType(value="unsigned int") int idx) {
        long __functionAddress = Functions.GetElementAsConstant;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (int)idx, (long)__functionAddress);
    }

    public static long nLLVMConstVector(long ScalarConstantVals, int Size) {
        long __functionAddress = Functions.ConstVector;
        return JNI.invokePP((long)ScalarConstantVals, (int)Size, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstVector(@NativeType(value="LLVMValueRef *") PointerBuffer ScalarConstantVals) {
        return LLVMCore.nLLVMConstVector(MemoryUtil.memAddress((CustomBuffer)ScalarConstantVals), ScalarConstantVals.remaining());
    }

    @NativeType(value="LLVMOpcode")
    public static int LLVMGetConstOpcode(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.GetConstOpcode;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePI((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAlignOf(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.AlignOf;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMSizeOf(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.SizeOf;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNeg;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePP((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNSWNeg;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePP((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNUWNeg;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePP((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstFNeg;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePP((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNot(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNot;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePP((long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAdd;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWAdd;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWAdd;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFAdd;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSub;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWSub;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWSub;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFSub;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstMul;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWMul;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWMul;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFMul;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstUDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstUDiv;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExactUDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstExactUDiv;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSDiv;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExactSDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstExactSDiv;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFDiv;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstURem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstURem;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSRem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSRem;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFRem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFRem;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAnd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAnd;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstOr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstOr;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstXor(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstXor;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstICmp(@NativeType(value="LLVMIntPredicate") int Predicate, @NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstICmp;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((int)Predicate, (long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFCmp(@NativeType(value="LLVMRealPredicate") int Predicate, @NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFCmp;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((int)Predicate, (long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstShl(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstShl;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstLShr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstLShr;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAShr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAShr;
        if (Checks.CHECKS) {
            Checks.check((long)LHSConstant);
            Checks.check((long)RHSConstant);
        }
        return JNI.invokePPP((long)LHSConstant, (long)RHSConstant, (long)__functionAddress);
    }

    public static long nLLVMConstGEP(long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstGEP;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ConstantIndices, (int)NumIndices, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstGEP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstGEP(ConstantVal, MemoryUtil.memAddress((CustomBuffer)ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstGEP2(long Ty, long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstGEP2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Ty);
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPPP((long)Ty, (long)ConstantVal, (long)ConstantIndices, (int)NumIndices, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstGEP2(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstGEP2(Ty, ConstantVal, MemoryUtil.memAddress((CustomBuffer)ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstInBoundsGEP(long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstInBoundsGEP;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ConstantIndices, (int)NumIndices, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInBoundsGEP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstInBoundsGEP(ConstantVal, MemoryUtil.memAddress((CustomBuffer)ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstInBoundsGEP2(long Ty, long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstInBoundsGEP2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Ty);
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPPP((long)Ty, (long)ConstantVal, (long)ConstantIndices, (int)NumIndices, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInBoundsGEP2(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstInBoundsGEP2(Ty, ConstantVal, MemoryUtil.memAddress((CustomBuffer)ConstantIndices), ConstantIndices.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstTrunc(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstTrunc;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSExt;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstZExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstZExt;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPTrunc(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPTrunc;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPExt;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstUIToFP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstUIToFP;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSIToFP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSIToFP;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPToUI(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPToUI;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPToSI(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPToSI;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPtrToInt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstPtrToInt;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntToPtr(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstIntToPtr;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAddrSpaceCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstAddrSpaceCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstZExtOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstZExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSExtOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstTruncOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstTruncOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPointerCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstPointerCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType, @NativeType(value="LLVMBool") boolean isSigned) {
        long __functionAddress = Functions.ConstIntCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (int)(isSigned ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPCast;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantVal);
            Checks.check((long)ToType);
        }
        return JNI.invokePPP((long)ConstantVal, (long)ToType, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSelect(@NativeType(value="LLVMValueRef") long ConstantCondition, @NativeType(value="LLVMValueRef") long ConstantIfTrue, @NativeType(value="LLVMValueRef") long ConstantIfFalse) {
        long __functionAddress = Functions.ConstSelect;
        if (Checks.CHECKS) {
            Checks.check((long)ConstantCondition);
            Checks.check((long)ConstantIfTrue);
            Checks.check((long)ConstantIfFalse);
        }
        return JNI.invokePPPP((long)ConstantCondition, (long)ConstantIfTrue, (long)ConstantIfFalse, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExtractElement(@NativeType(value="LLVMValueRef") long VectorConstant, @NativeType(value="LLVMValueRef") long IndexConstant) {
        long __functionAddress = Functions.ConstExtractElement;
        if (Checks.CHECKS) {
            Checks.check((long)VectorConstant);
            Checks.check((long)IndexConstant);
        }
        return JNI.invokePPP((long)VectorConstant, (long)IndexConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInsertElement(@NativeType(value="LLVMValueRef") long VectorConstant, @NativeType(value="LLVMValueRef") long ElementValueConstant, @NativeType(value="LLVMValueRef") long IndexConstant) {
        long __functionAddress = Functions.ConstInsertElement;
        if (Checks.CHECKS) {
            Checks.check((long)VectorConstant);
            Checks.check((long)ElementValueConstant);
            Checks.check((long)IndexConstant);
        }
        return JNI.invokePPPP((long)VectorConstant, (long)ElementValueConstant, (long)IndexConstant, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstShuffleVector(@NativeType(value="LLVMValueRef") long VectorAConstant, @NativeType(value="LLVMValueRef") long VectorBConstant, @NativeType(value="LLVMValueRef") long MaskConstant) {
        long __functionAddress = Functions.ConstShuffleVector;
        if (Checks.CHECKS) {
            Checks.check((long)VectorAConstant);
            Checks.check((long)VectorBConstant);
            Checks.check((long)MaskConstant);
        }
        return JNI.invokePPPP((long)VectorAConstant, (long)VectorBConstant, (long)MaskConstant, (long)__functionAddress);
    }

    public static long nLLVMConstExtractValue(long AggConstant, long IdxList, int NumIdx) {
        long __functionAddress = Functions.ConstExtractValue;
        if (Checks.CHECKS) {
            Checks.check((long)AggConstant);
        }
        return JNI.invokePPP((long)AggConstant, (long)IdxList, (int)NumIdx, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExtractValue(@NativeType(value="LLVMValueRef") long AggConstant, @NativeType(value="unsigned int *") IntBuffer IdxList) {
        return LLVMCore.nLLVMConstExtractValue(AggConstant, MemoryUtil.memAddress((IntBuffer)IdxList), IdxList.remaining());
    }

    public static long nLLVMConstInsertValue(long AggConstant, long ElementValueConstant, long IdxList, int NumIdx) {
        long __functionAddress = Functions.ConstInsertValue;
        if (Checks.CHECKS) {
            Checks.check((long)AggConstant);
            Checks.check((long)ElementValueConstant);
        }
        return JNI.invokePPPP((long)AggConstant, (long)ElementValueConstant, (long)IdxList, (int)NumIdx, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInsertValue(@NativeType(value="LLVMValueRef") long AggConstant, @NativeType(value="LLVMValueRef") long ElementValueConstant, @NativeType(value="unsigned int *") IntBuffer IdxList) {
        return LLVMCore.nLLVMConstInsertValue(AggConstant, ElementValueConstant, MemoryUtil.memAddress((IntBuffer)IdxList), IdxList.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBlockAddress(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BlockAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)F);
            Checks.check((long)BB);
        }
        return JNI.invokePPP((long)F, (long)BB, (long)__functionAddress);
    }

    public static long nLLVMConstInlineAsm(long Ty, long AsmString, long Constraints, int HasSideEffects, int IsAlignStack) {
        long __functionAddress = Functions.ConstInlineAsm;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)Ty, (long)AsmString, (long)Constraints, (int)HasSideEffects, (int)IsAlignStack, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer AsmString, @NativeType(value="char const *") ByteBuffer Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)AsmString);
            Checks.checkNT1((ByteBuffer)Constraints);
        }
        return LLVMCore.nLLVMConstInlineAsm(Ty, MemoryUtil.memAddress((ByteBuffer)AsmString), MemoryUtil.memAddress((ByteBuffer)Constraints), HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence AsmString, @NativeType(value="char const *") CharSequence Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(AsmString, true);
            long AsmStringEncoded = stack.getPointerAddress();
            stack.nUTF8(Constraints, true);
            long ConstraintsEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstInlineAsm(Ty, AsmStringEncoded, ConstraintsEncoded, HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMGetGlobalParent(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetGlobalParent;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePP((long)Global, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsDeclaration(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.IsDeclaration;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMLinkage")
    public static int LLVMGetLinkage(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetLinkage;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress);
    }

    public static void LLVMSetLinkage(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMLinkage") int Linkage) {
        long __functionAddress = Functions.SetLinkage;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)Linkage, (long)__functionAddress);
    }

    public static long nLLVMGetSection(long Global) {
        long __functionAddress = Functions.GetSection;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePP((long)Global, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetSection(@NativeType(value="LLVMValueRef") long Global) {
        long __result = LLVMCore.nLLVMGetSection(Global);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nLLVMSetSection(long Global, long Section) {
        long __functionAddress = Functions.SetSection;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        JNI.invokePPV((long)Global, (long)Section, (long)__functionAddress);
    }

    public static void LLVMSetSection(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="char const *") ByteBuffer Section) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Section);
        }
        LLVMCore.nLLVMSetSection(Global, MemoryUtil.memAddress((ByteBuffer)Section));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetSection(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="char const *") CharSequence Section) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Section, true);
            long SectionEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetSection(Global, SectionEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMVisibility")
    public static int LLVMGetVisibility(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetVisibility;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress);
    }

    public static void LLVMSetVisibility(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMVisibility") int Viz) {
        long __functionAddress = Functions.SetVisibility;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)Viz, (long)__functionAddress);
    }

    @NativeType(value="LLVMDLLStorageClass")
    public static int LLVMGetDLLStorageClass(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetDLLStorageClass;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress);
    }

    public static void LLVMSetDLLStorageClass(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMDLLStorageClass") int Class2) {
        long __functionAddress = Functions.SetDLLStorageClass;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)Class2, (long)__functionAddress);
    }

    @NativeType(value="LLVMUnnamedAddr")
    public static int LLVMGetUnnamedAddress(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetUnnamedAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress);
    }

    public static void LLVMSetUnnamedAddress(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMUnnamedAddr") int UnnamedAddr) {
        long __functionAddress = Functions.SetUnnamedAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)UnnamedAddr, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGlobalGetValueType(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GlobalGetValueType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
        }
        return JNI.invokePP((long)Global, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMHasUnnamedAddr(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.HasUnnamedAddr;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        return JNI.invokePI((long)Global, (long)__functionAddress) != 0;
    }

    public static void LLVMSetUnnamedAddr(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMBool") boolean HasUnnamedAddr) {
        long __functionAddress = Functions.SetUnnamedAddr;
        if (Checks.CHECKS) {
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)(HasUnnamedAddr ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetAlignment(@NativeType(value="LLVMValueRef") long V2) {
        long __functionAddress = Functions.GetAlignment;
        if (Checks.CHECKS) {
            Checks.check((long)V2);
        }
        return JNI.invokePI((long)V2, (long)__functionAddress);
    }

    public static void LLVMSetAlignment(@NativeType(value="LLVMValueRef") long V2, @NativeType(value="unsigned int") int Bytes) {
        long __functionAddress = Functions.SetAlignment;
        if (Checks.CHECKS) {
            Checks.check((long)V2);
        }
        JNI.invokePV((long)V2, (int)Bytes, (long)__functionAddress);
    }

    public static void LLVMGlobalSetMetadata(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="unsigned int") int Kind, @NativeType(value="LLVMMetadataRef") long MD) {
        long __functionAddress = Functions.GlobalSetMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
            Checks.check((long)MD);
        }
        JNI.invokePPV((long)Global, (int)Kind, (long)MD, (long)__functionAddress);
    }

    public static void LLVMGlobalEraseMetadata(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="unsigned int") int Kind) {
        long __functionAddress = Functions.GlobalEraseMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (int)Kind, (long)__functionAddress);
    }

    public static void LLVMGlobalClearMetadata(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GlobalClearMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Global);
        }
        JNI.invokePV((long)Global, (long)__functionAddress);
    }

    public static long nLLVMGlobalCopyAllMetadata(long Value, long NumEntries) {
        long __functionAddress = Functions.GlobalCopyAllMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Value);
        }
        return JNI.invokePPP((long)Value, (long)NumEntries, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueMetadataEntry *")
    public static long LLVMGlobalCopyAllMetadata(@NativeType(value="LLVMValueRef") long Value, @NativeType(value="size_t *") PointerBuffer NumEntries) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)NumEntries, (int)1);
        }
        return LLVMCore.nLLVMGlobalCopyAllMetadata(Value, MemoryUtil.memAddress((CustomBuffer)NumEntries));
    }

    public static void LLVMDisposeValueMetadataEntries(@NativeType(value="LLVMValueMetadataEntry *") long Entries) {
        long __functionAddress = Functions.DisposeValueMetadataEntries;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        JNI.invokePV((long)Entries, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMValueMetadataEntriesGetKind(@NativeType(value="LLVMValueMetadataEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ValueMetadataEntriesGetKind;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        return JNI.invokePI((long)Entries, (int)Index, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMValueMetadataEntriesGetMetadata(@NativeType(value="LLVMValueMetadataEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ValueMetadataEntriesGetMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Entries);
        }
        return JNI.invokePP((long)Entries, (int)Index, (long)__functionAddress);
    }

    public static long nLLVMAddGlobal(long M, long Ty, long Name) {
        long __functionAddress = Functions.AddGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)M, (long)Ty, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAddGlobal(M, Ty, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddGlobal(M, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAddGlobalInAddressSpace(long M, long Ty, long Name, int AddressSpace) {
        long __functionAddress = Functions.AddGlobalInAddressSpace;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)M, (long)Ty, (long)Name, (int)AddressSpace, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalInAddressSpace(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="unsigned int") int AddressSpace) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAddGlobalInAddressSpace(M, Ty, MemoryUtil.memAddress((ByteBuffer)Name), AddressSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalInAddressSpace(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name, @NativeType(value="unsigned int") int AddressSpace) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddGlobalInAddressSpace(M, Ty, NameEncoded, AddressSpace);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedGlobal(long M, long Name) {
        long __functionAddress = Functions.GetNamedGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMGetNamedGlobal(M, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedGlobal(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstGlobal(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastGlobal(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetNextGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePP((long)GlobalVar, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetPreviousGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePP((long)GlobalVar, (long)__functionAddress);
    }

    public static void LLVMDeleteGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.DeleteGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        JNI.invokePV((long)GlobalVar, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetInitializer(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetInitializer;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePP((long)GlobalVar, (long)__functionAddress);
    }

    public static void LLVMSetInitializer(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.SetInitializer;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
            Checks.check((long)ConstantVal);
        }
        JNI.invokePPV((long)GlobalVar, (long)ConstantVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsThreadLocal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsThreadLocal;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePI((long)GlobalVar, (long)__functionAddress) != 0;
    }

    public static void LLVMSetThreadLocal(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsThreadLocal) {
        long __functionAddress = Functions.SetThreadLocal;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        JNI.invokePV((long)GlobalVar, (int)(IsThreadLocal ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsGlobalConstant(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsGlobalConstant;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePI((long)GlobalVar, (long)__functionAddress) != 0;
    }

    public static void LLVMSetGlobalConstant(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsConstant) {
        long __functionAddress = Functions.SetGlobalConstant;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        JNI.invokePV((long)GlobalVar, (int)(IsConstant ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMThreadLocalMode")
    public static int LLVMGetThreadLocalMode(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetThreadLocalMode;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePI((long)GlobalVar, (long)__functionAddress);
    }

    public static void LLVMSetThreadLocalMode(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMThreadLocalMode") int Mode) {
        long __functionAddress = Functions.SetThreadLocalMode;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        JNI.invokePV((long)GlobalVar, (int)Mode, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsExternallyInitialized(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsExternallyInitialized;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePI((long)GlobalVar, (long)__functionAddress) != 0;
    }

    public static void LLVMSetExternallyInitialized(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsExtInit) {
        long __functionAddress = Functions.SetExternallyInitialized;
        if (Checks.CHECKS) {
            Checks.check((long)GlobalVar);
        }
        JNI.invokePV((long)GlobalVar, (int)(IsExtInit ? 1 : 0), (long)__functionAddress);
    }

    public static long nLLVMAddAlias(long M, long Ty, long Aliasee, long Name) {
        long __functionAddress = Functions.AddAlias;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)Ty);
            Checks.check((long)Aliasee);
        }
        return JNI.invokePPPPP((long)M, (long)Ty, (long)Aliasee, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Aliasee, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAddAlias(M, Ty, Aliasee, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Aliasee, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddAlias(M, Ty, Aliasee, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedGlobalAlias(long M, long Name, long NameLen) {
        long __functionAddress = Functions.GetNamedGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePPPP((long)M, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMCore.nLLVMGetNamedGlobalAlias(M, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedGlobalAlias(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstGlobalAlias(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastGlobalAlias(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextGlobalAlias(@NativeType(value="LLVMValueRef") long GA) {
        long __functionAddress = Functions.GetNextGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)GA);
        }
        return JNI.invokePP((long)GA, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousGlobalAlias(@NativeType(value="LLVMValueRef") long GA) {
        long __functionAddress = Functions.GetPreviousGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)GA);
        }
        return JNI.invokePP((long)GA, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAliasGetAliasee(@NativeType(value="LLVMValueRef") long Alias) {
        long __functionAddress = Functions.AliasGetAliasee;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Alias);
        }
        return JNI.invokePP((long)Alias, (long)__functionAddress);
    }

    public static void LLVMAliasSetAliasee(@NativeType(value="LLVMValueRef") long Alias, @NativeType(value="LLVMValueRef") long Aliasee) {
        long __functionAddress = Functions.AliasSetAliasee;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Alias);
            Checks.check((long)Aliasee);
        }
        JNI.invokePPV((long)Alias, (long)Aliasee, (long)__functionAddress);
    }

    public static void LLVMDeleteFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.DeleteFunction;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePV((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMHasPersonalityFn(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.HasPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePI((long)Fn, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPersonalityFn(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    public static void LLVMSetPersonalityFn(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef") long PersonalityFn) {
        long __functionAddress = Functions.SetPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
            Checks.check((long)PersonalityFn);
        }
        JNI.invokePPV((long)Fn, (long)PersonalityFn, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetIntrinsicID(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetIntrinsicID;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePI((long)Fn, (long)__functionAddress);
    }

    public static long nLLVMGetIntrinsicDeclaration(long Mod, int ID, long ParamTypes, long ParamCount) {
        long __functionAddress = Functions.GetIntrinsicDeclaration;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Mod);
        }
        return JNI.invokePPPP((long)Mod, (int)ID, (long)ParamTypes, (long)ParamCount, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetIntrinsicDeclaration(@NativeType(value="LLVMModuleRef") long Mod, @NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        return LLVMCore.nLLVMGetIntrinsicDeclaration(Mod, ID, MemoryUtil.memAddress((CustomBuffer)ParamTypes), ParamTypes.remaining());
    }

    public static long nLLVMIntrinsicGetType(long Ctx, int ID, long ParamTypes, long ParamCount) {
        long __functionAddress = Functions.IntrinsicGetType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Ctx);
        }
        return JNI.invokePPPP((long)Ctx, (int)ID, (long)ParamTypes, (long)ParamCount, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIntrinsicGetType(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        return LLVMCore.nLLVMIntrinsicGetType(Ctx, ID, MemoryUtil.memAddress((CustomBuffer)ParamTypes), ParamTypes.remaining());
    }

    public static long nLLVMIntrinsicGetName(int ID, long NameLength) {
        long __functionAddress = Functions.IntrinsicGetName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePP((int)ID, (long)NameLength, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMIntrinsicGetName(@NativeType(value="unsigned") int ID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLength = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMIntrinsicGetName(ID, MemoryUtil.memAddress((CustomBuffer)NameLength));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)((int)NameLength.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMIntrinsicCopyOverloadedName(int ID, long ParamTypes, long ParamCount, long NameLength) {
        long __functionAddress = Functions.IntrinsicCopyOverloadedName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePPPP((int)ID, (long)ParamTypes, (long)ParamCount, (long)NameLength, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMIntrinsicCopyOverloadedName(@NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLength = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMIntrinsicCopyOverloadedName(ID, MemoryUtil.memAddress((CustomBuffer)ParamTypes), ParamTypes.remaining(), MemoryUtil.memAddress((CustomBuffer)NameLength));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)((int)NameLength.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIntrinsicIsOverloaded(@NativeType(value="unsigned") int ID) {
        long __functionAddress = Functions.IntrinsicIsOverloaded;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeI((int)ID, (long)__functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetFunctionCallConv(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFunctionCallConv;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePI((long)Fn, (long)__functionAddress);
    }

    public static void LLVMSetFunctionCallConv(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="unsigned int") int CC) {
        long __functionAddress = Functions.SetFunctionCallConv;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePV((long)Fn, (int)CC, (long)__functionAddress);
    }

    public static long nLLVMGetGC(long Fn) {
        long __functionAddress = Functions.GetGC;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetGC(@NativeType(value="LLVMValueRef") long Fn) {
        long __result = LLVMCore.nLLVMGetGC(Fn);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nLLVMSetGC(long Fn, long Name) {
        long __functionAddress = Functions.SetGC;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePPV((long)Fn, (long)Name, (long)__functionAddress);
    }

    public static void LLVMSetGC(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        LLVMCore.nLLVMSetGC(Fn, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetGC(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetGC(Fn, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMAddAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.AddAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
            Checks.check((long)A);
        }
        JNI.invokePPV((long)F, (int)Idx, (long)A, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetAttributeCountAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx) {
        long __functionAddress = Functions.GetAttributeCountAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        return JNI.invokePI((long)F, (int)Idx, (long)__functionAddress);
    }

    public static void nLLVMGetAttributesAtIndex(long F, int Idx, long Attrs) {
        long __functionAddress = Functions.GetAttributesAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        JNI.invokePPV((long)F, (int)Idx, (long)Attrs, (long)__functionAddress);
    }

    public static void LLVMGetAttributesAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef *") PointerBuffer Attrs) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Attrs, (int)LLVMCore.LLVMGetAttributeCountAtIndex(F, Idx));
        }
        LLVMCore.nLLVMGetAttributesAtIndex(F, Idx, MemoryUtil.memAddress((CustomBuffer)Attrs));
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetEnumAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetEnumAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        return JNI.invokePP((long)F, (int)Idx, (int)KindID, (long)__functionAddress);
    }

    public static long nLLVMGetStringAttributeAtIndex(long F, int Idx, long K, int KLen) {
        long __functionAddress = Functions.GetStringAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        return JNI.invokePPP((long)F, (int)Idx, (long)K, (int)KLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        return LLVMCore.nLLVMGetStringAttributeAtIndex(F, Idx, MemoryUtil.memAddress((ByteBuffer)K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetStringAttributeAtIndex(F, Idx, KEncoded, KEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMRemoveEnumAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.RemoveEnumAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        JNI.invokePV((long)F, (int)Idx, (int)KindID, (long)__functionAddress);
    }

    public static void nLLVMRemoveStringAttributeAtIndex(long F, int Idx, long K, int KLen) {
        long __functionAddress = Functions.RemoveStringAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check((long)F);
        }
        JNI.invokePPV((long)F, (int)Idx, (long)K, (int)KLen, (long)__functionAddress);
    }

    public static void LLVMRemoveStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        LLVMCore.nLLVMRemoveStringAttributeAtIndex(F, Idx, MemoryUtil.memAddress((ByteBuffer)K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMRemoveStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMRemoveStringAttributeAtIndex(F, Idx, KEncoded, KEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddTargetDependentFunctionAttr(long Fn, long A, long V2) {
        long __functionAddress = Functions.AddTargetDependentFunctionAttr;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePPPV((long)Fn, (long)A, (long)V2, (long)__functionAddress);
    }

    public static void LLVMAddTargetDependentFunctionAttr(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer A, @NativeType(value="char const *") ByteBuffer V2) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)A);
            Checks.checkNT1((ByteBuffer)V2);
        }
        LLVMCore.nLLVMAddTargetDependentFunctionAttr(Fn, MemoryUtil.memAddress((ByteBuffer)A), MemoryUtil.memAddress((ByteBuffer)V2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddTargetDependentFunctionAttr(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence A, @NativeType(value="char const *") CharSequence V2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(A, true);
            long AEncoded = stack.getPointerAddress();
            stack.nUTF8(V2, true);
            long VEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddTargetDependentFunctionAttr(Fn, AEncoded, VEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountParams(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.CountParams;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePI((long)Fn, (long)__functionAddress);
    }

    public static void nLLVMGetParams(long Fn, long Params) {
        long __functionAddress = Functions.GetParams;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePPV((long)Fn, (long)Params, (long)__functionAddress);
    }

    public static void LLVMGetParams(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Params) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Params, (int)LLVMCore.LLVMCountParams(Fn));
        }
        LLVMCore.nLLVMGetParams(Fn, MemoryUtil.memAddress((CustomBuffer)Params));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParam(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetParam;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (int)Index, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParamParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetParamParent;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstParam(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFirstParam;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastParam(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetLastParam;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextParam(@NativeType(value="LLVMValueRef") long Arg) {
        long __functionAddress = Functions.GetNextParam;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        return JNI.invokePP((long)Arg, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousParam(@NativeType(value="LLVMValueRef") long Arg) {
        long __functionAddress = Functions.GetPreviousParam;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        return JNI.invokePP((long)Arg, (long)__functionAddress);
    }

    public static void LLVMSetParamAlignment(@NativeType(value="LLVMValueRef") long Arg, @NativeType(value="unsigned int") int Align) {
        long __functionAddress = Functions.SetParamAlignment;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        JNI.invokePV((long)Arg, (int)Align, (long)__functionAddress);
    }

    public static long nLLVMMDStringInContext(long C, long Str, int SLen) {
        long __functionAddress = Functions.MDStringInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)Str, (int)SLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Str) {
        return LLVMCore.nLLVMMDStringInContext(C, MemoryUtil.memAddress((ByteBuffer)Str), Str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMMDStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMMDStringInContext(C, StrEncoded, StrEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMMDString(long Str, int SLen) {
        long __functionAddress = Functions.MDString;
        return JNI.invokePP((long)Str, (int)SLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDString(@NativeType(value="char const *") ByteBuffer Str) {
        return LLVMCore.nLLVMMDString(MemoryUtil.memAddress((ByteBuffer)Str), Str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMMDString(@NativeType(value="char const *") CharSequence Str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMMDString(StrEncoded, StrEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMMDNodeInContext(long C, long Vals, int Count) {
        long __functionAddress = Functions.MDNodeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)Vals, (int)Count, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDNodeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef *") PointerBuffer Vals) {
        return LLVMCore.nLLVMMDNodeInContext(C, MemoryUtil.memAddress((CustomBuffer)Vals), Vals.remaining());
    }

    public static long nLLVMMDNode(long Vals, int Count) {
        long __functionAddress = Functions.MDNode;
        return JNI.invokePP((long)Vals, (int)Count, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDNode(@NativeType(value="LLVMValueRef *") PointerBuffer Vals) {
        return LLVMCore.nLLVMMDNode(MemoryUtil.memAddress((CustomBuffer)Vals), Vals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMetadataAsValue(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMMetadataRef") long MD) {
        long __functionAddress = Functions.MetadataAsValue;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)MD);
        }
        return JNI.invokePPP((long)C, (long)MD, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMValueAsMetadata(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueAsMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    public static long nLLVMGetMDString(long V2, long Length) {
        long __functionAddress = Functions.GetMDString;
        if (Checks.CHECKS) {
            Checks.check((long)V2);
        }
        return JNI.invokePPP((long)V2, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetMDString(@NativeType(value="LLVMValueRef") long V2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetMDString(V2, MemoryUtil.memAddress((IntBuffer)Length));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDNodeNumOperands(@NativeType(value="LLVMValueRef") long V2) {
        long __functionAddress = Functions.GetMDNodeNumOperands;
        if (Checks.CHECKS) {
            Checks.check((long)V2);
        }
        return JNI.invokePI((long)V2, (long)__functionAddress);
    }

    public static void nLLVMGetMDNodeOperands(long V2, long Dest) {
        long __functionAddress = Functions.GetMDNodeOperands;
        if (Checks.CHECKS) {
            Checks.check((long)V2);
        }
        JNI.invokePPV((long)V2, (long)Dest, (long)__functionAddress);
    }

    public static void LLVMGetMDNodeOperands(@NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Dest, (int)LLVMCore.LLVMGetMDNodeNumOperands(V2));
        }
        LLVMCore.nLLVMGetMDNodeOperands(V2, MemoryUtil.memAddress((CustomBuffer)Dest));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBasicBlockAsValue(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BasicBlockAsValue;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMValueIsBasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueIsBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMValueAsBasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueAsBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (long)__functionAddress);
    }

    public static long nLLVMGetBasicBlockName(long BB) {
        long __functionAddress = Functions.GetBasicBlockName;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetBasicBlockName(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __result = LLVMCore.nLLVMGetBasicBlockName(BB);
        return MemoryUtil.memUTF8((long)__result);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetBasicBlockParent(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetBasicBlockParent;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetBasicBlockTerminator(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetBasicBlockTerminator;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountBasicBlocks(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.CountBasicBlocks;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePI((long)Fn, (long)__functionAddress);
    }

    public static void nLLVMGetBasicBlocks(long Fn, long BasicBlocks) {
        long __functionAddress = Functions.GetBasicBlocks;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        JNI.invokePPV((long)Fn, (long)BasicBlocks, (long)__functionAddress);
    }

    public static void LLVMGetBasicBlocks(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer BasicBlocks) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)BasicBlocks, (int)LLVMCore.LLVMCountBasicBlocks(Fn));
        }
        LLVMCore.nLLVMGetBasicBlocks(Fn, MemoryUtil.memAddress((CustomBuffer)BasicBlocks));
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetFirstBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFirstBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetLastBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetLastBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetNextBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetNextBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetPreviousBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetPreviousBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetEntryBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetEntryBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePP((long)Fn, (long)__functionAddress);
    }

    public static long nLLVMCreateBasicBlockInContext(long C, long Name) {
        long __functionAddress = Functions.CreateBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMCreateBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMCreateBasicBlockInContext(C, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMCreateBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateBasicBlockInContext(C, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAppendBasicBlockInContext(long C, long Fn, long Name) {
        long __functionAddress = Functions.AppendBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)Fn);
        }
        return JNI.invokePPPP((long)C, (long)Fn, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAppendBasicBlockInContext(C, Fn, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAppendBasicBlockInContext(C, Fn, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAppendBasicBlock(long Fn, long Name) {
        long __functionAddress = Functions.AppendBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Fn);
        }
        return JNI.invokePPP((long)Fn, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlock(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMAppendBasicBlock(Fn, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlock(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAppendBasicBlock(Fn, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMInsertBasicBlockInContext(long C, long BB, long Name) {
        long __functionAddress = Functions.InsertBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)BB);
        }
        return JNI.invokePPPP((long)C, (long)BB, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMInsertBasicBlockInContext(C, BB, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMInsertBasicBlockInContext(C, BB, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMInsertBasicBlock(long InsertBeforeBB, long Name) {
        long __functionAddress = Functions.InsertBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)InsertBeforeBB);
        }
        return JNI.invokePPP((long)InsertBeforeBB, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlock(@NativeType(value="LLVMBasicBlockRef") long InsertBeforeBB, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMInsertBasicBlock(InsertBeforeBB, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlock(@NativeType(value="LLVMBasicBlockRef") long InsertBeforeBB, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMInsertBasicBlock(InsertBeforeBB, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDeleteBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.DeleteBasicBlock;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        JNI.invokePV((long)BB, (long)__functionAddress);
    }

    public static void LLVMRemoveBasicBlockFromParent(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.RemoveBasicBlockFromParent;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        JNI.invokePV((long)BB, (long)__functionAddress);
    }

    public static void LLVMMoveBasicBlockBefore(@NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="LLVMBasicBlockRef") long MovePos) {
        long __functionAddress = Functions.MoveBasicBlockBefore;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
            Checks.check((long)MovePos);
        }
        JNI.invokePPV((long)BB, (long)MovePos, (long)__functionAddress);
    }

    public static void LLVMMoveBasicBlockAfter(@NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="LLVMBasicBlockRef") long MovePos) {
        long __functionAddress = Functions.MoveBasicBlockAfter;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
            Checks.check((long)MovePos);
        }
        JNI.invokePPV((long)BB, (long)MovePos, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstInstruction(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetFirstInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastInstruction(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetLastInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)BB);
        }
        return JNI.invokePP((long)BB, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean LLVMHasMetadata(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.HasMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePI((long)Val, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetMetadata(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
        }
        return JNI.invokePP((long)Val, (int)KindID, (long)__functionAddress);
    }

    public static void LLVMSetMetadata(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int KindID, @NativeType(value="LLVMValueRef") long Node) {
        long __functionAddress = Functions.SetMetadata;
        if (Checks.CHECKS) {
            Checks.check((long)Val);
            Checks.check((long)Node);
        }
        JNI.invokePPV((long)Val, (int)KindID, (long)Node, (long)__functionAddress);
    }

    public static long nLLVMInstructionGetAllMetadataOtherThanDebugLoc(long Instr, long NumEntries) {
        long __functionAddress = Functions.InstructionGetAllMetadataOtherThanDebugLoc;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Instr);
        }
        return JNI.invokePPP((long)Instr, (long)NumEntries, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueMetadataEntry *")
    public static long LLVMInstructionGetAllMetadataOtherThanDebugLoc(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="size_t *") PointerBuffer NumEntries) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)NumEntries, (int)1);
        }
        return LLVMCore.nLLVMInstructionGetAllMetadataOtherThanDebugLoc(Instr, MemoryUtil.memAddress((CustomBuffer)NumEntries));
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetInstructionParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetInstructionParent;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextInstruction(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetNextInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousInstruction(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetPreviousInstruction;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    public static void LLVMInstructionRemoveFromParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionRemoveFromParent;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        JNI.invokePV((long)Inst, (long)__functionAddress);
    }

    public static void LLVMInstructionEraseFromParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionEraseFromParent;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        JNI.invokePV((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMOpcode")
    public static int LLVMGetInstructionOpcode(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetInstructionOpcode;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePI((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMIntPredicate")
    public static int LLVMGetICmpPredicate(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetICmpPredicate;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePI((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMRealPredicate")
    public static int LLVMGetFCmpPredicate(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetFCmpPredicate;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePI((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMInstructionClone(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionClone;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsATerminatorInst(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.IsATerminatorInst;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumArgOperands(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetNumArgOperands;
        if (Checks.CHECKS) {
            Checks.check((long)Instr);
        }
        return JNI.invokePI((long)Instr, (long)__functionAddress);
    }

    public static void LLVMSetInstructionCallConv(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="unsigned int") int CC) {
        long __functionAddress = Functions.SetInstructionCallConv;
        if (Checks.CHECKS) {
            Checks.check((long)Instr);
        }
        JNI.invokePV((long)Instr, (int)CC, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetInstructionCallConv(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetInstructionCallConv;
        if (Checks.CHECKS) {
            Checks.check((long)Instr);
        }
        return JNI.invokePI((long)Instr, (long)__functionAddress);
    }

    public static void LLVMSetInstrParamAlignment(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="unsigned int") int index, @NativeType(value="unsigned int") int Align) {
        long __functionAddress = Functions.SetInstrParamAlignment;
        if (Checks.CHECKS) {
            Checks.check((long)Instr);
        }
        JNI.invokePV((long)Instr, (int)index, (int)Align, (long)__functionAddress);
    }

    public static void LLVMAddCallSiteAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.AddCallSiteAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)A);
        }
        JNI.invokePPV((long)C, (int)Idx, (long)A, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetCallSiteAttributeCount(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx) {
        long __functionAddress = Functions.GetCallSiteAttributeCount;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePI((long)C, (int)Idx, (long)__functionAddress);
    }

    public static void nLLVMGetCallSiteAttributes(long C, int Idx, long Attrs) {
        long __functionAddress = Functions.GetCallSiteAttributes;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePPV((long)C, (int)Idx, (long)Attrs, (long)__functionAddress);
    }

    public static void LLVMGetCallSiteAttributes(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef *") PointerBuffer Attrs) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Attrs, (int)LLVMCore.LLVMGetCallSiteAttributeCount(C, Idx));
        }
        LLVMCore.nLLVMGetCallSiteAttributes(C, Idx, MemoryUtil.memAddress((CustomBuffer)Attrs));
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteEnumAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetCallSiteEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (int)Idx, (int)KindID, (long)__functionAddress);
    }

    public static long nLLVMGetCallSiteStringAttribute(long C, int Idx, long K, int KLen) {
        long __functionAddress = Functions.GetCallSiteStringAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePPP((long)C, (int)Idx, (long)K, (int)KLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        return LLVMCore.nLLVMGetCallSiteStringAttribute(C, Idx, MemoryUtil.memAddress((ByteBuffer)K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetCallSiteStringAttribute(C, Idx, KEncoded, KEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMRemoveCallSiteEnumAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.RemoveCallSiteEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePV((long)C, (int)Idx, (int)KindID, (long)__functionAddress);
    }

    public static void nLLVMRemoveCallSiteStringAttribute(long C, int Idx, long K, int KLen) {
        long __functionAddress = Functions.RemoveCallSiteStringAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePPV((long)C, (int)Idx, (long)K, (int)KLen, (long)__functionAddress);
    }

    public static void LLVMRemoveCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        LLVMCore.nLLVMRemoveCallSiteStringAttribute(C, Idx, MemoryUtil.memAddress((ByteBuffer)K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMRemoveCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMRemoveCallSiteStringAttribute(C, Idx, KEncoded, KEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetCalledFunctionType(@NativeType(value="LLVMValueRef") long C) {
        long __functionAddress = Functions.GetCalledFunctionType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCalledValue(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetCalledValue;
        if (Checks.CHECKS) {
            Checks.check((long)Instr);
        }
        return JNI.invokePP((long)Instr, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsTailCall(@NativeType(value="LLVMValueRef") long CallInst) {
        long __functionAddress = Functions.IsTailCall;
        if (Checks.CHECKS) {
            Checks.check((long)CallInst);
        }
        return JNI.invokePI((long)CallInst, (long)__functionAddress) != 0;
    }

    public static void LLVMSetTailCall(@NativeType(value="LLVMValueRef") long CallInst, @NativeType(value="LLVMBool") boolean IsTailCall) {
        long __functionAddress = Functions.SetTailCall;
        if (Checks.CHECKS) {
            Checks.check((long)CallInst);
        }
        JNI.invokePV((long)CallInst, (int)(IsTailCall ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetNormalDest(@NativeType(value="LLVMValueRef") long InvokeInst) {
        long __functionAddress = Functions.GetNormalDest;
        if (Checks.CHECKS) {
            Checks.check((long)InvokeInst);
        }
        return JNI.invokePP((long)InvokeInst, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetUnwindDest(@NativeType(value="LLVMValueRef") long InvokeInst) {
        long __functionAddress = Functions.GetUnwindDest;
        if (Checks.CHECKS) {
            Checks.check((long)InvokeInst);
        }
        return JNI.invokePP((long)InvokeInst, (long)__functionAddress);
    }

    public static void LLVMSetNormalDest(@NativeType(value="LLVMValueRef") long InvokeInst, @NativeType(value="LLVMBasicBlockRef") long B) {
        long __functionAddress = Functions.SetNormalDest;
        if (Checks.CHECKS) {
            Checks.check((long)InvokeInst);
            Checks.check((long)B);
        }
        JNI.invokePPV((long)InvokeInst, (long)B, (long)__functionAddress);
    }

    public static void LLVMSetUnwindDest(@NativeType(value="LLVMValueRef") long InvokeInst, @NativeType(value="LLVMBasicBlockRef") long B) {
        long __functionAddress = Functions.SetUnwindDest;
        if (Checks.CHECKS) {
            Checks.check((long)InvokeInst);
            Checks.check((long)B);
        }
        JNI.invokePPV((long)InvokeInst, (long)B, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumSuccessors(@NativeType(value="LLVMValueRef") long Term) {
        long __functionAddress = Functions.GetNumSuccessors;
        if (Checks.CHECKS) {
            Checks.check((long)Term);
        }
        return JNI.invokePI((long)Term, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetSuccessor(@NativeType(value="LLVMValueRef") long Term, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.GetSuccessor;
        if (Checks.CHECKS) {
            Checks.check((long)Term);
        }
        return JNI.invokePP((long)Term, (int)i, (long)__functionAddress);
    }

    public static void LLVMSetSuccessor(@NativeType(value="LLVMValueRef") long Term, @NativeType(value="unsigned int") int i, @NativeType(value="LLVMBasicBlockRef") long block) {
        long __functionAddress = Functions.SetSuccessor;
        if (Checks.CHECKS) {
            Checks.check((long)Term);
            Checks.check((long)block);
        }
        JNI.invokePPV((long)Term, (int)i, (long)block, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConditional(@NativeType(value="LLVMValueRef") long Branch) {
        long __functionAddress = Functions.IsConditional;
        if (Checks.CHECKS) {
            Checks.check((long)Branch);
        }
        return JNI.invokePI((long)Branch, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCondition(@NativeType(value="LLVMValueRef") long Branch) {
        long __functionAddress = Functions.GetCondition;
        if (Checks.CHECKS) {
            Checks.check((long)Branch);
        }
        return JNI.invokePP((long)Branch, (long)__functionAddress);
    }

    public static void LLVMSetCondition(@NativeType(value="LLVMValueRef") long Branch, @NativeType(value="LLVMValueRef") long Cond) {
        long __functionAddress = Functions.SetCondition;
        if (Checks.CHECKS) {
            Checks.check((long)Branch);
            Checks.check((long)Cond);
        }
        JNI.invokePPV((long)Branch, (long)Cond, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetSwitchDefaultDest(@NativeType(value="LLVMValueRef") long SwitchInstr) {
        long __functionAddress = Functions.GetSwitchDefaultDest;
        if (Checks.CHECKS) {
            Checks.check((long)SwitchInstr);
        }
        return JNI.invokePP((long)SwitchInstr, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetAllocatedType(@NativeType(value="LLVMValueRef") long Alloca) {
        long __functionAddress = Functions.GetAllocatedType;
        if (Checks.CHECKS) {
            Checks.check((long)Alloca);
        }
        return JNI.invokePP((long)Alloca, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsInBounds(@NativeType(value="LLVMValueRef") long GEP) {
        long __functionAddress = Functions.IsInBounds;
        if (Checks.CHECKS) {
            Checks.check((long)GEP);
        }
        return JNI.invokePI((long)GEP, (long)__functionAddress) != 0;
    }

    public static void LLVMSetIsInBounds(@NativeType(value="LLVMValueRef") long GEP, @NativeType(value="LLVMBool") boolean InBounds) {
        long __functionAddress = Functions.SetIsInBounds;
        if (Checks.CHECKS) {
            Checks.check((long)GEP);
        }
        JNI.invokePV((long)GEP, (int)(InBounds ? 1 : 0), (long)__functionAddress);
    }

    public static void nLLVMAddIncoming(long PhiNode, long IncomingValues, long IncomingBlocks, int Count) {
        long __functionAddress = Functions.AddIncoming;
        if (Checks.CHECKS) {
            Checks.check((long)PhiNode);
        }
        JNI.invokePPPV((long)PhiNode, (long)IncomingValues, (long)IncomingBlocks, (int)Count, (long)__functionAddress);
    }

    public static void LLVMAddIncoming(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="LLVMValueRef *") PointerBuffer IncomingValues, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer IncomingBlocks) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)IncomingBlocks, (int)IncomingValues.remaining());
        }
        LLVMCore.nLLVMAddIncoming(PhiNode, MemoryUtil.memAddress((CustomBuffer)IncomingValues), MemoryUtil.memAddress((CustomBuffer)IncomingBlocks), IncomingValues.remaining());
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountIncoming(@NativeType(value="LLVMValueRef") long PhiNode) {
        long __functionAddress = Functions.CountIncoming;
        if (Checks.CHECKS) {
            Checks.check((long)PhiNode);
        }
        return JNI.invokePI((long)PhiNode, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetIncomingValue(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetIncomingValue;
        if (Checks.CHECKS) {
            Checks.check((long)PhiNode);
        }
        return JNI.invokePP((long)PhiNode, (int)Index, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetIncomingBlock(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetIncomingBlock;
        if (Checks.CHECKS) {
            Checks.check((long)PhiNode);
        }
        return JNI.invokePP((long)PhiNode, (int)Index, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumIndices(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetNumIndices;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePI((long)Inst, (long)__functionAddress);
    }

    public static long nLLVMGetIndices(long Inst) {
        long __functionAddress = Functions.GetIndices;
        if (Checks.CHECKS) {
            Checks.check((long)Inst);
        }
        return JNI.invokePP((long)Inst, (long)__functionAddress);
    }

    @NativeType(value="unsigned int const *")
    public static IntBuffer LLVMGetIndices(@NativeType(value="LLVMValueRef") long Inst, @NativeType(value="unsigned int") int Count) {
        long __result = LLVMCore.nLLVMGetIndices(Inst);
        return MemoryUtil.memIntBuffer((long)__result, (int)Count);
    }

    @NativeType(value="LLVMBuilderRef")
    public static long LLVMCreateBuilderInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.CreateBuilderInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePP((long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMBuilderRef")
    public static long LLVMCreateBuilder() {
        long __functionAddress = Functions.CreateBuilder;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void LLVMPositionBuilder(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMBasicBlockRef") long Block, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.PositionBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Block);
            Checks.check((long)Instr);
        }
        JNI.invokePPPV((long)Builder, (long)Block, (long)Instr, (long)__functionAddress);
    }

    public static void LLVMPositionBuilderBefore(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.PositionBuilderBefore;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Instr);
        }
        JNI.invokePPV((long)Builder, (long)Instr, (long)__functionAddress);
    }

    public static void LLVMPositionBuilderAtEnd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.PositionBuilderAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Block);
        }
        JNI.invokePPV((long)Builder, (long)Block, (long)__functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetInsertBlock(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.GetInsertBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePP((long)Builder, (long)__functionAddress);
    }

    public static void LLVMClearInsertionPosition(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.ClearInsertionPosition;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        JNI.invokePV((long)Builder, (long)__functionAddress);
    }

    public static void LLVMInsertIntoBuilder(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.InsertIntoBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Instr);
        }
        JNI.invokePPV((long)Builder, (long)Instr, (long)__functionAddress);
    }

    public static void nLLVMInsertIntoBuilderWithName(long Builder, long Instr, long Name) {
        long __functionAddress = Functions.InsertIntoBuilderWithName;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Instr);
        }
        JNI.invokePPPV((long)Builder, (long)Instr, (long)Name, (long)__functionAddress);
    }

    public static void LLVMInsertIntoBuilderWithName(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Instr, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        LLVMCore.nLLVMInsertIntoBuilderWithName(Builder, Instr, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMInsertIntoBuilderWithName(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Instr, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMInsertIntoBuilderWithName(Builder, Instr, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeBuilder(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.DisposeBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        JNI.invokePV((long)Builder, (long)__functionAddress);
    }

    public static void LLVMSetCurrentDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long L) {
        long __functionAddress = Functions.SetCurrentDebugLocation;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)L);
        }
        JNI.invokePPV((long)Builder, (long)L, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCurrentDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.GetCurrentDebugLocation;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePP((long)Builder, (long)__functionAddress);
    }

    public static void LLVMSetInstDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.SetInstDebugLocation;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Inst);
        }
        JNI.invokePPV((long)Builder, (long)Inst, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildRetVoid(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.BuildRetVoid;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePP((long)Builder, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildRet(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2) {
        long __functionAddress = Functions.BuildRet;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V2);
        }
        return JNI.invokePPP((long)Builder, (long)V2, (long)__functionAddress);
    }

    public static long nLLVMBuildAggregateRet(long Builder, long RetVals, int N) {
        long __functionAddress = Functions.BuildAggregateRet;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPP((long)Builder, (long)RetVals, (int)N, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAggregateRet(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef *") PointerBuffer RetVals) {
        return LLVMCore.nLLVMBuildAggregateRet(Builder, MemoryUtil.memAddress((CustomBuffer)RetVals), RetVals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.BuildBr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Dest);
        }
        return JNI.invokePPP((long)Builder, (long)Dest, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCondBr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Else) {
        long __functionAddress = Functions.BuildCondBr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)If);
            Checks.check((long)Then);
            Checks.check((long)Else);
        }
        return JNI.invokePPPPP((long)Builder, (long)If, (long)Then, (long)Else, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSwitch(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMBasicBlockRef") long Else, @NativeType(value="unsigned int") int NumCases) {
        long __functionAddress = Functions.BuildSwitch;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V2);
            Checks.check((long)Else);
        }
        return JNI.invokePPPP((long)Builder, (long)V2, (long)Else, (int)NumCases, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIndirectBr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Addr, @NativeType(value="unsigned int") int NumDests) {
        long __functionAddress = Functions.BuildIndirectBr;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Addr);
        }
        return JNI.invokePPP((long)B, (long)Addr, (int)NumDests, (long)__functionAddress);
    }

    public static long nLLVMBuildInvoke(long Builder, long Fn, long Args, int NumArgs, long Then, long Catch, long Name) {
        long __functionAddress = Functions.BuildInvoke;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Fn);
            Checks.check((long)Then);
            Checks.check((long)Catch);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Fn, (long)Args, (int)NumArgs, (long)Then, (long)Catch, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInvoke(Builder, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), Then, Catch, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInvoke(Builder, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), Then, Catch, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInvoke2(long Builder, long Ty, long Fn, long Args, int NumArgs, long Then, long Catch, long Name) {
        long __functionAddress = Functions.BuildInvoke2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)Fn);
            Checks.check((long)Then);
            Checks.check((long)Catch);
        }
        return JNI.invokePPPPPPPP((long)Builder, (long)Ty, (long)Fn, (long)Args, (int)NumArgs, (long)Then, (long)Catch, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInvoke2(Builder, Ty, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), Then, Catch, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInvoke2(Builder, Ty, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), Then, Catch, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUnreachable(@NativeType(value="LLVMBuilderRef") long Builder) {
        long __functionAddress = Functions.BuildUnreachable;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePP((long)Builder, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildResume(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Exn) {
        long __functionAddress = Functions.BuildResume;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Exn);
        }
        return JNI.invokePPP((long)B, (long)Exn, (long)__functionAddress);
    }

    public static long nLLVMBuildLandingPad(long B, long Ty, long PersFn, int NumClauses, long Name) {
        long __functionAddress = Functions.BuildLandingPad;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Ty);
            Checks.check((long)PersFn);
        }
        return JNI.invokePPPPP((long)B, (long)Ty, (long)PersFn, (int)NumClauses, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLandingPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PersFn, @NativeType(value="unsigned int") int NumClauses, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildLandingPad(B, Ty, PersFn, NumClauses, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLandingPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PersFn, @NativeType(value="unsigned int") int NumClauses, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLandingPad(B, Ty, PersFn, NumClauses, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupRet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BuildCleanupRet;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)CatchPad);
            Checks.check((long)BB);
        }
        return JNI.invokePPPP((long)B, (long)CatchPad, (long)BB, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchRet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BuildCatchRet;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)CatchPad);
            Checks.check((long)BB);
        }
        return JNI.invokePPPP((long)B, (long)CatchPad, (long)BB, (long)__functionAddress);
    }

    public static long nLLVMBuildCatchPad(long B, long ParentPad, long Args, int NumArgs, long Name) {
        long __functionAddress = Functions.BuildCatchPad;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)ParentPad);
        }
        return JNI.invokePPPPP((long)B, (long)ParentPad, (long)Args, (int)NumArgs, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCatchPad(B, ParentPad, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCatchPad(B, ParentPad, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCleanupPad(long B, long ParentPad, long Args, int NumArgs, long Name) {
        long __functionAddress = Functions.BuildCleanupPad;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)ParentPad);
        }
        return JNI.invokePPPPP((long)B, (long)ParentPad, (long)Args, (int)NumArgs, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCleanupPad(B, ParentPad, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCleanupPad(B, ParentPad, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCatchSwitch(long B, long ParentPad, long UnwindBB, int NumHandlers, long Name) {
        long __functionAddress = Functions.BuildCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)ParentPad);
            Checks.check((long)UnwindBB);
        }
        return JNI.invokePPPPP((long)B, (long)ParentPad, (long)UnwindBB, (int)NumHandlers, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchSwitch(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMBasicBlockRef") long UnwindBB, @NativeType(value="unsigned int") int NumHandlers, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCatchSwitch(B, ParentPad, UnwindBB, NumHandlers, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchSwitch(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMBasicBlockRef") long UnwindBB, @NativeType(value="unsigned int") int NumHandlers, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCatchSwitch(B, ParentPad, UnwindBB, NumHandlers, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMAddCase(@NativeType(value="LLVMValueRef") long Switch, @NativeType(value="LLVMValueRef") long OnVal, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddCase;
        if (Checks.CHECKS) {
            Checks.check((long)Switch);
            Checks.check((long)OnVal);
            Checks.check((long)Dest);
        }
        JNI.invokePPPV((long)Switch, (long)OnVal, (long)Dest, (long)__functionAddress);
    }

    public static void LLVMAddDestination(@NativeType(value="LLVMValueRef") long IndirectBr, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddDestination;
        if (Checks.CHECKS) {
            Checks.check((long)IndirectBr);
            Checks.check((long)Dest);
        }
        JNI.invokePPV((long)IndirectBr, (long)Dest, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumClauses(@NativeType(value="LLVMValueRef") long LandingPad) {
        long __functionAddress = Functions.GetNumClauses;
        if (Checks.CHECKS) {
            Checks.check((long)LandingPad);
        }
        return JNI.invokePI((long)LandingPad, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetClause(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="unsigned int") int Idx) {
        long __functionAddress = Functions.GetClause;
        if (Checks.CHECKS) {
            Checks.check((long)LandingPad);
        }
        return JNI.invokePP((long)LandingPad, (int)Idx, (long)__functionAddress);
    }

    public static void LLVMAddClause(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="LLVMValueRef") long ClauseVal) {
        long __functionAddress = Functions.AddClause;
        if (Checks.CHECKS) {
            Checks.check((long)LandingPad);
            Checks.check((long)ClauseVal);
        }
        JNI.invokePPV((long)LandingPad, (long)ClauseVal, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsCleanup(@NativeType(value="LLVMValueRef") long LandingPad) {
        long __functionAddress = Functions.IsCleanup;
        if (Checks.CHECKS) {
            Checks.check((long)LandingPad);
        }
        return JNI.invokePI((long)LandingPad, (long)__functionAddress) != 0;
    }

    public static void LLVMSetCleanup(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="LLVMBool") boolean Val) {
        long __functionAddress = Functions.SetCleanup;
        if (Checks.CHECKS) {
            Checks.check((long)LandingPad);
        }
        JNI.invokePV((long)LandingPad, (int)(Val ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMAddHandler(@NativeType(value="LLVMValueRef") long CatchSwitch, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddHandler;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)CatchSwitch);
            Checks.check((long)Dest);
        }
        JNI.invokePPV((long)CatchSwitch, (long)Dest, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumHandlers(@NativeType(value="LLVMValueRef") long CatchSwitch) {
        long __functionAddress = Functions.GetNumHandlers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)CatchSwitch);
        }
        return JNI.invokePI((long)CatchSwitch, (long)__functionAddress);
    }

    public static void nLLVMGetHandlers(long CatchSwitch, long Handlers) {
        long __functionAddress = Functions.GetHandlers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)CatchSwitch);
        }
        JNI.invokePPV((long)CatchSwitch, (long)Handlers, (long)__functionAddress);
    }

    public static void LLVMGetHandlers(@NativeType(value="LLVMValueRef") long CatchSwitch, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer Handlers) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((CustomBuffer)Handlers, (int)LLVMCore.LLVMGetNumHandlers(CatchSwitch));
        }
        LLVMCore.nLLVMGetHandlers(CatchSwitch, MemoryUtil.memAddress((CustomBuffer)Handlers));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetArgOperand(@NativeType(value="LLVMValueRef") long Funclet, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.GetArgOperand;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Funclet);
        }
        return JNI.invokePP((long)Funclet, (int)i, (long)__functionAddress);
    }

    public static void LLVMSetArgOperand(@NativeType(value="LLVMValueRef") long Funclet, @NativeType(value="unsigned int") int i, @NativeType(value="LLVMValueRef") long value) {
        long __functionAddress = Functions.SetArgOperand;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Funclet);
            Checks.check((long)value);
        }
        JNI.invokePPV((long)Funclet, (int)i, (long)value, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParentCatchSwitch(@NativeType(value="LLVMValueRef") long CatchPad) {
        long __functionAddress = Functions.GetParentCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)CatchPad);
        }
        return JNI.invokePP((long)CatchPad, (long)__functionAddress);
    }

    public static void LLVMSetParentCatchSwitch(@NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMValueRef") long CatchSwitch) {
        long __functionAddress = Functions.SetParentCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)CatchPad);
            Checks.check((long)CatchSwitch);
        }
        JNI.invokePPV((long)CatchPad, (long)CatchSwitch, (long)__functionAddress);
    }

    public static long nLLVMBuildAdd(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildAdd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildAdd(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAdd(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWAdd(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNSWAdd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNSWAdd(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWAdd(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWAdd(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNUWAdd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNUWAdd(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWAdd(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFAdd(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFAdd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFAdd(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFAdd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFAdd(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSub(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildSub;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSub(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSub(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWSub(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNSWSub;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNSWSub(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWSub(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWSub(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNUWSub;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNUWSub(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWSub(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFSub(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFSub;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFSub(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFSub(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFSub(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildMul(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildMul;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildMul(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildMul(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWMul(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNSWMul;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNSWMul(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWMul(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWMul(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildNUWMul;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNUWMul(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWMul(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFMul(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFMul;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFMul(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFMul(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFMul(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildUDiv(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildUDiv;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildUDiv(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildUDiv(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExactUDiv(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildExactUDiv;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactUDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildExactUDiv(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactUDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExactUDiv(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSDiv(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildSDiv;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSDiv(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSDiv(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExactSDiv(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildExactSDiv;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactSDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildExactSDiv(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactSDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExactSDiv(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFDiv(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFDiv;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFDiv(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFDiv(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFDiv(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildURem(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildURem;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildURem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildURem(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildURem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildURem(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSRem(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildSRem;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSRem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSRem(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSRem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSRem(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFRem(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFRem;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFRem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFRem(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFRem(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFRem(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildShl(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildShl;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShl(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildShl(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShl(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildShl(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildLShr(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildLShr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLShr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildLShr(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLShr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLShr(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAShr(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildAShr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAShr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildAShr(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAShr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAShr(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAnd(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildAnd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAnd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildAnd(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAnd(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAnd(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildOr(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildOr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildOr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildOr(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildOr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildOr(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildXor(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildXor;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildXor(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildXor(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildXor(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildXor(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildBinOp(long B, int Op, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildBinOp;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)B, (int)Op, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBinOp(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildBinOp(B, Op, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBinOp(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildBinOp(B, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNeg(long Builder, long V2, long Name) {
        long __functionAddress = Functions.BuildNeg;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V2);
        }
        return JNI.invokePPPP((long)Builder, (long)V2, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNeg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNeg(Builder, V2, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNeg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNeg(Builder, V2, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWNeg(long B, long V2, long Name) {
        long __functionAddress = Functions.BuildNSWNeg;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)V2);
        }
        return JNI.invokePPPP((long)B, (long)V2, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNSWNeg(B, V2, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWNeg(B, V2, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWNeg(long B, long V2, long Name) {
        long __functionAddress = Functions.BuildNUWNeg;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)V2);
        }
        return JNI.invokePPPP((long)B, (long)V2, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNUWNeg(B, V2, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWNeg(B, V2, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFNeg(long Builder, long V2, long Name) {
        long __functionAddress = Functions.BuildFNeg;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V2);
        }
        return JNI.invokePPPP((long)Builder, (long)V2, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFNeg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFNeg(Builder, V2, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFNeg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFNeg(Builder, V2, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNot(long Builder, long V2, long Name) {
        long __functionAddress = Functions.BuildNot;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V2);
        }
        return JNI.invokePPPP((long)Builder, (long)V2, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNot(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildNot(Builder, V2, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNot(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNot(Builder, V2, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildMalloc(long Builder, long Ty, long Name) {
        long __functionAddress = Functions.BuildMalloc;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)Builder, (long)Ty, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMalloc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildMalloc(Builder, Ty, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMalloc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildMalloc(Builder, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildArrayMalloc(long Builder, long Ty, long Val, long Name) {
        long __functionAddress = Functions.BuildArrayMalloc;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)Val);
        }
        return JNI.invokePPPPP((long)Builder, (long)Ty, (long)Val, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayMalloc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildArrayMalloc(Builder, Ty, Val, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayMalloc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildArrayMalloc(Builder, Ty, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemSet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Ptr, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMValueRef") long Len, @NativeType(value="unsigned") int Align) {
        long __functionAddress = Functions.BuildMemSet;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Ptr);
            Checks.check((long)Val);
            Checks.check((long)Len);
        }
        return JNI.invokePPPPP((long)B, (long)Ptr, (long)Val, (long)Len, (int)Align, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemCpy(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Dst, @NativeType(value="unsigned") int DstAlign, @NativeType(value="LLVMValueRef") long Src, @NativeType(value="unsigned") int SrcAlign, @NativeType(value="LLVMValueRef") long Size) {
        long __functionAddress = Functions.BuildMemCpy;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Dst);
            Checks.check((long)Src);
            Checks.check((long)Size);
        }
        return JNI.invokePPPPP((long)B, (long)Dst, (int)DstAlign, (long)Src, (int)SrcAlign, (long)Size, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemMove(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Dst, @NativeType(value="unsigned") int DstAlign, @NativeType(value="LLVMValueRef") long Src, @NativeType(value="unsigned") int SrcAlign, @NativeType(value="LLVMValueRef") long Size) {
        long __functionAddress = Functions.BuildMemMove;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Dst);
            Checks.check((long)Src);
            Checks.check((long)Size);
        }
        return JNI.invokePPPPP((long)B, (long)Dst, (int)DstAlign, (long)Src, (int)SrcAlign, (long)Size, (long)__functionAddress);
    }

    public static long nLLVMBuildAlloca(long Builder, long Ty, long Name) {
        long __functionAddress = Functions.BuildAlloca;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)Builder, (long)Ty, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAlloca(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildAlloca(Builder, Ty, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAlloca(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAlloca(Builder, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildArrayAlloca(long Builder, long Ty, long Val, long Name) {
        long __functionAddress = Functions.BuildArrayAlloca;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)Val);
        }
        return JNI.invokePPPPP((long)Builder, (long)Ty, (long)Val, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayAlloca(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildArrayAlloca(Builder, Ty, Val, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayAlloca(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildArrayAlloca(Builder, Ty, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFree(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long PointerVal) {
        long __functionAddress = Functions.BuildFree;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)PointerVal);
        }
        return JNI.invokePPP((long)Builder, (long)PointerVal, (long)__functionAddress);
    }

    public static long nLLVMBuildLoad(long Builder, long PointerVal, long Name) {
        long __functionAddress = Functions.BuildLoad;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)PointerVal);
        }
        return JNI.invokePPPP((long)Builder, (long)PointerVal, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildLoad(Builder, PointerVal, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLoad(Builder, PointerVal, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildLoad2(long Builder, long Ty, long PointerVal, long Name) {
        long __functionAddress = Functions.BuildLoad2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)PointerVal);
        }
        return JNI.invokePPPPP((long)Builder, (long)Ty, (long)PointerVal, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildLoad2(Builder, Ty, PointerVal, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLoad2(Builder, Ty, PointerVal, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStore(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMValueRef") long Ptr) {
        long __functionAddress = Functions.BuildStore;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)Ptr);
        }
        return JNI.invokePPPP((long)Builder, (long)Val, (long)Ptr, (long)__functionAddress);
    }

    public static long nLLVMBuildGEP(long B, long Pointer2, long Indices, int NumIndices, long Name) {
        long __functionAddress = Functions.BuildGEP;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPPP((long)B, (long)Pointer2, (long)Indices, (int)NumIndices, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildGEP(B, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGEP(B, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInBoundsGEP(long B, long Pointer2, long Indices, int NumIndices, long Name) {
        long __functionAddress = Functions.BuildInBoundsGEP;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPPP((long)B, (long)Pointer2, (long)Indices, (int)NumIndices, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInBoundsGEP(B, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInBoundsGEP(B, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildStructGEP(long B, long Pointer2, int Idx, long Name) {
        long __functionAddress = Functions.BuildStructGEP;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPP((long)B, (long)Pointer2, (int)Idx, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildStructGEP(B, Pointer2, Idx, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildStructGEP(B, Pointer2, Idx, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGEP2(long B, long Ty, long Pointer2, long Indices, int NumIndices, long Name) {
        long __functionAddress = Functions.BuildGEP2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Ty);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPPPP((long)B, (long)Ty, (long)Pointer2, (long)Indices, (int)NumIndices, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildGEP2(B, Ty, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGEP2(B, Ty, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInBoundsGEP2(long B, long Ty, long Pointer2, long Indices, int NumIndices, long Name) {
        long __functionAddress = Functions.BuildInBoundsGEP2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Ty);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPPPP((long)B, (long)Ty, (long)Pointer2, (long)Indices, (int)NumIndices, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInBoundsGEP2(B, Ty, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInBoundsGEP2(B, Ty, Pointer2, MemoryUtil.memAddress((CustomBuffer)Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildStructGEP2(long B, long Ty, long Pointer2, int Idx, long Name) {
        long __functionAddress = Functions.BuildStructGEP2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)B);
            Checks.check((long)Ty);
            Checks.check((long)Pointer2);
        }
        return JNI.invokePPPPP((long)B, (long)Ty, (long)Pointer2, (int)Idx, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildStructGEP2(B, Ty, Pointer2, Idx, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildStructGEP2(B, Ty, Pointer2, Idx, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGlobalString(long B, long Str, long Name) {
        long __functionAddress = Functions.BuildGlobalString;
        if (Checks.CHECKS) {
            Checks.check((long)B);
        }
        return JNI.invokePPPP((long)B, (long)Str, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalString(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Str);
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildGlobalString(B, MemoryUtil.memAddress((ByteBuffer)Str), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalString(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") CharSequence Str, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Str, true);
            long StrEncoded = stack.getPointerAddress();
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGlobalString(B, StrEncoded, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGlobalStringPtr(long B, long Str, long Name) {
        long __functionAddress = Functions.BuildGlobalStringPtr;
        if (Checks.CHECKS) {
            Checks.check((long)B);
        }
        return JNI.invokePPPP((long)B, (long)Str, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalStringPtr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Str);
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildGlobalStringPtr(B, MemoryUtil.memAddress((ByteBuffer)Str), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalStringPtr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") CharSequence Str, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Str, true);
            long StrEncoded = stack.getPointerAddress();
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGlobalStringPtr(B, StrEncoded, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetVolatile(@NativeType(value="LLVMValueRef") long MemoryAccessInst) {
        long __functionAddress = Functions.GetVolatile;
        if (Checks.CHECKS) {
            Checks.check((long)MemoryAccessInst);
        }
        return JNI.invokePI((long)MemoryAccessInst, (long)__functionAddress) != 0;
    }

    public static void LLVMSetVolatile(@NativeType(value="LLVMValueRef") long MemoryAccessInst, @NativeType(value="LLVMBool") boolean IsVolatile) {
        long __functionAddress = Functions.SetVolatile;
        if (Checks.CHECKS) {
            Checks.check((long)MemoryAccessInst);
        }
        JNI.invokePV((long)MemoryAccessInst, (int)(IsVolatile ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetOrdering(@NativeType(value="LLVMValueRef") long MemoryAccessInst) {
        long __functionAddress = Functions.GetOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)MemoryAccessInst);
        }
        return JNI.invokePI((long)MemoryAccessInst, (long)__functionAddress);
    }

    public static void LLVMSetOrdering(@NativeType(value="LLVMValueRef") long MemoryAccessInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)MemoryAccessInst);
        }
        JNI.invokePV((long)MemoryAccessInst, (int)Ordering, (long)__functionAddress);
    }

    public static long nLLVMBuildTrunc(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildTrunc;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTrunc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildTrunc(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTrunc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildTrunc(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildZExt(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildZExt;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildZExt(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildZExt(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSExt(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildSExt;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSExt(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSExt(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPToUI(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildFPToUI;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToUI(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFPToUI(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToUI(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPToUI(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPToSI(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildFPToSI;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToSI(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFPToSI(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToSI(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPToSI(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildUIToFP(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildUIToFP;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUIToFP(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildUIToFP(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUIToFP(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildUIToFP(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSIToFP(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildSIToFP;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSIToFP(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSIToFP(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSIToFP(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSIToFP(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPTrunc(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildFPTrunc;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPTrunc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFPTrunc(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPTrunc(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPTrunc(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPExt(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildFPExt;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFPExt(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPExt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPExt(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPtrToInt(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildPtrToInt;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrToInt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildPtrToInt(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrToInt(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPtrToInt(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIntToPtr(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildIntToPtr;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntToPtr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildIntToPtr(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntToPtr(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIntToPtr(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildBitCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildBitCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildBitCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAddrSpaceCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildAddrSpaceCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAddrSpaceCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildAddrSpaceCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAddrSpaceCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAddrSpaceCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildZExtOrBitCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildZExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildZExtOrBitCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildZExtOrBitCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSExtOrBitCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildSExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSExtOrBitCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSExtOrBitCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildTruncOrBitCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildTruncOrBitCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTruncOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildTruncOrBitCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTruncOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildTruncOrBitCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCast(long B, int Op, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildCast;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)B, (int)Op, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCast(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCast(B, Op, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCast(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCast(B, Op, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPointerCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildPointerCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildPointerCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPointerCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPointerCast2(long Builder, long Val, long DestTy, int IsSigned, long Name) {
        long __functionAddress = Functions.BuildPointerCast2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (int)IsSigned, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="LLVMBool") boolean IsSigned, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildPointerCast2(Builder, Val, DestTy, IsSigned ? 1 : 0, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="LLVMBool") boolean IsSigned, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPointerCast2(Builder, Val, DestTy, IsSigned ? 1 : 0, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIntCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildIntCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildIntCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIntCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPCast(long Builder, long Val, long DestTy, long Name) {
        long __functionAddress = Functions.BuildFPCast;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)DestTy);
        }
        return JNI.invokePPPPP((long)Builder, (long)Val, (long)DestTy, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFPCast(Builder, Val, DestTy, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPCast(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPCast(Builder, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildICmp(long Builder, int Op, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildICmp;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (int)Op, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildICmp(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMIntPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildICmp(Builder, Op, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildICmp(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMIntPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildICmp(Builder, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFCmp(long Builder, int Op, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildFCmp;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (int)Op, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFCmp(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMRealPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFCmp(Builder, Op, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFCmp(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMRealPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFCmp(Builder, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPhi(long Builder, long Ty, long Name) {
        long __functionAddress = Functions.BuildPhi;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPP((long)Builder, (long)Ty, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPhi(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildPhi(Builder, Ty, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPhi(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPhi(Builder, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCall(long Builder, long Fn, long Args, int NumArgs, long Name) {
        long __functionAddress = Functions.BuildCall;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Fn);
        }
        return JNI.invokePPPPP((long)Builder, (long)Fn, (long)Args, (int)NumArgs, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCall(Builder, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCall(Builder, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCall2(long Builder, long Ty, long Fn, long Args, int NumArgs, long Name) {
        long __functionAddress = Functions.BuildCall2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)Fn);
        }
        return JNI.invokePPPPPP((long)Builder, (long)Ty, (long)Fn, (long)Args, (int)NumArgs, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildCall2(Builder, Ty, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall2(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCall2(Builder, Ty, Fn, MemoryUtil.memAddress((CustomBuffer)Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSelect(long Builder, long If, long Then, long Else, long Name) {
        long __functionAddress = Functions.BuildSelect;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)If);
            Checks.check((long)Then);
            Checks.check((long)Else);
        }
        return JNI.invokePPPPPP((long)Builder, (long)If, (long)Then, (long)Else, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSelect(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMValueRef") long Then, @NativeType(value="LLVMValueRef") long Else, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildSelect(Builder, If, Then, Else, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSelect(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMValueRef") long Then, @NativeType(value="LLVMValueRef") long Else, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSelect(Builder, If, Then, Else, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildVAArg(long Builder, long List, long Ty, long Name) {
        long __functionAddress = Functions.BuildVAArg;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)List);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPP((long)Builder, (long)List, (long)Ty, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildVAArg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long List, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildVAArg(Builder, List, Ty, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildVAArg(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long List, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildVAArg(Builder, List, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExtractElement(long Builder, long VecVal, long Index, long Name) {
        long __functionAddress = Functions.BuildExtractElement;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)VecVal);
            Checks.check((long)Index);
        }
        return JNI.invokePPPPP((long)Builder, (long)VecVal, (long)Index, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractElement(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildExtractElement(Builder, VecVal, Index, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractElement(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExtractElement(Builder, VecVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInsertElement(long Builder, long VecVal, long EltVal, long Index, long Name) {
        long __functionAddress = Functions.BuildInsertElement;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)VecVal);
            Checks.check((long)EltVal);
            Checks.check((long)Index);
        }
        return JNI.invokePPPPPP((long)Builder, (long)VecVal, (long)EltVal, (long)Index, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertElement(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInsertElement(Builder, VecVal, EltVal, Index, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertElement(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInsertElement(Builder, VecVal, EltVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildShuffleVector(long Builder, long V1, long V2, long Mask, long Name) {
        long __functionAddress = Functions.BuildShuffleVector;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)V1);
            Checks.check((long)V2);
            Checks.check((long)Mask);
        }
        return JNI.invokePPPPPP((long)Builder, (long)V1, (long)V2, (long)Mask, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShuffleVector(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V1, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMValueRef") long Mask, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildShuffleVector(Builder, V1, V2, Mask, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShuffleVector(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long V1, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMValueRef") long Mask, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildShuffleVector(Builder, V1, V2, Mask, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExtractValue(long Builder, long AggVal, int Index, long Name) {
        long __functionAddress = Functions.BuildExtractValue;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)AggVal);
        }
        return JNI.invokePPPP((long)Builder, (long)AggVal, (int)Index, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractValue(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildExtractValue(Builder, AggVal, Index, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractValue(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExtractValue(Builder, AggVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInsertValue(long Builder, long AggVal, long EltVal, int Index, long Name) {
        long __functionAddress = Functions.BuildInsertValue;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)AggVal);
            Checks.check((long)EltVal);
        }
        return JNI.invokePPPPP((long)Builder, (long)AggVal, (long)EltVal, (int)Index, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertValue(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildInsertValue(Builder, AggVal, EltVal, Index, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertValue(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInsertValue(Builder, AggVal, EltVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIsNull(long Builder, long Val, long Name) {
        long __functionAddress = Functions.BuildIsNull;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
        }
        return JNI.invokePPPP((long)Builder, (long)Val, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNull(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildIsNull(Builder, Val, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNull(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIsNull(Builder, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIsNotNull(long Builder, long Val, long Name) {
        long __functionAddress = Functions.BuildIsNotNull;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
        }
        return JNI.invokePPPP((long)Builder, (long)Val, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNotNull(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildIsNotNull(Builder, Val, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNotNull(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIsNotNull(Builder, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPtrDiff(long Builder, long LHS, long RHS, long Name) {
        long __functionAddress = Functions.BuildPtrDiff;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)LHS);
            Checks.check((long)RHS);
        }
        return JNI.invokePPPPP((long)Builder, (long)LHS, (long)RHS, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrDiff(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildPtrDiff(Builder, LHS, RHS, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrDiff(@NativeType(value="LLVMBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPtrDiff(Builder, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFence(long B, int ordering, int singleThread, long Name) {
        long __functionAddress = Functions.BuildFence;
        if (Checks.CHECKS) {
            Checks.check((long)B);
        }
        return JNI.invokePPP((long)B, (int)ordering, (int)singleThread, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFence(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMCore.nLLVMBuildFence(B, ordering, singleThread ? 1 : 0, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFence(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFence(B, ordering, singleThread ? 1 : 0, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAtomicRMW(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicRMWBinOp") int op, @NativeType(value="LLVMValueRef") long PTR, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread) {
        long __functionAddress = Functions.BuildAtomicRMW;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)PTR);
            Checks.check((long)Val);
        }
        return JNI.invokePPPP((long)B, (int)op, (long)PTR, (long)Val, (int)ordering, (int)(singleThread ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAtomicCmpXchg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Ptr, @NativeType(value="LLVMValueRef") long Cmp, @NativeType(value="LLVMValueRef") long New, @NativeType(value="LLVMAtomicOrdering") int SuccessOrdering, @NativeType(value="LLVMAtomicOrdering") int FailureOrdering, @NativeType(value="LLVMBool") boolean SingleThread) {
        long __functionAddress = Functions.BuildAtomicCmpXchg;
        if (Checks.CHECKS) {
            Checks.check((long)B);
            Checks.check((long)Ptr);
            Checks.check((long)Cmp);
            Checks.check((long)New);
        }
        return JNI.invokePPPPP((long)B, (long)Ptr, (long)Cmp, (long)New, (int)SuccessOrdering, (int)FailureOrdering, (int)(SingleThread ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsAtomicSingleThread(@NativeType(value="LLVMValueRef") long AtomicInst) {
        long __functionAddress = Functions.IsAtomicSingleThread;
        if (Checks.CHECKS) {
            Checks.check((long)AtomicInst);
        }
        return JNI.invokePI((long)AtomicInst, (long)__functionAddress) != 0;
    }

    public static void LLVMSetAtomicSingleThread(@NativeType(value="LLVMValueRef") long AtomicInst, @NativeType(value="LLVMBool") boolean SingleThread) {
        long __functionAddress = Functions.SetAtomicSingleThread;
        if (Checks.CHECKS) {
            Checks.check((long)AtomicInst);
        }
        JNI.invokePV((long)AtomicInst, (int)(SingleThread ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetCmpXchgSuccessOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst) {
        long __functionAddress = Functions.GetCmpXchgSuccessOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)CmpXchgInst);
        }
        return JNI.invokePI((long)CmpXchgInst, (long)__functionAddress);
    }

    public static void LLVMSetCmpXchgSuccessOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetCmpXchgSuccessOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)CmpXchgInst);
        }
        JNI.invokePV((long)CmpXchgInst, (int)Ordering, (long)__functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetCmpXchgFailureOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst) {
        long __functionAddress = Functions.GetCmpXchgFailureOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)CmpXchgInst);
        }
        return JNI.invokePI((long)CmpXchgInst, (long)__functionAddress);
    }

    public static void LLVMSetCmpXchgFailureOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetCmpXchgFailureOrdering;
        if (Checks.CHECKS) {
            Checks.check((long)CmpXchgInst);
        }
        JNI.invokePV((long)CmpXchgInst, (int)Ordering, (long)__functionAddress);
    }

    @NativeType(value="LLVMModuleProviderRef")
    public static long LLVMCreateModuleProviderForExistingModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateModuleProviderForExistingModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static void LLVMDisposeModuleProvider(@NativeType(value="LLVMModuleProviderRef") long M) {
        long __functionAddress = Functions.DisposeModuleProvider;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        JNI.invokePV((long)M, (long)__functionAddress);
    }

    public static int nLLVMCreateMemoryBufferWithContentsOfFile(long Path, long OutMemBuf, long OutMessage) {
        long __functionAddress = Functions.CreateMemoryBufferWithContentsOfFile;
        return JNI.invokePPPI((long)Path, (long)OutMemBuf, (long)OutMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithContentsOfFile(@NativeType(value="char const *") ByteBuffer Path, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Path);
            Checks.check((CustomBuffer)OutMemBuf, (int)1);
            Checks.check((CustomBuffer)OutMessage, (int)1);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithContentsOfFile(MemoryUtil.memAddress((ByteBuffer)Path), MemoryUtil.memAddress((CustomBuffer)OutMemBuf), MemoryUtil.memAddress((CustomBuffer)OutMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithContentsOfFile(@NativeType(value="char const *") CharSequence Path, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutMemBuf, (int)1);
            Checks.check((CustomBuffer)OutMessage, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Path, true);
            long PathEncoded = stack.getPointerAddress();
            boolean bl = LLVMCore.nLLVMCreateMemoryBufferWithContentsOfFile(PathEncoded, MemoryUtil.memAddress((CustomBuffer)OutMemBuf), MemoryUtil.memAddress((CustomBuffer)OutMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMCreateMemoryBufferWithSTDIN(long OutMemBuf, long OutMessage) {
        long __functionAddress = Functions.CreateMemoryBufferWithSTDIN;
        return JNI.invokePPI((long)OutMemBuf, (long)OutMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithSTDIN(@NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutMemBuf, (int)1);
            Checks.check((CustomBuffer)OutMessage, (int)1);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithSTDIN(MemoryUtil.memAddress((CustomBuffer)OutMemBuf), MemoryUtil.memAddress((CustomBuffer)OutMessage)) != 0;
    }

    public static long nLLVMCreateMemoryBufferWithMemoryRange(long InputData, long InputDataLength, long BufferName, int RequiresNullTerminator) {
        long __functionAddress = Functions.CreateMemoryBufferWithMemoryRange;
        return JNI.invokePPPP((long)InputData, (long)InputDataLength, (long)BufferName, (int)RequiresNullTerminator, (long)__functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRange(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") ByteBuffer BufferName, @NativeType(value="LLVMBool") boolean RequiresNullTerminator) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)BufferName);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithMemoryRange(MemoryUtil.memAddress((ByteBuffer)InputData), InputData.remaining(), MemoryUtil.memAddress((ByteBuffer)BufferName), RequiresNullTerminator ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRange(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") CharSequence BufferName, @NativeType(value="LLVMBool") boolean RequiresNullTerminator) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(BufferName, true);
            long BufferNameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateMemoryBufferWithMemoryRange(MemoryUtil.memAddress((ByteBuffer)InputData), InputData.remaining(), BufferNameEncoded, RequiresNullTerminator ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCreateMemoryBufferWithMemoryRangeCopy(long InputData, long InputDataLength, long BufferName) {
        long __functionAddress = Functions.CreateMemoryBufferWithMemoryRangeCopy;
        return JNI.invokePPPP((long)InputData, (long)InputDataLength, (long)BufferName, (long)__functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRangeCopy(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") ByteBuffer BufferName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)BufferName);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithMemoryRangeCopy(MemoryUtil.memAddress((ByteBuffer)InputData), InputData.remaining(), MemoryUtil.memAddress((ByteBuffer)BufferName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRangeCopy(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") CharSequence BufferName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(BufferName, true);
            long BufferNameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateMemoryBufferWithMemoryRangeCopy(MemoryUtil.memAddress((ByteBuffer)InputData), InputData.remaining(), BufferNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetBufferStart(long MemBuf) {
        long __functionAddress = Functions.GetBufferStart;
        if (Checks.CHECKS) {
            Checks.check((long)MemBuf);
        }
        return JNI.invokePP((long)MemBuf, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetBufferStart(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __result = LLVMCore.nLLVMGetBufferStart(MemBuf);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="size_t")
    public static long LLVMGetBufferSize(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.GetBufferSize;
        if (Checks.CHECKS) {
            Checks.check((long)MemBuf);
        }
        return JNI.invokePP((long)MemBuf, (long)__functionAddress);
    }

    public static void LLVMDisposeMemoryBuffer(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.DisposeMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)MemBuf);
        }
        JNI.invokePV((long)MemBuf, (long)__functionAddress);
    }

    @NativeType(value="LLVMPassRegistryRef")
    public static long LLVMGetGlobalPassRegistry() {
        long __functionAddress = Functions.GetGlobalPassRegistry;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreatePassManager() {
        long __functionAddress = Functions.CreatePassManager;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreateFunctionPassManagerForModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateFunctionPassManagerForModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreateFunctionPassManager(@NativeType(value="LLVMModuleProviderRef") long MP) {
        long __functionAddress = Functions.CreateFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)MP);
        }
        return JNI.invokePP((long)MP, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRunPassManager(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.RunPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)PM);
            Checks.check((long)M);
        }
        return JNI.invokePPI((long)PM, (long)M, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMInitializeFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM) {
        long __functionAddress = Functions.InitializeFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)FPM);
        }
        return JNI.invokePI((long)FPM, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRunFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM, @NativeType(value="LLVMValueRef") long F) {
        long __functionAddress = Functions.RunFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)FPM);
            Checks.check((long)F);
        }
        return JNI.invokePPI((long)FPM, (long)F, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMFinalizeFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM) {
        long __functionAddress = Functions.FinalizeFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)FPM);
        }
        return JNI.invokePI((long)FPM, (long)__functionAddress) != 0;
    }

    public static void LLVMDisposePassManager(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.DisposePassManager;
        if (Checks.CHECKS) {
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMStartMultithreaded() {
        long __functionAddress = Functions.StartMultithreaded;
        return JNI.invokeI((long)__functionAddress) != 0;
    }

    public static void LLVMStopMultithreaded() {
        long __functionAddress = Functions.StopMultithreaded;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsMultithreaded() {
        long __functionAddress = Functions.IsMultithreaded;
        return JNI.invokeI((long)__functionAddress) != 0;
    }

    static /* synthetic */ SharedLibrary access$000() {
        return LLVM;
    }

    public static final class Functions {
        public static final long InitializeCore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInitializeCore");
        public static final long Shutdown = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMShutdown");
        public static final long CreateMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateMessage");
        public static final long DisposeMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposeMessage");
        public static final long ContextCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextCreate");
        public static final long GetGlobalContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetGlobalContext");
        public static final long ContextSetDiagnosticHandler = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextSetDiagnosticHandler");
        public static final long ContextGetDiagnosticHandler = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextGetDiagnosticHandler");
        public static final long ContextGetDiagnosticContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextGetDiagnosticContext");
        public static final long ContextSetYieldCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextSetYieldCallback");
        public static final long ContextShouldDiscardValueNames = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMContextShouldDiscardValueNames");
        public static final long ContextSetDiscardValueNames = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMContextSetDiscardValueNames");
        public static final long ContextDispose = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMContextDispose");
        public static final long GetDiagInfoDescription = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetDiagInfoDescription");
        public static final long GetDiagInfoSeverity = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetDiagInfoSeverity");
        public static final long GetMDKindIDInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMDKindIDInContext");
        public static final long GetMDKindID = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMDKindID");
        public static final long GetEnumAttributeKindForName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetEnumAttributeKindForName");
        public static final long GetLastEnumAttributeKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastEnumAttributeKind");
        public static final long CreateEnumAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateEnumAttribute");
        public static final long GetEnumAttributeKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetEnumAttributeKind");
        public static final long GetEnumAttributeValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetEnumAttributeValue");
        public static final long CreateStringAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateStringAttribute");
        public static final long GetStringAttributeKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetStringAttributeKind");
        public static final long GetStringAttributeValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetStringAttributeValue");
        public static final long IsEnumAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsEnumAttribute");
        public static final long IsStringAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsStringAttribute");
        public static final long ModuleCreateWithName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMModuleCreateWithName");
        public static final long ModuleCreateWithNameInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMModuleCreateWithNameInContext");
        public static final long CloneModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCloneModule");
        public static final long DisposeModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposeModule");
        public static final long GetModuleIdentifier = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetModuleIdentifier");
        public static final long SetModuleIdentifier = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetModuleIdentifier");
        public static final long GetSourceFileName = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetSourceFileName");
        public static final long SetSourceFileName = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetSourceFileName");
        public static final long GetDataLayoutStr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetDataLayoutStr");
        public static final long GetDataLayout = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetDataLayout");
        public static final long SetDataLayout = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetDataLayout");
        public static final long GetTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetTarget");
        public static final long SetTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetTarget");
        public static final long CopyModuleFlagsMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMCopyModuleFlagsMetadata");
        public static final long DisposeModuleFlagsMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMDisposeModuleFlagsMetadata");
        public static final long ModuleFlagEntriesGetFlagBehavior = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMModuleFlagEntriesGetFlagBehavior");
        public static final long ModuleFlagEntriesGetKey = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMModuleFlagEntriesGetKey");
        public static final long ModuleFlagEntriesGetMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMModuleFlagEntriesGetMetadata");
        public static final long GetModuleFlag = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetModuleFlag");
        public static final long AddModuleFlag = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMAddModuleFlag");
        public static final long DumpModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDumpModule");
        public static final long PrintModuleToFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPrintModuleToFile");
        public static final long PrintModuleToString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPrintModuleToString");
        public static final long GetModuleInlineAsm = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetModuleInlineAsm");
        public static final long SetModuleInlineAsm2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetModuleInlineAsm2");
        public static final long AppendModuleInlineAsm = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMAppendModuleInlineAsm");
        public static final long GetInlineAsm = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetInlineAsm");
        public static final long GetModuleContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetModuleContext");
        public static final long GetTypeByName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetTypeByName");
        public static final long GetFirstNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetFirstNamedMetadata");
        public static final long GetLastNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetLastNamedMetadata");
        public static final long GetNextNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNextNamedMetadata");
        public static final long GetPreviousNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetPreviousNamedMetadata");
        public static final long GetNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNamedMetadata");
        public static final long GetOrInsertNamedMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetOrInsertNamedMetadata");
        public static final long GetNamedMetadataName = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNamedMetadataName");
        public static final long GetNamedMetadataNumOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNamedMetadataNumOperands");
        public static final long GetNamedMetadataOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNamedMetadataOperands");
        public static final long AddNamedMetadataOperand = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddNamedMetadataOperand");
        public static final long GetDebugLocDirectory = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetDebugLocDirectory");
        public static final long GetDebugLocFilename = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetDebugLocFilename");
        public static final long GetDebugLocLine = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetDebugLocLine");
        public static final long GetDebugLocColumn = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetDebugLocColumn");
        public static final long AddFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddFunction");
        public static final long GetNamedFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNamedFunction");
        public static final long GetFirstFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstFunction");
        public static final long GetLastFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastFunction");
        public static final long GetNextFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextFunction");
        public static final long GetPreviousFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPreviousFunction");
        public static final long SetModuleInlineAsm = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetModuleInlineAsm");
        public static final long GetTypeKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetTypeKind");
        public static final long TypeIsSized = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMTypeIsSized");
        public static final long GetTypeContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetTypeContext");
        public static final long DumpType = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMDumpType");
        public static final long PrintTypeToString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPrintTypeToString");
        public static final long Int1TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt1TypeInContext");
        public static final long Int8TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt8TypeInContext");
        public static final long Int16TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt16TypeInContext");
        public static final long Int32TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt32TypeInContext");
        public static final long Int64TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt64TypeInContext");
        public static final long Int128TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt128TypeInContext");
        public static final long IntTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIntTypeInContext");
        public static final long Int1Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt1Type");
        public static final long Int8Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt8Type");
        public static final long Int16Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt16Type");
        public static final long Int32Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt32Type");
        public static final long Int64Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt64Type");
        public static final long Int128Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInt128Type");
        public static final long IntType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIntType");
        public static final long GetIntTypeWidth = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetIntTypeWidth");
        public static final long HalfTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMHalfTypeInContext");
        public static final long FloatTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFloatTypeInContext");
        public static final long DoubleTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDoubleTypeInContext");
        public static final long X86FP80TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMX86FP80TypeInContext");
        public static final long FP128TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFP128TypeInContext");
        public static final long PPCFP128TypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPPCFP128TypeInContext");
        public static final long HalfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMHalfType");
        public static final long FloatType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFloatType");
        public static final long DoubleType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDoubleType");
        public static final long X86FP80Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMX86FP80Type");
        public static final long FP128Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFP128Type");
        public static final long PPCFP128Type = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPPCFP128Type");
        public static final long FunctionType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFunctionType");
        public static final long IsFunctionVarArg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsFunctionVarArg");
        public static final long GetReturnType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetReturnType");
        public static final long CountParamTypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCountParamTypes");
        public static final long GetParamTypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetParamTypes");
        public static final long StructTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStructTypeInContext");
        public static final long StructType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStructType");
        public static final long StructCreateNamed = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStructCreateNamed");
        public static final long GetStructName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetStructName");
        public static final long StructSetBody = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStructSetBody");
        public static final long CountStructElementTypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCountStructElementTypes");
        public static final long GetStructElementTypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetStructElementTypes");
        public static final long StructGetTypeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStructGetTypeAtIndex");
        public static final long IsPackedStruct = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsPackedStruct");
        public static final long IsOpaqueStruct = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsOpaqueStruct");
        public static final long IsLiteralStruct = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIsLiteralStruct");
        public static final long GetElementType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetElementType");
        public static final long GetSubtypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetSubtypes");
        public static final long GetNumContainedTypes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumContainedTypes");
        public static final long ArrayType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMArrayType");
        public static final long GetArrayLength = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetArrayLength");
        public static final long PointerType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPointerType");
        public static final long GetPointerAddressSpace = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPointerAddressSpace");
        public static final long VectorType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMVectorType");
        public static final long GetVectorSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetVectorSize");
        public static final long VoidTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMVoidTypeInContext");
        public static final long LabelTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMLabelTypeInContext");
        public static final long X86MMXTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMX86MMXTypeInContext");
        public static final long TokenTypeInContext = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMTokenTypeInContext");
        public static final long MetadataTypeInContext = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMMetadataTypeInContext");
        public static final long VoidType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMVoidType");
        public static final long LabelType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMLabelType");
        public static final long X86MMXType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMX86MMXType");
        public static final long TypeOf = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMTypeOf");
        public static final long GetValueKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetValueKind");
        public static final long GetValueName2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetValueName2");
        public static final long SetValueName2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetValueName2");
        public static final long DumpValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDumpValue");
        public static final long PrintValueToString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPrintValueToString");
        public static final long ReplaceAllUsesWith = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMReplaceAllUsesWith");
        public static final long IsConstant = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsConstant");
        public static final long IsUndef = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsUndef");
        public static final long IsAArgument = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAArgument");
        public static final long IsABasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsABasicBlock");
        public static final long IsAInlineAsm = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAInlineAsm");
        public static final long IsAUser = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAUser");
        public static final long IsAConstant = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstant");
        public static final long IsABlockAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsABlockAddress");
        public static final long IsAConstantAggregateZero = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantAggregateZero");
        public static final long IsAConstantArray = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantArray");
        public static final long IsAConstantDataSequential = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantDataSequential");
        public static final long IsAConstantDataArray = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantDataArray");
        public static final long IsAConstantDataVector = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantDataVector");
        public static final long IsAConstantExpr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantExpr");
        public static final long IsAConstantFP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantFP");
        public static final long IsAConstantInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantInt");
        public static final long IsAConstantPointerNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantPointerNull");
        public static final long IsAConstantStruct = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantStruct");
        public static final long IsAConstantTokenNone = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantTokenNone");
        public static final long IsAConstantVector = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAConstantVector");
        public static final long IsAGlobalValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAGlobalValue");
        public static final long IsAGlobalAlias = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAGlobalAlias");
        public static final long IsAGlobalIFunc = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIsAGlobalIFunc");
        public static final long IsAGlobalObject = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAGlobalObject");
        public static final long IsAFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFunction");
        public static final long IsAGlobalVariable = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAGlobalVariable");
        public static final long IsAUndefValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAUndefValue");
        public static final long IsAInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAInstruction");
        public static final long IsABinaryOperator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsABinaryOperator");
        public static final long IsACallInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACallInst");
        public static final long IsAIntrinsicInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAIntrinsicInst");
        public static final long IsADbgInfoIntrinsic = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsADbgInfoIntrinsic");
        public static final long IsADbgVariableIntrinsic = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIsADbgVariableIntrinsic");
        public static final long IsADbgDeclareInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsADbgDeclareInst");
        public static final long IsADbgLabelInst = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIsADbgLabelInst");
        public static final long IsAMemIntrinsic = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMemIntrinsic");
        public static final long IsAMemCpyInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMemCpyInst");
        public static final long IsAMemMoveInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMemMoveInst");
        public static final long IsAMemSetInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMemSetInst");
        public static final long IsACmpInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACmpInst");
        public static final long IsAFCmpInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFCmpInst");
        public static final long IsAICmpInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAICmpInst");
        public static final long IsAExtractElementInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAExtractElementInst");
        public static final long IsAGetElementPtrInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAGetElementPtrInst");
        public static final long IsAInsertElementInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAInsertElementInst");
        public static final long IsAInsertValueInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAInsertValueInst");
        public static final long IsALandingPadInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsALandingPadInst");
        public static final long IsAPHINode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAPHINode");
        public static final long IsASelectInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsASelectInst");
        public static final long IsAShuffleVectorInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAShuffleVectorInst");
        public static final long IsAStoreInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAStoreInst");
        public static final long IsABranchInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsABranchInst");
        public static final long IsAIndirectBrInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAIndirectBrInst");
        public static final long IsAInvokeInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAInvokeInst");
        public static final long IsAReturnInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAReturnInst");
        public static final long IsASwitchInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsASwitchInst");
        public static final long IsAUnreachableInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAUnreachableInst");
        public static final long IsAResumeInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAResumeInst");
        public static final long IsACleanupReturnInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACleanupReturnInst");
        public static final long IsACatchReturnInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACatchReturnInst");
        public static final long IsAFuncletPadInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFuncletPadInst");
        public static final long IsACatchPadInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACatchPadInst");
        public static final long IsACleanupPadInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACleanupPadInst");
        public static final long IsAUnaryInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAUnaryInstruction");
        public static final long IsAAllocaInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAAllocaInst");
        public static final long IsACastInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsACastInst");
        public static final long IsAAddrSpaceCastInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAAddrSpaceCastInst");
        public static final long IsABitCastInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsABitCastInst");
        public static final long IsAFPExtInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFPExtInst");
        public static final long IsAFPToSIInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFPToSIInst");
        public static final long IsAFPToUIInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFPToUIInst");
        public static final long IsAFPTruncInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAFPTruncInst");
        public static final long IsAIntToPtrInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAIntToPtrInst");
        public static final long IsAPtrToIntInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAPtrToIntInst");
        public static final long IsASExtInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsASExtInst");
        public static final long IsASIToFPInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsASIToFPInst");
        public static final long IsATruncInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsATruncInst");
        public static final long IsAUIToFPInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAUIToFPInst");
        public static final long IsAZExtInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAZExtInst");
        public static final long IsAExtractValueInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAExtractValueInst");
        public static final long IsALoadInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsALoadInst");
        public static final long IsAVAArgInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAVAArgInst");
        public static final long IsAMDNode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMDNode");
        public static final long IsAMDString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAMDString");
        public static final long GetValueName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetValueName");
        public static final long SetValueName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetValueName");
        public static final long GetFirstUse = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstUse");
        public static final long GetNextUse = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextUse");
        public static final long GetUser = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetUser");
        public static final long GetUsedValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetUsedValue");
        public static final long GetOperand = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetOperand");
        public static final long GetOperandUse = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetOperandUse");
        public static final long SetOperand = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetOperand");
        public static final long GetNumOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumOperands");
        public static final long ConstNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNull");
        public static final long ConstAllOnes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstAllOnes");
        public static final long GetUndef = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetUndef");
        public static final long IsNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsNull");
        public static final long ConstPointerNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstPointerNull");
        public static final long ConstInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstInt");
        public static final long ConstIntOfArbitraryPrecision = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntOfArbitraryPrecision");
        public static final long ConstIntOfString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntOfString");
        public static final long ConstIntOfStringAndSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntOfStringAndSize");
        public static final long ConstReal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstReal");
        public static final long ConstRealOfString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstRealOfString");
        public static final long ConstRealOfStringAndSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstRealOfStringAndSize");
        public static final long ConstIntGetZExtValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntGetZExtValue");
        public static final long ConstIntGetSExtValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntGetSExtValue");
        public static final long ConstRealGetDouble = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstRealGetDouble");
        public static final long ConstStringInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstStringInContext");
        public static final long ConstString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstString");
        public static final long IsConstantString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsConstantString");
        public static final long GetAsString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetAsString");
        public static final long ConstStructInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstStructInContext");
        public static final long ConstStruct = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstStruct");
        public static final long ConstArray = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstArray");
        public static final long ConstNamedStruct = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNamedStruct");
        public static final long GetElementAsConstant = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetElementAsConstant");
        public static final long ConstVector = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstVector");
        public static final long GetConstOpcode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetConstOpcode");
        public static final long AlignOf = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAlignOf");
        public static final long SizeOf = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSizeOf");
        public static final long ConstNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNeg");
        public static final long ConstNSWNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNSWNeg");
        public static final long ConstNUWNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNUWNeg");
        public static final long ConstFNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFNeg");
        public static final long ConstNot = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNot");
        public static final long ConstAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstAdd");
        public static final long ConstNSWAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNSWAdd");
        public static final long ConstNUWAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNUWAdd");
        public static final long ConstFAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFAdd");
        public static final long ConstSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSub");
        public static final long ConstNSWSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNSWSub");
        public static final long ConstNUWSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNUWSub");
        public static final long ConstFSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFSub");
        public static final long ConstMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstMul");
        public static final long ConstNSWMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNSWMul");
        public static final long ConstNUWMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstNUWMul");
        public static final long ConstFMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFMul");
        public static final long ConstUDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstUDiv");
        public static final long ConstExactUDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstExactUDiv");
        public static final long ConstSDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSDiv");
        public static final long ConstExactSDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstExactSDiv");
        public static final long ConstFDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFDiv");
        public static final long ConstURem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstURem");
        public static final long ConstSRem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSRem");
        public static final long ConstFRem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFRem");
        public static final long ConstAnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstAnd");
        public static final long ConstOr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstOr");
        public static final long ConstXor = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstXor");
        public static final long ConstICmp = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstICmp");
        public static final long ConstFCmp = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFCmp");
        public static final long ConstShl = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstShl");
        public static final long ConstLShr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstLShr");
        public static final long ConstAShr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstAShr");
        public static final long ConstGEP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstGEP");
        public static final long ConstGEP2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMConstGEP2");
        public static final long ConstInBoundsGEP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstInBoundsGEP");
        public static final long ConstInBoundsGEP2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMConstInBoundsGEP2");
        public static final long ConstTrunc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstTrunc");
        public static final long ConstSExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSExt");
        public static final long ConstZExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstZExt");
        public static final long ConstFPTrunc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFPTrunc");
        public static final long ConstFPExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFPExt");
        public static final long ConstUIToFP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstUIToFP");
        public static final long ConstSIToFP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSIToFP");
        public static final long ConstFPToUI = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFPToUI");
        public static final long ConstFPToSI = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFPToSI");
        public static final long ConstPtrToInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstPtrToInt");
        public static final long ConstIntToPtr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntToPtr");
        public static final long ConstBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstBitCast");
        public static final long ConstAddrSpaceCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstAddrSpaceCast");
        public static final long ConstZExtOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstZExtOrBitCast");
        public static final long ConstSExtOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSExtOrBitCast");
        public static final long ConstTruncOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstTruncOrBitCast");
        public static final long ConstPointerCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstPointerCast");
        public static final long ConstIntCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstIntCast");
        public static final long ConstFPCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstFPCast");
        public static final long ConstSelect = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstSelect");
        public static final long ConstExtractElement = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstExtractElement");
        public static final long ConstInsertElement = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstInsertElement");
        public static final long ConstShuffleVector = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstShuffleVector");
        public static final long ConstExtractValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstExtractValue");
        public static final long ConstInsertValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstInsertValue");
        public static final long BlockAddress = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBlockAddress");
        public static final long ConstInlineAsm = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMConstInlineAsm");
        public static final long GetGlobalParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetGlobalParent");
        public static final long IsDeclaration = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsDeclaration");
        public static final long GetLinkage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLinkage");
        public static final long SetLinkage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetLinkage");
        public static final long GetSection = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetSection");
        public static final long SetSection = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetSection");
        public static final long GetVisibility = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetVisibility");
        public static final long SetVisibility = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetVisibility");
        public static final long GetDLLStorageClass = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetDLLStorageClass");
        public static final long SetDLLStorageClass = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetDLLStorageClass");
        public static final long GetUnnamedAddress = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetUnnamedAddress");
        public static final long SetUnnamedAddress = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetUnnamedAddress");
        public static final long GlobalGetValueType = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGlobalGetValueType");
        public static final long HasUnnamedAddr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMHasUnnamedAddr");
        public static final long SetUnnamedAddr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetUnnamedAddr");
        public static final long GetAlignment = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetAlignment");
        public static final long SetAlignment = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetAlignment");
        public static final long GlobalSetMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGlobalSetMetadata");
        public static final long GlobalEraseMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGlobalEraseMetadata");
        public static final long GlobalClearMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGlobalClearMetadata");
        public static final long GlobalCopyAllMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGlobalCopyAllMetadata");
        public static final long DisposeValueMetadataEntries = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMDisposeValueMetadataEntries");
        public static final long ValueMetadataEntriesGetKind = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMValueMetadataEntriesGetKind");
        public static final long ValueMetadataEntriesGetMetadata = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMValueMetadataEntriesGetMetadata");
        public static final long AddGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddGlobal");
        public static final long AddGlobalInAddressSpace = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddGlobalInAddressSpace");
        public static final long GetNamedGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNamedGlobal");
        public static final long GetFirstGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstGlobal");
        public static final long GetLastGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastGlobal");
        public static final long GetNextGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextGlobal");
        public static final long GetPreviousGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPreviousGlobal");
        public static final long DeleteGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDeleteGlobal");
        public static final long GetInitializer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetInitializer");
        public static final long SetInitializer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetInitializer");
        public static final long IsThreadLocal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsThreadLocal");
        public static final long SetThreadLocal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetThreadLocal");
        public static final long IsGlobalConstant = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsGlobalConstant");
        public static final long SetGlobalConstant = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetGlobalConstant");
        public static final long GetThreadLocalMode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetThreadLocalMode");
        public static final long SetThreadLocalMode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetThreadLocalMode");
        public static final long IsExternallyInitialized = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsExternallyInitialized");
        public static final long SetExternallyInitialized = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetExternallyInitialized");
        public static final long AddAlias = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddAlias");
        public static final long GetNamedGlobalAlias = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNamedGlobalAlias");
        public static final long GetFirstGlobalAlias = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetFirstGlobalAlias");
        public static final long GetLastGlobalAlias = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetLastGlobalAlias");
        public static final long GetNextGlobalAlias = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNextGlobalAlias");
        public static final long GetPreviousGlobalAlias = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetPreviousGlobalAlias");
        public static final long AliasGetAliasee = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMAliasGetAliasee");
        public static final long AliasSetAliasee = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMAliasSetAliasee");
        public static final long DeleteFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDeleteFunction");
        public static final long HasPersonalityFn = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMHasPersonalityFn");
        public static final long GetPersonalityFn = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPersonalityFn");
        public static final long SetPersonalityFn = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetPersonalityFn");
        public static final long GetIntrinsicID = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetIntrinsicID");
        public static final long GetIntrinsicDeclaration = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetIntrinsicDeclaration");
        public static final long IntrinsicGetType = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIntrinsicGetType");
        public static final long IntrinsicGetName = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIntrinsicGetName");
        public static final long IntrinsicCopyOverloadedName = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIntrinsicCopyOverloadedName");
        public static final long IntrinsicIsOverloaded = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMIntrinsicIsOverloaded");
        public static final long GetFunctionCallConv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFunctionCallConv");
        public static final long SetFunctionCallConv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetFunctionCallConv");
        public static final long GetGC = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetGC");
        public static final long SetGC = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetGC");
        public static final long AddAttributeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddAttributeAtIndex");
        public static final long GetAttributeCountAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetAttributeCountAtIndex");
        public static final long GetAttributesAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetAttributesAtIndex");
        public static final long GetEnumAttributeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetEnumAttributeAtIndex");
        public static final long GetStringAttributeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetStringAttributeAtIndex");
        public static final long RemoveEnumAttributeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRemoveEnumAttributeAtIndex");
        public static final long RemoveStringAttributeAtIndex = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRemoveStringAttributeAtIndex");
        public static final long AddTargetDependentFunctionAttr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddTargetDependentFunctionAttr");
        public static final long CountParams = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCountParams");
        public static final long GetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetParams");
        public static final long GetParam = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetParam");
        public static final long GetParamParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetParamParent");
        public static final long GetFirstParam = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstParam");
        public static final long GetLastParam = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastParam");
        public static final long GetNextParam = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextParam");
        public static final long GetPreviousParam = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPreviousParam");
        public static final long SetParamAlignment = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetParamAlignment");
        public static final long MDStringInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMDStringInContext");
        public static final long MDString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMDString");
        public static final long MDNodeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMDNodeInContext");
        public static final long MDNode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMDNode");
        public static final long MetadataAsValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMetadataAsValue");
        public static final long ValueAsMetadata = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMValueAsMetadata");
        public static final long GetMDString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMDString");
        public static final long GetMDNodeNumOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMDNodeNumOperands");
        public static final long GetMDNodeOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMDNodeOperands");
        public static final long BasicBlockAsValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBasicBlockAsValue");
        public static final long ValueIsBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMValueIsBasicBlock");
        public static final long ValueAsBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMValueAsBasicBlock");
        public static final long GetBasicBlockName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBasicBlockName");
        public static final long GetBasicBlockParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBasicBlockParent");
        public static final long GetBasicBlockTerminator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBasicBlockTerminator");
        public static final long CountBasicBlocks = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCountBasicBlocks");
        public static final long GetBasicBlocks = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBasicBlocks");
        public static final long GetFirstBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstBasicBlock");
        public static final long GetLastBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastBasicBlock");
        public static final long GetNextBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextBasicBlock");
        public static final long GetPreviousBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPreviousBasicBlock");
        public static final long GetEntryBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetEntryBasicBlock");
        public static final long CreateBasicBlockInContext = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMCreateBasicBlockInContext");
        public static final long AppendBasicBlockInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAppendBasicBlockInContext");
        public static final long AppendBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAppendBasicBlock");
        public static final long InsertBasicBlockInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInsertBasicBlockInContext");
        public static final long InsertBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInsertBasicBlock");
        public static final long DeleteBasicBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDeleteBasicBlock");
        public static final long RemoveBasicBlockFromParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRemoveBasicBlockFromParent");
        public static final long MoveBasicBlockBefore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMoveBasicBlockBefore");
        public static final long MoveBasicBlockAfter = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMMoveBasicBlockAfter");
        public static final long GetFirstInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFirstInstruction");
        public static final long GetLastInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetLastInstruction");
        public static final long HasMetadata = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMHasMetadata");
        public static final long GetMetadata = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetMetadata");
        public static final long SetMetadata = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetMetadata");
        public static final long InstructionGetAllMetadataOtherThanDebugLoc = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMInstructionGetAllMetadataOtherThanDebugLoc");
        public static final long GetInstructionParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetInstructionParent");
        public static final long GetNextInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNextInstruction");
        public static final long GetPreviousInstruction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetPreviousInstruction");
        public static final long InstructionRemoveFromParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInstructionRemoveFromParent");
        public static final long InstructionEraseFromParent = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInstructionEraseFromParent");
        public static final long GetInstructionOpcode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetInstructionOpcode");
        public static final long GetICmpPredicate = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetICmpPredicate");
        public static final long GetFCmpPredicate = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetFCmpPredicate");
        public static final long InstructionClone = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInstructionClone");
        public static final long IsATerminatorInst = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsATerminatorInst");
        public static final long GetNumArgOperands = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumArgOperands");
        public static final long SetInstructionCallConv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetInstructionCallConv");
        public static final long GetInstructionCallConv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetInstructionCallConv");
        public static final long SetInstrParamAlignment = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetInstrParamAlignment");
        public static final long AddCallSiteAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddCallSiteAttribute");
        public static final long GetCallSiteAttributeCount = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCallSiteAttributeCount");
        public static final long GetCallSiteAttributes = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCallSiteAttributes");
        public static final long GetCallSiteEnumAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCallSiteEnumAttribute");
        public static final long GetCallSiteStringAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCallSiteStringAttribute");
        public static final long RemoveCallSiteEnumAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRemoveCallSiteEnumAttribute");
        public static final long RemoveCallSiteStringAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRemoveCallSiteStringAttribute");
        public static final long GetCalledFunctionType = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetCalledFunctionType");
        public static final long GetCalledValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCalledValue");
        public static final long IsTailCall = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsTailCall");
        public static final long SetTailCall = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetTailCall");
        public static final long GetNormalDest = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNormalDest");
        public static final long GetUnwindDest = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetUnwindDest");
        public static final long SetNormalDest = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetNormalDest");
        public static final long SetUnwindDest = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetUnwindDest");
        public static final long GetNumSuccessors = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumSuccessors");
        public static final long GetSuccessor = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetSuccessor");
        public static final long SetSuccessor = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetSuccessor");
        public static final long IsConditional = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsConditional");
        public static final long GetCondition = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCondition");
        public static final long SetCondition = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetCondition");
        public static final long GetSwitchDefaultDest = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetSwitchDefaultDest");
        public static final long GetAllocatedType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetAllocatedType");
        public static final long IsInBounds = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsInBounds");
        public static final long SetIsInBounds = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetIsInBounds");
        public static final long AddIncoming = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddIncoming");
        public static final long CountIncoming = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCountIncoming");
        public static final long GetIncomingValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetIncomingValue");
        public static final long GetIncomingBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetIncomingBlock");
        public static final long GetNumIndices = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumIndices");
        public static final long GetIndices = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetIndices");
        public static final long CreateBuilderInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateBuilderInContext");
        public static final long CreateBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateBuilder");
        public static final long PositionBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPositionBuilder");
        public static final long PositionBuilderBefore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPositionBuilderBefore");
        public static final long PositionBuilderAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMPositionBuilderAtEnd");
        public static final long GetInsertBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetInsertBlock");
        public static final long ClearInsertionPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMClearInsertionPosition");
        public static final long InsertIntoBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInsertIntoBuilder");
        public static final long InsertIntoBuilderWithName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInsertIntoBuilderWithName");
        public static final long DisposeBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposeBuilder");
        public static final long SetCurrentDebugLocation = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetCurrentDebugLocation");
        public static final long GetCurrentDebugLocation = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCurrentDebugLocation");
        public static final long SetInstDebugLocation = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetInstDebugLocation");
        public static final long BuildRetVoid = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildRetVoid");
        public static final long BuildRet = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildRet");
        public static final long BuildAggregateRet = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAggregateRet");
        public static final long BuildBr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildBr");
        public static final long BuildCondBr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildCondBr");
        public static final long BuildSwitch = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSwitch");
        public static final long BuildIndirectBr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildIndirectBr");
        public static final long BuildInvoke = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildInvoke");
        public static final long BuildInvoke2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildInvoke2");
        public static final long BuildUnreachable = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildUnreachable");
        public static final long BuildResume = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildResume");
        public static final long BuildLandingPad = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildLandingPad");
        public static final long BuildCleanupRet = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCleanupRet");
        public static final long BuildCatchRet = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCatchRet");
        public static final long BuildCatchPad = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCatchPad");
        public static final long BuildCleanupPad = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCleanupPad");
        public static final long BuildCatchSwitch = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCatchSwitch");
        public static final long AddCase = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddCase");
        public static final long AddDestination = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddDestination");
        public static final long GetNumClauses = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetNumClauses");
        public static final long GetClause = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetClause");
        public static final long AddClause = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMAddClause");
        public static final long IsCleanup = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsCleanup");
        public static final long SetCleanup = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetCleanup");
        public static final long AddHandler = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMAddHandler");
        public static final long GetNumHandlers = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetNumHandlers");
        public static final long GetHandlers = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetHandlers");
        public static final long GetArgOperand = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetArgOperand");
        public static final long SetArgOperand = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetArgOperand");
        public static final long GetParentCatchSwitch = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMGetParentCatchSwitch");
        public static final long SetParentCatchSwitch = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMSetParentCatchSwitch");
        public static final long BuildAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAdd");
        public static final long BuildNSWAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNSWAdd");
        public static final long BuildNUWAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNUWAdd");
        public static final long BuildFAdd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFAdd");
        public static final long BuildSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSub");
        public static final long BuildNSWSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNSWSub");
        public static final long BuildNUWSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNUWSub");
        public static final long BuildFSub = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFSub");
        public static final long BuildMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildMul");
        public static final long BuildNSWMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNSWMul");
        public static final long BuildNUWMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNUWMul");
        public static final long BuildFMul = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFMul");
        public static final long BuildUDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildUDiv");
        public static final long BuildExactUDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildExactUDiv");
        public static final long BuildSDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSDiv");
        public static final long BuildExactSDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildExactSDiv");
        public static final long BuildFDiv = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFDiv");
        public static final long BuildURem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildURem");
        public static final long BuildSRem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSRem");
        public static final long BuildFRem = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFRem");
        public static final long BuildShl = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildShl");
        public static final long BuildLShr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildLShr");
        public static final long BuildAShr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAShr");
        public static final long BuildAnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAnd");
        public static final long BuildOr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildOr");
        public static final long BuildXor = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildXor");
        public static final long BuildBinOp = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildBinOp");
        public static final long BuildNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNeg");
        public static final long BuildNSWNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNSWNeg");
        public static final long BuildNUWNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNUWNeg");
        public static final long BuildFNeg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFNeg");
        public static final long BuildNot = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildNot");
        public static final long BuildMalloc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildMalloc");
        public static final long BuildArrayMalloc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildArrayMalloc");
        public static final long BuildMemSet = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildMemSet");
        public static final long BuildMemCpy = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildMemCpy");
        public static final long BuildMemMove = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildMemMove");
        public static final long BuildAlloca = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAlloca");
        public static final long BuildArrayAlloca = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildArrayAlloca");
        public static final long BuildFree = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFree");
        public static final long BuildLoad = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildLoad");
        public static final long BuildLoad2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildLoad2");
        public static final long BuildStore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildStore");
        public static final long BuildGEP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildGEP");
        public static final long BuildInBoundsGEP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildInBoundsGEP");
        public static final long BuildStructGEP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildStructGEP");
        public static final long BuildGEP2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildGEP2");
        public static final long BuildInBoundsGEP2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildInBoundsGEP2");
        public static final long BuildStructGEP2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildStructGEP2");
        public static final long BuildGlobalString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildGlobalString");
        public static final long BuildGlobalStringPtr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildGlobalStringPtr");
        public static final long GetVolatile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetVolatile");
        public static final long SetVolatile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetVolatile");
        public static final long GetOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetOrdering");
        public static final long SetOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetOrdering");
        public static final long BuildTrunc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildTrunc");
        public static final long BuildZExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildZExt");
        public static final long BuildSExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSExt");
        public static final long BuildFPToUI = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFPToUI");
        public static final long BuildFPToSI = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFPToSI");
        public static final long BuildUIToFP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildUIToFP");
        public static final long BuildSIToFP = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSIToFP");
        public static final long BuildFPTrunc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFPTrunc");
        public static final long BuildFPExt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFPExt");
        public static final long BuildPtrToInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildPtrToInt");
        public static final long BuildIntToPtr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildIntToPtr");
        public static final long BuildBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildBitCast");
        public static final long BuildAddrSpaceCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAddrSpaceCast");
        public static final long BuildZExtOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildZExtOrBitCast");
        public static final long BuildSExtOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSExtOrBitCast");
        public static final long BuildTruncOrBitCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildTruncOrBitCast");
        public static final long BuildCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildCast");
        public static final long BuildPointerCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildPointerCast");
        public static final long BuildPointerCast2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildPointerCast2");
        public static final long BuildIntCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildIntCast");
        public static final long BuildFPCast = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFPCast");
        public static final long BuildICmp = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildICmp");
        public static final long BuildFCmp = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFCmp");
        public static final long BuildPhi = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildPhi");
        public static final long BuildCall = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildCall");
        public static final long BuildCall2 = LLVMCore.access$000().getFunctionAddress((CharSequence)"LLVMBuildCall2");
        public static final long BuildSelect = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildSelect");
        public static final long BuildVAArg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildVAArg");
        public static final long BuildExtractElement = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildExtractElement");
        public static final long BuildInsertElement = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildInsertElement");
        public static final long BuildShuffleVector = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildShuffleVector");
        public static final long BuildExtractValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildExtractValue");
        public static final long BuildInsertValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildInsertValue");
        public static final long BuildIsNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildIsNull");
        public static final long BuildIsNotNull = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildIsNotNull");
        public static final long BuildPtrDiff = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildPtrDiff");
        public static final long BuildFence = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildFence");
        public static final long BuildAtomicRMW = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAtomicRMW");
        public static final long BuildAtomicCmpXchg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMBuildAtomicCmpXchg");
        public static final long IsAtomicSingleThread = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsAtomicSingleThread");
        public static final long SetAtomicSingleThread = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetAtomicSingleThread");
        public static final long GetCmpXchgSuccessOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCmpXchgSuccessOrdering");
        public static final long SetCmpXchgSuccessOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetCmpXchgSuccessOrdering");
        public static final long GetCmpXchgFailureOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetCmpXchgFailureOrdering");
        public static final long SetCmpXchgFailureOrdering = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMSetCmpXchgFailureOrdering");
        public static final long CreateModuleProviderForExistingModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateModuleProviderForExistingModule");
        public static final long DisposeModuleProvider = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposeModuleProvider");
        public static final long CreateMemoryBufferWithContentsOfFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateMemoryBufferWithContentsOfFile");
        public static final long CreateMemoryBufferWithSTDIN = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateMemoryBufferWithSTDIN");
        public static final long CreateMemoryBufferWithMemoryRange = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateMemoryBufferWithMemoryRange");
        public static final long CreateMemoryBufferWithMemoryRangeCopy = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateMemoryBufferWithMemoryRangeCopy");
        public static final long GetBufferStart = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBufferStart");
        public static final long GetBufferSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetBufferSize");
        public static final long DisposeMemoryBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposeMemoryBuffer");
        public static final long GetGlobalPassRegistry = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMGetGlobalPassRegistry");
        public static final long CreatePassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreatePassManager");
        public static final long CreateFunctionPassManagerForModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateFunctionPassManagerForModule");
        public static final long CreateFunctionPassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMCreateFunctionPassManager");
        public static final long RunPassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRunPassManager");
        public static final long InitializeFunctionPassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMInitializeFunctionPassManager");
        public static final long RunFunctionPassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMRunFunctionPassManager");
        public static final long FinalizeFunctionPassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMFinalizeFunctionPassManager");
        public static final long DisposePassManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMDisposePassManager");
        public static final long StartMultithreaded = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStartMultithreaded");
        public static final long StopMultithreaded = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMStopMultithreaded");
        public static final long IsMultithreaded = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.access$000(), (String)"LLVMIsMultithreaded");

        private Functions() {
        }
    }
}

