/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nanovg.NSVGGradient;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NSVGpaint")
public class NSVGPaint
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int COLOR;
    public static final int GRADIENT;

    public NSVGPaint(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NSVGPaint.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char")
    public byte type() {
        return NSVGPaint.ntype(this.address());
    }

    @NativeType(value="unsigned int")
    public int color() {
        return NSVGPaint.ncolor(this.address());
    }

    @NativeType(value="NSVGgradient *")
    public NSVGGradient gradient() {
        return NSVGPaint.ngradient(this.address());
    }

    public static NSVGPaint create(long address) {
        return (NSVGPaint)NSVGPaint.wrap(NSVGPaint.class, (long)address);
    }

    @Nullable
    public static NSVGPaint createSafe(long address) {
        return address == 0L ? null : (NSVGPaint)NSVGPaint.wrap(NSVGPaint.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NSVGPaint.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NSVGPaint.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static byte ntype(long struct) {
        return UNSAFE.getByte(null, struct + (long)TYPE);
    }

    public static int ncolor(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLOR);
    }

    public static NSVGGradient ngradient(long struct) {
        return NSVGGradient.create(MemoryUtil.memGetAddress((long)(struct + (long)GRADIENT)));
    }

    static {
        Struct.Layout layout = NSVGPaint.__struct((Struct.Member[])new Struct.Member[]{NSVGPaint.__member((int)1), NSVGPaint.__union((Struct.Member[])new Struct.Member[]{NSVGPaint.__member((int)4), NSVGPaint.__member((int)POINTER_SIZE)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        COLOR = layout.offsetof(2);
        GRADIENT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NSVGPaint, Buffer> {
        private static final NSVGPaint ELEMENT_FACTORY = NSVGPaint.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NSVGPaint getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char")
        public byte type() {
            return NSVGPaint.ntype(this.address());
        }

        @NativeType(value="unsigned int")
        public int color() {
            return NSVGPaint.ncolor(this.address());
        }

        @NativeType(value="NSVGgradient *")
        public NSVGGradient gradient() {
            return NSVGPaint.ngradient(this.address());
        }
    }
}

