/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU41;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU42
extends CU41 {
    public static final int CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE = 0;
    public static final int CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE = 1;
    public static final int CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE = 2;
    public static final int CU_SHAREDMEM_CARVEOUT_DEFAULT = -1;
    public static final int CU_SHAREDMEM_CARVEOUT_MAX_SHARED = 100;
    public static final int CU_SHAREDMEM_CARVEOUT_MAX_L1 = 0;

    protected CU42() {
        throw new UnsupportedOperationException();
    }

    public static int ncuCtxGetSharedMemConfig(long pConfig) {
        long __functionAddress = Functions.CtxGetSharedMemConfig;
        return JNI.callPI((long)pConfig, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetSharedMemConfig(@NativeType(value="CUsharedconfig *") IntBuffer pConfig) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pConfig, (int)1);
        }
        return CU42.ncuCtxGetSharedMemConfig(MemoryUtil.memAddress((IntBuffer)pConfig));
    }

    @NativeType(value="CUresult")
    public static int cuCtxSetSharedMemConfig(@NativeType(value="CUsharedconfig") int config) {
        long __functionAddress = Functions.CtxSetSharedMemConfig;
        return JNI.callI((int)config, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuFuncSetSharedMemConfig(@NativeType(value="CUfunction") long hfunc, @NativeType(value="CUsharedconfig") int config) {
        long __functionAddress = Functions.FuncSetSharedMemConfig;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)config, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long CtxGetSharedMemConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxGetSharedMemConfig");
        public static final long CtxSetSharedMemConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxSetSharedMemConfig");
        public static final long FuncSetSharedMemConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuFuncSetSharedMemConfig");

        private Functions() {
        }
    }
}

