/*
 * Decompiled with CFR 0.152.
 */
package com.jrubystdinchannel;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class StdinChannelLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) throws IOException {
        RubyModule mmapModule = runtime.defineModule("StdinChannel");
        RubyClass byteBufferClass = runtime.defineClassUnder("Reader", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass rubyClass) {
                return new Reader(runtime, rubyClass);
            }
        }, mmapModule);
        byteBufferClass.defineAnnotatedMethods(Reader.class);
    }

    @JRubyClass(name={"Reader"}, parent="Object")
    public static class Reader
    extends RubyObject {
        private FileInputStream in;
        private FileChannel channel;

        public Reader(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        @JRubyMethod(name={"initialize"})
        public IRubyObject initialize(ThreadContext context) {
            this.in = Reader.interruptibleStdin(context);
            this.channel = this.in.getChannel();
            return context.nil;
        }

        private static FileInputStream interruptibleStdin(ThreadContext context) {
            RaiseException EXTRACT_ERROR = context.runtime.newRuntimeError("cannot find underlying FileInputStream in System.in");
            try {
                InputStream stdin = System.in;
                Field inField = FilterInputStream.class.getDeclaredField("in");
                inField.setAccessible(true);
                while (stdin instanceof FilterInputStream) {
                    stdin = (InputStream)inField.get(stdin);
                }
                if (!(stdin instanceof FileInputStream)) {
                    throw EXTRACT_ERROR;
                }
                return (FileInputStream)stdin;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw EXTRACT_ERROR;
            }
        }

        @JRubyMethod(name={"read"}, required=1)
        public IRubyObject read(ThreadContext context, IRubyObject _size) throws IOException {
            int n;
            int size = RubyNumeric.num2int((IRubyObject)_size);
            ByteBuffer data = ByteBuffer.allocate(size);
            try {
                n = this.channel.read(data);
            }
            catch (ClosedChannelException e) {
                throw context.runtime.newRaiseException(this.getRuntime().getModule("StdinChannel").getClass("ClosedChannelError"), "stdin channel closed");
            }
            catch (IOException e) {
                throw context.runtime.newIOErrorFromException(e);
            }
            if (n > 0) {
                byte[] bytes = new byte[n];
                data.position(0);
                data.get(bytes, 0, n);
                return RubyString.newString((Ruby)context.runtime, (byte[])bytes);
            }
            if (n == 0) {
                return new RubyString(context.runtime, context.runtime.getString());
            }
            throw context.runtime.newEOFError();
        }

        @JRubyMethod(name={"channel"})
        public IRubyObject channel(ThreadContext context) {
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.channel);
        }

        @JRubyMethod(name={"close"})
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

