/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.basic;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public abstract class AbstractBasicConverter
extends AbstractConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
        }
        Object result = this.fromExpression(configuration, evaluator, type2);
        if (result instanceof String) {
            try {
                result = this.fromString((String)result);
            }
            catch (ComponentConfigurationException e2) {
                if (e2.getFailedConfiguration() == null) {
                    e2.setFailedConfiguration(configuration);
                }
                throw e2;
            }
        }
        return result;
    }

    protected abstract Object fromString(String var1) throws ComponentConfigurationException;

    @Override
    protected final Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type2) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (value != null && value.length() > 0) {
                result = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type2) : evaluator.evaluate(value);
            }
            if (result == null && (value = configuration.getAttribute("default-value")) != null && value.length() > 0) {
                result = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type2) : evaluator.evaluate(value);
            }
            return result;
        }
        catch (ExpressionEvaluationException e2) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e2);
        }
    }
}

