/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonFormat {
    public static final String DEFAULT_LOCALE = "##default";
    public static final String DEFAULT_TIMEZONE = "##default";

    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public static class Value {
        private final String pattern;
        private final Shape shape;
        private final Locale locale;
        private final String timezoneStr;
        private TimeZone _timezone;

        public Value() {
            this("", Shape.ANY, "", "");
        }

        public Value(JsonFormat ann) {
            this(ann.pattern(), ann.shape(), ann.locale(), ann.timezone());
        }

        public Value(String p, Shape sh2, String localeStr, String tzStr) {
            this(p, sh2, localeStr == null || localeStr.length() == 0 || "##default".equals(localeStr) ? null : new Locale(localeStr), tzStr == null || tzStr.length() == 0 || "##default".equals(tzStr) ? null : tzStr, null);
        }

        public Value(String p, Shape sh2, Locale l, TimeZone tz) {
            this.pattern = p;
            this.shape = sh2 == null ? Shape.ANY : sh2;
            this.locale = l;
            this._timezone = tz;
            this.timezoneStr = null;
        }

        public Value(String p, Shape sh2, Locale l, String tzStr, TimeZone tz) {
            this.pattern = p;
            this.shape = sh2 == null ? Shape.ANY : sh2;
            this.locale = l;
            this._timezone = tz;
            this.timezoneStr = tzStr;
        }

        public Value withPattern(String p) {
            return new Value(p, this.shape, this.locale, this.timezoneStr, this._timezone);
        }

        public Value withShape(Shape s) {
            return new Value(this.pattern, s, this.locale, this.timezoneStr, this._timezone);
        }

        public Value withLocale(Locale l) {
            return new Value(this.pattern, this.shape, l, this.timezoneStr, this._timezone);
        }

        public Value withTimeZone(TimeZone tz) {
            return new Value(this.pattern, this.shape, this.locale, null, tz);
        }

        public String getPattern() {
            return this.pattern;
        }

        public Shape getShape() {
            return this.shape;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String timeZoneAsString() {
            if (this._timezone != null) {
                return this._timezone.getID();
            }
            return this.timezoneStr;
        }

        public TimeZone getTimeZone() {
            TimeZone tz = this._timezone;
            if (tz == null) {
                if (this.timezoneStr == null) {
                    return null;
                }
                this._timezone = tz = TimeZone.getTimeZone(this.timezoneStr);
            }
            return tz;
        }

        public boolean hasShape() {
            return this.shape != Shape.ANY;
        }

        public boolean hasPattern() {
            return this.pattern != null && this.pattern.length() > 0;
        }

        public boolean hasLocale() {
            return this.locale != null;
        }

        public boolean hasTimeZone() {
            return this._timezone != null || this.timezoneStr != null && !this.timezoneStr.isEmpty();
        }
    }

    public static enum Shape {
        ANY,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN;


        public boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }

        public boolean isStructured() {
            return this == OBJECT || this == ARRAY;
        }
    }
}

