/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.swingui.ConnectionComboBoxModel;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class Olap4jConnectionPanel
implements DataEntryPanel {
    private final Olap4jDataSource olapDataSource;
    private JPanel panel;
    private final JTextField nameField = new JTextField();
    private JTextField schemaFileField;
    private JComboBox dataSourceBox;
    private JRadioButton xmlaType;
    private JRadioButton inProcessType;
    private JTextField xmlaUriField;

    public Olap4jConnectionPanel(Olap4jDataSource olapDataSource, DataSourceCollection<JDBCDataSource> dsCollection) {
        this.olapDataSource = olapDataSource;
        this.panel = new JPanel((LayoutManager)new MigLayout("", "[][][grow][]", ""));
        this.nameField.setText(olapDataSource.getName());
        this.panel.add(new JLabel(Messages.getString("SPDataSourcePanel.connectionNameLabel")));
        this.panel.add((Component)this.nameField, "grow, span 3, wrap, gapbottom unrel");
        ButtonGroup connectionTypeGroup = new ButtonGroup();
        this.inProcessType = new JRadioButton("In-process Mondrian Server");
        connectionTypeGroup.add(this.inProcessType);
        this.panel.add((Component)this.inProcessType, "span 2,wrap");
        this.panel.add((Component)new JLabel("Database Connection"), "span 2, gapbefore 25px");
        this.dataSourceBox = new JComboBox(new ConnectionComboBoxModel(dsCollection));
        if (olapDataSource.getDataSource() != null) {
            this.dataSourceBox.setSelectedItem(olapDataSource.getDataSource());
        }
        this.panel.add((Component)this.dataSourceBox, "grow,wrap, wmax 500");
        this.panel.add((Component)new JLabel("Mondrian Schema"), "span 2, gapbefore 25px");
        this.schemaFileField = new JTextField();
        URI initialSchemaURI = olapDataSource.getMondrianSchema();
        if (initialSchemaURI != null && initialSchemaURI.getScheme() != null && initialSchemaURI.getScheme().equals("file")) {
            this.schemaFileField.setText(initialSchemaURI.getSchemeSpecificPart());
        }
        this.panel.add((Component)this.schemaFileField, "growx, wmax 500");
        JButton fileChooserButton = new JButton("...");
        this.panel.add((Component)fileChooserButton, "wrap paragraph");
        fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(Olap4jConnectionPanel.this.schemaFileField.getText());
                fc.setFileFilter(SPSUtils.XML_FILE_FILTER);
                int choice = fc.showOpenDialog(Olap4jConnectionPanel.this.panel);
                if (choice == 0) {
                    Olap4jConnectionPanel.this.schemaFileField.setText(fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.xmlaType = new JRadioButton("Remote XML/A Server");
        connectionTypeGroup.add(this.xmlaType);
        this.panel.add((Component)this.xmlaType, "span 2,wrap");
        this.panel.add((Component)new JLabel("XML/A Server URL"), "span 2, gapbefore 25px");
        URI xmlaServerURI = olapDataSource.getXmlaServer();
        this.xmlaUriField = new JTextField(xmlaServerURI == null ? "" : xmlaServerURI.toString());
        this.panel.add((Component)this.xmlaUriField, "growx, wmax 500");
        Olap4jDataSource.Type type = olapDataSource.getType();
        if (type == null || type == Olap4jDataSource.Type.IN_PROCESS) {
            this.inProcessType.setSelected(true);
        } else if (type == Olap4jDataSource.Type.XMLA) {
            this.xmlaType.setSelected(true);
        } else {
            throw new IllegalStateException("Unknown olap4j connection type: " + (Object)((Object)type));
        }
    }

    @Override
    public boolean applyChanges() {
        if (this.nameField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.panel, Messages.getString("SPDataSourcePanel.blankNameNotAllowed"));
            return false;
        }
        this.olapDataSource.setName(this.nameField.getText().trim());
        if (this.inProcessType.isSelected()) {
            this.olapDataSource.setType(Olap4jDataSource.Type.IN_PROCESS);
            this.olapDataSource.setDataSource((JDBCDataSource)this.dataSourceBox.getSelectedItem());
            this.olapDataSource.setMondrianSchema(new File(this.schemaFileField.getText()).toURI());
        } else if (this.xmlaType.isSelected()) {
            this.olapDataSource.setType(Olap4jDataSource.Type.XMLA);
            try {
                this.olapDataSource.setXmlaServer(new URI(this.xmlaUriField.getText()).toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(this.panel, "XML/A Server URI is not valid.");
                return false;
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(this.panel, "XML/A Server URI is not valid.");
                return false;
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this.panel, "XML/A Server URI is not valid.");
                return false;
            }
        } else {
            throw new IllegalStateException("Someone added a new connection type but forgot to put in the code for storing it");
        }
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }
}

