/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.DefaultValueGenerator;
import org.zaproxy.zap.model.ValueGenerator;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String METHOD_POST = "POST";
    private URI uri;
    private String url;
    private Map<String, String> envAttributes = new HashMap<String, String>();
    private final SpiderParam param;
    private final ValueGenerator valueGenerator;

    public SpiderHtmlFormParser(SpiderParam param) {
        this(param, new DefaultValueGenerator());
    }

    public SpiderHtmlFormParser(SpiderParam param, ValueGenerator valueGenerator) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter param must not be null.");
        }
        if (valueGenerator == null) {
            throw new IllegalArgumentException("Parameter valueGenerator must not be null.");
        }
        this.param = param;
        this.valueGenerator = valueGenerator;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        log.debug((Object)"Parsing an HTML message for forms...");
        if (!this.param.isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)message.getResponseBody().toString());
        }
        String baseURL = message.getRequestHeader().getURI().toString();
        this.uri = message.getRequestHeader().getURI();
        Element base = source.getFirstElement("base");
        if (base != null) {
            String href;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + base.getDebugInfo()));
            }
            if ((href = base.getAttributeValue("href")) != null && !href.isEmpty()) {
                baseURL = URLCanonicalizer.getCanonicalURL(href, baseURL);
            }
        }
        List forms = source.getAllElements("form");
        for (Element form : forms) {
            this.envAttributes.clear();
            for (Attribute att : form.getAttributes()) {
                this.envAttributes.put(att.getKey(), att.getValue());
            }
            String method = form.getAttributeValue("method");
            String action = form.getAttributeValue("action");
            log.debug((Object)("Found new form with method: '" + method + "' and action: " + action));
            if (action == null) {
                log.debug((Object)("No form 'action' defined. Using base URL: " + baseURL));
                action = baseURL;
            }
            if (!this.param.isPostForm() && method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                log.debug((Object)"Skipping form with POST method because of user settings.");
                continue;
            }
            if (action.contains("#")) {
                int fs = action.lastIndexOf("#");
                action = action.substring(0, fs);
            }
            this.url = URLCanonicalizer.getCanonicalURL(action, baseURL);
            FormData formData = this.prepareFormDataSet(source, form);
            if (method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                String fullURL = URLCanonicalizer.getCanonicalURL(action, baseURL);
                if (fullURL == null) {
                    return false;
                }
                log.debug((Object)("Canonical URL constructed using '" + action + "': " + fullURL));
                for (String submitData : formData) {
                    this.notifyPostResourceFound(message, depth, fullURL, submitData);
                }
                continue;
            }
            if (action.contains("?")) {
                if (action.endsWith("?")) {
                    this.processGetForm(message, depth, action, baseURL, formData);
                    continue;
                }
                this.processGetForm(message, depth, action + "&", baseURL, formData);
                continue;
            }
            this.processGetForm(message, depth, action + "?", baseURL, formData);
        }
        return false;
    }

    private void processGetForm(HttpMessage message, int depth, String action, String baseURL, FormData formData) {
        for (String submitData : formData) {
            log.debug((Object)("Submitting form with GET method and query with form parameters: " + submitData));
            this.processURL(message, depth, action + submitData, baseURL);
        }
    }

    private FormData prepareFormDataSet(Source source, Element form) {
        LinkedList<FormDataField> formDataFields = new LinkedList<FormDataField>();
        for (FormField field : SpiderHtmlFormParser.getFormFields(source, form)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New form field: " + field.getDebugInfo()));
            }
            for (String value : this.getDefaultTextValue(field)) {
                formDataFields.add(new FormDataField(field.getName(), value, field.getFormControl().getFormControlType().isSubmit()));
            }
        }
        return new FormData(formDataFields);
    }

    private static FormFields getFormFields(Source source, Element form) {
        TreeSet<FormControl> formControls = new TreeSet<FormControl>();
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "input");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "textarea");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "select");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "button");
        String formId = form.getAttributeValue("id");
        if (formId != null && !formId.isEmpty()) {
            SpiderHtmlFormParser.addAll(formControls, source.getAllElements("form", formId, true));
        }
        Iterator it = formControls.iterator();
        while (it.hasNext()) {
            FormControl formControl = (FormControl)it.next();
            String targetForm = (String)formControl.getAttributesMap().get("form");
            if (targetForm == null || targetForm.equals(formId)) continue;
            it.remove();
        }
        return new FormFields(formControls);
    }

    private static void addAll(SortedSet<FormControl> formControls, Segment segment, String tagName) {
        SpiderHtmlFormParser.addAll(formControls, segment.getAllElements(tagName));
    }

    private static void addAll(SortedSet<FormControl> formControls, List<Element> elements) {
        for (Element element : elements) {
            FormControl formControl = element.getFormControl();
            if (formControl == null) continue;
            formControls.add(formControl);
        }
    }

    private List<String> getDefaultTextValue(FormField field) {
        String fieldId = field.getName();
        HashMap<String, String> fieldAttributes = new HashMap<String, String>();
        ArrayList<String> definedValues = new ArrayList<String>();
        fieldAttributes.putAll(field.getFormControl().getAttributesMap());
        fieldAttributes.put("Control Type", field.getFormControl().getFormControlType().name());
        if (field.getFormControl().getFormControlType().isSubmit()) {
            ArrayList<String> submitFields = new ArrayList<String>();
            for (String value : field.getPredefinedValues()) {
                String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, value, definedValues, this.envAttributes, fieldAttributes);
                submitFields.add(finalValue);
            }
            return submitFields;
        }
        ArrayList<String> values = field.getValues();
        String defaultValue = null;
        if (field.getFormControl().getAttributesMap().containsKey("value")) {
            defaultValue = (String)field.getFormControl().getAttributesMap().get("value");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Existing values: " + values));
        }
        if (values.isEmpty() || values.size() == 1 && ((String)values.get(0)).isEmpty()) {
            Collection predefValues = field.getPredefinedValues();
            if (!predefValues.isEmpty()) {
                definedValues.addAll(predefValues);
                if (defaultValue == null) {
                    Iterator iterator = predefValues.iterator();
                    defaultValue = (String)iterator.next();
                    if (iterator.hasNext()) {
                        defaultValue = (String)iterator.next();
                    }
                }
            }
            defaultValue = defaultValue == null ? DEFAULT_EMPTY_VALUE : defaultValue;
        } else if (defaultValue == null) {
            defaultValue = (String)values.get(0);
        }
        String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, defaultValue, definedValues, this.envAttributes, fieldAttributes);
        log.debug((Object)("Generated: " + finalValue + "For field " + field.getName()));
        values = new ArrayList<String>(1);
        values.add(finalValue);
        return values;
    }

    private void notifyPostResourceFound(HttpMessage message, int depth, String url, String requestBody) {
        log.debug((Object)("Submitting form with POST method and message body with form parameters (normal encoding): " + requestBody));
        this.notifyListenersPostResourceFound(message, depth + 1, url, requestBody);
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isHtml();
    }

    private static class FormDataField {
        private String name;
        private String value;
        private boolean submit;

        public FormDataField(String name, String value, boolean submit) {
            try {
                this.name = URLEncoder.encode(name, SpiderHtmlFormParser.ENCODING_TYPE);
                this.value = URLEncoder.encode(value, SpiderHtmlFormParser.ENCODING_TYPE);
                this.submit = submit;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSubmit() {
            return this.submit;
        }
    }

    private static class FormData
    implements Iterable<String> {
        private final List<FormDataField> fields;
        private final List<FormDataField> submitFields;

        private FormData(List<FormDataField> fields) {
            this.fields = fields;
            this.submitFields = new ArrayList<FormDataField>();
            this.fields.forEach(f -> {
                if (f.isSubmit()) {
                    this.submitFields.add((FormDataField)f);
                }
            });
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorImpl();
        }

        private class IteratorImpl
        implements Iterator<String> {
            private boolean started;
            private List<FormDataField> consumedSubmitFields = new ArrayList<FormDataField>();

            private IteratorImpl() {
            }

            @Override
            public boolean hasNext() {
                return !this.started || this.consumedSubmitFields.size() < FormData.this.submitFields.size();
            }

            @Override
            public String next() {
                if (!this.started) {
                    this.started = true;
                } else if (this.consumedSubmitFields.size() >= FormData.this.submitFields.size()) {
                    throw new NoSuchElementException("No more form data to generate.");
                }
                boolean submitted = false;
                StringBuilder formData = new StringBuilder(100);
                for (FormDataField field : FormData.this.fields) {
                    if (field.isSubmit()) {
                        if (submitted || this.consumedSubmitFields.contains(field)) continue;
                        submitted = true;
                        this.consumedSubmitFields.add(field);
                    }
                    if (formData.length() > 0) {
                        formData.append('&');
                    }
                    formData.append(field.getName());
                    formData.append('=');
                    formData.append(field.getValue());
                }
                return formData.toString();
            }
        }
    }
}

