/*
 * Decompiled with CFR 0.152.
 */
package values;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.ImageIcon;
import values.GameType;
import values.Orientation;
import values.Settings;

public class BrickColor {
    private Map<Orientation, ImageIcon> colors;
    private int index = -1;
    private static final int GRAY_COLOR = 0x828282;
    private static final int[] RGB_COLORS = new int[]{255, 0xEE0000, 16759296, 16773926, 47872, 61166, 14942463, 16752336, 0xECECEC, 0xB07B00, 0x828282};
    public static final int SPECIAL_TOTAL = 5;
    public static final int SPECIAL_UNIVERSAL = 10;
    public static final int SPECIAL_BOMB = 11;
    public static final int SPECIAL_LIGHTNING = 12;
    public static final int SPECIAL_ARROWS = 13;
    public static final int SPECIAL_COLORS = 14;
    private static final ImageIcon BLACK_IMAGE = new ImageIcon();
    private static final ImageIcon GRAY_IMAGE = new ImageIcon();
    public static final BrickColor BLACK = new BrickColor(){

        @Override
        public ImageIcon getColor(Orientation orientation) {
            return BLACK_IMAGE;
        }

        @Override
        public ImageIcon getColor() {
            return BLACK_IMAGE;
        }
    };
    public static final BrickColor GRAY = new BrickColor(){

        @Override
        public ImageIcon getColor(Orientation orientation) {
            return GRAY_IMAGE;
        }

        @Override
        public ImageIcon getColor() {
            return GRAY_IMAGE;
        }
    };
    private static final List<Map<Orientation, ImageIcon>> COLORS = new ArrayList<Map<Orientation, ImageIcon>>();
    private static Random generator = new Random(System.currentTimeMillis());

    public static void init(Integer n) {
        BufferedImage bufferedImage;
        ImageIcon imageIcon;
        HashMap<Orientation, ImageIcon> hashMap;
        int n2;
        COLORS.clear();
        ClassLoader classLoader = null;
        try {
            classLoader = Class.forName("values.BrickColor").getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Fatal: can't load resources from jar");
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        ImageIcon imageIcon2 = new ImageIcon(classLoader.getResource("images/mask" + n + ".png"));
        ImageIcon imageIcon3 = new ImageIcon(classLoader.getResource("images/d_up" + n + ".png"));
        ImageIcon imageIcon4 = new ImageIcon(classLoader.getResource("images/d_down" + n + ".png"));
        ImageIcon imageIcon5 = new ImageIcon(classLoader.getResource("images/d_left" + n + ".png"));
        ImageIcon imageIcon6 = new ImageIcon(classLoader.getResource("images/d_right" + n + ".png"));
        BLACK_IMAGE.setImage(new ImageIcon(classLoader.getResource("images/black.png")).getImage());
        GRAY_IMAGE.setImage(new ImageIcon(BrickColor.createBasicImage(10, imageIcon2)).getImage());
        int n3 = Settings.getBrickSize();
        for (n2 = 0; n2 < 10; ++n2) {
            hashMap = new HashMap<Orientation, ImageIcon>();
            imageIcon = new ImageIcon(BrickColor.createBasicImage(n2, imageIcon2));
            hashMap.put(Orientation.NONE, imageIcon);
            bufferedImage = BrickColor.createBasicImage(n2, imageIcon2);
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon3.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.TOP, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.createBasicImage(n2, imageIcon2);
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon6.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.RIGHT, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.createBasicImage(n2, imageIcon2);
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon4.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.BOTTOM, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.createBasicImage(n2, imageIcon2);
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon5.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.LEFT, new ImageIcon(bufferedImage));
            COLORS.add(hashMap);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            hashMap = new HashMap();
            imageIcon = new ImageIcon(classLoader.getResource("images/" + n2 + ".png"));
            hashMap.put(Orientation.NONE, imageIcon);
            bufferedImage = BrickColor.toBufferedImage(imageIcon.getImage());
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon3.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.TOP, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.toBufferedImage(imageIcon.getImage());
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon6.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.RIGHT, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.toBufferedImage(imageIcon.getImage());
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon4.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.BOTTOM, new ImageIcon(bufferedImage));
            bufferedImage = BrickColor.toBufferedImage(imageIcon.getImage());
            bufferedImage.getGraphics().drawImage(Settings.getScaledImage(imageIcon5.getImage(), n3, n3), 0, 0, null);
            hashMap.put(Orientation.LEFT, new ImageIcon(bufferedImage));
            COLORS.add(hashMap);
        }
    }

    private static BufferedImage createBasicImage(int n, ImageIcon imageIcon) {
        int n2 = Settings.getBrickSize();
        int n3 = Settings.getBrickSize();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(RGB_COLORS[n]));
        graphics.fillRect(0, 0, n2, n3);
        graphics.drawImage(Settings.getScaledImage(imageIcon.getImage(), n2, n3), 0, 0, null);
        return bufferedImage;
    }

    private BrickColor() {
    }

    public BrickColor(int n) {
        this.colors = COLORS.get(n);
        this.index = n;
    }

    public BrickColor(BrickColor brickColor, int n) {
        int n2 = brickColor.getIndex() + 1;
        if (n2 >= n) {
            n2 = 0;
        }
        this.colors = COLORS.get(n2);
        this.index = n2;
    }

    public ImageIcon getColor(Orientation orientation) {
        return this.colors.get((Object)orientation);
    }

    public ImageIcon getColor() {
        return this.colors.get((Object)Orientation.NONE);
    }

    public int getIndex() {
        return this.index;
    }

    public void reInit() {
        if (this.index >= 0) {
            this.colors = COLORS.get(this.index);
        }
    }

    public static BrickColor generate(int n, GameType gameType) {
        if ((gameType.isArcade().booleanValue() || gameType.isPuzzle().booleanValue()) && generator.nextInt(15) == 7) {
            return new BrickColor(10 + generator.nextInt(5));
        }
        return new BrickColor(generator.nextInt(n));
    }

    public boolean compareTo(BrickColor brickColor) {
        return this.getColor().equals(brickColor.getColor());
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = BrickColor.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

