/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodUtil {
    @NotNull
    public static PsiCodeBlock createCodeBlockFromText(@NotNull String blockText, @NotNull PsiElement psiElement) {
        if (blockText == null) {
            PsiMethodUtil.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            PsiMethodUtil.$$$reportNull$$$0(1);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiElement.getProject());
        PsiCodeBlock psiCodeBlock = elementFactory.createCodeBlockFromText("{" + blockText + "}", psiElement);
        if (psiCodeBlock == null) {
            PsiMethodUtil.$$$reportNull$$$0(2);
        }
        return psiCodeBlock;
    }

    public static boolean hasMethodByName(@NotNull Collection<PsiMethod> classMethods, @NotNull String methodName, int paramCount) {
        if (classMethods == null) {
            PsiMethodUtil.$$$reportNull$$$0(3);
        }
        if (methodName == null) {
            PsiMethodUtil.$$$reportNull$$$0(4);
        }
        return classMethods.stream().filter(m -> methodName.equals(m.getName())).anyMatch(m -> PsiMethodUtil.acceptedParameterCount(m, paramCount));
    }

    public static boolean hasSimilarMethod(@NotNull Collection<PsiMethod> classMethods, @NotNull String methodName, int paramCount) {
        if (classMethods == null) {
            PsiMethodUtil.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            PsiMethodUtil.$$$reportNull$$$0(6);
        }
        return classMethods.stream().filter(m -> methodName.equalsIgnoreCase(m.getName())).anyMatch(m -> PsiMethodUtil.acceptedParameterCount(m, paramCount));
    }

    private static boolean acceptedParameterCount(@NotNull PsiMethod classMethod, int methodArgCount) {
        if (classMethod == null) {
            PsiMethodUtil.$$$reportNull$$$0(7);
        }
        int minArgs = classMethod.getParameterList().getParametersCount();
        int maxArgs = minArgs--;
        if (classMethod.isVarArgs()) {
            maxArgs = Integer.MAX_VALUE;
        }
        return methodArgCount >= minArgs && methodArgCount <= maxArgs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiMethodUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMethods";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiMethodUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockFromText";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMethodByName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSimilarMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptedParameterCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

