/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokProcessorUtil {
    @NonNls
    private static final String ACCESS_LEVEL_PRIVATE = "PRIVATE";
    @NonNls
    private static final String ACCESS_LEVEL_PROTECTED = "PROTECTED";
    @NonNls
    private static final String ACCESS_LEVEL_PACKAGE_LOCAL = "PACKAGE";
    @NonNls
    private static final String ACCESS_LEVEL_PUBLIC = "PUBLIC";
    private static final Map<Integer, String> ACCESS_LEVEL_MAP = new HashMap<Integer, String>(){
        {
            this.put(4, LombokProcessorUtil.ACCESS_LEVEL_PUBLIC);
            this.put(2, LombokProcessorUtil.ACCESS_LEVEL_PACKAGE_LOCAL);
            this.put(3, LombokProcessorUtil.ACCESS_LEVEL_PROTECTED);
            this.put(1, LombokProcessorUtil.ACCESS_LEVEL_PRIVATE);
        }
    };
    private static final Map<String, String> VALUE_ACCESS_LEVEL_MAP = new HashMap<String, String>(){
        {
            this.put(LombokProcessorUtil.ACCESS_LEVEL_PUBLIC, "public");
            this.put(LombokProcessorUtil.ACCESS_LEVEL_PACKAGE_LOCAL, "packageLocal");
            this.put(LombokProcessorUtil.ACCESS_LEVEL_PROTECTED, "protected");
            this.put(LombokProcessorUtil.ACCESS_LEVEL_PRIVATE, "private");
        }
    };

    @Nullable
    @PsiModifier.ModifierConstant
    public static String getMethodModifier(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(0);
        }
        return LombokProcessorUtil.getLevelVisibility(psiAnnotation, "value");
    }

    @Nullable
    @PsiModifier.ModifierConstant
    public static String getAccessVisibility(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(1);
        }
        return LombokProcessorUtil.getLevelVisibility(psiAnnotation, "access");
    }

    @Nullable
    @PsiModifier.ModifierConstant
    public static String getLevelVisibility(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(2);
        }
        return LombokProcessorUtil.getLevelVisibility(psiAnnotation, "level");
    }

    @Nullable
    @PsiModifier.ModifierConstant
    private static String getLevelVisibility(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter) {
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(3);
        }
        if (parameter == null) {
            LombokProcessorUtil.$$$reportNull$$$0(4);
        }
        return LombokProcessorUtil.convertAccessLevelToJavaModifier(PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, parameter));
    }

    @Nullable
    public static String getAccessLevel(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter) {
        String annotationValue;
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(5);
        }
        if (parameter == null) {
            LombokProcessorUtil.$$$reportNull$$$0(6);
        }
        return (annotationValue = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, parameter)) == null ? null : VALUE_ACCESS_LEVEL_MAP.get(annotationValue);
    }

    public static boolean isLevelVisible(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(7);
        }
        return null != LombokProcessorUtil.getLevelVisibility(psiAnnotation);
    }

    public static Collection<String> getOnX(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameterName) {
        PsiAnnotationMemberValue onXValue;
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(8);
        }
        if (parameterName == null) {
            LombokProcessorUtil.$$$reportNull$$$0(9);
        }
        if (!((onXValue = psiAnnotation.findAttributeValue(parameterName)) instanceof PsiAnnotation)) {
            return Collections.emptyList();
        }
        Collection<PsiAnnotation> annotations = PsiAnnotationUtil.getAnnotationValues((PsiAnnotation)onXValue, "value", PsiAnnotation.class);
        ArrayList<String> annotationStrings = new ArrayList<String>();
        for (PsiAnnotation annotation : annotations) {
            PsiAnnotationParameterList params = annotation.getParameterList();
            annotationStrings.add(PsiAnnotationSearchUtil.getSimpleNameOf(annotation) + params.getText());
        }
        return annotationStrings;
    }

    @Nullable
    @PsiModifier.ModifierConstant
    private static String convertAccessLevelToJavaModifier(String value) {
        if (null == value || value.isEmpty()) {
            return "public";
        }
        if (ACCESS_LEVEL_PUBLIC.equals(value)) {
            return "public";
        }
        if ("MODULE".equals(value)) {
            return "packageLocal";
        }
        if (ACCESS_LEVEL_PROTECTED.equals(value)) {
            return "protected";
        }
        if (ACCESS_LEVEL_PACKAGE_LOCAL.equals(value)) {
            return "packageLocal";
        }
        if (ACCESS_LEVEL_PRIVATE.equals(value)) {
            return "private";
        }
        if ("NONE".equals(value)) {
            return null;
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation createAnnotationWithAccessLevel(@NotNull PsiModifierListOwner psiModifierListOwner, String annotationClassName) {
        int accessLevelCode;
        String accessLevel;
        if (psiModifierListOwner == null) {
            LombokProcessorUtil.$$$reportNull$$$0(10);
        }
        Object value = "";
        PsiModifierList modifierList = psiModifierListOwner.getModifierList();
        if (null != modifierList && null != (accessLevel = ACCESS_LEVEL_MAP.get(accessLevelCode = PsiUtil.getAccessLevel((PsiModifierList)modifierList))) && !ACCESS_LEVEL_PUBLIC.equals(accessLevel)) {
            value = "lombok.AccessLevel." + accessLevel;
        }
        PsiAnnotation psiAnnotation = PsiAnnotationUtil.createPsiAnnotation(psiModifierListOwner, (String)value, annotationClassName);
        if (psiAnnotation == null) {
            LombokProcessorUtil.$$$reportNull$$$0(11);
        }
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/LombokProcessorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/LombokProcessorUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationWithAccessLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodModifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAccessVisibility";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLevelVisibility";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLevelVisible";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOnX";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationWithAccessLevel";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

