/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "jvmName", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddJvmNameAnnotationFix
extends KotlinQuickFixAction<KtElement> {
    private final String jvmName;
    private static final FqName JVM_NAME_FQ_NAME;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        String string;
        if (this.getElement() instanceof KtAnnotationEntry) {
            string = KotlinBundle.message("fix.change.jvm.name", new Object[0]);
        } else {
            Object[] objectArray = new Object[1];
            Name name2 = JVM_NAME_FQ_NAME.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"JVM_NAME_FQ_NAME.shortName()");
            objectArray[0] = name2;
            string = KotlinBundle.message("fix.add.annotation.text.self", objectArray);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        block4: {
            KtElement ktElement;
            KtElement element3;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                KtElement ktElement2 = (KtElement)this.getElement();
                if (ktElement2 == null) {
                    return;
                }
                ktElement = element3 = ktElement2;
                if (!(ktElement instanceof KtAnnotationEntry)) break block3;
                KtValueArgumentList argList = ((KtAnnotationEntry)element3).getValueArgumentList();
                KtValueArgumentList newArgList = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null).createCallArguments("(\"" + this.jvmName + "\")");
                if (argList != null) {
                    argList.replace((PsiElement)newArgList);
                } else {
                    element3.addAfter((PsiElement)newArgList, ((KtAnnotationEntry)element3).getLastChild());
                }
                break block4;
            }
            if (!(ktElement instanceof KtFunction)) break block4;
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)element3), (FqName)JVM_NAME_FQ_NAME, (String)('\"' + this.jvmName + '\"'), null, null, (int)12, null);
        }
    }

    public AddJvmNameAnnotationFix(@NotNull KtElement element3, @NotNull String jvmName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        super((PsiElement)element3);
        this.jvmName = jvmName;
    }

    static {
        Companion = new Companion(null);
        JVM_NAME_FQ_NAME = new FqName("kotlin.jvm.JvmName");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "JVM_NAME_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "typeElements", "", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtNamedFunction)) {
                psiElement2 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            String string = function2.getName();
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"function.name ?: return null");
            String functionName = string;
            PsiElement psiElement3 = function2.getParent();
            if (psiElement3 == null) {
                return null;
            }
            PsiElement containingDeclaration2 = psiElement3;
            NewDeclarationNameValidator nameValidator2 = new NewDeclarationNameValidator(containingDeclaration2, (PsiElement)function2, NewDeclarationNameValidator.Target.FUNCTIONS_AND_CLASSES, null, 8, null);
            Object object = function2.getReceiverTypeReference();
            if (object == null || (object = this.typeElements((KtTypeReference)object)) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"", null, null, (int)0, null, (Function1)createAction.receiverTypeElements.1.INSTANCE, (int)30, null)) == null) {
                object = "";
            }
            Object receiverTypeElements2 = object;
            String jvmName = KotlinNameSuggester.INSTANCE.suggestNameByName(functionName + (String)receiverTypeElements2, (Function1)nameValidator2);
            KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)function2), (FqName)JVM_NAME_FQ_NAME);
            return new AddJvmNameAnnotationFix((KtElement)(ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)function2), jvmName);
        }

        private final List<KtTypeElement> typeElements(KtTypeReference $this$typeElements) {
            boolean bl = false;
            List typeElements2 = new ArrayList();
            Function1<KtTypeReference, Unit> $fun$collect$1 = new Function1<KtTypeReference, Unit>(typeElements2){
                final /* synthetic */ List $typeElements;

                public final void invoke(@NotNull KtTypeReference typeReference) {
                    Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
                    KtTypeElement ktTypeElement = typeReference.getTypeElement();
                    if (ktTypeElement == null) {
                        return;
                    }
                    KtTypeElement typeElement = ktTypeElement;
                    List list = typeElement.getTypeArgumentsAsTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"typeElement.typeArgumentsAsTypes");
                    List typeArguments = list;
                    if (typeArguments.isEmpty()) {
                        this.$typeElements.add(typeElement);
                    } else {
                        Iterable $this$forEach$iv = typeArguments;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            KtTypeReference it = (KtTypeReference)element$iv;
                            boolean bl = false;
                            KtTypeReference ktTypeReference = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"it");
                            this.invoke(ktTypeReference);
                        }
                    }
                }
                {
                    this.$typeElements = list;
                    super(1);
                }
            };
            Object object = $this$typeElements.getTypeElement();
            if (object != null && (object = object.getTypeArgumentsAsTypes()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl2 = false;
                    KtTypeReference ktTypeReference = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"it");
                    $fun$collect$1.invoke(ktTypeReference);
                }
            }
            return typeElements2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

