/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.BaseKotlinImportLayoutPanelKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0004J\b\u0010\u0013\u001a\u00020\u000eH\u0004J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0004J\b\u0010\u0017\u001a\u00020\u000eH\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/BaseKotlinImportLayoutPanel;", "Ljavax/swing/JPanel;", "title", "", "(Ljava/lang/String;)V", "layoutTable", "Lcom/intellij/ui/table/JBTable;", "getLayoutTable", "()Lcom/intellij/ui/table/JBTable;", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "getPackageTable", "()Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "addPackage", "", "fixColumnWidthToHeader", "columnIndex", "", "movePackageDown", "movePackageUp", "refreshTableModel", "row", "removePackage", "resizeColumns", "kotlin.idea"})
public class BaseKotlinImportLayoutPanel
extends JPanel {
    @NotNull
    private final KotlinPackageEntryTable packageTable;
    @NotNull
    private final JBTable layoutTable;

    @NotNull
    public final KotlinPackageEntryTable getPackageTable() {
        return this.packageTable;
    }

    @NotNull
    public final JBTable getLayoutTable() {
        return this.layoutTable;
    }

    protected final void addPackage() {
        int row = this.layoutTable.getSelectedRow() + 1;
        if (row < 0) {
            row = this.packageTable.getEntryCount();
        }
        KotlinPackageEntry entry = new KotlinPackageEntry("", true);
        this.packageTable.insertEntryAt(entry, row);
        this.refreshTableModel(row);
    }

    protected final void removePackage() {
        int row = this.layoutTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        if (entry.isSpecial()) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        this.packageTable.removeEntryAt(row);
        TableModel tableModel = this.layoutTable.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        AbstractTableModel model2 = (AbstractTableModel)tableModel;
        model2.fireTableRowsDeleted(row, row);
        if (row >= this.packageTable.getEntryCount()) {
            --row;
        }
        if (row >= 0) {
            this.layoutTable.setRowSelectionInterval(row, row);
        }
    }

    protected final void movePackageUp() {
        int row = this.layoutTable.getSelectedRow();
        if (row < 1) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        KotlinPackageEntry previousEntry = this.packageTable.getEntryAt(row - 1);
        this.packageTable.setEntryAt(entry, row - 1);
        this.packageTable.setEntryAt(previousEntry, row);
        TableModel tableModel = this.layoutTable.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        AbstractTableModel model2 = (AbstractTableModel)tableModel;
        model2.fireTableRowsUpdated(row - 1, row);
        this.layoutTable.setRowSelectionInterval(row - 1, row - 1);
    }

    protected final void movePackageDown() {
        int row = this.layoutTable.getSelectedRow();
        if (row >= this.packageTable.getEntryCount() - 1) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        KotlinPackageEntry nextEntry = this.packageTable.getEntryAt(row + 1);
        this.packageTable.setEntryAt(entry, row + 1);
        this.packageTable.setEntryAt(nextEntry, row);
        TableModel tableModel = this.layoutTable.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        AbstractTableModel model2 = (AbstractTableModel)tableModel;
        model2.fireTableRowsUpdated(row, row + 1);
        this.layoutTable.setRowSelectionInterval(row + 1, row + 1);
    }

    private final void refreshTableModel(int row) {
        TableModel tableModel = this.layoutTable.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        AbstractTableModel model2 = (AbstractTableModel)tableModel;
        model2.fireTableRowsInserted(row, row);
        this.layoutTable.setRowSelectionInterval(row, row);
        TableUtil.editCellAt((JTable)((JTable)this.layoutTable), (int)row, (int)0);
        Component editorComp = this.layoutTable.getEditorComponent();
        if (editorComp != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(editorComp){
                final /* synthetic */ Component $editorComp;

                public final void run() {
                    IdeFocusManager.getGlobalInstance().requestFocus(this.$editorComp, true);
                }
                {
                    this.$editorComp = component;
                }
            });
        }
    }

    protected final void resizeColumns() {
        ColoredTableCellRenderer packageRenderer2 = new ColoredTableCellRenderer(this){
            final /* synthetic */ BaseKotlinImportLayoutPanel this$0;

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                KotlinPackageEntry entry = this.this$0.getPackageTable().getEntryAt(row);
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors.KEYWORD");
                TextAttributes attributes = textAttributesKey.getDefaultAttributes();
                this.append("import", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                KotlinPackageEntry kotlinPackageEntry = entry;
                if (Intrinsics.areEqual((Object)kotlinPackageEntry, (Object)KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY)) {
                    this.append("all other imports", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else if (Intrinsics.areEqual((Object)kotlinPackageEntry, (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY)) {
                    this.append("all alias imports", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(entry.getPackageName() + ".*", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        TableColumnModel tableColumnModel = this.layoutTable.getColumnModel();
        boolean bl = false;
        boolean bl2 = false;
        TableColumnModel $this$apply = tableColumnModel;
        boolean bl3 = false;
        TableColumn tableColumn = $this$apply.getColumn(0);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"getColumn(0)");
        tableColumn.setCellRenderer((TableCellRenderer)packageRenderer2);
        TableColumn tableColumn2 = $this$apply.getColumn(1);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn2, (String)"getColumn(1)");
        tableColumn2.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.fixColumnWidthToHeader(1);
    }

    private final void fixColumnWidthToHeader(int columnIndex) {
        JBTable jBTable = this.layoutTable;
        boolean bl = false;
        boolean bl2 = false;
        JBTable $this$with = jBTable;
        boolean bl3 = false;
        TableColumn column = $this$with.getColumnModel().getColumn(columnIndex);
        JTableHeader jTableHeader = $this$with.getTableHeader();
        JTableHeader jTableHeader2 = $this$with.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader2, (String)"tableHeader");
        int width = 15 + jTableHeader.getFontMetrics(jTableHeader2.getFont()).stringWidth($this$with.getColumnName(columnIndex));
        TableColumn tableColumn = column;
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"column");
        tableColumn.setMinWidth(width);
        column.setMaxWidth(width);
    }

    public BaseKotlinImportLayoutPanel(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(new BorderLayout());
        this.packageTable = new KotlinPackageEntryTable();
        this.layoutTable = BaseKotlinImportLayoutPanelKt.createTableForPackageEntries(this.packageTable);
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)((Insets)JBUI.emptyInsets())));
    }
}

