/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0014JF\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterAfterUnmatchedBraceHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler;", "()V", "getRBraceOffset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isDeclarationInitializer", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class KotlinEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int caretOffset = ((Number)caretOffsetRef.get()).intValue() - 1;
        PsiElement element3 = file.findElementAt(caretOffset);
        PsiElement psiElement2 = element3;
        if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.LBRACE)) {
            EnterHandlerDelegate.Result result2 = super.preprocessEnter(file, editor2, caretOffsetRef, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result2;
        }
        if (!(element3 instanceof PsiWhiteSpace)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prevElement = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter((PsiFile)file, (int)caretOffset);
        if (prevElement != null) {
            ASTNode aSTNode = prevElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"prevElement.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.LBRACE)) {
                EnterHandlerDelegate.Result result3 = super.preprocessEnter(file, editor2, new Ref((Object)(PsiUtilsKt.getStartOffset((PsiElement)prevElement) + 1)), caretAdvance, dataContext, originalHandler);
                Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
                return result3;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor2, int caretOffset) {
        int n;
        Integer endOffset2;
        Integer n2;
        PsiElement parent2;
        PsiElement element3;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement2 = element3 = file.findElementAt(caretOffset - 1);
        Object object = parent2 = psiElement2 != null ? psiElement2.getParent() : null;
        if (parent2 instanceof KtFunctionLiteral) {
            KtCallExpression call;
            PsiElement $this$getStrictParentOfType$iv = parent2;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = call = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression != null && this.isDeclarationInitializer((KtExpression)ktCallExpression)) {
                Object object2;
                PsiElement psiElement3 = ((KtFunctionLiteral)parent2).getParent();
                if (!(psiElement3 instanceof KtLambdaExpression)) {
                    psiElement3 = null;
                }
                n2 = (object2 = (KtLambdaExpression)psiElement3) != null && (object2 = object2.getBodyExpression()) != null && (object2 = object2.getStatements()) != null && (object2 = (KtExpression)CollectionsKt.firstOrNull((List)object2)) != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)object2))) : null;
            } else {
                n2 = null;
            }
        } else if (parent2 instanceof KtWhenExpression) {
            if (this.isDeclarationInitializer((KtExpression)parent2)) {
                KtWhenCondition ktWhenCondition;
                List list = ((KtWhenExpression)parent2).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parent.entries");
                Object[] objectArray = (Object[])CollectionsKt.firstOrNull((List)list);
                if (!((objectArray != null && (objectArray = objectArray.getConditions()) != null ? (KtWhenCondition)ArraysKt.firstOrNull((Object[])objectArray) : (ktWhenCondition = null)) instanceof KtWhenConditionWithExpression)) {
                    ktWhenCondition = null;
                }
                KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)ktWhenCondition;
                n2 = ktWhenConditionWithExpression != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktWhenConditionWithExpression))) : null;
            } else {
                n2 = null;
            }
        } else {
            n2 = null;
        }
        Integer n3 = endOffset2 = n2;
        if (n3 != null) {
            n = n3;
            return n;
        }
        n = super.getRBraceOffset(file, editor2, caretOffset);
        return n;
    }

    private final boolean isDeclarationInitializer(KtExpression $this$isDeclarationInitializer) {
        PsiElement psiElement2 = $this$isDeclarationInitializer.getParent();
        if (!(psiElement2 instanceof KtDeclarationWithInitializer)) {
            psiElement2 = null;
        }
        KtDeclarationWithInitializer ktDeclarationWithInitializer = (KtDeclarationWithInitializer)psiElement2;
        return Intrinsics.areEqual((Object)(ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null), (Object)$this$isDeclarationInitializer);
    }
}

