/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.google.common.base.Stopwatch;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheImpl;
import com.intellij.workspaceModel.storage.EntityStorageSerializer;
import com.intellij.workspaceModel.storage.EntityTypesResolver;
import com.intellij.workspaceModel.storage.SerializationResult;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "cacheFile", "Ljava/nio/file/Path;", "saveAlarm", "Lcom/intellij/util/SingleAlarm;", "serializer", "Lcom/intellij/workspaceModel/storage/EntityStorageSerializer;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "dispose", "", "initCacheFile", "loadCache", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "saveCache", "storage", "Companion", "PluginAwareEntityTypesResolver", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class WorkspaceModelCacheImpl
implements Disposable {
    private final Path cacheFile;
    private final VirtualFileUrlManager virtualFileManager;
    private final EntityStorageSerializer serializer;
    private final SingleAlarm saveAlarm;
    private final Project project;
    private static final Logger LOG;
    private static final String DATA_DIR_NAME = "project-model-cache";
    @TestOnly
    @Nullable
    private static File testCacheFile;
    private static final AtomicBoolean cachesInvalidated;
    private static final File invalidateCachesMarkerFile;
    public static final Companion Companion;

    private final Path initCacheFile() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && testCacheFile != null) {
            Path testFile;
            File file2 = testCacheFile;
            Intrinsics.checkNotNull((Object)file2);
            Path path = testFile = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"testFile");
            if (!PathKt.exists((Path)path)) {
                String string = "Test cache file defined, but doesn't exist";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return testFile;
        }
        return PathKt.div((Path)ProjectUtil.getProjectDataPath((Project)this.project, (String)DATA_DIR_NAME), (String)"cache.data");
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final WorkspaceEntityStorage loadCache() {
        try {
            WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder;
            if (!PathKt.exists((Path)this.cacheFile)) {
                return null;
            }
            if (invalidateCachesMarkerFile.exists() && PathKt.lastModified((Path)this.cacheFile).toMillis() < invalidateCachesMarkerFile.lastModified()) {
                LOG.info("Skipping project model cache since '" + invalidateCachesMarkerFile + "' is present and newer than cache file '" + this.cacheFile + '\'');
                FileUtil.delete((Path)this.cacheFile);
                return null;
            }
            LOG.debug("Loading project model cache from " + this.cacheFile);
            Stopwatch stopWatch = Stopwatch.createStarted();
            Closeable closeable = PathKt.inputStream((Path)this.cacheFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                workspaceEntityStorageBuilder = this.serializer.deserializeCache(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            WorkspaceEntityStorageBuilder builder2 = workspaceEntityStorageBuilder;
            LOG.debug("Loaded project model cache from " + this.cacheFile + " in " + stopWatch.stop());
            return builder2;
        }
        catch (Throwable t) {
            LOG.warn("Could not deserialize project model cache from " + this.cacheFile, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCache(WorkspaceEntityStorage storage) {
        File file2 = FileUtil.createTempFile((File)this.cacheFile.getParent().toFile(), (String)"cache", (String)".tmp");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026oFile(), \"cache\", \".tmp\")");
        File tmpFile = file2;
        try {
            SerializationResult serializationResult;
            Object object = tmpFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                serializationResult = this.serializer.serializeCache(it, storage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            SerializationResult serializationResult2 = serializationResult;
            if (serializationResult2 instanceof SerializationResult.Fail) {
                LOG.warn("Workspace model cache was not serialized: " + ((SerializationResult.Fail)serializationResult2).getInfo());
            }
            try {
                Files.move(tmpFile.toPath(), this.cacheFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                LOG.warn((Throwable)e);
                Files.move(tmpFile.toPath(), this.cacheFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    public WorkspaceModelCacheImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.serializer = new EntityStorageSerializerImpl(PluginAwareEntityTypesResolver.INSTANCE, this.virtualFileManager);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.cacheFile = this.initCacheFile();
        LOG.debug("Project Model Cache at " + this.cacheFile);
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        workspaceModelTopics.subscribeImmediately(messageBusConnection, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LOG.debug("Schedule cache update");
                SingleAlarm.request$default(saveAlarm, false, 0, 3, null);
            }

            @Override
            public void beforeChanged(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        this.saveAlarm = SingleAlarmKt.pooledThreadSingleAlarm(1000, this, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceModelCacheImpl this$0;

            public final void invoke() {
                WorkspaceEntityStorage storage = WorkspaceModel.Companion.getInstance(WorkspaceModelCacheImpl.access$getProject$p(this.this$0)).getEntityStorage().getCurrent();
                if (!WorkspaceModelCacheImpl.access$getCachesInvalidated$cp().get()) {
                    WorkspaceModelCacheImpl.access$getLOG$cp().debug("Saving project model cache to " + WorkspaceModelCacheImpl.access$getCacheFile$p(this.this$0));
                    WorkspaceModelCacheImpl.access$saveCache(this.this$0, storage);
                }
                if (WorkspaceModelCacheImpl.access$getCachesInvalidated$cp().get()) {
                    FileUtil.delete((Path)WorkspaceModelCacheImpl.access$getCacheFile$p(this.this$0));
                }
            }
            {
                this.this$0 = workspaceModelCacheImpl;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelCacheImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        cachesInvalidated = new AtomicBoolean(false);
        invalidateCachesMarkerFile = new File(PathManagerEx.getAppSystemDir().resolve("projectModelCache").toFile(), ".invalidate");
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceModelCacheImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ Path access$getCacheFile$p(WorkspaceModelCacheImpl $this) {
        return $this.cacheFile;
    }

    public static final /* synthetic */ void access$saveCache(WorkspaceModelCacheImpl $this, WorkspaceEntityStorage storage) {
        $this.saveCache(storage);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$PluginAwareEntityTypesResolver;", "Lcom/intellij/workspaceModel/storage/EntityTypesResolver;", "()V", "getPluginId", "", "clazz", "Ljava/lang/Class;", "resolveClass", "name", "pluginId", "intellij.platform.ide.impl"})
    public static final class PluginAwareEntityTypesResolver
    implements EntityTypesResolver {
        public static final PluginAwareEntityTypesResolver INSTANCE;

        @Override
        @Nullable
        public String getPluginId(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            PluginId pluginId = PluginManager.getInstance().getPluginOrPlatformByClassName(clazz.getName());
            return pluginId != null ? pluginId.getIdString() : null;
        }

        @Override
        @NotNull
        public Class<?> resolveClass(@NotNull String name, @Nullable String pluginId) {
            ClassLoader classLoader;
            PluginId id2;
            PluginId pluginId2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = pluginId;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                pluginId2 = PluginId.getId((String)it);
            } else {
                pluginId2 = id2 = null;
            }
            if (id2 == null) {
                classLoader = ApplicationManager.class.getClassLoader();
            } else {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(id2);
                if (ideaPluginDescriptor == null) {
                    String string3 = "Could not resolve plugin by id '" + pluginId + "' for type: " + name;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"PluginManagerCore.getPlu\u2026uginId' for type: $name\")");
                IdeaPluginDescriptor plugin2 = ideaPluginDescriptor;
                classLoader = plugin2.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = ApplicationManager.class.getClassLoader();
                }
            }
            ClassLoader classloader = classLoader;
            Class<?> clazz = classloader.loadClass(name);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classloader.loadClass(name)");
            return clazz;
        }

        private PluginAwareEntityTypesResolver() {
        }

        static {
            PluginAwareEntityTypesResolver pluginAwareEntityTypesResolver;
            INSTANCE = pluginAwareEntityTypesResolver = new PluginAwareEntityTypesResolver();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$Companion;", "", "()V", "DATA_DIR_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateCachesMarkerFile", "Ljava/io/File;", "testCacheFile", "getTestCacheFile", "()Ljava/io/File;", "setTestCacheFile", "(Ljava/io/File;)V", "invalidateCaches", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final File getTestCacheFile() {
            return testCacheFile;
        }

        public final void setTestCacheFile(@Nullable File file2) {
            testCacheFile = file2;
        }

        public final void invalidateCaches() {
            LOG.info("Invalidating project model caches by creating " + invalidateCachesMarkerFile);
            cachesInvalidated.set(true);
            try {
                FileUtil.createParentDirs((File)invalidateCachesMarkerFile);
                FileUtil.writeToFile((File)invalidateCachesMarkerFile, (String)String.valueOf(System.currentTimeMillis()));
            }
            catch (Throwable t) {
                LOG.warn("Cannot update the invalidation marker file", t);
            }
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)invalidateCaches.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

