/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageVersionComparator
implements Comparator<String> {
    public static final Comparator<String> VERSION_COMPARATOR = new PackageVersionComparator();

    @Override
    public int compare(String version1, String version2) {
        List<String> vs1 = PackageVersionComparator.parse(version1);
        List<String> vs2 = PackageVersionComparator.parse(version2);
        for (int i2 = 0; i2 < vs1.size() && i2 < vs2.size(); ++i2) {
            String vs1Part = vs1.get(i2);
            String vs2Part = vs2.get(i2);
            if (vs1Part.equals("**") || vs2Part.equals("**")) {
                return 0;
            }
            int result2 = vs1Part.compareTo(vs2Part);
            if (result2 == 0) continue;
            return result2;
        }
        return vs1.size() - vs2.size();
    }

    @Nullable
    private static String replace(@NotNull String s) {
        ImmutableMap sub;
        String tmp;
        if (s == null) {
            PackageVersionComparator.$$$reportNull$$$0(0);
        }
        if ((tmp = (String)(sub = ImmutableMap.of((Object)"pre", (Object)"c", (Object)"preview", (Object)"c", (Object)"rc", (Object)"c", (Object)"dev", (Object)"@")).get(s)) != null) {
            s = tmp;
        }
        if (s.equals(".") || s.equals("-")) {
            return null;
        }
        if (s.matches("[0-9]+")) {
            try {
                long value2 = Long.parseLong(s);
                return String.format("%08d", value2);
            }
            catch (NumberFormatException e) {
                return s;
            }
        }
        return "*" + s;
    }

    @NotNull
    private static List<String> parse(@Nullable String s) {
        if (s == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageVersionComparator.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Pattern COMPONENT_RE = Pattern.compile("\\d+|[a-z]+|\\.|-|.+");
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = COMPONENT_RE.matcher(s);
        while (matcher.find()) {
            String component2 = PackageVersionComparator.replace(matcher.group());
            if (component2 == null) continue;
            results.add(component2);
        }
        for (int i2 = results.size() - 1; i2 > 0 && "00000000".equals(results.get(i2)); --i2) {
            results.remove(i2);
        }
        results.add("*final");
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            PackageVersionComparator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/packaging/PackageVersionComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/packaging/PackageVersionComparator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

