/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextCompletionUtil {
    public static final Key<TextCompletionProvider> COMPLETING_TEXT_FIELD_KEY = Key.create((String)"COMPLETING_TEXT_FIELD_KEY");
    public static final Key<Boolean> AUTO_POPUP_KEY = Key.create((String)"AUTOPOPUP_TEXT_FIELD_KEY");

    public static void installProvider(@NotNull PsiFile psiFile, @NotNull TextCompletionProvider provider2, boolean autoPopup) {
        if (psiFile == null) {
            TextCompletionUtil.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            TextCompletionUtil.$$$reportNull$$$0(1);
        }
        psiFile.putUserData(COMPLETING_TEXT_FIELD_KEY, (Object)provider2);
        psiFile.putUserData(AUTO_POPUP_KEY, (Object)autoPopup);
    }

    @Nullable
    public static TextCompletionProvider getProvider(@NotNull PsiFile file2) {
        TextCompletionProvider provider2;
        if (file2 == null) {
            TextCompletionUtil.$$$reportNull$$$0(2);
        }
        if ((provider2 = (TextCompletionProvider)file2.getUserData(COMPLETING_TEXT_FIELD_KEY)) == null || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)provider2)) {
            return null;
        }
        return provider2;
    }

    public static void installCompletionHint(@NotNull EditorEx editor) {
        String completionShortcutText;
        if (editor == null) {
            TextCompletionUtil.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmpty((String)(completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"))))) {
            final Ref toShowHintRef = new Ref((Object)true);
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    toShowHintRef.set((Object)false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/textCompletion/TextCompletionUtil$1", "documentChanged"));
                }
            });
            editor.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    if (editor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (Boolean.TRUE.equals(editor.getUserData(AutoPopupController.AUTO_POPUP_ON_FOCUS_GAINED))) {
                        AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
                        return;
                    }
                    if (((Boolean)toShowHintRef.get()).booleanValue() && editor.getDocument().getText().isEmpty() && !this.hasValidationInfo(editor)) {
                        ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showInformationHint(editor, LangBundle.message((String)"hint.text.code.completion.available", (Object[])new Object[]{completionShortcutText})));
                    }
                }

                private boolean hasValidationInfo(@NotNull Editor editor) {
                    if (editor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    for (Component parent : UIUtil.uiParents((Component)editor.getComponent(), (boolean)false)) {
                        ComponentValidator validator;
                        if (!(parent instanceof JComponent) || (validator = (ComponentValidator)ComponentValidator.getInstance((JComponent)((JComponent)parent)).orElse(null)) == null || validator.getValidationInfo() == null) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void focusLost(@NotNull Editor editor) {
                    if (editor == null) {
                        2.$$$reportNull$$$0(2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "editor";
                    objectArray2[1] = "com/intellij/util/textCompletion/TextCompletionUtil$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusGained";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "hasValidationInfo";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusLost";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/textCompletion/TextCompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installCompletionHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DocumentWithCompletionCreator
    extends LanguageTextField.SimpleDocumentCreator {
        @NotNull
        private final TextCompletionProvider myProvider;
        private final boolean myAutoPopup;

        public DocumentWithCompletionCreator(@NotNull TextCompletionProvider provider2, boolean autoPopup) {
            if (provider2 == null) {
                DocumentWithCompletionCreator.$$$reportNull$$$0(0);
            }
            this.myProvider = provider2;
            this.myAutoPopup = autoPopup;
        }

        @Override
        public void customizePsiFile(@NotNull PsiFile file2) {
            if (file2 == null) {
                DocumentWithCompletionCreator.$$$reportNull$$$0(1);
            }
            TextCompletionUtil.installProvider(file2, this.myProvider, this.myAutoPopup);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/textCompletion/TextCompletionUtil$DocumentWithCompletionCreator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizePsiFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

