/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ref.DebugReflectionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance(CachedValueLeakChecker.class);
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    CachedValueLeakChecker() {
    }

    static void checkProvider(@NotNull CachedValueProvider<?> provider2, @NotNull Key<?> key, @NotNull UserDataHolder userDataHolder) {
        if (provider2 == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(0);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(1);
        }
        if (userDataHolder == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(2);
        }
        if (!DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        CachedValueLeakChecker.findReferencedPsi(provider2, key, userDataHolder);
    }

    private static synchronized void findReferencedPsi(@NotNull Object root, @NotNull Key<?> key, @NotNull UserDataHolder toIgnore) {
        if (root == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(4);
        }
        if (toIgnore == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(5);
        }
        Predicate<Object> shouldExamineValue = value2 -> {
            if (value2 == toIgnore) {
                return false;
            }
            if (value2 instanceof ASTNode && (value2 = ((ASTNode)value2).getPsi()) == toIgnore) {
                return false;
            }
            if (value2 instanceof Project || value2 instanceof Module || value2 instanceof Application) {
                return false;
            }
            return !(value2 instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value2), (PsiElement)((PsiElement)toIgnore), (boolean)true);
        };
        Map<Object, @NonNls String> roots = Collections.singletonMap(root, "CachedValueProvider " + key);
        DebugReflectionUtil.walkObjects(5, roots, PsiElement.class, shouldExamineValue, (PairProcessor<Object, ? super DebugReflectionUtil.BackLink>)((PairProcessor)(value2, backLink) -> {
            if (value2 instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root + "\n" + backLink);
                return false;
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/CachedValueLeakChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

