/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    @ApiStatus.Internal
    public static void saveDocumentIfFileWillBecomeBinary(VirtualFile vFile, @NotNull String newName2) {
        FileDocumentManager fdm;
        Document doc;
        FileType newFileType;
        if (newName2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(0);
        }
        if ((UnknownFileType.INSTANCE.equals(newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName2)) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
            fdm.saveDocumentAsIs(doc);
        }
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(1);
        }
        if (newName2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(2);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            PsiFileImplUtil.saveDocumentIfFileWillBecomeBinary(vFile, newName2);
            vFile.rename((Object)manager, newName2);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name) throws IncorrectOperationException {
        VirtualFile vFile;
        VirtualFile parentFile;
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            PsiFileImplUtil.$$$reportNull$$$0(4);
        }
        if ((parentFile = (vFile = file2.getVirtualFile()).getParent()) == null) {
            return;
        }
        VirtualFile child2 = parentFile.findChild(name);
        if (child2 != null && !child2.equals(vFile)) {
            throw new IncorrectOperationException("File " + child2.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(5);
        }
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete((Object)manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/PsiFileImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDocumentIfFileWillBecomeBinary";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSetName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

