/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.CompactRecordsTable;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.RefCountingStorage;
import com.intellij.util.io.storage.Storage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FSRecords {
    private static final Logger LOG = Logger.getInstance(FSRecords.class);
    public static final boolean WE_HAVE_CONTENT_HASHES = SystemProperties.getBooleanProperty((String)"idea.share.contents", (boolean)true);
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    private static final boolean lazyVfsDataCleaning = SystemProperties.getBooleanProperty((String)"idea.lazy.vfs.data.cleaning", (boolean)true);
    private static final boolean backgroundVfsFlush = SystemProperties.getBooleanProperty((String)"idea.background.vfs.flush", (boolean)true);
    private static final boolean inlineAttributes = SystemProperties.getBooleanProperty((String)"idea.inline.vfs.attributes", (boolean)true);
    private static final boolean bulkAttrReadSupport = SystemProperties.getBooleanProperty((String)"idea.bulk.attr.read", (boolean)false);
    private static final boolean useCompressionUtil = SystemProperties.getBooleanProperty((String)"idea.use.lightweight.compression.for.vfs", (boolean)false);
    private static final boolean useSmallAttrTable = SystemProperties.getBooleanProperty((String)"idea.use.small.attr.table.for.vfs", (boolean)true);
    private static final boolean ourStoreRootsSeparately = SystemProperties.getBooleanProperty((String)"idea.store.roots.separately", (boolean)false);
    private static final int VERSION = 56 + (WE_HAVE_CONTENT_HASHES ? 16 : 0) + (IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER ? 55 : 0) + (bulkAttrReadSupport ? 39 : 0) + (inlineAttributes ? 49 : 0) + (ourStoreRootsSeparately ? 99 : 0) + (useCompressionUtil ? 127 : 0) + (useSmallAttrTable ? 49 : 0) + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 21 : 0) + (FileSystemUtil.DO_NOT_RESOLVE_SYMLINKS ? 59 : 0) + (ZipHandlerBase.USE_CRC_INSTEAD_OF_TIMESTAMP ? 79 : 0);
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTR_REF_OFFSET = 12;
    private static final int ATTR_REF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MOD_COUNT_OFFSET = 28;
    private static final int MOD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    private static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private static final int HEADER_VERSION_OFFSET = 0;
    private static final int HEADER_GLOBAL_MOD_COUNT_OFFSET = 8;
    private static final int HEADER_CONNECTION_STATUS_OFFSET = 12;
    private static final int HEADER_TIMESTAMP_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int CORRUPTED_MAGIC = -1412464769;
    private static final FileAttribute ourChildrenAttr = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    private static final FileAttribute ourSymlinkTargetAttr = new FileAttribute("FsRecords.SYMLINK_TARGET");
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock r = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock w = lock.writeLock();
    private static volatile int ourLocalModificationCount;
    private static volatile boolean ourIsDisposed;
    private static final int FREE_RECORD_FLAG = 1024;
    private static final int ALL_VALID_FLAGS = 2047;
    private static final int MAX_INITIALIZATION_ATTEMPTS = 10;
    private static final int ROOT_RECORD_ID = 1;
    private static final int MAX_SMALL_ATTR_SIZE = 64;
    private static final boolean DUMP_STATISTICS;
    private static long totalContents;
    private static long totalReuses;
    private static long time;
    private static int contents;
    private static int reuses;

    static int writeAttributesToRecord(int id2, int parentId, @NotNull FileAttributes attributes, @NotNull String name) {
        if (attributes == null) {
            FSRecords.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FSRecords.$$$reportNull$$$0(1);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int nameId = FSRecords.setName(id2, name);
            FSRecords.setTimestamp(id2, attributes.lastModified);
            FSRecords.setLength(id2, attributes.isDirectory() ? -1L : attributes.length);
            FSRecords.setFlags(id2, PersistentFSImpl.fileAttributesToFlags(attributes), true);
            FSRecords.setParent(id2, parentId);
            return nameId;
        });
    }

    @Contract(value="_->fail")
    static void requestVfsRebuild(@NotNull Throwable e) {
        if (e == null) {
            FSRecords.$$$reportNull$$$0(2);
        }
        DbConnection.handleError(e);
    }

    @NotNull
    static File basePath() {
        return new File(DbConnection.getCachesDir());
    }

    @NotNull
    public static String diagnosticsForAlreadyCreatedFile(int id2, int nameId, @NotNull Object existingData) {
        if (existingData == null) {
            FSRecords.$$$reportNull$$$0(3);
        }
        FSRecords.invalidateCaches();
        int parentId = FSRecords.getParent(id2);
        String msg = "File already created: id=" + id2 + "; nameId=" + nameId + "(" + FSRecords.getNameByNameId(nameId) + "); parentId=" + parentId + "; existingData=" + existingData;
        if (parentId > 0) {
            msg = msg + "; parent.name=" + FSRecords.getName(parentId);
            msg = msg + "; parent.children=" + FSRecords.list(parentId);
        }
        String string = msg;
        if (string == null) {
            FSRecords.$$$reportNull$$$0(4);
        }
        return string;
    }

    private FSRecords() {
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return VERSION;
    }

    static void connect() {
        DbConnection.connect();
    }

    public static long getCreationTimestamp() {
        return (Long)FSRecords.readAndHandleErrors(() -> DbConnection.getTimestamp());
    }

    private static ResizeableMappedFile getRecords() {
        ResizeableMappedFile records = DbConnection.myRecords;
        assert (records != null) : "Vfs must be initialized";
        return records;
    }

    private static ContentHashEnumerator getContentHashesEnumerator() {
        return DbConnection.myContentHashesEnumerator;
    }

    private static RefCountingStorage getContentStorage() {
        return DbConnection.myContents;
    }

    private static Storage getAttributesStorage() {
        return DbConnection.myAttributes;
    }

    private static PersistentStringEnumerator getNames() {
        return DbConnection.getNames();
    }

    public static int createRecord() {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            int free = DbConnection.getFreeRecord();
            if (free == 0) {
                int fileLength = FSRecords.length();
                LOG.assertTrue(fileLength % 40 == 0);
                int newRecord = fileLength / 40;
                DbConnection.cleanRecord(newRecord);
                assert (fileLength + 40 == FSRecords.length());
                return newRecord;
            }
            if (lazyVfsDataCleaning) {
                FSRecords.deleteContentAndAttributes(free);
            }
            DbConnection.cleanRecord(free);
            return free;
        });
    }

    private static int length() {
        return (int)FSRecords.getRecords().length();
    }

    static void deleteRecordRecursively(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            if (lazyVfsDataCleaning) {
                FSRecords.markAsDeletedRecursively(id2);
            } else {
                FSRecords.doDeleteRecursively(id2);
            }
        });
    }

    private static void markAsDeletedRecursively(int id2) {
        for (int subRecord : FSRecords.listIds(id2)) {
            FSRecords.markAsDeletedRecursively(subRecord);
        }
        FSRecords.markAsDeleted(id2);
    }

    private static void markAsDeleted(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.addToFreeRecordsList(id2);
        });
    }

    private static void doDeleteRecursively(int id2) {
        for (int subRecord : FSRecords.listIds(id2)) {
            FSRecords.doDeleteRecursively(subRecord);
        }
        FSRecords.deleteRecord(id2);
    }

    private static void deleteRecord(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.deleteContentAndAttributes(id2);
            DbConnection.cleanRecord(id2);
            FSRecords.addToFreeRecordsList(id2);
        });
    }

    private static void deleteContentAndAttributes(int id2) throws IOException {
        int att_page;
        int content_page = FSRecords.getContentRecordId(id2);
        if (content_page != 0) {
            if (WE_HAVE_CONTENT_HASHES) {
                FSRecords.getContentStorage().releaseRecord(content_page, false);
            } else {
                FSRecords.getContentStorage().releaseRecord(content_page);
            }
        }
        if ((att_page = FSRecords.getAttributeRecordId(id2)) != 0) {
            try (DataInputStream attStream = FSRecords.getAttributesStorage().readStream(att_page);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attStream, DbConnection.RESERVED_ATTR_ID, id2);
                }
                while (attStream.available() > 0) {
                    DataInputOutputUtil.readINT((DataInput)attStream);
                    int attAddressOrSize = DataInputOutputUtil.readINT((DataInput)attStream);
                    if (inlineAttributes) {
                        if (attAddressOrSize < 64) {
                            attStream.skipBytes(attAddressOrSize);
                            continue;
                        }
                        attAddressOrSize -= 64;
                    }
                    FSRecords.getAttributesStorage().deleteRecord(attAddressOrSize);
                }
            }
            FSRecords.getAttributesStorage().deleteRecord(att_page);
        }
    }

    private static void addToFreeRecordsList(int id2) {
        FSRecords.setFlags(id2, 1024, false);
    }

    @TestOnly
    static int @NotNull [] listRoots() {
        int[] nArray = (int[])FSRecords.readAndHandleErrors(() -> {
            if (ourStoreRootsSeparately) {
                IntArrayList result2 = new IntArrayList();
                try (LineNumberReader stream2 = new LineNumberReader(Files.newBufferedReader(DbConnection.myRootsFile));){
                    String str;
                    while ((str = stream2.readLine()) != null) {
                        int index = str.indexOf(32);
                        int id2 = Integer.parseInt(str.substring(0, index));
                        result2.add(id2);
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                return result2.toIntArray();
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input == null) {
                    int[] stream2 = ArrayUtilRt.EMPTY_INT_ARRAY;
                    return stream2;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                int[] result3 = ArrayUtil.newIntArray((int)count);
                int prevId = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    DataInputOutputUtil.readINT((DataInput)input);
                    prevId = result3[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                }
                int[] nArray = result3;
                return nArray;
            }
        });
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    @TestOnly
    static void force() {
        FSRecords.writeAndHandleErrors(() -> DbConnection.doForce());
    }

    @TestOnly
    static boolean isDirty() {
        return (Boolean)FSRecords.readAndHandleErrors(DbConnection::isDirty);
    }

    private static void saveNameIdSequenceWithDeltas(int[] names2, int[] ids, DataOutputStream output) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)output, (int)names2.length);
        int prevId = 0;
        int prevNameId = 0;
        for (int i2 = 0; i2 < names2.length; ++i2) {
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(names2[i2] - prevNameId));
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(ids[i2] - prevId));
            prevId = ids[i2];
            prevNameId = names2[i2];
        }
    }

    static int findRootRecord(@NotNull String rootUrl) {
        if (rootUrl == null) {
            FSRecords.$$$reportNull$$$0(6);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int id2;
            if (ourStoreRootsSeparately) {
                Closeable stream2;
                try {
                    stream2 = new LineNumberReader(Files.newBufferedReader(DbConnection.myRootsFile));
                    try {
                        String str;
                        while ((str = ((LineNumberReader)stream2).readLine()) != null) {
                            int index = str.indexOf(32);
                            if (!str.substring(index + 1).equals(rootUrl)) continue;
                            Integer n = Integer.parseInt(str.substring(0, index));
                            return n;
                        }
                    }
                    finally {
                        ((BufferedReader)stream2).close();
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                DbConnection.markDirty();
                stream2 = Files.newBufferedWriter(DbConnection.myRootsFile, StandardOpenOption.APPEND);
                try {
                    int id3 = FSRecords.createRecord();
                    ((Writer)stream2).write(id3 + " " + rootUrl + "\n");
                    Integer index = id3;
                    return index;
                }
                finally {
                    if (stream2 != null) {
                        ((Writer)stream2).close();
                    }
                }
            }
            int root = FSRecords.getNames().tryEnumerate((Object)rootUrl);
            int[] names2 = ArrayUtilRt.EMPTY_INT_ARRAY;
            int[] ids = ArrayUtilRt.EMPTY_INT_ARRAY;
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input != null) {
                    int count = DataInputOutputUtil.readINT((DataInput)input);
                    names2 = ArrayUtil.newIntArray((int)count);
                    ids = ArrayUtil.newIntArray((int)count);
                    int prevId = 0;
                    int prevNameId = 0;
                    for (int i2 = 0; i2 < count; ++i2) {
                        int name = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                        int id4 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                        if (name == root) {
                            Integer n = id4;
                            return n;
                        }
                        prevNameId = names2[i2] = name;
                        prevId = ids[i2] = id4;
                    }
                }
            }
            DbConnection.markDirty();
            root = FSRecords.getNames().enumerate(rootUrl);
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                id2 = FSRecords.createRecord();
                int index = Arrays.binarySearch(ids, id2);
                ids = ArrayUtil.insert((int[])ids, (int)(-index - 1), (int)id2);
                names2 = ArrayUtil.insert((int[])names2, (int)(-index - 1), (int)root);
                FSRecords.saveNameIdSequenceWithDeltas(names2, ids, output);
            }
            return id2;
        });
    }

    static void deleteRootRecord(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            int[] names2;
            int[] ids;
            DbConnection.markDirty();
            if (ourStoreRootsSeparately) {
                ArrayList<Object> rootsThatLeft = new ArrayList<Object>();
                try (LineNumberReader stream22 = new LineNumberReader(Files.newBufferedReader(DbConnection.myRootsFile));){
                    Object str;
                    while ((str = stream22.readLine()) != null) {
                        int n = ((String)str).indexOf(32);
                        int rootId = Integer.parseInt(((String)str).substring(0, n));
                        if (rootId == id2) continue;
                        rootsThatLeft.add(str);
                    }
                }
                catch (FileNotFoundException stream22) {
                    // empty catch block
                }
                try (BufferedWriter stream = Files.newBufferedWriter(DbConnection.myRootsFile, new OpenOption[0]);){
                    for (String string : rootsThatLeft) {
                        stream.write(string);
                        stream.write("\n");
                    }
                }
                return;
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                assert (input != null);
                int n = DataInputOutputUtil.readINT((DataInput)input);
                int[] names22 = ArrayUtil.newIntArray((int)n);
                ids = ArrayUtil.newIntArray((int)n);
                int prevId = 0;
                int prevNameId = 0;
                for (int i2 = 0; i2 < n; ++i2) {
                    names22[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                    ids[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    prevId = ids[i2];
                    prevNameId = names22[i2];
                }
            }
            int index = ArrayUtil.find((int[])ids, (int)id2);
            assert (index >= 0);
            names2 = ArrayUtil.remove((int[])names2, (int)index);
            ids = ArrayUtil.remove((int[])ids, (int)index);
            try (DataOutputStream dataOutputStream = FSRecords.writeAttribute(1, ourChildrenAttr);){
                FSRecords.saveNameIdSequenceWithDeltas(names2, ids, dataOutputStream);
            }
        });
    }

    static int @NotNull [] listIds(int id2) {
        int[] nArray = (int[])FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id2, ourChildrenAttr);){
                if (input == null) {
                    int[] nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                int[] result2 = ArrayUtil.newIntArray((int)count);
                int prevId = id2;
                for (int i2 = 0; i2 < count; ++i2) {
                    prevId = result2[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                }
                int[] nArray = result2;
                return nArray;
            }
        });
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    static boolean mayHaveChildren(int id2) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id2, ourChildrenAttr);){
                if (input == null) {
                    Boolean bl = true;
                    return bl;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                Boolean bl = count != 0;
                return bl;
            }
        });
    }

    @NotNull
    static ListResult list(int parentId) {
        ListResult listResult = (ListResult)FSRecords.readAndHandleErrors(() -> FSRecords.doLoadChildren(parentId));
        if (listResult == null) {
            FSRecords.$$$reportNull$$$0(8);
        }
        return listResult;
    }

    @NotNull
    public static List<CharSequence> listNames(int parentId) {
        List list2 = ContainerUtil.map(FSRecords.list((int)parentId).children, c -> c.getName());
        if (list2 == null) {
            FSRecords.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private static ListResult doLoadChildren(int parentId) throws IOException {
        assert (parentId > 0) : parentId;
        DataInputStream input = FSRecords.readAttribute(parentId, ourChildrenAttr);
        int count = input == null ? 0 : DataInputOutputUtil.readINT((DataInput)input);
        ArrayList<ChildInfoImpl> result2 = count == 0 ? Collections.emptyList() : new ArrayList<ChildInfoImpl>(count);
        int prevId = parentId;
        for (int i2 = 0; i2 < count; ++i2) {
            int id2;
            prevId = id2 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
            int nameId = FSRecords.doGetNameId(id2);
            ChildInfoImpl child2 = new ChildInfoImpl(id2, nameId, null, null, null);
            result2.add(child2);
        }
        ListResult listResult = new ListResult(result2);
        ListResult listResult2 = listResult;
        if (listResult2 == null) {
            FSRecords.$$$reportNull$$$0(10);
        }
        return listResult2;
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    static boolean wereChildrenAccessed(int id2) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> FSRecords.findAttributePage(id2, ourChildrenAttr, false) != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readAndHandleErrors(@NotNull ThrowableComputable<T, ?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(11);
        }
        assert (lock.getReadHoldCount() == 0);
        try {
            r.lock();
            try {
                Object object = action2.compute();
                return (T)object;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
    }

    private static <T> T writeAndHandleErrors(@NotNull ThrowableComputable<T, ?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(12);
        }
        try {
            w.lock();
            Object object = action2.compute();
            return (T)object;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void writeAndHandleErrors(@NotNull ThrowableRunnable<?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(13);
        }
        try {
            w.lock();
            action2.run();
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ListResult update(int parentId, @NotNull Function<? super ListResult, ? extends ListResult> childrenConvertor) {
        ListResult listResult;
        if (childrenConvertor == null) {
            FSRecords.$$$reportNull$$$0(14);
        }
        assert (parentId > 0) : parentId;
        ListResult children2 = FSRecords.list(parentId);
        ListResult result2 = childrenConvertor.apply(children2);
        try {
            ListResult toSave;
            w.lock();
            if (result2.childrenWereChangedSinceLastList()) {
                children2 = FSRecords.doLoadChildren(parentId);
                toSave = childrenConvertor.apply(children2);
            } else {
                toSave = result2;
            }
            FSRecords.updateSymlinksForNewChildren(parentId, children2, toSave);
            FSRecords.doSaveChildren(parentId, toSave);
            ListResult listResult2 = toSave;
            listResult = listResult2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            ExceptionUtil.rethrow((Throwable)e);
            ListResult listResult3 = result2;
            ListResult listResult4 = listResult3;
            if (listResult4 == null) {
                FSRecords.$$$reportNull$$$0(16);
            }
            return listResult4;
        }
        finally {
            w.unlock();
        }
        if (listResult == null) {
            FSRecords.$$$reportNull$$$0(15);
        }
        return listResult;
    }

    private static void updateSymlinksForNewChildren(int parentId, @NotNull ListResult oldChildren, @NotNull ListResult newChildren) {
        if (oldChildren == null) {
            FSRecords.$$$reportNull$$$0(17);
        }
        if (newChildren == null) {
            FSRecords.$$$reportNull$$$0(18);
        }
        ContainerUtil.processSortedListsInOrder(oldChildren.children, newChildren.children, Comparator.comparingInt(ChildInfo::getId), (boolean)true, (childInfo, isOldInfo) -> {
            if (!isOldInfo.booleanValue()) {
                FSRecords.updateSymlinkInfoForNewChild(parentId, childInfo);
            }
        });
    }

    private static void updateSymlinkInfoForNewChild(int parentId, @NotNull ChildInfo info) {
        int attributes;
        if (info == null) {
            FSRecords.$$$reportNull$$$0(19);
        }
        if ((attributes = info.getFileAttributeFlags()) != -1 && PersistentFS.isSymLink(attributes)) {
            int id2 = info.getId();
            String symlinkTarget = info.getSymlinkTarget();
            FSRecords.storeSymlinkTarget(id2, symlinkTarget);
            CharSequence name = info.getName();
            LocalFileSystem fs = LocalFileSystem.getInstance();
            if (fs instanceof LocalFileSystemImpl) {
                VirtualFile parent = PersistentFS.getInstance().findFileById(parentId);
                assert (parent != null) : parentId + 47 + id2 + ": " + name + " -> " + symlinkTarget;
                String linkPath = parent.getPath() + "/" + name;
                ((LocalFileSystemImpl)fs).symlinkUpdated(id2, parent, name, linkPath, symlinkTarget);
            }
        }
    }

    private static void doSaveChildren(int parentId, @NotNull ListResult toSave) throws IOException {
        if (toSave == null) {
            FSRecords.$$$reportNull$$$0(20);
        }
        DbConnection.markDirty();
        try (DataOutputStream record = FSRecords.writeAttribute(parentId, ourChildrenAttr);){
            DataInputOutputUtil.writeINT((DataOutput)record, (int)toSave.children.size());
            int prevId = parentId;
            for (ChildInfo childInfo : toSave.children) {
                int childId = childInfo.getId();
                if (childId <= 0) {
                    throw new IllegalArgumentException("ids must be >0 but got: " + childId + "; childInfo: " + childInfo + "; list: " + toSave);
                }
                if (childId == parentId) {
                    LOG.error("Cyclic parent-child relations. parentId=" + parentId + "; list: " + toSave);
                    continue;
                }
                int delta = childId - prevId;
                if (prevId != parentId && delta <= 0) {
                    throw new IllegalArgumentException("The list must be sorted by (unique) id but got parentId: " + parentId + "; delta: " + delta + "; childInfo: " + childInfo + "; prevId: " + prevId + "; toSave: " + toSave);
                }
                DataInputOutputUtil.writeINT((DataOutput)record, (int)delta);
                prevId = childId;
            }
        }
    }

    @Nullable
    static String readSymlinkTarget(int id2) {
        String result2 = (String)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(id2, ourSymlinkTargetAttr);){
                if (stream != null) {
                    String string = StringUtil.nullize((String)IOUtil.readUTF((DataInput)stream));
                    return string;
                }
            }
            return null;
        });
        return result2 != null ? FileUtil.toSystemIndependentName((String)result2) : null;
    }

    static void storeSymlinkTarget(int id2, @Nullable String symlinkTarget) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            try (DataOutputStream stream = FSRecords.writeAttribute(id2, ourSymlinkTargetAttr);){
                IOUtil.writeUTF((DataOutput)stream, (String)StringUtil.notNullize((String)symlinkTarget));
            }
        });
    }

    private static void incModCount(int id2) {
        FSRecords.incLocalModCount();
        int count = FSRecords.doGetModCount() + 1;
        FSRecords.getRecords().putInt(8L, count);
        FSRecords.setModCount(id2, count);
    }

    private static void incLocalModCount() {
        DbConnection.markDirty();
        ++ourLocalModificationCount;
    }

    static int getLocalModCount() {
        return ourLocalModificationCount;
    }

    static int getModCount() {
        return (Integer)FSRecords.readAndHandleErrors(FSRecords::doGetModCount);
    }

    private static int doGetModCount() {
        return FSRecords.getRecords().getInt(8L);
    }

    public static int getParent(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> {
            int parentId = FSRecords.getRecordInt(id2, 0);
            if (parentId == id2) {
                LOG.error("Cyclic parent child relations in the database. id = " + id2);
                return 0;
            }
            return parentId;
        });
    }

    @Nullable
    static VirtualFileSystemEntry findFileById(final int id2, final @NotNull ConcurrentIntObjectMap<VirtualFileSystemEntry> idToDirCache) {
        if (idToDirCache == null) {
            FSRecords.$$$reportNull$$$0(21);
        }
        class ParentFinder
        implements ThrowableComputable<Void, Throwable> {
            @Nullable
            private IntList path;
            private VirtualFileSystemEntry foundParent;

            ParentFinder() {
            }

            public Void compute() {
                int parentId;
                int currentId = id2;
                while ((parentId = FSRecords.getRecordInt(currentId, 0)) != 0) {
                    if (parentId == currentId || this.path != null && this.path.size() % 128 == 0 && this.path.contains(parentId)) {
                        LOG.error("Cyclic parent child relations in the database. id = " + parentId);
                        break;
                    }
                    this.foundParent = (VirtualFileSystemEntry)((Object)idToDirCache.get(parentId));
                    if (this.foundParent != null) break;
                    currentId = parentId;
                    if (this.path == null) {
                        this.path = new IntArrayList();
                    }
                    this.path.add(currentId);
                }
                return null;
            }

            private VirtualFileSystemEntry findDescendantByIdPath() {
                VirtualFileSystemEntry parent = this.foundParent;
                if (this.path != null) {
                    for (int i2 = this.path.size() - 1; i2 >= 0; --i2) {
                        parent = this.findChild(parent, this.path.getInt(i2));
                    }
                }
                return this.findChild(parent, id2);
            }

            private VirtualFileSystemEntry findChild(VirtualFileSystemEntry parent, int childId) {
                VirtualFileSystemEntry old;
                if (!(parent instanceof VirtualDirectoryImpl)) {
                    return null;
                }
                VirtualFileSystemEntry child2 = ((VirtualDirectoryImpl)parent).doFindChildById(childId);
                if (child2 instanceof VirtualDirectoryImpl && (old = (VirtualFileSystemEntry)((Object)idToDirCache.putIfAbsent(childId, (Object)child2))) != null) {
                    child2 = old;
                }
                return child2;
            }
        }
        ParentFinder finder = new ParentFinder();
        FSRecords.readAndHandleErrors(finder);
        return finder.findDescendantByIdPath();
    }

    static void setParent(int id2, int parentId) {
        if (id2 == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            FSRecords.putRecordInt(id2, 0, parentId);
        });
    }

    private static int doGetNameId(int id2) {
        assert (id2 > 0) : id2;
        return FSRecords.getRecordInt(id2, 4);
    }

    public static int getNameId(@NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(22);
        }
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getNames().enumerate(name));
    }

    public static String getName(int id2) {
        return FSRecords.getNameSequence(id2).toString();
    }

    @NotNull
    static CharSequence getNameSequence(int id2) {
        CharSequence charSequence = (CharSequence)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameSequence(id2));
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(23);
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence doGetNameSequence(int id2) throws IOException {
        int nameId = FSRecords.doGetNameId(id2);
        CharSequence charSequence = nameId == 0 ? "" : FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId);
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(24);
        }
        return charSequence;
    }

    public static String getNameByNameId(int nameId) {
        return (String)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameByNameId(nameId));
    }

    private static String doGetNameByNameId(int nameId) throws IOException {
        assert (nameId >= 0) : nameId;
        return nameId == 0 ? "" : FSRecords.getNames().valueOf(nameId);
    }

    static int setName(int id2, @NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(25);
        }
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            int nameId = FSRecords.getNames().enumerate(name);
            assert (nameId > 0) : nameId;
            FSRecords.putRecordInt(id2, 4, nameId);
            return nameId;
        });
    }

    static @PersistentFS.Attributes int getFlags(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.doGetFlags(id2));
    }

    private static @PersistentFS.Attributes int doGetFlags(int id2) {
        return FSRecords.getRecordInt(id2, 8);
    }

    static void setFlags(int id2, @PersistentFS.Attributes int flags, boolean markAsChange) {
        FSRecords.writeAndHandleErrors(() -> {
            if (markAsChange) {
                FSRecords.incModCount(id2);
            }
            FSRecords.putRecordInt(id2, 8, flags);
        });
    }

    static long getLength(int id2) {
        return (Long)FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong((long)FSRecords.getOffset(id2, 32)));
    }

    static void setLength(int id2, long len) {
        FSRecords.writeAndHandleErrors(() -> {
            int lengthOffset;
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong((long)(lengthOffset = FSRecords.getOffset(id2, 32))) != len) {
                FSRecords.incModCount(id2);
                records.putLong((long)lengthOffset, len);
            }
        });
    }

    static long getTimestamp(int id2) {
        return (Long)FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong((long)FSRecords.getOffset(id2, 20)));
    }

    static void setTimestamp(int id2, long value2) {
        FSRecords.writeAndHandleErrors(() -> {
            int timeStampOffset = FSRecords.getOffset(id2, 20);
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong((long)timeStampOffset) != value2) {
                FSRecords.incModCount(id2);
                records.putLong((long)timeStampOffset, value2);
            }
        });
    }

    static int getModCount(int id2) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getRecordInt(id2, 28));
    }

    private static void setModCount(int id2, int value2) {
        FSRecords.putRecordInt(id2, 28, value2);
    }

    private static int getContentRecordId(int fileId) {
        return FSRecords.getRecordInt(fileId, 16);
    }

    private static void setContentRecordId(int id2, int value2) {
        FSRecords.putRecordInt(id2, 16, value2);
    }

    private static int getAttributeRecordId(int id2) {
        return FSRecords.getRecordInt(id2, 12);
    }

    private static void setAttributeRecordId(int id2, int value2) {
        FSRecords.putRecordInt(id2, 12, value2);
    }

    private static int getRecordInt(int id2, int offset) {
        return FSRecords.getRecords().getInt((long)FSRecords.getOffset(id2, offset));
    }

    private static void putRecordInt(int id2, int offset, int value2) {
        FSRecords.getRecords().putInt((long)FSRecords.getOffset(id2, offset), value2);
    }

    private static int getOffset(int id2, int offset) {
        return id2 * 40 + offset;
    }

    @Nullable
    static DataInputStream readContent(int fileId) {
        int page = (Integer)FSRecords.readAndHandleErrors(() -> {
            FSRecords.checkFileIsValid(fileId);
            return FSRecords.getContentRecordId(fileId);
        });
        if (page == 0) {
            return null;
        }
        try {
            return FSRecords.doReadContentById(page);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @NotNull
    static DataInputStream readContentById(int contentId) {
        try {
            return FSRecords.doReadContentById(contentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            if (null == null) {
                FSRecords.$$$reportNull$$$0(26);
            }
            return null;
        }
    }

    @NotNull
    private static DataInputStream doReadContentById(int contentId) throws IOException {
        DataInputStream stream = FSRecords.getContentStorage().readStream(contentId);
        if (useCompressionUtil) {
            byte[] bytes = CompressionUtil.readCompressed((DataInput)stream);
            stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
        }
        DataInputStream dataInputStream = stream;
        if (dataInputStream == null) {
            FSRecords.$$$reportNull$$$0(27);
        }
        return dataInputStream;
    }

    @Nullable
    public static DataInputStream readAttributeWithLock(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(28);
        }
        return (DataInputStream)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(fileId, att);){
                if (stream != null && att.isVersioned()) {
                    try {
                        int actualVersion = DataInputOutputUtil.readINT((DataInput)stream);
                        if (actualVersion != att.getVersion()) {
                            DataInputStream dataInputStream = null;
                            return dataInputStream;
                        }
                    }
                    catch (IOException e) {
                        DataInputStream dataInputStream = null;
                        return dataInputStream;
                    }
                }
                DataInputStream dataInputStream = stream;
                return dataInputStream;
            }
        });
    }

    @Nullable
    private static DataInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(29);
        }
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        if (recordId == 0) {
            return null;
        }
        int encodedAttrId = DbConnection.getAttributeId(attribute.getId());
        Storage storage = FSRecords.getAttributesStorage();
        int page = 0;
        try (DataInputStream attrRefs = storage.readStream(recordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
            }
            while (attrRefs.available() > 0) {
                int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                if (attIdOnPage != encodedAttrId) {
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                    continue;
                }
                if (inlineAttributes && attrAddressOrSize < 64) {
                    byte[] b = new byte[attrAddressOrSize];
                    attrRefs.readFully(b);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(b));
                    return dataInputStream;
                }
                page = inlineAttributes ? attrAddressOrSize - 64 : attrAddressOrSize;
                break;
            }
        }
        if (page == 0) {
            return null;
        }
        DataInputStream stream = FSRecords.getAttributesStorage().readStream(page);
        if (bulkAttrReadSupport) {
            FSRecords.skipRecordHeader(stream, encodedAttrId, fileId);
        }
        return stream;
    }

    private static int findAttributePage(int fileId, @NotNull FileAttribute attr, boolean toWrite) throws IOException {
        if (attr == null) {
            FSRecords.$$$reportNull$$$0(30);
        }
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        int encodedAttrId = DbConnection.getAttributeId(attr.getId());
        boolean directoryRecord = false;
        Storage storage = FSRecords.getAttributesStorage();
        if (recordId == 0) {
            if (!toWrite) {
                return 0;
            }
            recordId = storage.createNewRecord();
            FSRecords.setAttributeRecordId(fileId, recordId);
            directoryRecord = true;
        } else {
            try (DataInputStream attrRefs = storage.readStream(recordId);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
                }
                while (attrRefs.available() > 0) {
                    int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    if (attIdOnPage == encodedAttrId) {
                        if (inlineAttributes) {
                            int n = attrAddressOrSize < 64 ? -recordId : attrAddressOrSize - 64;
                            return n;
                        }
                        int n = attrAddressOrSize;
                        return n;
                    }
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                }
            }
        }
        if (toWrite) {
            try {
                int n;
                block28: {
                    AbstractStorage.AppenderStream appender = storage.appendStream(recordId);
                    try {
                        if (bulkAttrReadSupport && directoryRecord) {
                            DataInputOutputUtil.writeINT((DataOutput)appender, (int)DbConnection.RESERVED_ATTR_ID);
                            DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
                        }
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)encodedAttrId);
                        int attrAddress = storage.createNewRecord();
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)(inlineAttributes ? attrAddress + 64 : attrAddress));
                        DbConnection.REASONABLY_SMALL.myAttrPageRequested = true;
                        n = attrAddress;
                        if (appender == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (appender != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    appender.close();
                }
                return n;
            }
            finally {
                DbConnection.REASONABLY_SMALL.myAttrPageRequested = false;
            }
        }
        return 0;
    }

    private static void skipRecordHeader(DataInputStream refs, int expectedRecordTag, int expectedFileId) throws IOException {
        int attId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (attId == expectedRecordTag || expectedRecordTag == 0);
        int fileId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (expectedFileId == fileId || expectedFileId == 0);
    }

    private static void writeRecordHeader(int recordTag, int fileId, @NotNull DataOutputStream appender) throws IOException {
        if (appender == null) {
            FSRecords.$$$reportNull$$$0(31);
        }
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)recordTag);
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
    }

    private static void checkFileIsValid(int fileId) throws IOException {
        assert (fileId > 0) : fileId;
        if (!lazyVfsDataCleaning) assert (!BitUtil.isSet((int)FSRecords.doGetFlags(fileId), (int)1024)) : "Accessing attribute of a deleted page: " + fileId + ":" + FSRecords.doGetNameSequence(fileId);
    }

    static int acquireFileContent(int fileId) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int record = FSRecords.getContentRecordId(fileId);
            if (record > 0) {
                FSRecords.getContentStorage().acquireRecord(record);
            }
            return record;
        });
    }

    static void releaseContent(int contentId) {
        FSRecords.writeAndHandleErrors(() -> FSRecords.getContentStorage().releaseRecord(contentId, !WE_HAVE_CONTENT_HASHES));
    }

    static int getContentId(int fileId) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getContentRecordId(fileId));
    }

    static byte[] getContentHash(int fileId) {
        if (!WE_HAVE_CONTENT_HASHES) {
            return null;
        }
        return (byte[])FSRecords.readAndHandleErrors(() -> {
            int contentId = FSRecords.getContentRecordId(fileId);
            return contentId <= 0 ? null : FSRecords.getContentHashesEnumerator().valueOf(contentId);
        });
    }

    @NotNull
    static DataOutputStream writeContent(int fileId, boolean readOnly) {
        return new ContentOutputStream(fileId, readOnly);
    }

    static void writeContent(int fileId, ByteArraySequence bytes, boolean readOnly) {
        new ContentOutputStream(fileId, readOnly).writeBytes(bytes);
    }

    static int storeUnlinkedContent(byte[] bytes) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int recordId;
            if (WE_HAVE_CONTENT_HASHES) {
                recordId = FSRecords.findOrCreateContentRecord(bytes, 0, bytes.length);
                if (recordId > 0) {
                    return recordId;
                }
                recordId = -recordId;
            } else {
                recordId = FSRecords.getContentStorage().acquireNewRecord();
            }
            try (AbstractStorage.StorageDataOutput output = FSRecords.getContentStorage().writeStream(recordId, true);){
                output.write(bytes);
            }
            return recordId;
        });
    }

    @NotNull
    public static DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(32);
        }
        AttributeOutputStream stream = new AttributeOutputStream(fileId, att);
        if (att.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)att.getVersion());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        AttributeOutputStream attributeOutputStream = stream;
        if (attributeOutputStream == null) {
            FSRecords.$$$reportNull$$$0(33);
        }
        return attributeOutputStream;
    }

    @NotNull
    private static MessageDigest getContentHashDigest() {
        MessageDigest messageDigest = DigestUtil.sha1();
        if (messageDigest == null) {
            FSRecords.$$$reportNull$$$0(34);
        }
        return messageDigest;
    }

    private static byte @NotNull [] calculateHash(byte[] bytes, int offset, int length) {
        MessageDigest digest = FSRecords.getContentHashDigest();
        digest.update(String.valueOf(length).getBytes(StandardCharsets.UTF_8));
        digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
        digest.update(bytes, offset, length);
        byte[] byArray = digest.digest();
        if (byArray == null) {
            FSRecords.$$$reportNull$$$0(35);
        }
        return byArray;
    }

    private static int findOrCreateContentRecord(byte[] bytes, int offset, int length) throws IOException {
        assert (WE_HAVE_CONTENT_HASHES);
        long started = DUMP_STATISTICS ? System.nanoTime() : 0L;
        byte[] contentHash = FSRecords.calculateHash(bytes, offset, length);
        long done = DUMP_STATISTICS ? System.nanoTime() - started : 0L;
        time += done;
        totalContents += (long)length;
        if (DUMP_STATISTICS && (++contents & 0x3FFF) == 0) {
            LOG.info("Contents:" + contents + " of " + totalContents + ", reuses:" + reuses + " of " + totalReuses + " for " + time / 1000000L);
        }
        ContentHashEnumerator hashesEnumerator = FSRecords.getContentHashesEnumerator();
        int largestId = hashesEnumerator.getLargestId();
        int page = hashesEnumerator.enumerate(contentHash);
        if (page <= largestId) {
            ++reuses;
            FSRecords.getContentStorage().acquireRecord(page);
            totalReuses += (long)length;
            return page;
        }
        int newRecord = FSRecords.getContentStorage().acquireNewRecord();
        assert (page == newRecord) : "Unexpected content storage modification: page=" + page + "; newRecord=" + newRecord;
        return -page;
    }

    static void dispose() {
        FSRecords.writeAndHandleErrors(() -> {
            try {
                DbConnection.doForce();
                DbConnection.closeFiles();
            }
            finally {
                ourIsDisposed = true;
            }
        });
    }

    public static void invalidateCaches() {
        DbConnection.createBrokenMarkerFile(null);
    }

    static void checkSanity() {
        long t = System.currentTimeMillis();
        int recordCount = (Integer)FSRecords.readAndHandleErrors(() -> {
            int fileLength = FSRecords.length();
            assert (fileLength % 40 == 0);
            return fileLength / 40;
        });
        IntArrayList usedAttributeRecordIds = new IntArrayList();
        IntArrayList validAttributeIds = new IntArrayList();
        for (int id2 = 2; id2 < recordCount; ++id2) {
            int flags = FSRecords.getFlags(id2);
            LOG.assertTrue((flags & 0xFFFFF800) == 0, (Object)("Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id2));
            int currentId = id2;
            boolean isFreeRecord = (Boolean)FSRecords.readAndHandleErrors(() -> DbConnection.myFreeRecords.contains(currentId));
            if (BitUtil.isSet((int)flags, (int)1024)) {
                LOG.assertTrue(isFreeRecord, (Object)("Record, marked free, not in free list: " + id2));
                continue;
            }
            LOG.assertTrue(!isFreeRecord, (Object)("Record, not marked free, in free list: " + id2));
            FSRecords.checkRecordSanity(id2, recordCount, (IntList)usedAttributeRecordIds, (IntList)validAttributeIds);
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    private static void checkRecordSanity(int id2, int recordCount, IntList usedAttributeRecordIds, IntList validAttributeIds) {
        int parentId = FSRecords.getParent(id2);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && FSRecords.getParent(parentId) > 0) {
            int parentFlags = FSRecords.getFlags(parentId);
            assert (!BitUtil.isSet((int)parentFlags, (int)1024)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet((int)parentFlags, (int)2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        CharSequence name = FSRecords.getNameSequence(id2);
        LOG.assertTrue(parentId == 0 || name.length() != 0, (Object)("File with empty name found under " + FSRecords.getNameSequence(parentId) + ", id=" + id2));
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.checkContentsStorageSanity(id2);
            FSRecords.checkAttributesStorageSanity(id2, usedAttributeRecordIds, validAttributeIds);
        });
        long length = FSRecords.getLength(id2);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    private static void checkContentsStorageSanity(int id2) {
        int recordId = FSRecords.getContentRecordId(id2);
        assert (recordId >= 0);
        if (recordId > 0) {
            FSRecords.getContentStorage().checkSanity(recordId);
        }
    }

    private static void checkAttributesStorageSanity(int id2, IntList usedAttributeRecordIds, IntList validAttributeIds) {
        int attributeRecordId = FSRecords.getAttributeRecordId(id2);
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            try {
                FSRecords.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds);
            }
            catch (IOException ex) {
                DbConnection.handleError(ex);
            }
        }
    }

    private static void checkAttributesSanity(int attributeRecordId, IntList usedAttributeRecordIds, IntList validAttributeIds) throws IOException {
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        try (DataInputStream dataInputStream = FSRecords.getAttributesStorage().readStream(attributeRecordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(dataInputStream, 0, 0);
            }
            while (dataInputStream.available() > 0) {
                int attId = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (!validAttributeIds.contains(attId)) {
                    validAttributeIds.add(attId);
                }
                int attDataRecordIdOrSize = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (inlineAttributes) {
                    if (attDataRecordIdOrSize < 64) {
                        dataInputStream.skipBytes(attDataRecordIdOrSize);
                        continue;
                    }
                    attDataRecordIdOrSize -= 64;
                }
                assert (!usedAttributeRecordIds.contains(attDataRecordIdOrSize));
                usedAttributeRecordIds.add(attDataRecordIdOrSize);
                FSRecords.getAttributesStorage().checkSanity(attDataRecordIdOrSize);
            }
        }
    }

    @Contract(value="_->fail")
    public static void handleError(Throwable e) throws RuntimeException, Error {
        DbConnection.handleError(e);
    }

    static {
        DUMP_STATISTICS = WE_HAVE_CONTENT_HASHES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingData";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenConvertor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChildren";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSave";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDirCache";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "diagnosticsForAlreadyCreatedFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listIds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "listNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNameSequence";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadContentById";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentHashDigest";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestVfsRebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "diagnosticsForAlreadyCreatedFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootRecord";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readAndHandleErrors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeAndHandleErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinksForNewChildren";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinkInfoForNewChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doSaveChildren";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFileById";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeWithLock";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findAttributePage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeRecordHeader";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AttributeOutputStream
    extends DataOutputStream {
        @NotNull
        private final FileAttribute myAttribute;
        private final int myFileId;

        private AttributeOutputStream(int fileId, @NotNull FileAttribute attribute) {
            if (attribute == null) {
                AttributeOutputStream.$$$reportNull$$$0(0);
            }
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttribute = attribute;
        }

        public void close() throws IOException {
            super.close();
            FSRecords.writeAndHandleErrors(() -> {
                BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
                if (inlineAttributes && _out.size() < 64) {
                    this.rewriteDirectoryRecordWithAttrContent(_out);
                    FSRecords.incLocalModCount();
                } else {
                    FSRecords.incLocalModCount();
                    int page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    if (inlineAttributes && page < 0) {
                        this.rewriteDirectoryRecordWithAttrContent(new BufferExposingByteArrayOutputStream());
                        page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    }
                    if (bulkAttrReadSupport) {
                        BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                        this.out = stream;
                        FSRecords.writeRecordHeader(DbConnection.getAttributeId(this.myAttribute.getId()), this.myFileId, this);
                        this.write(_out.getInternalBuffer(), 0, _out.size());
                        FSRecords.getAttributesStorage().writeBytes(page, stream.toByteArraySequence(), this.myAttribute.isFixedSize());
                    } else {
                        FSRecords.getAttributesStorage().writeBytes(page, _out.toByteArraySequence(), this.myAttribute.isFixedSize());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rewriteDirectoryRecordWithAttrContent(@NotNull BufferExposingByteArrayOutputStream _out) throws IOException {
            if (_out == null) {
                AttributeOutputStream.$$$reportNull$$$0(1);
            }
            int recordId = FSRecords.getAttributeRecordId(this.myFileId);
            assert (inlineAttributes);
            int encodedAttrId = DbConnection.getAttributeId(this.myAttribute.getId());
            Storage storage = FSRecords.getAttributesStorage();
            BufferExposingByteArrayOutputStream unchangedPreviousDirectoryStream = null;
            boolean directoryRecord = false;
            if (recordId == 0) {
                recordId = storage.createNewRecord();
                FSRecords.setAttributeRecordId(this.myFileId, recordId);
                directoryRecord = true;
            } else {
                try (DataInputStream attrRefs = storage.readStream(recordId);
                     DataOutputStream dataStream = null;){
                    int remainingAtStart = attrRefs.available();
                    if (bulkAttrReadSupport) {
                        unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                        dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                        int attId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (attId == DbConnection.RESERVED_ATTR_ID);
                        int fileId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (this.myFileId == fileId);
                        FSRecords.writeRecordHeader(attId, fileId, dataStream);
                    }
                    while (attrRefs.available() > 0) {
                        int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        if (attIdOnPage != encodedAttrId) {
                            if (dataStream == null) {
                                unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                                dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                            }
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attIdOnPage);
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attrAddressOrSize);
                            if (attrAddressOrSize >= 64) continue;
                            byte[] b = new byte[attrAddressOrSize];
                            attrRefs.readFully(b);
                            dataStream.write(b);
                            continue;
                        }
                        if (attrAddressOrSize >= 64) continue;
                        if (_out.size() == attrAddressOrSize) {
                            int remaining = attrRefs.available();
                            storage.replaceBytes(recordId, remainingAtStart - remaining, _out.toByteArraySequence());
                            return;
                        }
                        attrRefs.skipBytes(attrAddressOrSize);
                    }
                }
            }
            try (AbstractStorage.StorageDataOutput directoryStream = storage.writeStream(recordId);){
                if (directoryRecord && bulkAttrReadSupport) {
                    FSRecords.writeRecordHeader(DbConnection.RESERVED_ATTR_ID, this.myFileId, (DataOutputStream)directoryStream);
                }
                if (unchangedPreviousDirectoryStream != null) {
                    directoryStream.write(unchangedPreviousDirectoryStream.getInternalBuffer(), 0, unchangedPreviousDirectoryStream.size());
                }
                if (_out.size() > 0) {
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)encodedAttrId);
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)_out.size());
                    directoryStream.write(_out.getInternalBuffer(), 0, _out.size());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_out";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$AttributeOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rewriteDirectoryRecordWithAttrContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ContentOutputStream
    extends DataOutputStream {
        final int myFileId;
        final boolean myFixedSize;

        private ContentOutputStream(int fileId, boolean readOnly) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myFixedSize = readOnly;
        }

        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            this.writeBytes(_out.toByteArraySequence());
        }

        private void writeBytes(ByteArraySequence bytes) {
            FSRecords.writeAndHandleErrors(() -> {
                ByteArraySequence newBytes;
                boolean fixedSize;
                int page;
                RefCountingStorage contentStorage = FSRecords.getContentStorage();
                FSRecords.checkFileIsValid(this.myFileId);
                if (WE_HAVE_CONTENT_HASHES) {
                    page = FSRecords.findOrCreateContentRecord(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                    if (page < 0 || FSRecords.getContentId(this.myFileId) != page) {
                        FSRecords.incModCount(this.myFileId);
                        FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    }
                    FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    if (page > 0) {
                        return;
                    }
                    page = -page;
                    fixedSize = true;
                } else {
                    FSRecords.incModCount(this.myFileId);
                    page = FSRecords.getContentRecordId(this.myFileId);
                    if (page == 0 || contentStorage.getRefCount(page) > 1) {
                        page = contentStorage.acquireNewRecord();
                        FSRecords.setContentRecordId(this.myFileId, page);
                    }
                    fixedSize = this.myFixedSize;
                }
                if (useCompressionUtil) {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    try (DataOutputStream outputStream = new DataOutputStream((OutputStream)out);){
                        CompressionUtil.writeCompressed((DataOutput)outputStream, (byte[])bytes.getBytes(), (int)bytes.getOffset(), (int)bytes.getLength());
                    }
                    newBytes = out.toByteArraySequence();
                } else {
                    newBytes = bytes;
                }
                contentStorage.writeBytes(page, newBytes, fixedSize);
            });
        }
    }

    private static final class DbConnection {
        private static boolean ourInitialized;
        private static PersistentStringEnumerator myNames;
        private static Storage myAttributes;
        private static RefCountingStorage myContents;
        private static ResizeableMappedFile myRecords;
        private static ContentHashEnumerator myContentHashesEnumerator;
        private static Path myRootsFile;
        private static final VfsDependentEnum<String> myAttributesList;
        private static final IntList myFreeRecords;
        private static volatile boolean myDirty;
        private static ScheduledFuture<?> myFlushingFuture;
        private static boolean myCorrupted;
        private static final AttrPageAwareCapacityAllocationPolicy REASONABLY_SMALL;
        private static final int RESERVED_ATTR_ID;
        private static final int FIRST_ATTR_ID_OFFSET;

        private DbConnection() {
        }

        public static void connect() {
            FSRecords.writeAndHandleErrors(() -> {
                if (!ourInitialized) {
                    DbConnection.init();
                    DbConnection.setupFlushing();
                    ourInitialized = true;
                }
            });
        }

        private static void scanFreeRecords() {
            int fileLength = (int)myRecords.length();
            LOG.assertTrue(fileLength % 40 == 0, (Object)("invalid file size: " + fileLength));
            int count = fileLength / 40;
            for (int n = 2; n < count; ++n) {
                if (!BitUtil.isSet((int)FSRecords.getFlags(n), (int)1024)) continue;
                myFreeRecords.add(n);
            }
        }

        static int getFreeRecord() {
            return myFreeRecords.isEmpty() ? 0 : myFreeRecords.removeInt(myFreeRecords.size() - 1);
        }

        private static void createBrokenMarkerFile(@Nullable Throwable reason) {
            File brokenMarker = DbConnection.getCorruptionMarkerFile();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream(out);){
                new Exception().printStackTrace(stream);
                if (reason != null) {
                    stream.print("\nReason:\n");
                    reason.printStackTrace(stream);
                }
            }
            LOG.info("Creating VFS corruption marker; Trace=\n" + out);
            try (FileWriter writer = new FileWriter(brokenMarker);){
                writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static File getCorruptionMarkerFile() {
            return new File(FSRecords.basePath(), "corruption.marker");
        }

        private static void init() {
            Exception exception = null;
            for (int i2 = 0; i2 < 10; ++i2) {
                exception = DbConnection.tryInit();
                if (exception != null) continue;
                return;
            }
            throw new RuntimeException("Can't initialize filesystem storage", exception);
        }

        @Nullable
        private static Exception tryInit() {
            Path basePath = FSRecords.basePath().getAbsoluteFile().toPath();
            try {
                Files.createDirectories(basePath, new java.nio.file.attribute.FileAttribute[0]);
            }
            catch (IOException e) {
                return e;
            }
            Path namesFile = basePath.resolve("names" + VFS_FILES_EXTENSION);
            Path attributesFile = basePath.resolve("attrib" + VFS_FILES_EXTENSION);
            Path contentsFile = basePath.resolve("content" + VFS_FILES_EXTENSION);
            Path contentsHashesFile = basePath.resolve("contentHashes" + VFS_FILES_EXTENSION);
            Path recordsFile = basePath.resolve("records" + VFS_FILES_EXTENSION);
            myRootsFile = ourStoreRootsSeparately ? basePath.resolve("roots" + VFS_FILES_EXTENSION) : null;
            File vfsDependentEnumBaseFile = VfsDependentEnum.getBaseFile();
            if (!Files.exists(namesFile, new LinkOption[0])) {
                DbConnection.invalidateIndex("'" + namesFile + "' does not exist");
            }
            try {
                int version2;
                boolean initial;
                boolean aligned;
                if (DbConnection.getCorruptionMarkerFile().exists()) {
                    DbConnection.invalidateIndex("corruption marker found");
                    throw new IOException("Corruption marker file found");
                }
                StorageLockContext storageLockContext = new StorageLockContext(false);
                myNames = new PersistentStringEnumerator(namesFile, storageLockContext);
                myAttributes = new Storage(attributesFile, REASONABLY_SMALL){

                    protected AbstractRecordsTable createRecordsTable(PagePool pool, @NotNull Path recordsFile) throws IOException {
                        if (recordsFile == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return inlineAttributes && useSmallAttrTable ? new CompactRecordsTable(recordsFile, pool, false) : super.createRecordsTable(pool, recordsFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordsFile", "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection$1", "createRecordsTable"));
                    }
                };
                myContents = new RefCountingStorage(contentsFile, CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, useCompressionUtil){

                    @NotNull
                    protected ExecutorService createExecutor() {
                        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FSRecords Pool");
                        if (executorService == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return executorService;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection$2", "createExecutor"));
                    }
                };
                myContentHashesEnumerator = WE_HAVE_CONTENT_HASHES ? new ContentHashEnumerator(contentsHashesFile, storageLockContext) : null;
                boolean bl = aligned = PagedFileStorage.BUFFER_SIZE % 40 == 0;
                if (!aligned) {
                    LOG.error("Buffer size " + PagedFileStorage.BUFFER_SIZE + " is not aligned for record size 40");
                }
                boolean bl2 = initial = (myRecords = new ResizeableMappedFile(recordsFile, 20480, storageLockContext, PagedFileStorage.BUFFER_SIZE, aligned, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER)).length() == 0L;
                if (initial) {
                    DbConnection.cleanRecord(0);
                    DbConnection.cleanRecord(1);
                    DbConnection.setCurrentVersion();
                }
                if ((version2 = DbConnection.getVersion()) != VERSION) {
                    throw new IOException("FS repository version mismatch: actual=" + version2 + " expected=" + VERSION);
                }
                if (myRecords.getInt(12L) != 523190095) {
                    throw new IOException("FS repository wasn't safely shut down");
                }
                if (initial) {
                    DbConnection.markDirty();
                }
                DbConnection.scanFreeRecords();
                DbConnection.getAttributeId(ourChildrenAttr.getId());
                return null;
            }
            catch (Exception e) {
                LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
                try {
                    DbConnection.closeFiles();
                    boolean deleted = FileUtil.delete((File)DbConnection.getCorruptionMarkerFile());
                    deleted &= IOUtil.deleteAllFilesStartingWith((Path)namesFile);
                    deleted &= AbstractStorage.deleteFiles((Path)attributesFile);
                    deleted &= AbstractStorage.deleteFiles((Path)contentsFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((Path)contentsHashesFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((Path)recordsFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)vfsDependentEnumBaseFile);
                    if (!(deleted &= myRootsFile == null || IOUtil.deleteAllFilesStartingWith((Path)myRootsFile))) {
                        throw new IOException("Cannot delete filesystem storage files");
                    }
                }
                catch (IOException e1) {
                    e1.addSuppressed(e);
                    LOG.warn("Cannot rebuild filesystem storage", (Throwable)e1);
                    return e1;
                }
                return e;
            }
        }

        private static void invalidateIndex(@NotNull String reason) {
            String[] children2;
            if (reason == null) {
                DbConnection.$$$reportNull$$$0(0);
            }
            LOG.info("Marking VFS as corrupted: " + reason);
            File indexRoot = PathManager.getIndexRoot();
            if (indexRoot.exists() && (children2 = indexRoot.list()) != null && children2.length > 0) {
                FileUtil.createIfDoesntExist((File)new File(PathManager.getIndexRoot(), "corruption.marker"));
            }
        }

        @NotNull
        private static String getCachesDir() {
            String dir = System.getProperty("caches_dir");
            Object object = dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
            if (object == null) {
                DbConnection.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static void markDirty() {
            assert (lock.isWriteLocked());
            if (!myDirty) {
                myDirty = true;
                myRecords.putInt(12L, 313341156);
            }
        }

        private static void setupFlushing() {
            if (!backgroundVfsFlush) {
                return;
            }
            myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                private int lastModCount;

                @Override
                public void run() {
                    if (this.lastModCount == ourLocalModificationCount) {
                        DbConnection.flush();
                    }
                    this.lastModCount = ourLocalModificationCount;
                }
            });
        }

        private static void doForce() {
            if (myNames != null && myFlushingFuture != null) {
                myNames.force();
                myAttributes.force();
                myContents.force();
                if (myContentHashesEnumerator != null) {
                    myContentHashesEnumerator.force();
                }
                DbConnection.markClean();
                myRecords.force();
            }
        }

        private static void flush() {
            if (DbConnection.isDirty() && !HeavyProcessLatch.INSTANCE.isRunning()) {
                FSRecords.readAndHandleErrors(() -> {
                    DbConnection.doForce();
                    return null;
                });
            }
        }

        public static boolean isDirty() {
            return myDirty || myNames.isDirty() || myAttributes.isDirty() || myContents.isDirty() || myRecords.isDirty() || myContentHashesEnumerator != null && myContentHashesEnumerator.isDirty();
        }

        private static int getVersion() {
            int recordsVersion = myRecords.getInt(0L);
            if (myAttributes.getVersion() != recordsVersion || myContents.getVersion() != recordsVersion) {
                return -1;
            }
            return recordsVersion;
        }

        private static long getTimestamp() {
            return myRecords.getLong(16L);
        }

        private static void setCurrentVersion() {
            myRecords.putInt(0L, VERSION);
            myRecords.putLong(16L, System.currentTimeMillis());
            myAttributes.setVersion(VERSION);
            myContents.setVersion(VERSION);
            myRecords.putInt(12L, 523190095);
        }

        static void cleanRecord(int id2) {
            myRecords.put((long)id2 * 40L, ZEROES, 0, 40);
        }

        private static PersistentStringEnumerator getNames() {
            return myNames;
        }

        private static void closeFiles() throws IOException {
            if (myFlushingFuture != null) {
                myFlushingFuture.cancel(false);
                myFlushingFuture = null;
            }
            if (myNames != null) {
                myNames.close();
                myNames = null;
            }
            if (myAttributes != null) {
                Disposer.dispose((Disposable)myAttributes);
                myAttributes = null;
            }
            if (myContents != null) {
                Disposer.dispose((Disposable)myContents);
                myContents = null;
            }
            if (myContentHashesEnumerator != null) {
                myContentHashesEnumerator.close();
                myContentHashesEnumerator = null;
            }
            if (myRecords != null) {
                DbConnection.markClean();
                myRecords.close();
                myRecords = null;
            }
            ourInitialized = false;
        }

        private static void markClean() {
            assert (lock.isWriteLocked() || lock.getReadHoldCount() != 0);
            if (myDirty) {
                myDirty = false;
                myRecords.putInt(12L, myCorrupted ? -1412464769 : 523190095);
            }
        }

        private static int getAttributeId(@NotNull String attId) throws IOException {
            if (attId == null) {
                DbConnection.$$$reportNull$$$0(2);
            }
            return myAttributesList.getIdRaw(attId, false) + FIRST_ATTR_ID_OFFSET;
        }

        @Contract(value="_->fail")
        private static void handleError(@NotNull Throwable e) throws RuntimeException, Error {
            if (e == null) {
                DbConnection.$$$reportNull$$$0(3);
            }
            assert (lock.getReadHoldCount() == 0);
            if (!ourIsDisposed) {
                w.lock();
                try {
                    if (!myCorrupted) {
                        DbConnection.createBrokenMarkerFile(e);
                        myCorrupted = true;
                        DbConnection.doForce();
                    }
                }
                finally {
                    w.unlock();
                }
            }
            ExceptionUtil.rethrow((Throwable)e);
        }

        static {
            myAttributesList = new VfsDependentEnum("attrib", EnumeratorStringDescriptor.INSTANCE, 1);
            myFreeRecords = new IntArrayList();
            REASONABLY_SMALL = new AttrPageAwareCapacityAllocationPolicy();
            RESERVED_ATTR_ID = bulkAttrReadSupport ? 1 : 0;
            FIRST_ATTR_ID_OFFSET = bulkAttrReadSupport ? RESERVED_ATTR_ID : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCachesDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invalidateIndex";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeId";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class AttrPageAwareCapacityAllocationPolicy
        extends CapacityAllocationPolicy {
            boolean myAttrPageRequested;

            private AttrPageAwareCapacityAllocationPolicy() {
            }

            public int calculateCapacity(int requiredLength) {
                return Math.max(this.myAttrPageRequested ? 8 : 32, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
            }
        }
    }
}

