/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.FilePathHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilePartNodeRoot
extends FilePartNode {
    private FilePartNodeRoot(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(0);
        }
        super(fs);
    }

    @Override
    public String toString() {
        return "root -> " + this.children.length;
    }

    @Override
    @NotNull
    CharSequence getName() {
        return "";
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(1);
        }
        int nameId = FilePartNodeRoot.getNameId(file2);
        NewVirtualFileSystem fs = (NewVirtualFileSystem)file2.getFileSystem();
        VirtualFile parent = FilePartNodeRoot.getParentThroughJar(file2, fs);
        VirtualFilePointerManagerImpl.NodeToUpdate nodeToUpdate = this.matchById(parent, file2, nameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)new MultiMap(), true, true, fs);
        if (nodeToUpdate == null) {
            FilePartNodeRoot.$$$reportNull$$$0(2);
        }
        return nodeToUpdate;
    }

    void addRelevantPointersFrom(@NotNull VirtualFileSystemEntry parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, @NotNull List<? super VirtualFilePointerManagerImpl.NodeToUpdate> toUpdateNodes, boolean addSubdirectoryPointers, @NotNull NewVirtualFileSystem fs, boolean addRecursiveDirectoryPointers, @NotNull VFileEvent event) {
        VirtualFilePointerManagerImpl.NodeToUpdate toUpdate;
        if (parent == null) {
            FilePartNodeRoot.$$$reportNull$$$0(3);
        }
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(4);
        }
        if (toUpdateNodes == null) {
            FilePartNodeRoot.$$$reportNull$$$0(5);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(6);
        }
        if (event == null) {
            FilePartNodeRoot.$$$reportNull$$$0(7);
        }
        if ((toUpdate = this.matchById((VirtualFile)parent, file2, childNameId, toFirePointers, false, addRecursiveDirectoryPointers, fs)) != null) {
            toUpdate.myEvent = event;
            toUpdateNodes.add(toUpdate);
            toUpdate.node.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, pointer));
            if (addSubdirectoryPointers) {
                FilePartNodeRoot.addAllPointersStrictlyUnder(toUpdate.node, toFirePointers);
            }
        }
    }

    private static void addAllPointersStrictlyUnder(@NotNull FilePartNode node, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        if (node == null) {
            FilePartNodeRoot.$$$reportNull$$$0(8);
        }
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(9);
        }
        for (FilePartNode child2 : node.children) {
            child2.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, pointer));
            FilePartNodeRoot.addAllPointersStrictlyUnder(child2, toFirePointers);
        }
    }

    @Contract(value="_, _, _, _, true, _, _ -> !null")
    private VirtualFilePointerManagerImpl.NodeToUpdate matchById(@Nullable VirtualFile parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, boolean createIfNotFound, boolean addRecursiveDirectoryPtr, @NotNull NewVirtualFileSystem fs) {
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(10);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(11);
        }
        if (childNameId <= 0 && childNameId != -2) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        List hierarchy = parent == null ? Collections.emptyList() : FilePartNodeRoot.getHierarchy(parent, fs);
        FilePartNode node = this;
        for (int i2 = hierarchy.size() - 1; i2 >= 0; --i2) {
            int nameId;
            VirtualFile part = (VirtualFile)hierarchy.get(i2);
            FilePartNode child2 = node.findChildByNameId(part, nameId = FilePartNodeRoot.getNameId(part), createIfNotFound, (NewVirtualFileSystem)part.getFileSystem());
            if (child2 == null) {
                return null;
            }
            if (child2 instanceof UrlPartNode) {
                child2 = child2.replaceWithFPPN(part, node);
            }
            if (addRecursiveDirectoryPtr) {
                child2.addRecursiveDirectoryPtrTo(toFirePointers);
            }
            node = child2;
        }
        FilePartNode child3 = node.findChildByNameId(file2, childNameId, createIfNotFound, fs);
        return child3 == null ? null : new VirtualFilePointerManagerImpl.NodeToUpdate(node, child3);
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        if (file2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(12);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(13);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        while (true) {
            result2.add(file2);
            file2 = FilePartNodeRoot.getParentThroughJar(file2, fs);
            if (file2 == null) break;
            fs = (NewVirtualFileSystem)file2.getFileSystem();
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            FilePartNodeRoot.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByPath(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        NullVirtualFile NEVER_TRIED_TO_FIND;
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(15);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(16);
        }
        List<String> names2 = FilePartNodeRoot.splitNames(path);
        NewVirtualFile fsRoot = null;
        NullVirtualFile currentFile = NEVER_TRIED_TO_FIND = NullVirtualFile.INSTANCE;
        FilePartNode currentNode = this;
        FilePartNodeRoot parentNode = this;
        LocalFileSystem currentFS = fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs;
        for (int i2 = names2.size() - 1; i2 >= 0; --i2) {
            int index;
            String name = names2.get(i2);
            if (name.equals("!/") && currentFS instanceof LocalFileSystem) {
                currentFS = fs;
            }
            if ((index = currentNode.binarySearchChildByName(name)) >= 0) {
                parentNode = currentNode;
                currentNode = currentNode.children[index];
                currentFile = currentFile == NEVER_TRIED_TO_FIND || currentFile == null ? currentFile : currentFile.findChild(name);
                continue;
            }
            if (currentFile == NEVER_TRIED_TO_FIND) {
                if (fsRoot == null) {
                    String rootPath = (String)ContainerUtil.getLastItem(names2);
                    fsRoot = ManagingFS.getInstance().findRoot(rootPath, (NewVirtualFileSystem)(fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs));
                    if (fsRoot != null && !FilePathHashingStrategy.create((boolean)fsRoot.isCaseSensitive()).equals((Object)fsRoot.getName(), (Object)rootPath)) {
                        fsRoot = null;
                    }
                }
                currentFile = fsRoot == null ? null : FilePartNodeRoot.findFileFromRoot(fsRoot, (NewVirtualFileSystem)currentFS, names2, i2);
            } else {
                VirtualFile virtualFile = currentFile = currentFile == null ? null : FilePartNodeRoot.findChildThroughJar((VirtualFile)currentFile, name, (NewVirtualFileSystem)currentFS);
            }
            FilePartNode child2 = currentFile == null ? new UrlPartNode(name, FilePartNodeRoot.myUrl(currentNode.myFileOrUrl), (NewVirtualFileSystem)currentFS) : new FilePartNode(name.equals("!/") ? -2 : FilePartNodeRoot.getNameId((VirtualFile)currentFile), currentFile, (NewVirtualFileSystem)currentFS);
            currentNode.children = (FilePartNode[])ArrayUtil.insert((Object[])currentNode.children, (int)(-index - 1), (Object)child2);
            parentNode = currentNode;
            currentNode = child2;
        }
        return new VirtualFilePointerManagerImpl.NodeToUpdate(parentNode, currentNode);
    }

    @NotNull
    static List<String> splitNames(@NotNull String path) {
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(17);
        }
        ArrayList<String> names2 = new ArrayList<String>(20);
        int end = path.length();
        if (end == 0) {
            ArrayList<String> arrayList = names2;
            if (arrayList == null) {
                FilePartNodeRoot.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        while (true) {
            boolean isJarSeparator;
            boolean bl = isJarSeparator = StringUtil.endsWith((CharSequence)path, (int)0, (int)end, (CharSequence)"!/") && end > 2 && path.charAt(end - 3) != '/';
            if (isJarSeparator) {
                names2.add("!/");
                end -= 2;
                continue;
            }
            if (path.charAt(end - 1) == '/') {
                --end;
            }
            if (end == 0 && path.charAt(0) == '/') {
                end = 1;
            }
            int startIndex = FilePartNodeRoot.extractName(path, end);
            assert (startIndex != end) : "startIndex: " + startIndex + "; end: " + end + "; path:'" + path + "'; toExtract: '" + path.substring(0, end) + "'";
            names2.add(path.substring(startIndex, end));
            if (startIndex == 0) break;
            end = startIndex;
        }
        ArrayList<String> arrayList = names2;
        if (arrayList == null) {
            FilePartNodeRoot.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static VirtualFile findFileFromRoot(@NotNull NewVirtualFile root, @NotNull NewVirtualFileSystem fs, @NotNull List<String> names2, int startIndex) {
        String name;
        if (root == null) {
            FilePartNodeRoot.$$$reportNull$$$0(20);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(21);
        }
        if (names2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(22);
        }
        NewVirtualFile file2 = root;
        for (int i2 = names2.size() - 2; i2 >= startIndex && (file2 = FilePartNodeRoot.findChildThroughJar((VirtualFile)file2, name = names2.get(i2), fs)) != null; --i2) {
        }
        return file2;
    }

    private static int extractName(@NotNull CharSequence path, int length) {
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(23);
        }
        if (length == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int i2 = StringUtil.lastIndexOf((CharSequence)path, (char)'/', (int)0, (int)length);
        if (i2 != -1 && PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)i2)) {
            return 0;
        }
        return i2 + 1;
    }

    void removePointer(@NotNull VirtualFilePointerImpl pointer) {
        FilePartNode node;
        int remainingLeaves;
        if (pointer == null) {
            FilePartNodeRoot.$$$reportNull$$$0(24);
        }
        if ((remainingLeaves = (node = pointer.myNode).removeLeaf(pointer)) == 0) {
            VirtualFile file2 = FilePartNodeRoot.myFile(node.myFileOrUrl);
            if (file2 == null) {
                List<String> parts = FilePartNodeRoot.splitNames(VfsUtilCore.urlToPath((String)FilePartNodeRoot.myUrl(node.myFileOrUrl)));
                this.removeEmptyNodesByPath(parts);
            } else {
                List<VirtualFile> parts = FilePartNodeRoot.getHierarchy(file2, (NewVirtualFileSystem)file2.getFileSystem());
                this.removeEmptyNodesByFile(parts);
            }
        }
    }

    void checkConsistency() {
        if (VirtualFilePointerManagerImpl.IS_UNDER_UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            this.doCheckConsistency(null, "", this.myFS.getProtocol() + "://");
        }
    }

    @NotNull
    static FilePartNodeRoot createFakeRoot(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(25);
        }
        return new FilePartNodeRoot(fs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePartNodeRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFirePointers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdateNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePartNodeRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateByFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateByFile";
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointersFrom";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersStrictlyUnder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchById";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateByPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "splitNames";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findFileFromRoot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFakeRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

