/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerStore;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.LocallyFoundJdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.PendingJdkRequest;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eJ\u0016\u0010$\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eH\u0002J#\u0010&\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u000b\u0012\t\u0018\u00010\u0016\u00a2\u0006\u0002\b(0'2\u0006\u0010)\u001a\u00020\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u001d\u0010+\u001a\n -*\u0004\u0018\u00010,0,*\u00020,2\u0006\u0010.\u001a\u00020\u0016H\u0082\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myPendingDownloads", "Ljava/util/HashMap;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/PendingJdkRequest;", "Lkotlin/collections/HashMap;", "defaultInstallDir", "Ljava/nio/file/Path;", "newVersion", "findAlreadyInstalledJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "feedItem", "findJdkItemForInstalledJdk", "jdkPath", "jdkHome", "", "installJdk", "", "request", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "installJdkImpl", "markerFile", "installDir", "prepareJdkInstallation", "jdkItem", "targetPath", "prepareJdkInstallationDirect", "prepareJdkInstallationImpl", "validateInstallDir", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "div", "Ljava/io/File;", "kotlin.jvm.PlatformType", "path", "Companion", "intellij.platform.lang.impl"})
public final class JdkInstaller {
    private final Logger LOG;
    private final ReentrantLock myLock;
    private final HashMap<JdkItem, PendingJdkRequest> myPendingDownloads;
    public static final Companion Companion = new Companion(null);

    private final File div(File $this$div, String path) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"$this$div");
        return new File($this$div, path).getAbsoluteFile();
    }

    @NotNull
    public final Path defaultInstallDir() {
        Path path;
        String explicitHome = System.getProperty("jdk.downloader.home");
        if (explicitHome != null) {
            Path path2 = Paths.get(explicitHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(explicitHome)");
            return path2;
        }
        String string = System.getProperty("user.home");
        if (string == null) {
            string = ".";
        }
        Path home = Paths.get(FileUtil.toCanonicalPath((String)string), new String[0]);
        if (SystemInfo.isLinux) {
            Path path3 = home.resolve(".jdks");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"home.resolve(\".jdks\")");
        } else if (SystemInfo.isMac) {
            Path path4 = home.resolve("Library/Java/JavaVirtualMachines");
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"home.resolve(\"Library/Java/JavaVirtualMachines\")");
        } else if (SystemInfo.isWindows) {
            Path path5 = home.resolve(".jdks");
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"home.resolve(\".jdks\")");
        } else {
            String string2 = "Unsupported OS: " + SystemInfo.getOsNameAndVersion();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return path;
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Path targetDir = this.defaultInstallDir().resolve(newVersion.getInstallFolderName());
        int count = 1;
        Path uniqueDir = targetDir;
        while (true) {
            Path path = uniqueDir;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"uniqueDir");
            if (!PathKt.exists((Path)path)) break;
            Path path2 = targetDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetDir");
            uniqueDir = path2.getParent().resolve("" + targetDir.getFileName() + '-' + count++);
        }
        Path path = uniqueDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"uniqueDir.toAbsolutePath()");
        return path;
    }

    @NotNull
    public final Pair<Path, String> validateInstallDir(@NotNull String selectedPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)selectedPath, (String)"selectedPath");
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.empty", (Object[])new Object[0]));
        }
        File[] fileArray = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = fileArray;
            boolean bl2 = false;
            $this$runCatching = Paths.get(FileUtil.expandUserHome((String)selectedPath), new String[0]);
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        fileArray = object;
        bl = false;
        boolean bl4 = false;
        File[] fileArray2 = Result.exceptionOrNull-impl((Object)fileArray);
        if (fileArray2 != null) {
            File[] t = fileArray2;
            boolean bl5 = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + t.getMessage(), (Throwable)t);
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.resolving.path", (Object[])new Object[0]));
        }
        Path targetDir = (Path)fileArray;
        if (Files.isRegularFile(targetDir, new LinkOption[0])) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.file", (Object[])new Object[0]));
        }
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            File[] fileArray3 = targetDir.toFile().listFiles();
            if (fileArray3 != null) {
                fileArray = fileArray3;
                bl = false;
                fileArray2 = fileArray;
                boolean bl6 = false;
                if (!(fileArray2.length == 0)) {
                    return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.nonEmpty.dir", (Object[])new Object[0]));
                }
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    public final void installJdk(@NotNull JdkInstallRequest request, @Nullable ProgressIndicator indicator, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof LocallyFoundJdk) {
            return;
        }
        if (request instanceof PendingJdkRequest) {
            ((PendingJdkRequest)request).tryStartInstallOrWait(indicator, (Function0<Unit>)((Function0)new Function0<Unit>(this, request, indicator, project){
                final /* synthetic */ JdkInstaller this$0;
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Project $project;

                public final void invoke() {
                    JdkInstaller.access$installJdkImpl(this.this$0, this.$request, this.$indicator, this.$project);
                }
                {
                    this.this$0 = jdkInstaller;
                    this.$request = jdkInstallRequest;
                    this.$indicator = progressIndicator;
                    this.$project = project;
                    super(0);
                }
            }));
            return;
        }
        this.LOG.error("Unexpected JdkInstallRequest: " + request + " of type " + request.getClass().getName());
        this.installJdkImpl(request, indicator, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void installJdkImpl(JdkInstallRequest request, ProgressIndicator indicator, Project project) {
        boolean $this$runCatching3222;
        Object object3;
        Object sizeDiff;
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<JdkInstallerListener>(request, project){
            final /* synthetic */ JdkInstallRequest $request;
            final /* synthetic */ Project $project;

            public final void accept(JdkInstallerListener it) {
                it.onJdkDownloadStarted(this.$request, this.$project);
            }
            {
                this.$request = jdkInstallRequest;
                this.$project = project;
            }
        });
        JdkItem item = request.getItem();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(ProjectBundle.message((String)"progress.text.installing.jdk.1", (Object[])new Object[]{item.getFullPresentationText()}));
        }
        Path targetDir = request.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            String string = "Cannot parse download URL: " + item.getUrl();
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            String string = "URL must use https:// protocol, but was: " + url2;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText2(ProjectBundle.message((String)"progress.text2.downloading.jdk", (Object[])new Object[0]));
        }
        Path downloadFile = Paths.get(PathManager.getTempPath(), "jdk-" + System.nanoTime() + '-' + item.getArchiveFileName());
        try {
            boolean bl;
            Object $this$runCatching22222;
            Object object;
            try {
                HttpRequests.request((String)item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile.toFile(), indicator);
                Path path = downloadFile;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"downloadFile");
                if (!PathKt.isFile((Path)path)) {
                    throw (Throwable)new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
                throw t;
            }
            JdkInstaller jdkInstaller = this;
            boolean bl4 = false;
            try {
                object = Result.Companion;
                $this$runCatching22222 = jdkInstaller;
                boolean bl5 = false;
                $this$runCatching22222 = Files.size(downloadFile) - item.getArchiveSize();
                bl5 = false;
                object = Result.constructor-impl((Object)$this$runCatching22222);
            }
            catch (Throwable $this$runCatching22222) {
                Result.Companion bl5 = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching22222));
            }
            jdkInstaller = object;
            bl4 = false;
            sizeDiff = (Long)((Object)(Result.isFailure-impl((Object)jdkInstaller) ? null : jdkInstaller));
            Long l = sizeDiff;
            if (l == null || l != 0L) {
                Object object2;
                StringBuilder stringBuilder = new StringBuilder().append("The downloaded ").append(item.getFullPresentationText()).append(" has incorrect file size,\n").append("the difference is ");
                Long l2 = sizeDiff;
                if (l2 != null) {
                    long l3 = l2;
                    boolean bl6 = false;
                    object2 = Math.abs(l3);
                    throw (Throwable)new RuntimeException(stringBuilder.append(object2).append(" bytes.\n").append("Check your internet connection and try again later").toString());
                }
                object2 = "unknown";
                throw (Throwable)new RuntimeException(stringBuilder.append(object2).append(" bytes.\n").append("Check your internet connection and try again later").toString());
            }
            object3 = this;
            boolean bl7 = false;
            try {
                $this$runCatching22222 = Result.Companion;
                Object $this$runCatching3222 = object3;
                boolean bl8 = false;
                $this$runCatching3222 = com.google.common.io.Files.asByteSource((File)downloadFile.toFile()).hash(Hashing.sha256()).toString();
                bl = false;
                $this$runCatching22222 = Result.constructor-impl((Object)$this$runCatching3222);
            }
            catch (Throwable $this$runCatching3222) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                $this$runCatching22222 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching3222));
            }
            object3 = $this$runCatching22222;
            bl7 = false;
            String actualHashCode = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder().append("Failed to verify SHA-256 checksum for ").append(item.getFullPresentationText()).append("\n\n").append("The actual value is ");
                String string = actualHashCode;
                if (string != null) {
                    throw (Throwable)new RuntimeException(stringBuilder.append(string).append(",\n").append("but expected ").append(item.getSha256()).append(" was expected\n").append("Check your internet connection and try again later").toString());
                }
                string = "unknown";
                throw (Throwable)new RuntimeException(stringBuilder.append(string).append(",\n").append("but expected ").append(item.getSha256()).append(" was expected\n").append("Check your internet connection and try again later").toString());
            }
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator4 = indicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setText2(ProjectBundle.message((String)"progress.text2.unpacking.jdk", (Object[])new Object[0]));
            }
            try {
                boolean bl10;
                Object object4;
                Decompressor decompressor = item.getPackageType().openDecompressor(downloadFile);
                decompressor.postProcessor((Consumer)new Consumer<Path>(indicator){
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final void accept(Path it) {
                        block0: {
                            ProgressIndicator progressIndicator = this.$indicator;
                            if (progressIndicator == null) break block0;
                            progressIndicator.checkCanceled();
                        }
                    }
                    {
                        this.$indicator = progressIndicator;
                    }
                });
                String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])new char[]{'/'});
                if (!StringsKt.isBlank((CharSequence)fullMatchPath)) {
                    decompressor.removePrefixPath(fullMatchPath);
                }
                decompressor.extract(targetDir);
                $this$runCatching22222 = this;
                $this$runCatching3222 = false;
                try {
                    object4 = Result.Companion;
                    JdkInstaller $this$runCatching42 = (JdkInstaller)$this$runCatching22222;
                    boolean bl11 = false;
                    $this$runCatching42.writeMarkerFile(request);
                    $this$runCatching42 = Unit.INSTANCE;
                    bl11 = false;
                    object4 = Result.constructor-impl((Object)$this$runCatching42);
                }
                catch (Throwable $this$runCatching42) {
                    Result.Companion bl11 = Result.Companion;
                    bl10 = false;
                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching42));
                }
                $this$runCatching22222 = this;
                $this$runCatching3222 = false;
                try {
                    object4 = Result.Companion;
                    JdkInstaller $this$runCatching = (JdkInstaller)$this$runCatching22222;
                    boolean bl12 = false;
                    boolean $i$f$service = false;
                    Object object5 = ApplicationManager.getApplication().getService(JdkInstallerStore.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                    ((JdkInstallerStore)((Object)object5)).registerInstall(item, targetDir);
                    Unit unit = Unit.INSTANCE;
                    boolean bl13 = false;
                    object4 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    bl10 = false;
                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
                throw t;
            }
            sizeDiff = this;
            boolean bl14 = false;
        }
        catch (Throwable t) {
            try {
                PathKt.delete$default((Path)targetDir, (boolean)false, (int)1, null);
                Path path = this.markerFile(targetDir);
                if (path == null) throw t;
                PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                throw t;
            }
            catch (Throwable throwable) {
                JdkInstaller jdkInstaller2 = this;
                boolean bl16 = false;
                try {
                    Object object6 = Result.Companion;
                    JdkInstaller $this$runCatching6 = jdkInstaller2;
                    boolean bl17 = false;
                    FileUtil.delete((Path)downloadFile);
                    Unit unit = Unit.INSTANCE;
                    boolean bl18 = false;
                    object6 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    boolean bl19 = false;
                    Object object7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<JdkInstallerListener>(request, project){
                    final /* synthetic */ JdkInstallRequest $request;
                    final /* synthetic */ Project $project;

                    public final void accept(JdkInstallerListener it) {
                        it.onJdkDownloadFinished(this.$request, this.$project);
                    }
                    {
                        this.$request = jdkInstallRequest;
                        this.$project = project;
                    }
                });
                throw throwable;
            }
        }
        try {
            object3 = Result.Companion;
            JdkInstaller $this$runCatching5 = (JdkInstaller)sizeDiff;
            boolean bl15 = false;
            FileUtil.delete((Path)downloadFile);
            Unit unit = Unit.INSTANCE;
            bl15 = false;
            object3 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion bl15 = Result.Companion;
            $this$runCatching3222 = false;
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        JdkInstallRequest existingRequest;
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (Registry.is((String)"jdk.downloader.reuse.installed") && (existingRequest = this.findAlreadyInstalledJdk(jdkItem)) != null) {
            return existingRequest;
        }
        if (Registry.is((String)"jdk.downloader.reuse.downloading")) {
            PendingJdkRequest pendingJdkRequest;
            Lock lock = this.myLock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                PendingJdkRequest pendingJdkRequest2 = this.myPendingDownloads.computeIfAbsent(jdkItem, new Function<JdkItem, PendingJdkRequest>(this, jdkItem, targetPath){
                    final /* synthetic */ JdkInstaller this$0;
                    final /* synthetic */ JdkItem $jdkItem$inlined;
                    final /* synthetic */ Path $targetPath$inlined;
                    {
                        this.this$0 = jdkInstaller;
                        this.$jdkItem$inlined = jdkItem;
                        this.$targetPath$inlined = path;
                    }

                    @NotNull
                    public final PendingJdkRequest apply(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstaller.access$prepareJdkInstallationImpl(this.this$0, this.$jdkItem$inlined, this.$targetPath$inlined);
                    }
                });
                pendingJdkRequest = pendingJdkRequest2;
            }
            finally {
                lock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)pendingJdkRequest, (String)"myLock.withLock {\n      \u2026em, targetPath) }\n      }");
            return pendingJdkRequest;
        }
        return this.prepareJdkInstallationDirect(jdkItem, targetPath);
    }

    @NotNull
    public final JdkInstallRequest prepareJdkInstallationDirect(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    /*
     * WARNING - void declaration
     */
    private final PendingJdkRequest prepareJdkInstallationImpl(JdkItem jdkItem, Path targetPath) {
        void home;
        Pair<Path, String> pair = this.validateInstallDir(((Object)targetPath).toString());
        Path path = (Path)pair.component1();
        String error = (String)pair.component2();
        if (home == null || error != null) {
            String string = error;
            if (string == null) {
                string = "Invalid Target Directory";
            }
            throw (Throwable)new RuntimeException(string);
        }
        Path javaHome = jdkItem.resolveJavaHome(targetPath);
        Files.createDirectories(javaHome, new FileAttribute[0]);
        PendingJdkRequest request = new PendingJdkRequest(jdkItem, targetPath, javaHome);
        this.writeMarkerFile(request);
        return request;
    }

    private final Path markerFile(Path installDir) {
        Path path = installDir.getParent();
        return path != null ? path.resolve("" + '.' + installDir.getFileName() + ".intellij") : null;
    }

    private final void writeMarkerFile(JdkInstallRequest request) {
        Path installDir = request.getInstallDir();
        Path path = this.markerFile(installDir);
        if (path == null) {
            return;
        }
        Path markerFile2 = path;
        try {
            request.getItem().writeMarkerFile(markerFile2);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            this.LOG.warn("Failed to write marker file to " + markerFile2 + ". " + t.getMessage(), t);
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable String jdkHome) {
        try {
            if (jdkHome == null) {
                return null;
            }
            Path jdkPath = Paths.get(jdkHome, new String[0]);
            return this.findJdkItemForInstalledJdk(jdkPath);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable Path jdkPath) {
        try {
            Object v0;
            block6: {
                if (jdkPath == null) {
                    return null;
                }
                if (!PathKt.isDirectory((Path)jdkPath)) {
                    return null;
                }
                Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)jdkPath, (Function1)findJdkItemForInstalledJdk.markerFile.1.INSTANCE), (Function1)findJdkItemForInstalledJdk.markerFile.2.INSTANCE), (int)5), (Function1)((Function1)new Function1<Path, Path>(this){
                    final /* synthetic */ JdkInstaller this$0;

                    @Nullable
                    public final Path invoke(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstaller.access$markerFile(this.this$0, it);
                    }
                    {
                        this.this$0 = jdkInstaller;
                        super(1);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!PathKt.isFile((Path)it)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path = v0;
            if (path == null) {
                return null;
            }
            Path markerFile2 = path;
            ObjectNode json = JdkListParser.INSTANCE.readTree(PathKt.readBytes((Path)markerFile2));
            return JdkListParser.INSTANCE.parseJdkItem(json, JdkPredicate.Companion.createInstance());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private final JdkInstallRequest findAlreadyInstalledJdk(JdkItem feedItem) {
        try {
            List list2;
            JdkInstaller jdkInstaller = this;
            boolean bl = false;
            boolean bl2 = false;
            JdkInstaller $this$run = jdkInstaller;
            boolean bl3 = false;
            Path defaultInstallDir = $this$run.defaultInstallDir();
            if (!PathKt.isDirectory((Path)defaultInstallDir)) {
                boolean bl4 = false;
                list2 = CollectionsKt.emptyList();
            } else {
                Stream<Path> stream = Files.list(defaultInstallDir);
                Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(defaultInstallDir)");
                list2 = StreamsKt.toList(stream);
            }
            List localRoots = list2;
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(JdkInstallerStore.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            List<Path> historyRoots = ((JdkInstallerStore)((Object)object)).findInstallations(feedItem);
            Iterator iterator2 = CollectionsKt.plus((Collection)localRoots, (Iterable)historyRoots).iterator();
            while (iterator2.hasNext()) {
                Path jdkHome;
                JdkItem item;
                Path installDir;
                Path path = installDir = (Path)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"installDir");
                if (!PathKt.isDirectory((Path)path)) continue;
                if (this.findJdkItemForInstalledJdk(installDir) == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)item, (Object)feedItem) ^ true || !PathKt.isDirectory((Path)(jdkHome = item.resolveJavaHome(installDir))) || !JdkUtil.checkForJdk((File)jdkHome.toFile())) continue;
                return new LocallyFoundJdk(feedItem, installDir, jdkHome);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    public JdkInstaller() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        this.myLock = new ReentrantLock();
        this.myPendingDownloads = new HashMap();
    }

    public static final /* synthetic */ void access$installJdkImpl(JdkInstaller $this, JdkInstallRequest request, ProgressIndicator indicator, Project project) {
        $this.installJdkImpl(request, indicator, project);
    }

    public static final /* synthetic */ PendingJdkRequest access$prepareJdkInstallationImpl(JdkInstaller $this, JdkItem jdkItem, Path targetPath) {
        return $this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    public static final /* synthetic */ Path access$markerFile(JdkInstaller $this, Path installDir) {
        return $this.markerFile(installDir);
    }

    @JvmStatic
    @NotNull
    public static final JdkInstaller getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdkInstaller getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(JdkInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (JdkInstaller)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

