/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class DumbServiceSyncTaskQueue {
    private final AtomicBoolean myIsRunning;
    private final DumbServiceMergingTaskQueue myTaskQueue;

    public DumbServiceSyncTaskQueue(@NotNull DumbServiceMergingTaskQueue queue2) {
        if (queue2 == null) {
            DumbServiceSyncTaskQueue.$$$reportNull$$$0(0);
        }
        this.myIsRunning = new AtomicBoolean(false);
        this.myTaskQueue = queue2;
    }

    public void runTaskSynchronously(@NotNull DumbModeTask task2) {
        if (task2 == null) {
            DumbServiceSyncTaskQueue.$$$reportNull$$$0(1);
        }
        this.myTaskQueue.addTask(task2);
        if (!this.myIsRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processQueue();
        }
        finally {
            this.myIsRunning.set(false);
        }
    }

    private void processQueue() {
        while (true) {
            DumbServiceMergingTaskQueue.QueuedDumbModeTask nextTask = this.myTaskQueue.extractNextTask();
            try {
                if (nextTask == null) break;
                DumbServiceSyncTaskQueue.doRunTaskSynchronously(nextTask);
                continue;
            }
            finally {
                if (nextTask == null) continue;
                nextTask.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRunTaskSynchronously(@NotNull DumbServiceMergingTaskQueue.QueuedDumbModeTask task2) {
        ProgressIndicator indicator;
        if (task2 == null) {
            DumbServiceSyncTaskQueue.$$$reportNull$$$0(2);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        indicator.pushState();
        ((CoreProgressManager)ProgressManager.getInstance()).suppressPrioritizing();
        try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted(IdeBundle.message((String)"progress.performing.indexing.tasks", (Object[])new Object[0]), HeavyProcessLatch.Type.Indexing);){
            task2.executeTask(indicator);
        }
        finally {
            ((CoreProgressManager)ProgressManager.getInstance()).restorePrioritizing();
            indicator.popState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceSyncTaskQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskSynchronously";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunTaskSynchronously";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

