/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger LOG = Logger.getInstance(AbstractExternalSystemTask.class);
    private final AtomicReference<ExternalSystemTaskState> myState;
    private final AtomicReference<Throwable> myError;
    @NotNull
    private final transient Project myIdeProject;
    @NotNull
    private final ExternalSystemTaskId myId;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectPath;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id2, @NotNull ExternalSystemTaskType type, @NotNull Project project, @NotNull String externalProjectPath) {
        if (id2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(2);
        }
        if (externalProjectPath == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(3);
        }
        this.myState = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
        this.myError = new AtomicReference();
        this.myExternalSystemId = id2;
        this.myIdeProject = project;
        this.myId = ExternalSystemTaskId.create((ProjectSystemId)id2, (ExternalSystemTaskType)type, (Project)this.myIdeProject);
        this.myExternalProjectPath = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(4);
        }
        return projectSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.myId;
        if (externalSystemTaskId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(5);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        ExternalSystemTaskState externalSystemTaskState = this.myState.get();
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(6);
        }
        return externalSystemTaskState;
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(7);
        }
        this.myState.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update2) {
        if (expect == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(8);
        }
        if (update2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(9);
        }
        return this.myState.compareAndSet(expect, update2);
    }

    public Throwable getError() {
        return this.myError.get();
    }

    @NotNull
    public Project getIdeProject() {
        Project project = this.myIdeProject;
        if (project == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.myExternalProjectPath;
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ApplicationManager.getApplication().getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade facade = manager.getFacade(this.myIdeProject, this.myExternalProjectPath, this.myExternalSystemId);
                this.setState(facade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable e) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.myError.set(e);
                if (this.myIdeProject.isDisposed()) break block3;
                LOG.warn(e);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(12);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(13);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter2 = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractExternalSystemTask.this.updateProgressIndicator(event, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$1", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter2) : new ExternalSystemTaskNotificationListener[]{adapter2};
        this.execute(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(14);
        }
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class);
        try {
            processingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            this.myError.set(e);
            this.setState(ExternalSystemTaskState.FAILED);
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myError.set(e);
            this.setState(ExternalSystemTaskState.FAILED);
        }
        finally {
            processingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(15);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(16);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter2 = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$2", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter2) : new ExternalSystemTaskNotificationListener[]{adapter2};
        return this.cancel(ls);
    }

    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState currentTaskState;
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(17);
        }
        if ((currentTaskState = this.getState()).isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        if (!this.compareAndSetState(currentTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        try {
            return this.doCancel();
        }
        catch (NotSupportedException e) {
            NotificationData notification2 = new NotificationData("Cancellation failed", e.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notification2.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notification2);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        return false;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    @NlsContexts.ProgressText
    protected String wrapProgressText(@NotNull String text2) {
        if (text2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(18);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), text2});
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(19);
        }
        return string;
    }

    public int hashCode() {
        return this.myId.hashCode() + this.myExternalSystemId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalSystemTask task2 = (AbstractExternalSystemTask)((Object)o);
        return this.myId.equals((Object)task2.myId) && this.myExternalSystemId.equals((Object)task2.myExternalSystemId);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.myExternalSystemId.getReadableName(), this.myId, this.myState);
    }

    private void updateProgressIndicator(@NotNull ExternalSystemTaskNotificationEvent event, @NotNull ProgressIndicator indicator) {
        String sizeInfo;
        String unit;
        long progress2;
        long total;
        ProgressBuildEvent progressEvent;
        if (event == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(21);
        }
        if (event instanceof ExternalSystemBuildEvent && ((ExternalSystemBuildEvent)event).getBuildEvent() instanceof ProgressBuildEvent) {
            progressEvent = (ProgressBuildEvent)((ExternalSystemBuildEvent)event).getBuildEvent();
            total = progressEvent.getTotal();
            progress2 = progressEvent.getProgress();
            unit = progressEvent.getUnit();
        } else if (event instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemStatusEvent) {
            progressEvent = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
            total = progressEvent.getTotal();
            progress2 = progressEvent.getProgress();
            unit = progressEvent.getUnit();
        } else {
            return;
        }
        if (total <= 0L) {
            indicator.setIndeterminate(true);
            sizeInfo = "bytes".equals(unit) ? StringUtil.formatFileSize((long)progress2) + " / ?" : "";
        } else {
            indicator.setIndeterminate(false);
            indicator.setFraction((double)progress2 / (double)total);
            sizeInfo = "bytes".equals(unit) ? StringUtil.formatFileSize((long)progress2) + " / " + StringUtil.formatFileSize((long)total) : "";
        }
        String description = event.getDescription();
        indicator.setText(this.wrapProgressText(description) + (String)(sizeInfo.isEmpty() ? "" : "  (" + sizeInfo + ")"));
    }

    @NotNull
    protected static ExternalSystemTaskNotificationListener wrapWithListener(final @NotNull ExternalSystemProgressNotificationManagerImpl manager) {
        if (manager == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(22);
        }
        return new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                manager.onStatusChange(event);
            }

            public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text2, boolean stdOut) {
                if (id2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (text2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                manager.onTaskOutput(id2, text2, stdOut);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStatusChange";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTaskOutput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateProgressIndicator";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

