/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TechnicalSupportAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TechnicalSupportAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setVisible(ApplicationInfoImpl.getShadowInstance().getSupportUrl() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TechnicalSupportAction.$$$reportNull$$$0(1);
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String urlTemplate = appInfo.getSupportUrl();
        String url = urlTemplate.replace("$BUILD", appInfo.getBuild().asStringWithoutProductCode()).replace("$OS", TechnicalSupportAction.getOSName()).replace("$TIMEZONE", System.getProperty("user.timezone"));
        BrowserUtil.browse((String)StringUtil.replace((String)url, (String)" ", (String)"%20"), (Project)e.getProject());
    }

    @NonNls
    private static String getOSName() {
        Object name = "";
        if (SystemInfo.isWindows) {
            name = (String)name + "win-";
            name = (String)name + TechnicalSupportAction.getWindowsVersion();
            if (SystemInfo.is64Bit) {
                name = (String)name + "-64";
            }
        } else if (SystemInfo.isLinux) {
            name = (String)name + "linux";
        } else if (SystemInfo.isSolaris) {
            name = (String)name + "solaris";
        } else if (SystemInfo.isMac) {
            name = (String)name + "mac";
            if (!SystemInfo.isOsVersionAtLeast((String)"10.8")) {
                name = (String)name + "-old";
            }
        } else {
            name = (String)name + "other-os";
        }
        return name;
    }

    private static boolean isWindowsVersion(String version2) {
        return StringUtil.compareVersionNumbers((String)SystemInfo.OS_VERSION, (String)version2) == 0;
    }

    @NonNls
    private static String getWindowsVersion() {
        if (TechnicalSupportAction.isWindowsVersion("5.1")) {
            return "xp";
        }
        if (TechnicalSupportAction.isWindowsVersion("5.2")) {
            return "2003";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.0")) {
            return "vista";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.1")) {
            return "7";
        }
        if (TechnicalSupportAction.isWindowsVersion("6.2")) {
            return "8";
        }
        if (TechnicalSupportAction.isWindowsVersion("10.0")) {
            return "10";
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/TechnicalSupportAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

