/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.find.FindBundle;
import com.intellij.find.actions.CustomTargetVariant;
import com.intellij.find.actions.PsiTargetVariant;
import com.intellij.find.actions.ResolverKt$findShowUsages$1;
import com.intellij.find.actions.SearchTargetVariant;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.navigation.ChooserKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"allTargets", "", "Lcom/intellij/find/actions/TargetVariant;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "findShowUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "popupTitle", "", "handler", "Lcom/intellij/find/actions/UsageVariantHandler;", "searchTargets", "Lcom/intellij/find/usages/api/SearchTarget;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class ResolverKt {
    public static final void findShowUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull List<? extends TargetVariant> allTargets, @NlsContexts.PopupTitle @NotNull String popupTitle, @NotNull UsageVariantHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter(allTargets, (String)"allTargets");
        Intrinsics.checkNotNullParameter((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        switch (allTargets.size()) {
            case 0: {
                Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
                String string = FindBundle.message("find.no.usages.at.cursor.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FindBundle.message(\"find\u2026.usages.at.cursor.error\")");
                String message = string;
                if (editor == null) {
                    Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    break;
                }
                HintManager.getInstance().showErrorHint(editor, message);
                break;
            }
            case 1: {
                ((TargetVariant)CollectionsKt.single(allTargets)).handle(handler2);
                break;
            }
            default: {
                ChooserKt.chooseTargetPopup(popupTitle, allTargets, (Function1)ResolverKt$findShowUsages$1.INSTANCE, (Function1)new Function1<TargetVariant, Unit>(handler2){
                    final /* synthetic */ UsageVariantHandler $handler;

                    public final void invoke(@NotNull TargetVariant it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.handle(this.$handler);
                    }
                    {
                        this.$handler = usageVariantHandler;
                        super(1);
                    }
                }).showInBestPositionFor(dataContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TargetVariant> allTargets(@NotNull DataContext dataContext) {
        TargetVariant targetVariant;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ArrayList allTargets = new ArrayList();
        Iterable $this$mapTo$iv = ResolverKt.searchTargets(dataContext);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p1;
            SearchTarget searchTarget = (SearchTarget)item$iv;
            collection = allTargets;
            boolean bl = false;
            targetVariant = new SearchTargetVariant((SearchTarget)p1);
            collection.add(targetVariant);
        }
        UsageTarget[] usageTargets = (UsageTarget[])dataContext.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets == null) {
            Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                int offset = caretModel.getOffset();
                PsiReference reference2 = TargetElementUtil.findReference(editor, offset);
                if (reference2 != null) {
                    Collection<PsiElement> collection2 = TargetElementUtil.getInstance().getTargetCandidates(reference2);
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"TargetElementUtil.getIns\u2026rgetCandidates(reference)");
                    Iterable $this$mapTo$iv2 = collection2;
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv : $this$mapTo$iv2) {
                        void p1;
                        PsiElement psiElement = (PsiElement)item$iv;
                        collection = allTargets;
                        boolean bl = false;
                        targetVariant = new PsiTargetVariant((PsiElement)p1);
                        collection.add(targetVariant);
                    }
                }
            }
        } else {
            TargetVariant targetVariant2;
            UsageTarget target2 = usageTargets[0];
            Collection collection3 = allTargets;
            if (target2 instanceof PsiElement2UsageTargetAdapter) {
                PsiElement psiElement = ((PsiElement2UsageTargetAdapter)target2).getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"target.element");
                targetVariant2 = new PsiTargetVariant(psiElement);
            } else {
                targetVariant2 = new CustomTargetVariant(target2);
            }
            TargetVariant targetVariant3 = targetVariant2;
            boolean bl = false;
            collection3.add(targetVariant3);
        }
        return allTargets;
    }

    private static final List<SearchTarget> searchTargets(DataContext dataContext) {
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"dataContext.getData(Comm\u2026LE) ?: return emptyList()");
        PsiFile file2 = psiFile;
        Caret caret = (Caret)dataContext.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return CollectionsKt.emptyList();
        }
        int offset = caret.getOffset();
        return ImplKt.symbolSearchTargets(file2, offset);
    }
}

