/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.actions.BaseViewAction;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.content.Content;

public class CloseViewAction
extends BaseViewAction {
    protected void update(AnActionEvent e, ViewContext context, Content[] content2) {
        this.setEnabled(e, CloseViewAction.isEnabled(content2));
        boolean unpinAction = CloseViewAction.isUnpinAction(e, content2);
        if (unpinAction) {
            if (!Registry.get((String)"ide.editor.tabs.interactive.pin.button").asBoolean()) {
                e.getPresentation().setText("");
            } else {
                e.getPresentation().setText(TextWithMnemonic.parse((String)IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0])).dropMnemonic(true).getText());
            }
        }
        e.getPresentation().setIcon(unpinAction ? AllIcons.Actions.PinTab : AllIcons.Actions.Close);
        e.getPresentation().setHoveredIcon(unpinAction ? AllIcons.Actions.PinTab : AllIcons.Actions.CloseHovered);
    }

    protected void actionPerformed(AnActionEvent e, ViewContext context, Content[] content2) {
        if (CloseViewAction.isUnpinAction(e, content2)) {
            if (Registry.get((String)"ide.editor.tabs.interactive.pin.button").asBoolean()) {
                content2[0].setPinned(false);
            }
            return;
        }
        CloseViewAction.perform(context, content2[0]);
    }

    public static boolean perform(ViewContext context, Content content2) {
        return context.getContentManager().removeContent(content2, context.isToDisposeRemovedContent());
    }

    public static boolean isEnabled(Content[] content2) {
        return content2.length == 1 && content2[0].isCloseable();
    }

    private static boolean isUnpinAction(AnActionEvent e, Content[] content2) {
        return content2.length == 1 && content2[0].isPinnable() && content2[0].isPinned() && !ViewContext.isPopupPlace((String)e.getPlace());
    }
}

