/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateAction
extends BaseRunConfigurationAction {
    public CreateAction() {
        super(ExecutionBundle.messagePointer((String)"create.run.configuration.action.name", (Object[])new Object[0]), Presentation.NULL_STRING, null);
    }

    @Override
    protected void perform(ConfigurationContext context) {
        CreateAction.choosePolicy(context).perform(context);
    }

    @Override
    protected void updatePresentation(Presentation presentation2, @NotNull String actionText, ConfigurationContext context) {
        if (actionText == null) {
            CreateAction.$$$reportNull$$$0(0);
        }
        CreateAction.choosePolicy(context).update(presentation2, context, actionText);
    }

    private static BaseCreatePolicy choosePolicy(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        return configuration == null ? Holder.CREATE_AND_EDIT : Holder.EDIT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction", "updatePresentation"));
    }

    private static class Holder {
        private static final BaseCreatePolicy CREATE_AND_EDIT = new CreateAndEditPolicy();
        private static final BaseCreatePolicy EDIT = new EditPolicy();

        private Holder() {
        }
    }

    private static class EditPolicy
    extends CreateAndEditPolicy {
        private EditPolicy() {
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.getConfiguration();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}));
            }
        }
    }

    private static class CreateAndEditPolicy
    extends BaseCreatePolicy {
        private CreateAndEditPolicy() {
        }

        @Override
        protected void updateText(Presentation presentation2, String actionText) {
            presentation2.setText(ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), false);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.getConfiguration();
            if (ApplicationManager.getApplication().isUnitTestMode() || RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
                runManager.addConfiguration(configuration);
                runManager.setSelectedConfiguration(configuration);
            }
        }
    }

    private static abstract class BaseCreatePolicy {
        private BaseCreatePolicy() {
        }

        public void update(Presentation presentation2, ConfigurationContext context, @NotNull String actionText) {
            if (actionText == null) {
                BaseCreatePolicy.$$$reportNull$$$0(0);
            }
            this.updateText(presentation2, actionText);
            this.updateIcon(presentation2, context);
        }

        protected void updateIcon(Presentation presentation2, ConfigurationContext context) {
            List fromContext = context.getConfigurationsFromContext();
            if (fromContext == null || fromContext.size() == 1) {
                presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
                presentation2.setIcon(AllIcons.General.Settings);
            }
        }

        protected abstract void updateText(Presentation var1, String var2);

        public abstract void perform(ConfigurationContext var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction$BaseCreatePolicy", "update"));
        }
    }
}

