/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.LineFragmentSplitter;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.MergingCharSequence;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ByWord {
    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(3);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        return ByWord.compare(text1, words1, text2, words2, policy, indicator);
    }

    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull List<? extends InlineChunk> words1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(4);
        }
        if (words1 == null) {
            ByWord.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(6);
        }
        if (words2 == null) {
            ByWord.$$$reportNull$$$0(7);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(9);
        }
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWord.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        FairDiffIterable delimitersIterable = ByWord.matchAdjustmentDelimiters(text1, text2, words1, words2, wordChanges, indicator);
        DiffIterable iterable = ByWord.matchAdjustmentWhitespaces(text1, text2, delimitersIterable, policy, indicator);
        List<DiffFragment> list2 = ComparisonManagerImpl.convertIntoDiffFragments(iterable);
        if (list2 == null) {
            ByWord.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public static List<MergeWordFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(12);
        }
        if (text3 == null) {
            ByWord.$$$reportNull$$$0(13);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(15);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        List<InlineChunk> words3 = ByWord.getInlineChunks(text3);
        FairDiffIterable wordChanges1 = DiffIterableUtil.diff(words2, words1, indicator);
        wordChanges1 = ByWord.optimizeWordChunks(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable iterable1 = ByWord.matchAdjustmentDelimiters(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable wordChanges2 = DiffIterableUtil.diff(words2, words3, indicator);
        wordChanges2 = ByWord.optimizeWordChunks(text2, text3, words2, words3, wordChanges2, indicator);
        FairDiffIterable iterable2 = ByWord.matchAdjustmentDelimiters(text2, text3, words2, words3, wordChanges2, indicator);
        List<MergeRange> wordConflicts = ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
        List<MergeRange> result2 = ByWord.matchAdjustmentWhitespaces(text1, text2, text3, wordConflicts, policy, indicator);
        List<MergeWordFragment> list2 = ComparisonManagerImpl.convertIntoMergeWordFragments(result2);
        if (list2 == null) {
            ByWord.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public static List<LineBlock> compareAndSplit(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(18);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(20);
        }
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWord.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        List<LineFragmentSplitter.WordBlock> wordBlocks = new LineFragmentSplitter(text1, text2, words1, words2, wordChanges, indicator).run();
        ArrayList<LineBlock> lineBlocks = new ArrayList<LineBlock>(wordBlocks.size());
        for (LineFragmentSplitter.WordBlock block : wordBlocks) {
            Range offsets2 = block.offsets;
            Range words = block.words;
            CharSequence subtext1 = text1.subSequence(offsets2.start1, offsets2.end1);
            CharSequence subtext2 = text2.subSequence(offsets2.start2, offsets2.end2);
            List<InlineChunk> subwords1 = words1.subList(words.start1, words.end1);
            List<InlineChunk> subwords2 = words2.subList(words.start2, words.end2);
            FairDiffIterable subiterable = DiffIterableUtil.fair(DiffIterableUtil.subiterable(wordChanges, words.start1, words.end1, words.start2, words.end2));
            FairDiffIterable delimitersIterable = ByWord.matchAdjustmentDelimiters(subtext1, subtext2, subwords1, subwords2, subiterable, offsets2.start1, offsets2.start2, indicator);
            DiffIterable iterable = ByWord.matchAdjustmentWhitespaces(subtext1, subtext2, delimitersIterable, policy, indicator);
            List<DiffFragment> fragments = ComparisonManagerImpl.convertIntoDiffFragments(iterable);
            int newlines1 = ByWord.countNewlines(subwords1);
            int newlines2 = ByWord.countNewlines(subwords2);
            lineBlocks.add(new LineBlock(fragments, offsets2, newlines1, newlines2));
        }
        ArrayList<LineBlock> arrayList = lineBlocks;
        if (arrayList == null) {
            ByWord.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    private static FairDiffIterable optimizeWordChunks(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(23);
        }
        if (words1 == null) {
            ByWord.$$$reportNull$$$0(24);
        }
        if (words2 == null) {
            ByWord.$$$reportNull$$$0(25);
        }
        if (iterable == null) {
            ByWord.$$$reportNull$$$0(26);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(27);
        }
        FairDiffIterable fairDiffIterable = new ChunkOptimizer.WordChunkOptimizer(words1, words2, text1, text2, iterable, indicator).build();
        if (fairDiffIterable == null) {
            ByWord.$$$reportNull$$$0(28);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(30);
        }
        if (words1 == null) {
            ByWord.$$$reportNull$$$0(31);
        }
        if (words2 == null) {
            ByWord.$$$reportNull$$$0(32);
        }
        if (changes == null) {
            ByWord.$$$reportNull$$$0(33);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(34);
        }
        return ByWord.matchAdjustmentDelimiters(text1, text2, words1, words2, changes, 0, 0, indicator);
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, @NotNull FairDiffIterable changes, int startShift1, int startShift2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(35);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(36);
        }
        if (words1 == null) {
            ByWord.$$$reportNull$$$0(37);
        }
        if (words2 == null) {
            ByWord.$$$reportNull$$$0(38);
        }
        if (changes == null) {
            ByWord.$$$reportNull$$$0(39);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(40);
        }
        FairDiffIterable fairDiffIterable = new AdjustmentPunctuationMatcher(text1, text2, words1, words2, startShift1, startShift2, changes, indicator).build();
        if (fairDiffIterable == null) {
            ByWord.$$$reportNull$$$0(41);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable iterable, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(42);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(43);
        }
        if (iterable == null) {
            ByWord.$$$reportNull$$$0(44);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(45);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(46);
        }
        switch (policy) {
            case DEFAULT: {
                DiffIterable diffIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWord.$$$reportNull$$$0(47);
                }
                return diffIterable;
            }
            case TRIM_WHITESPACES: {
                DiffIterable defaultIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                DiffIterable diffIterable = new TrimSpacesCorrector(defaultIterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWord.$$$reportNull$$$0(48);
                }
                return diffIterable;
            }
            case IGNORE_WHITESPACES: {
                DiffIterable diffIterable = new IgnoreSpacesCorrector(iterable, text1, text2, indicator).build();
                if (diffIterable == null) {
                    ByWord.$$$reportNull$$$0(49);
                }
                return diffIterable;
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static List<MergeRange> matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull List<? extends MergeRange> conflicts, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(50);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(51);
        }
        if (text3 == null) {
            ByWord.$$$reportNull$$$0(52);
        }
        if (conflicts == null) {
            ByWord.$$$reportNull$$$0(53);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(54);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(55);
        }
        switch (policy) {
            case DEFAULT: {
                List<MergeRange> list2 = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                if (list2 == null) {
                    ByWord.$$$reportNull$$$0(56);
                }
                return list2;
            }
            case TRIM_WHITESPACES: {
                List<MergeRange> defaultConflicts = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                List<MergeRange> list3 = new MergeTrimSpacesCorrector(defaultConflicts, text1, text2, text3, indicator).build();
                if (list3 == null) {
                    ByWord.$$$reportNull$$$0(57);
                }
                return list3;
            }
            case IGNORE_WHITESPACES: {
                List<MergeRange> list4 = new MergeIgnoreSpacesCorrector(conflicts, text1, text2, text3, indicator).build();
                if (list4 == null) {
                    ByWord.$$$reportNull$$$0(58);
                }
                return list4;
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static Couple<FairDiffIterable> comparePunctuation2Side(@NotNull CharSequence text1, @NotNull CharSequence text21, @NotNull CharSequence text22, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(59);
        }
        if (text21 == null) {
            ByWord.$$$reportNull$$$0(60);
        }
        if (text22 == null) {
            ByWord.$$$reportNull$$$0(61);
        }
        if (indicator == null) {
            ByWord.$$$reportNull$$$0(62);
        }
        MergingCharSequence text2 = new MergingCharSequence(text21, text22);
        FairDiffIterable changes = ByChar.comparePunctuation(text1, (CharSequence)text2, indicator);
        Couple<List<Range>> ranges = ByWord.splitIterable2Side(changes, text21.length());
        FairDiffIterable iterable1 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.first, text1.length(), text21.length()));
        FairDiffIterable iterable2 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.second, text1.length(), text22.length()));
        Couple couple = Couple.of((Object)iterable1, (Object)iterable2);
        if (couple == null) {
            ByWord.$$$reportNull$$$0(63);
        }
        return couple;
    }

    @NotNull
    private static Couple<List<Range>> splitIterable2Side(@NotNull FairDiffIterable changes, int offset) {
        if (changes == null) {
            ByWord.$$$reportNull$$$0(64);
        }
        ArrayList<Range> ranges1 = new ArrayList<Range>();
        ArrayList<Range> ranges2 = new ArrayList<Range>();
        for (Range ch : changes.iterateUnchanged()) {
            if (ch.end2 <= offset) {
                ranges1.add(new Range(ch.start1, ch.end1, ch.start2, ch.end2));
                continue;
            }
            if (ch.start2 >= offset) {
                ranges2.add(new Range(ch.start1, ch.end1, ch.start2 - offset, ch.end2 - offset));
                continue;
            }
            int len2 = offset - ch.start2;
            ranges1.add(new Range(ch.start1, ch.start1 + len2, ch.start2, offset));
            ranges2.add(new Range(ch.start1 + len2, ch.end1, 0, ch.end2 - offset));
        }
        Couple couple = Couple.of(ranges1, ranges2);
        if (couple == null) {
            ByWord.$$$reportNull$$$0(65);
        }
        return couple;
    }

    private static boolean isLeadingTrailingSpace(@NotNull CharSequence text2, int start2) {
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(66);
        }
        return ByWord.isLeadingSpace(text2, start2) || ByWord.isTrailingSpace(text2, start2);
    }

    private static boolean isLeadingSpace(@NotNull CharSequence text2, int start2) {
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(67);
        }
        if (start2 < 0) {
            return false;
        }
        if (start2 == text2.length()) {
            return false;
        }
        if (!StringUtil.isWhiteSpace((char)text2.charAt(start2))) {
            return false;
        }
        --start2;
        while (start2 >= 0) {
            char c = text2.charAt(start2);
            if (c == '\n') {
                return true;
            }
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            --start2;
        }
        return true;
    }

    private static boolean isTrailingSpace(@NotNull CharSequence text2, int end) {
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(68);
        }
        if (end < 0) {
            return false;
        }
        if (end == text2.length()) {
            return false;
        }
        if (!StringUtil.isWhiteSpace((char)text2.charAt(end))) {
            return false;
        }
        while (end < text2.length()) {
            char c = text2.charAt(end);
            if (c == '\n') {
                return true;
            }
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            ++end;
        }
        return true;
    }

    private static int countNewlines(@NotNull List<? extends InlineChunk> words) {
        if (words == null) {
            ByWord.$$$reportNull$$$0(69);
        }
        int count = 0;
        for (InlineChunk inlineChunk : words) {
            if (!(inlineChunk instanceof NewlineChunk)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static List<InlineChunk> getInlineChunks(@NotNull CharSequence text2) {
        int charCount;
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(70);
        }
        ArrayList<InlineChunk> chunks = new ArrayList<InlineChunk>();
        int len = text2.length();
        int wordStart = -1;
        int wordHash = 0;
        for (int offset = 0; offset < len; offset += charCount) {
            boolean isWordPart;
            int ch = Character.codePointAt(text2, offset);
            charCount = Character.charCount(ch);
            boolean isAlpha = TrimUtil.isAlpha(ch);
            boolean bl = isWordPart = isAlpha && !TrimUtil.isContinuousScript(ch);
            if (isWordPart) {
                if (wordStart == -1) {
                    wordStart = offset;
                    wordHash = 0;
                }
                wordHash = wordHash * 31 + ch;
                continue;
            }
            if (wordStart != -1) {
                chunks.add(new WordChunk(text2, wordStart, offset, wordHash));
                wordStart = -1;
            }
            if (isAlpha) {
                chunks.add(new WordChunk(text2, offset, offset + charCount, ch));
                continue;
            }
            if (ch != 10) continue;
            chunks.add(new NewlineChunk(offset));
        }
        if (wordStart != -1) {
            chunks.add(new WordChunk(text2, wordStart, len, wordHash));
        }
        ArrayList<InlineChunk> arrayList = chunks;
        if (arrayList == null) {
            ByWord.$$$reportNull$$$0(71);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 16: 
            case 21: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 65: 
            case 71: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 16: 
            case 21: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 65: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 18: 
            case 23: 
            case 30: 
            case 36: 
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 19: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 20: 
            case 27: 
            case 34: 
            case 40: 
            case 46: 
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 24: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words1";
                break;
            }
            case 7: 
            case 25: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words2";
                break;
            }
            case 10: 
            case 16: 
            case 21: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 65: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByWord";
                break;
            }
            case 13: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 26: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 33: 
            case 39: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text21";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text22";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByWord";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "compareAndSplit";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeWordChunks";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentDelimiters";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentWhitespaces";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "comparePunctuation2Side";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIterable2Side";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 10: 
            case 16: 
            case 21: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 65: 
            case 71: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSplit";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "optimizeWordChunks";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentDelimiters";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentWhitespaces";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "comparePunctuation2Side";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "splitIterable2Side";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isLeadingTrailingSpace";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isLeadingSpace";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isTrailingSpace";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "countNewlines";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getInlineChunks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 16: 
            case 21: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 65: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineBlock {
        @NotNull
        public final List<DiffFragment> fragments;
        @NotNull
        public final Range offsets;
        public final int newlines1;
        public final int newlines2;

        public LineBlock(@NotNull List<DiffFragment> fragments, @NotNull Range offsets2, int newlines1, int newlines2) {
            if (fragments == null) {
                LineBlock.$$$reportNull$$$0(0);
            }
            if (offsets2 == null) {
                LineBlock.$$$reportNull$$$0(1);
            }
            this.fragments = fragments;
            this.offsets = offsets2;
            this.newlines1 = newlines1;
            this.newlines2 = newlines2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/comparison/ByWord$LineBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NewlineChunk
    implements InlineChunk {
        private final int myOffset;

        NewlineChunk(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getOffset1() {
            return this.myOffset;
        }

        @Override
        public int getOffset2() {
            return this.myOffset + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    static class WordChunk
    implements InlineChunk {
        @NotNull
        private final CharSequence myText;
        private final int myOffset1;
        private final int myOffset2;
        private final int myHash;

        WordChunk(@NotNull CharSequence text2, int offset1, int offset2, int hash) {
            if (text2 == null) {
                WordChunk.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myHash = hash;
        }

        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.myText.subSequence(this.myOffset1, this.myOffset2);
            if (charSequence == null) {
                WordChunk.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getOffset1() {
            return this.myOffset1;
        }

        @Override
        public int getOffset2() {
            return this.myOffset2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WordChunk word = (WordChunk)o;
            if (this.myHash != word.myHash) {
                return false;
            }
            return StringUtil.equals((CharSequence)this.getContent(), (CharSequence)word.getContent());
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$WordChunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$WordChunk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface InlineChunk {
        public int getOffset1();

        public int getOffset2();
    }

    private static class MergeTrimSpacesCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeTrimSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                MergeRange trimmed;
                int start1 = mergeRange.start1;
                int start2 = mergeRange.start2;
                int start3 = mergeRange.start3;
                int end1 = mergeRange.end1;
                int end2 = mergeRange.end2;
                int end3 = mergeRange.end3;
                if (ByWord.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText3, start3)) {
                    start3 = TrimUtil.trimStart(this.myText3, start3, end3);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText3, end3 - 1)) {
                    end3 = TrimUtil.trimEnd(this.myText3, start3, end3);
                }
                if ((trimmed = new MergeRange(start1, end1, start2, end2, start3, end3)).isEmpty() || TrimUtil.isEquals(this.myText1, this.myText2, this.myText3, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            List<MergeRange> list2 = this.myChanges;
            if (list2 == null) {
                MergeTrimSpacesCorrector.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$MergeTrimSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$MergeTrimSpacesCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TrimSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        TrimSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range2 : this.myIterable.iterateChanges()) {
                Range trimmed;
                int start1 = range2.start1;
                int start2 = range2.start2;
                int end1 = range2.end1;
                int end2 = range2.end2;
                if (ByWord.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if ((trimmed = new Range(start1, end1, start2, end2)).isEmpty() || TrimUtil.isEquals(this.myText1, this.myText2, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                TrimSpacesCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$TrimSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$TrimSpacesCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeIgnoreSpacesCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeIgnoreSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                MergeRange expanded = TrimUtil.expandWhitespaces(this.myText1, this.myText2, this.myText3, mergeRange);
                MergeRange trimmed = TrimUtil.trim(this.myText1, this.myText2, this.myText3, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.myText1, this.myText2, this.myText3, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            List<MergeRange> list2 = this.myChanges;
            if (list2 == null) {
                MergeIgnoreSpacesCorrector.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$MergeIgnoreSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$MergeIgnoreSpacesCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        IgnoreSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range2 : this.myIterable.iterateChanges()) {
                Range expanded = TrimUtil.expandWhitespaces(this.myText1, this.myText2, range2);
                Range trimmed = TrimUtil.trim(this.myText1, this.myText2, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.myText1, this.myText2, trimmed)) continue;
                this.myChanges.add(trimmed);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                IgnoreSpacesCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$IgnoreSpacesCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$IgnoreSpacesCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeDefaultCorrector {
        @NotNull
        private final List<? extends MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        MergeDefaultCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(2);
            }
            if (text3 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(4);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange mergeRange : this.myIterable) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.myText1, this.myText2, this.myText3, mergeRange.start1, mergeRange.start2, mergeRange.start3, mergeRange.end1, mergeRange.end2, mergeRange.end3);
                int startCut = TrimUtil.expandWhitespacesForward(this.myText1, this.myText2, this.myText3, mergeRange.start1, mergeRange.start2, mergeRange.start3, mergeRange.end1 - endCut, mergeRange.end2 - endCut, mergeRange.end3 - endCut);
                MergeRange expand = new MergeRange(mergeRange.start1 + startCut, mergeRange.end1 - endCut, mergeRange.start2 + startCut, mergeRange.end2 - endCut, mergeRange.start3 + startCut, mergeRange.end3 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            List<MergeRange> list2 = this.myChanges;
            if (list2 == null) {
                MergeDefaultCorrector.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text3";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$MergeDefaultCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$MergeDefaultCorrector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DefaultCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        DefaultCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (iterable == null) {
                DefaultCorrector.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                DefaultCorrector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                DefaultCorrector.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                DefaultCorrector.$$$reportNull$$$0(3);
            }
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range2 : this.myIterable.iterateChanges()) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.myText1, this.myText2, range2.start1, range2.start2, range2.end1, range2.end2);
                int startCut = TrimUtil.expandWhitespacesForward(this.myText1, this.myText2, range2.start1, range2.start2, range2.end1 - endCut, range2.end2 - endCut);
                Range expand = new Range(range2.start1 + startCut, range2.end1 - endCut, range2.start2 + startCut, range2.end2 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            DiffIterable diffIterable = DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
            if (diffIterable == null) {
                DefaultCorrector.$$$reportNull$$$0(4);
            }
            return diffIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$DefaultCorrector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$DefaultCorrector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdjustmentPunctuationMatcher {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final List<? extends InlineChunk> myWords1;
        @NotNull
        private final List<? extends InlineChunk> myWords2;
        @NotNull
        private final FairDiffIterable myChanges;
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myStartShift1;
        private final int myStartShift2;
        private final int myLen1;
        private final int myLen2;
        private final DiffIterableUtil.ChangeBuilder myBuilder;
        int lastStart1;
        int lastStart2;
        int lastEnd1;
        int lastEnd2;

        AdjustmentPunctuationMatcher(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, int startShift1, int startShift2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(1);
            }
            if (words1 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(2);
            }
            if (words2 == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(5);
            }
            this.myText1 = text1;
            this.myText2 = text2;
            this.myWords1 = words1;
            this.myWords2 = words2;
            this.myStartShift1 = startShift1;
            this.myStartShift2 = startShift2;
            this.myChanges = changes;
            this.myIndicator = indicator;
            this.myLen1 = text1.length();
            this.myLen2 = text2.length();
            this.myBuilder = new DiffIterableUtil.ChangeBuilder(this.myLen1, this.myLen2);
        }

        @NotNull
        public FairDiffIterable build() {
            this.execute();
            FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(this.myBuilder.finish());
            if (fairDiffIterable == null) {
                AdjustmentPunctuationMatcher.$$$reportNull$$$0(6);
            }
            return fairDiffIterable;
        }

        private void execute() {
            this.clearLastRange();
            this.matchForward(-1, -1);
            for (Range ch : this.myChanges.iterateUnchanged()) {
                int count = ch.end1 - ch.start1;
                for (int i2 = 0; i2 < count; ++i2) {
                    int index1 = ch.start1 + i2;
                    int index2 = ch.start2 + i2;
                    int start1 = this.getStartOffset1(index1);
                    int start2 = this.getStartOffset2(index2);
                    int end1 = this.getEndOffset1(index1);
                    int end2 = this.getEndOffset2(index2);
                    this.matchBackward(index1, index2);
                    this.myBuilder.markEqual(start1, start2, end1, end2);
                    this.matchForward(index1, index2);
                }
            }
            this.matchBackward(this.myWords1.size(), this.myWords2.size());
        }

        private void clearLastRange() {
            this.lastStart1 = -1;
            this.lastStart2 = -1;
            this.lastEnd1 = -1;
            this.lastEnd2 = -1;
        }

        private void matchBackward(int index1, int index2) {
            int start1 = index1 == 0 ? 0 : this.getEndOffset1(index1 - 1);
            int start2 = index2 == 0 ? 0 : this.getEndOffset2(index2 - 1);
            int end1 = index1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1);
            int end2 = index2 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2);
            this.matchBackward(start1, start2, end1, end2);
            this.clearLastRange();
        }

        private void matchForward(int index1, int index2) {
            int start1 = index1 == -1 ? 0 : this.getEndOffset1(index1);
            int start2 = index2 == -1 ? 0 : this.getEndOffset2(index2);
            int end1 = index1 + 1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1 + 1);
            int end2 = index2 + 1 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2 + 1);
            this.matchForward(start1, start2, end1, end2);
        }

        private void matchForward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 == -1 && this.lastStart2 == -1 && this.lastEnd1 == -1 && this.lastEnd2 == -1);
            this.lastStart1 = start1;
            this.lastStart2 = start2;
            this.lastEnd1 = end1;
            this.lastEnd2 = end2;
        }

        private void matchBackward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 != -1 && this.lastStart2 != -1 && this.lastEnd1 != -1 && this.lastEnd2 != -1);
            if (this.lastStart1 == start1 && this.lastStart2 == start2) {
                assert (this.lastEnd1 == end1 && this.lastEnd2 == end2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            if (this.lastStart1 < start1 && this.lastStart2 < start2) {
                assert (this.lastEnd1 <= start1 && this.lastEnd2 <= start2);
                this.matchRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            this.matchComplexRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2, start1, start2, end1, end2);
        }

        private void matchRange(int start1, int start2, int end1, int end2) {
            if (start1 == end1 && start2 == end2) {
                return;
            }
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable changes = ByChar.comparePunctuation(sequence1, sequence2, this.myIndicator);
            for (Range ch : changes.iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start2 + ch.start2, start1 + ch.end1, start2 + ch.end2);
            }
        }

        private void matchComplexRange(int start11, int start12, int end11, int end12, int start21, int start22, int end21, int end22) {
            if (start11 == start21 && end11 == end21) {
                this.matchComplexRangeLeft(start11, end11, start12, end12, start22, end22);
            } else if (start12 == start22 && end12 == end22) {
                this.matchComplexRangeRight(start12, end12, start11, end11, start21, end21);
            } else {
                throw new IllegalStateException();
            }
        }

        private void matchComplexRangeLeft(int start1, int end1, int start12, int end12, int start22, int end22) {
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence21 = this.myText2.subSequence(start12, end12);
            CharSequence sequence22 = this.myText2.subSequence(start22, end22);
            Couple<FairDiffIterable> changes = ByWord.comparePunctuation2Side(sequence1, sequence21, sequence22, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start12 + ch.start2, start1 + ch.end1, start12 + ch.end2);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start22 + ch.start2, start1 + ch.end1, start22 + ch.end2);
            }
        }

        private void matchComplexRangeRight(int start2, int end2, int start11, int end11, int start21, int end21) {
            CharSequence sequence11 = this.myText1.subSequence(start11, end11);
            CharSequence sequence12 = this.myText1.subSequence(start21, end21);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            Couple<FairDiffIterable> changes = ByWord.comparePunctuation2Side(sequence2, sequence11, sequence12, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start11 + ch.start2, start2 + ch.start1, start11 + ch.end2, start2 + ch.end1);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start21 + ch.start2, start2 + ch.start1, start21 + ch.end2, start2 + ch.end1);
            }
        }

        private int getStartOffset1(int index) {
            return this.myWords1.get(index).getOffset1() - this.myStartShift1;
        }

        private int getStartOffset2(int index) {
            return this.myWords2.get(index).getOffset1() - this.myStartShift2;
        }

        private int getEndOffset1(int index) {
            return this.myWords1.get(index).getOffset2() - this.myStartShift1;
        }

        private int getEndOffset2(int index) {
            return this.myWords2.get(index).getOffset2() - this.myStartShift2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByWord$AdjustmentPunctuationMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByWord$AdjustmentPunctuationMatcher";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

