/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.UsageRanges;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u0016"}, d2={"getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "symbol", "Lcom/intellij/model/Symbol;", "psiTarget", "Lcom/intellij/psi/PsiElement;", "getUsageRanges", "Lcom/intellij/codeInsight/highlighting/UsageRanges;", "file", "Lcom/intellij/psi/PsiFile;", "highlightSymbolUsages", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearHighlights", "", "highlightUsages", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class HighlightUsagesKt {
    public static final boolean highlightUsages(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Collection<Symbol> allTargets = TargetsKt.targetSymbols(file2, caretModel.getOffset());
        if (allTargets.isEmpty()) {
            return false;
        }
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
        for (Symbol symbol : allTargets) {
            HighlightUsagesKt.highlightSymbolUsages(project, editor, file2, symbol, clearHighlights);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void highlightSymbolUsages(Project project, Editor editor, PsiFile file2, Symbol symbol, boolean clearHighlights) {
        void writeRanges;
        void readDeclarationRanges;
        void readRanges;
        EditorWindow editorWindow;
        PsiCompiledFile psiCompiledFile;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiFile psiFile = file2;
        if (!(psiFile instanceof PsiCompiledFile)) {
            psiFile = null;
        }
        if ((psiCompiledFile = (PsiCompiledFile)psiFile) == null || (psiCompiledFile = psiCompiledFile.getDecompiledPsiFile()) == null) {
            psiCompiledFile = file2;
        }
        PsiFile fileToUse = injectedLanguageManager.getTopLevelFile((PsiElement)psiCompiledFile);
        Editor editor2 = editor;
        if (!(editor2 instanceof EditorWindow)) {
            editor2 = null;
        }
        if ((editorWindow = (EditorWindow)editor2) == null || (editorWindow = editorWindow.getDelegate()) == null) {
            editorWindow = editor;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editorWindow, (String)"(editor as? EditorWindow)?.delegate ?: editor");
        EditorWindow editorToUse = editorWindow;
        PsiFile psiFile2 = fileToUse;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"fileToUse");
        UsageRanges usageRanges = HighlightUsagesKt.getUsageRanges(psiFile2, symbol);
        Collection<TextRange> collection = usageRanges.component1();
        Collection<TextRange> collection2 = usageRanges.component2();
        Collection<TextRange> collection3 = usageRanges.component3();
        Collection<TextRange> writeDeclarationRanges = usageRanges.component4();
        HighlightUsagesHandler.highlightUsages(project, editorToUse, CollectionsKt.plus((Collection)readRanges, (Iterable)((Iterable)readDeclarationRanges)), CollectionsKt.plus((Collection)writeRanges, (Iterable)writeDeclarationRanges), clearHighlights);
        HighlightUsagesHandler.setStatusText(project, null, readRanges.size() + writeRanges.size(), clearHighlights);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final UsageRanges getUsageRanges(@NotNull PsiFile file, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        readRanges = new ArrayList<E>();
        writeRanges = new ArrayList<E>();
        readDeclarationRanges = new ArrayList<E>();
        writeDeclarationRanges = new ArrayList<E>();
        searchScope = (SearchScope)new LocalSearchScope((PsiElement)file);
        v0 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"file.project");
        project = v0;
        psiTarget = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        detector = psiTarget != null ? ReadWriteAccessDetector.findDetector((PsiElement)psiTarget) : null;
        refs = HighlightUsagesKt.getReferences(project, searchScope, symbol, psiTarget);
        for (PsiSymbolReference ref : refs) {
            if (detector == null || !(ref instanceof PsiReference)) ** GOTO lbl-1000
            v1 = psiTarget;
            Intrinsics.checkNotNull((Object)v1);
            if (detector.getReferenceAccess(v1, (PsiReference)ref) != ReadWriteAccessDetector.Access.Read) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            write = v2;
            HighlightUsagesHandler.collectHighlightRanges(ref, (Collection<? super TextRange>)(write != false ? writeRanges : readRanges));
        }
        v3 = SearchService.getInstance().searchPsiSymbolDeclarations(project, symbol, searchScope).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"SearchService.getInstanc\u2026archScope)\n    .findAll()");
        declarations = v3;
        declarationWrite = psiTarget != null && detector != null && detector.isDeclarationWriteAccess(psiTarget) != false;
        for (PsiSymbolDeclaration declaration : declarations) {
            HighlightUsagesHandler.collectHighlightRanges(declaration.getDeclaringElement(), declaration.getDeclarationRange(), (Collection<? super TextRange>)(declarationWrite != false ? writeDeclarationRanges : readDeclarationRanges));
        }
        return new UsageRanges((Collection<? extends TextRange>)readRanges, (Collection<? extends TextRange>)writeRanges, (Collection<? extends TextRange>)readDeclarationRanges, (Collection<? extends TextRange>)writeDeclarationRanges);
    }

    private static final Collection<PsiSymbolReference> getReferences(Project project, SearchScope searchScope2, Symbol symbol, PsiElement psiTarget) {
        if (psiTarget != null) {
            FindManager findManager = FindManager.getInstance((Project)project);
            if (findManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.find.impl.FindManagerImpl");
            }
            FindUsagesHandler oldHandler = ((FindManagerImpl)findManager).getFindUsagesManager().getFindUsagesHandler(psiTarget, true);
            if (oldHandler != null) {
                Collection<PsiReference> collection = oldHandler.findReferencesToHighlight(psiTarget, searchScope2);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"oldHandler.findReference\u2026t(psiTarget, searchScope)");
                return collection;
            }
        }
        Collection collection = SearchService.getInstance().searchPsiSymbolReferences(project, symbol, searchScope2).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"SearchService.getInstanc\u2026archScope)\n    .findAll()");
        return collection;
    }
}

