/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileInEditorProcessor {
    private static final Logger LOG = Logger.getInstance(FileInEditorProcessor.class);
    private final Editor myEditor;
    private boolean myNoChangesDetected;
    private final boolean myProcessChangesTextOnly;
    private final boolean myProcessSelectedText;
    private final LayoutCodeOptions myOptions;
    private final Project myProject;
    private final PsiFile myFile;
    private AbstractLayoutCodeProcessor myProcessor;

    public FileInEditorProcessor(PsiFile file2, Editor editor, LayoutCodeOptions runOptions) {
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myEditor = editor;
        this.myOptions = runOptions;
        this.myProcessSelectedText = this.myEditor != null && runOptions.getTextRangeType() == TextRangeType.SELECTED_TEXT;
        this.myProcessChangesTextOnly = runOptions.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
    }

    public void processCode() {
        if (!CodeStyle.isFormattingEnabled((PsiFile)this.myFile)) {
            if (!FileInEditorProcessor.isInHeadlessMode() && !this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                FileInEditorProcessor.showHint(this.myEditor, new DisabledFormattingMessageBuilder());
            }
            return;
        }
        if (this.myOptions.isOptimizeImports()) {
            this.myProcessor = new OptimizeImportsProcessor(this.myProject, this.myFile);
        }
        if (this.myProcessChangesTextOnly && !VcsFacade.getInstance().hasChanges(this.myFile)) {
            this.myNoChangesDetected = true;
        }
        this.myProcessor = this.mixWithReformatProcessor(this.myProcessor);
        if (this.myOptions.isRearrangeCode()) {
            this.myProcessor = this.mixWithRearrangeProcessor(this.myProcessor);
        }
        if (this.myOptions.isCodeCleanup()) {
            this.myProcessor = this.mixWithCleanupProcessor(this.myProcessor);
        }
        if (this.shouldNotify()) {
            this.myProcessor.setCollectInfo(true);
            this.myProcessor.setPostRunnable(() -> {
                if (!this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                    FileInEditorProcessor.showHint(this.myEditor, new FormattedMessageBuilder());
                }
            });
        }
        this.myProcessor.run();
        if (this.myEditor != null && this.myOptions.getTextRangeType() == TextRangeType.WHOLE_FILE) {
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithCleanupProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        if (processor2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(0);
        }
        processor2 = this.myProcessSelectedText ? new CodeCleanupCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new CodeCleanupCodeProcessor(processor2);
        AbstractLayoutCodeProcessor abstractLayoutCodeProcessor = processor2;
        if (abstractLayoutCodeProcessor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(1);
        }
        return abstractLayoutCodeProcessor;
    }

    private AbstractLayoutCodeProcessor mixWithRearrangeProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        if (processor2 == null) {
            FileInEditorProcessor.$$$reportNull$$$0(2);
        }
        processor2 = this.myProcessSelectedText ? new RearrangeCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new RearrangeCodeProcessor(processor2);
        return processor2;
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithReformatProcessor(@Nullable AbstractLayoutCodeProcessor processor2) {
        processor2 = processor2 != null ? (this.myProcessSelectedText ? new ReformatCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(processor2, this.myProcessChangesTextOnly)) : (this.myProcessSelectedText ? new ReformatCodeProcessor(this.myFile, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(this.myFile, this.myProcessChangesTextOnly));
        AbstractLayoutCodeProcessor abstractLayoutCodeProcessor = processor2;
        if (abstractLayoutCodeProcessor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(3);
        }
        return abstractLayoutCodeProcessor;
    }

    @NotNull
    private static String joinWithCommaAndCapitalize(String reformatNotification, String rearrangeNotification) {
        Object firstNotificationLine;
        Object object = firstNotificationLine = reformatNotification != null ? reformatNotification : rearrangeNotification;
        if (reformatNotification != null && rearrangeNotification != null) {
            firstNotificationLine = (String)firstNotificationLine + ", " + rearrangeNotification;
        }
        firstNotificationLine = StringUtil.capitalize((String)firstNotificationLine);
        String string = firstNotificationLine;
        if (string == null) {
            FileInEditorProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void showHint(@NotNull Editor editor, @NotNull MessageBuilder messageBuilder) {
        if (editor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(5);
        }
        if (messageBuilder == null) {
            FileInEditorProcessor.$$$reportNull$$$0(6);
        }
        FileInEditorProcessor.showHint(editor, messageBuilder.getMessage(), messageBuilder.createHyperlinkListener());
    }

    public static void showHint(@NotNull Editor editor, @NotNull @NlsContexts.HintText String info, @Nullable HyperlinkListener hyperlinkListener) {
        if (editor == null) {
            FileInEditorProcessor.$$$reportNull$$$0(7);
        }
        if (info == null) {
            FileInEditorProcessor.$$$reportNull$$$0(8);
        }
        JComponent component2 = HintUtil.createInformationLabel(info, hyperlinkListener, null, null);
        LightweightHint hint = new LightweightHint(component2);
        int flags = 42;
        if (EditorUtil.isPrimaryCaretVisible(editor)) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, flags, 0, false);
        } else {
            FileInEditorProcessor.showHintWithoutScroll(editor, hint, flags);
        }
    }

    private static void showHintWithoutScroll(Editor editor, LightweightHint hint, int flags) {
        short constraint;
        int y;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (FileInEditorProcessor.isCaretAboveTop(editor, visibleArea)) {
            y = visibleArea.y;
            constraint = 2;
        } else {
            y = visibleArea.y + visibleArea.height;
            constraint = 1;
        }
        Point hintPoint = new Point(visibleArea.x + visibleArea.width / 2, y);
        JComponent component2 = HintManagerImpl.getExternalComponent(editor);
        Point convertedPoint = SwingUtilities.convertPoint(editor.getContentComponent(), hintPoint, component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, convertedPoint, flags, 0, false, constraint);
    }

    private static boolean isCaretAboveTop(Editor editor, Rectangle area) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        VisualPosition caretVisualPosition = caret.getVisualPosition();
        int caretY = editor.visualPositionToXY((VisualPosition)caretVisualPosition).y;
        return caretY < area.y;
    }

    private boolean shouldNotify() {
        if (FileInEditorProcessor.isInHeadlessMode()) {
            return false;
        }
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        return es.isShowNotificationAfterReformat() && this.myEditor != null && !this.myProcessSelectedText;
    }

    private static boolean isInHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isHeadlessEnvironment();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FileInEditorProcessor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FileInEditorProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mixWithCleanupProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mixWithReformatProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithCommaAndCapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mixWithCleanupProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mixWithRearrangeProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MessageBuilder {
        private MessageBuilder() {
        }

        @NlsContexts.HintText
        public abstract String getMessage();

        @NotNull
        public abstract Runnable getHyperlinkRunnable();

        public final HyperlinkListener createHyperlinkListener() {
            return new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    this.getHyperlinkRunnable().run();
                }
            };
        }
    }

    private class FormattedMessageBuilder
    extends MessageBuilder {
        private FormattedMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            HtmlBuilder builder2 = new HtmlBuilder();
            LayoutCodeInfoCollector notifications = FileInEditorProcessor.this.myProcessor.getInfoCollector();
            LOG.assertTrue(notifications != null);
            if (notifications.isEmpty() && !FileInEditorProcessor.this.myNoChangesDetected) {
                if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                    builder2.append(LangBundle.message((String)"formatter.in.editor.message.already.formatted", (Object[])new Object[0])).br();
                } else {
                    builder2.append(LangBundle.message((String)"formatter.in.editor.message.content.already.formatted", (Object[])new Object[0])).br();
                }
            } else {
                if (notifications.hasReformatOrRearrangeNotification()) {
                    String reformatInfo = notifications.getReformatCodeNotification();
                    String rearrangeInfo = notifications.getRearrangeCodeNotification();
                    builder2.append(FileInEditorProcessor.joinWithCommaAndCapitalize(reformatInfo, rearrangeInfo));
                    if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                        builder2.append(LangBundle.message((String)"formatter.in.editor.message.changes.since.last.revision", (Object[])new Object[0]));
                    }
                    builder2.br();
                } else if (FileInEditorProcessor.this.myNoChangesDetected) {
                    builder2.append(LangBundle.message((String)"formatter.in.editor.message.no.changes.since.last.revision", (Object[])new Object[0])).br();
                }
                String optimizeImportsNotification = notifications.getOptimizeImportsNotification();
                if (optimizeImportsNotification != null) {
                    builder2.append(optimizeImportsNotification).br();
                }
            }
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowReformatFileDialog"));
            String color = ColorUtil.toHtmlColor((Color)JBColor.gray);
            builder2.append((HtmlChunk)HtmlChunk.span((String)("color:" + color)).child(HtmlChunk.raw((String)LangBundle.message((String)"formatter.in.editor.link.show.reformat.dialog", (Object[])new Object[0]))).addText(shortcutText));
            String string = builder2.wrapWith("html").toString();
            if (string == null) {
                FormattedMessageBuilder.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Runnable getHyperlinkRunnable() {
            Runnable runnable2 = () -> {
                AnAction action2 = ActionManager.getInstance().getAction("ShowReformatFileDialog");
                DataManager manager = DataManager.getInstance();
                if (manager != null) {
                    DataContext context = manager.getDataContext((Component)FileInEditorProcessor.this.myEditor.getContentComponent());
                    action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)context));
                }
            };
            if (runnable2 == null) {
                FormattedMessageBuilder.$$$reportNull$$$0(1);
            }
            return runnable2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/actions/FileInEditorProcessor$FormattedMessageBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHyperlinkRunnable";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class DisabledFormattingMessageBuilder
    extends MessageBuilder {
        private DisabledFormattingMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            VirtualFile virtualFile = FileInEditorProcessor.this.myFile.getVirtualFile();
            String message = virtualFile == null ? LangBundle.message((String)"formatter.unavailable.message", (Object[])new Object[0]) : LangBundle.message((String)"formatter.unavailable.for.0.message", (Object[])new Object[]{virtualFile.getName()});
            String string = new HtmlBuilder().append(message).append((HtmlChunk)HtmlChunk.p().child((HtmlChunk)HtmlChunk.span().child((HtmlChunk)HtmlChunk.link((String)"", (String)LangBundle.message((String)"formatter.unavailable.show.settings.link", (Object[])new Object[0]))))).wrapWithHtmlBody().toString();
            if (string == null) {
                DisabledFormattingMessageBuilder.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Runnable getHyperlinkRunnable() {
            Runnable runnable2 = () -> ShowSettingsUtilImpl.showSettingsDialog(FileInEditorProcessor.this.myProject, "preferences.sourceCode", "Do not format");
            if (runnable2 == null) {
                DisabledFormattingMessageBuilder.$$$reportNull$$$0(1);
            }
            return runnable2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/actions/FileInEditorProcessor$DisabledFormattingMessageBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHyperlinkRunnable";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

